/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.h;
import org.lwjgl.opengl.qd;

public final class BufferUtils {
    public static ShortBuffer createShortBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 1).asShortBuffer();
    }

    private static native void zeroBuffer0(Buffer var0, long var1, long var3);

    public static int getOffset(Buffer buffer) {
        return buffer.position() << BufferUtils.getElementSizeExponent(buffer);
    }

    public static ByteBuffer createByteBuffer(int n2) {
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    public static LongBuffer createLongBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 3).asLongBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 3).asDoubleBuffer();
    }

    public static void zeroBuffer(CharBuffer charBuffer) {
        CharBuffer charBuffer2 = charBuffer;
        BufferUtils.zeroBuffer0(charBuffer2, (long)charBuffer.position() * 2L, (long)charBuffer2.remaining() * 2L);
    }

    public static void zeroBuffer(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = floatBuffer;
        BufferUtils.zeroBuffer0(floatBuffer2, (long)floatBuffer.position() * 4L, (long)floatBuffer2.remaining() * 4L);
    }

    public static void zeroBuffer(ShortBuffer shortBuffer) {
        ShortBuffer shortBuffer2 = shortBuffer;
        BufferUtils.zeroBuffer0(shortBuffer2, (long)shortBuffer.position() * 2L, (long)shortBuffer2.remaining() * 2L);
    }

    static native long getBufferAddress(Buffer var0);

    public static h createPointerBuffer(int n2) {
        return h.short(n2);
    }

    public static CharBuffer createCharBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 1).asCharBuffer();
    }

    public static int getElementSizeExponent(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return 0;
        }
        if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
            return 1;
        }
        if (buffer instanceof FloatBuffer || buffer instanceof IntBuffer) {
            return 2;
        }
        if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
            return 3;
        }
        throw new IllegalStateException(new StringBuilder().insert(0, qd.break("k%\u000fR``Hq@fP UbFVbc\u0006xBy[,\u0001")).append(buffer).toString());
    }

    public static void zeroBuffer(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = intBuffer;
        BufferUtils.zeroBuffer0(intBuffer2, (long)intBuffer.position() * 4L, (long)intBuffer2.remaining() * 4L);
    }

    public static void zeroBuffer(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = doubleBuffer;
        BufferUtils.zeroBuffer0(doubleBuffer2, (long)doubleBuffer.position() * 8L, (long)doubleBuffer2.remaining() * 8L);
    }

    public static IntBuffer createIntBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 2).asIntBuffer();
    }

    public static void zeroBuffer(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = longBuffer;
        BufferUtils.zeroBuffer0(longBuffer2, (long)longBuffer.position() * 8L, (long)longBuffer2.remaining() * 8L);
    }

    public static void zeroBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        BufferUtils.zeroBuffer0(byteBuffer2, byteBuffer.position(), byteBuffer2.remaining());
    }

    public static FloatBuffer createFloatBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 2).asFloatBuffer();
    }
}

