
string RENDERPASS = "reflective";

texture Tex0 < string name = "logo_a.jpg"; >;
texture Tex1 < string name = "bumptest.jpg";>;


float4x3 WorldView  : WORLDVIEW; 
float4x4 Projection : PROJECTION;

float3 LightPos = float3(0,0.5,-1);

float3 LightDir;


float3 vDiffuse  = { 1.0f, 1.0f, 1.0f };        // diffuse direction
float3 vSpecular = { 0.0f, 0.0f, 0.0f };        // specular direction

float TheTime : TIME;

struct VS_OUTPUT
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR0;
    float4 Specular : COLOR1;
    float2 TexCoord : TEXCOORD0;
    float2 NormalMap: TEXCOORD1;
  
};

struct PS_OUTPUT
{
    float4 vColor           : COLOR0;
};


VS_OUTPUT VS
    (
    float4 Position : POSITION, 
    float4 Colour   : COLOR0,
    float3 Tangent  : TANGENT,
    float4 Spec     : COLOR1,
    float3 Normal   : NORMAL,
    float2 TexCoord : TEXCOORD0
    )
{
    VS_OUTPUT Out = (VS_OUTPUT)0;

	LightDir.x = 0;
	LightDir.y = 0;
	LightDir.z = 1.0;

	LightDir = normalize(LightDir);

	float3 P = mul(Position, WorldView);                    // position (view space)

	
	float3 N = Normal;
	float3 T = Tangent;


	float3 lpos = normalize(LightPos - P);
	float3 camvertvec = normalize(P);

	float3 halfvec = normalize(lpos + camvertvec);
	

	    
	float3 Binormal = cross(N, T);        

	float3x3 mLight = float3x3(T.x, Binormal.x, N.x,
	                 T.y, Binormal.y, N.y, 
        	         T.z, Binormal.z, N.z);
	

	
	Out.Diffuse = float4(mul(lpos, mLight) * 0.5 + 0.5,1);
	Out.Diffuse.w = 0.5f;
	Out.Specular = float4(mul(halfvec, mLight) * 0.5 + 0.5,1);
	
	Out.TexCoord.xy = TexCoord.xy ;
	Out.NormalMap.xy = TexCoord.xy * 2;
	
	Out.Position = mul(float4(P, 1), Projection);   // projected position

	   
	return Out;    
}




sampler DiffuseMap = sampler_state
{
Texture   = <Tex0>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = LINEAR;
};

sampler NormalMapa = sampler_state
{
Texture   = <Tex1>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = LINEAR;
};


float4 PS11(VS_OUTPUT In) : COLOR
{   
	float4 col= (tex2D(NormalMapa,In.NormalMap) - 0.5f) * 2.0f;
	float4 texcol= tex2D(DiffuseMap,In.TexCoord);
	float4 dif = (In.Diffuse - 0.5f) * 1.0f;
	float4 spec = (In.Specular - 0.5f) * 1.0f;
	float4 difbump = dot(dif, col);
	float4 speccol = dot(spec, col);

	speccol = speccol * speccol;
	speccol = speccol * speccol;
	speccol = speccol * speccol;
	//speccol = speccol * speccol;

	return (difbump  * texcol) + speccol;
}  


technique TSpecularBumpmap
{
    pass P0
    {   
        VertexShader = compile vs_1_1 VS();

       PixelShader  = compile ps_1_1 PS11();

        Sampler[0] = (DiffuseMap);
       Sampler[1] = (NormalMapa);

	AlphaBlendEnable = False;
	SrcBlend = Srcalpha;
	Destblend = InvSrcAlpha;

	AlphaOp[0] = SelectArg1;
	AlphaArg1[0] = Diffuse;
	TextureFactor = float4(0,0,0,0.5);

	

        
    }

}