.dasm   off
.smc    on
.opt    on
.mem    8
.index  16
.org    $008000

.comment
------------------------------------------------------------------------------
VRAM
$0000 - $01ff   screen plane 0 map (32x16 tiles)
$0200 - $04ff   screen plane 1 map (32x32 tiles)
$0400 - $       scroller font tile data
$1000 - $       f4cg logo tile data (576 tiles, 32x18 tiles)

CGRAM
$20 - $7f       f4cg logo
------------------------------------------------------------------------------
.end

.interrupts
reset           =       reset
nmi             =       vblank
.end

stack           equ     $01ff

f4cg_logo_sin   =       $0400           ; word, 0-1023
scroll_text_x   =       $0402           ; word
unpackbuf       =       $7f6000


reset:
        sei
        phk                             ; Make data bank the same as
        plb                             ; the program bank.
        clc                             ; Switch to native mode.
        xce
        jsr     init_snes               ; Initialize Super NES.
        rep     #$30                    ; Set AXY to 16-bit
        lda.w   #$0000                  ; Set direct register to $0000.
        tcd
        lda.w   #stack                  ; Set stack pointer.
        tcs
        sep     #$20

        cli
        jsr     Music_Init              ; Initialize music.
        jsr     f4cg_logo_init
        jsr     scroll_init
        jsr     title_init
        rep     #$30
        sep     #$20
        lda     #$03                    ; Screen mode 3.
        ora     #%00010000              ; BG1 - 16x16 dot tiles.
        ora     #%00100000              ; BG2 - 16x16 dot tiles.
        sta     $2105
        lda     #$00                    ; BG1 map @ $0000.
        sta     $2107
        lda     #$00                    ; BG2 map @ $0200.
        sta     $2108
        lda     #$01                    ; BG1 tile data @ $1000.
        ora     #$00                    ; BG2 tile data @ $0000.
        sta     $210b
        lda     #%00000011              ; Enable BG1/BG2.
        sta     $212c
        lda     #%10000000              ; Enable NMI.
        sta     $4200
        lda     #%11100000
        sta     $420c                   ; Enable HDMA channel #5/6/7.

        lda     #$00
-       wai
        wai
        sta     $2100
        inc
        cmp     #$10
        bne     -

-
        jmp     -


; Nonmaskable interrupt handler.
vblank:
        pha
        phx
        php
        rep     #$30

; Update logo swinging.
        lda     f4cg_logo_sin
        inc
        inc
        and.w   #((f4cg_logo_sin_data_end-f4cg_logo_sin_data)/2-1)
        sta     f4cg_logo_sin
        asl
        tax
        sep     #$20
        lda     f4cg_logo_sin_data,x
        sta     $210d
        lda     f4cg_logo_sin_data+1,x
        sta     $210d
; Update scroller.
        jsr     scroll_update

        jsr     Music_Play              ; Play SID music.

        plp
        plx
        pla
        rti


; Initialize title area.
title_bar_colour_hdma_data:
.dcb    $f8
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $f8
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.dcb    $00
.dcb    $00

title_bar_colour1_hdma_data:
.dcb    $80,0,0
.dcb    $01,102,12
.dcb    $01,104,12
.dcb    $01,107,12
.dcb    $01,109,12
.dcb    $01,111,12
.dcb    $01,114,12
.dcb    $01,116,12
.dcb    $01,117,12
.dcb    $01,119,12
.dcb    $01,120,12
.dcb    $01,122,12
.dcb    $01,125,12
.dcb    $01,127,12
.dcb    $01,63,97
.dcb    $01,127,12
.dcb    $01,125,12
.dcb    $01,122,12
.dcb    $01,120,12
.dcb    $01,119,12
.dcb    $01,117,12
.dcb    $01,116,12
.dcb    $01,114,12
.dcb    $01,111,12
.dcb    $01,109,12
.dcb    $01,107,12
.dcb    $01,104,12
.dcb    $01,102,12
.dcb    $19,0,0
.dcb    $01,102,12
.dcb    $01,104,12
.dcb    $01,107,12
.dcb    $01,109,12
.dcb    $01,111,12
.dcb    $01,114,12
.dcb    $01,116,12
.dcb    $01,117,12
.dcb    $01,119,12
.dcb    $01,120,12
.dcb    $01,122,12
.dcb    $01,125,12
.dcb    $01,127,12
.dcb    $01,63,97
.dcb    $01,127,12
.dcb    $01,125,12
.dcb    $01,122,12
.dcb    $01,120,12
.dcb    $01,119,12
.dcb    $01,117,12
.dcb    $01,116,12
.dcb    $01,114,12
.dcb    $01,111,12
.dcb    $01,109,12
.dcb    $01,107,12
.dcb    $01,104,12
.dcb    $01,102,12
.dcb    $01,0,0
.dcb    $00,$00,$00

temp    =       $80
title_init:
        sep     #$20
        lda     #$80
        sta     $2115
        ldx     #(9*32)+$0200
        stx     $2116
        rep     #$30
        ldy     #$0000
-       lda.l   title_text,y
        and.w   #$00ff
        asl
        tax
        lda     scroll_font_xlat,x
        adc.w   #$40
;        ora.w   #%0000010000000000
        sta     $2118
        iny
        cpy     #32*3
        bne     -
        sep     #$20

        lda     #%00000000
        sta     $4350                   ; Write 1-byte to same address.
        lda     #$21
        sta     $4351                   ; $2121
        ldx     #title_bar_colour_hdma_data
        stx     $4352
        stz     $4354

        lda     #%00000010
        sta     $4360                   ; Write 2-bytes to same address.
        lda     #$22
        sta     $4361                   ; $2122
        ldx     #title_bar_colour1_hdma_data
        stx     $4362
        stz     $4364
        rts


; Data is relocated to below address.
scroll_data_init:
.base   $1800
scroll_hdma_data:
.dcb    $80,0,0
.dcb    $50,0,0
.dcb    $10
scroll_hdma_data1:
.dcb    4,0
.dcb    $01,0,0
.dcb    0
scroll_hdma_data_end:

scroll_delay =  1
scroll_delay_count:
.dcw    0
flag_update_scroll:
.dcw    0
scroll_text_buffer:
.dsw    32
.end


; Initialize scroller.
scroll_init:
        rep     #$30

        pea     (scroll_font_tile_data&&$ffff)
        pea     ((scroll_font_tile_data>>16)&&$ffff)
        pea     (unpackbuf&&$ffff)
        pea     ((unpackbuf>>16)&&$ffff)
        jsl     unpack
        pla
        pla
        pla
        pla

        rep     #$30
        sep     #$20
        lda     #$80
        sta     $2115                   ; Increase address on w/$2119.
        ldx     #$0400
        stx     $2116                   ; VRAM address to store tile data.
        lda     #%00000001
        sta     $4300
        lda     #$18
        sta     $4301
        ldx     #(unpackbuf&&$ffff)
        stx     $4302
        lda     #((unpackbuf>>16)&&$ff)
        sta     $4304
        ldx     #6144
        stx     $4305
        lda     #%00000001
        sta     $420b

        lda     #$00
        sta     $2121
        ldx     #$0000
-       lda     scroll_font_pal_data,x
        sta     $2122
        inx
        cpx     #18*2
        bne     -

        lda     #$80
        sta     $2115
        ldx     #$0200
        stx     $2116
        ldx     #$0000
        ldy     #$0040
-       sty     $2118
        inx
        cpx     #$0200
        bne     -

        lda     #<(255)
        sta     $2110
        lda     #>(255)
        sta     $2110

        ldx     #$0000                  ; Relocate HDMA data for scroll.
-       lda     scroll_data_init,x
        sta     scroll_hdma_data,x
        inx
        cpx.w   #scroll_hdma_data_end-scroll_hdma_data
        bne     -

        lda     #%00000010
        sta     $4370                   ; Write 2-bytes to same address.
        lda     #$0f
        sta     $4371                   ; $2110
        ldx     #scroll_hdma_data
        stx     $4372
        stz     $4374

        rep     #$30
        ldx     #$0000
        lda.w   #$0040
-       sta     scroll_text_buffer,x
        inx
        inx
        cpx.w   #32*2
        bne     -
        sep     #$20

        ldx     #$0000
        stx     scroll_text_x
        stx     scroll_delay_count
        stx     flag_update_scroll

        lda     #%00000001              ; Initialize DMA channel #0.
        sta     $4300
        lda     #$18                    ; $2118
        sta     $4301
        rts

scroll_update:
        rep     #$30
        lda     scroll_hdma_data1
        cmp.w   #$000e
        beq     +
        inc
        inc
        sta     scroll_hdma_data1
        rts

+       ldx     #$0000                  ; Copy all tiles to the left.
-       lda     scroll_text_buffer+2,x
        sta     scroll_text_buffer,x
        inx
        inx
        cpx     #16*2
        bne     -

        ldx     scroll_text_x           ; Get scroll text pointer.
        lda     scroll_text,x           ; Get character from scroll text.
        and.w   #$00ff                  ; Mask high byte.
        asl
        inx                             ; Increase scroll text pointer.
        cpx     #scroll_text_length
        bne     +
        ldx     #$0000                  ; Reset scroll text pointer.
+       stx     scroll_text_x           ; Save scroll text pointer.
        tax
        lda     scroll_font_xlat,x      ; Convert ASCII to a tile.
        adc.w   #64
        sta     scroll_text_buffer+16*2 ; Store tile to text buffer.

        sep     #$20
;        lda     #%00000001
;        sta     $4300
;        lda     #$18                    ; $2118
;        sta     $4301
        ldx     #scroll_text_buffer
        stx     $4302
        stz     $4304
        ldx     #17*2
        stx     $4305
        lda     #$80
        sta     $2115
        ldx     #(13*32)+$0200
        stx     $2116
        lda     #%00000001
        sta     $420b

        rep     #$30
        lda.w   #$0000
        sta     scroll_hdma_data1
        rts


; Initialize F4CG logo.
f4cg_logo_init:
; Use DMA to store tile data for logo into VRAM.
        rep     #$30
        pea     (f4cg_logo_tile_data&&$ffff)
        pea     ((f4cg_logo_tile_data>>16)&&$ffff)
        pea     (unpackbuf&&$ffff)
        pea     ((unpackbuf>>16)&&$ffff)
        jsl     unpack
        pla
        pla
        pla
        pla

        rep     #$30
        sep     #$20
        lda     #$80
        sta     $2115                   ; Increase address on w/$2119.
        ldx     #$1000
        stx     $2116                   ; VRAM address to store tile data.
        lda     #%00000001
        sta     $4300
        lda     #$18
        sta     $4301
        ldx     #(unpackbuf&&$ffff)
        stx     $4302
        lda     #((unpackbuf>>16)&&$ff)
        sta     $4304
        ldx     #36864 ;32768                  ; Must split DMA into 2 segments
        stx     $4305                   ; since tile data is > 32768.
        lda     #%00000001
        sta     $420b

; Store palette data for logo into CGRAM.
        lda     #$40                    ; Logo colours start at 64.
        sta     $2121
        ldx     #$0000
-       lda.l   f4cg_logo_pal_data,x
        sta     $2122
        inx
        cpx     #192*2
        bne     -
; Copy screen map for logo into VRAM.
        rep     #$30
        lda.w   #$0000
        sta     $2116
        ldy     #$0000
-       lda     f4cg_logo_map_data,y
        sta     $2118
        iny
        iny
        cpy     #32*2*9
        bne     -

        lda.w   #$0000
        sep     #$20
; Adjust vertical scroll to center logo.
        lda     #>20
        sta     $210e
        lda     #<20
        sta     $210e
; Set swinging logo index.
        ldx     #0                      ; Reset sine index.
        stx     f4cg_logo_sin

        rts
f4cg_logo_sin_data:
.incbin "logo1.sin"
f4cg_logo_sin_data_end:
f4cg_logo_map_data :
.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0002,$0004,$0006,$0008,$000a,$000c,$000e
.dcw    $0120,$0122,$0124,$0126,$0128,$012a,$012c,$012e,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0020,$0022,$0024,$0026,$0028,$002a,$002c,$002e
.dcw    $0140,$0142,$0144,$0146,$0148,$014a,$014c,$014e,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0040,$0042,$0044,$0046,$0048,$004a,$004c,$004e
.dcw    $0160,$0162,$0164,$0166,$0168,$016a,$016c,$016e,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0060,$0062,$0064,$0066,$0068,$006a,$006c,$006e
.dcw    $0180,$0182,$0184,$0186,$0188,$018a,$018c,$018e,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0080,$0082,$0084,$0086,$0088,$008a,$008c,$008e
.dcw    $01a0,$01a2,$01a4,$01a6,$01a8,$01aa,$01ac,$01ae,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$00a0,$00a2,$00a4,$00a6,$00a8,$00aa,$00ac,$00ae
.dcw    $01c0,$01c2,$01c4,$01c6,$01c8,$01ca,$01cc,$01ce,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$00c0,$00c2,$00c4,$00c6,$00c8,$00ca,$00cc,$00ce
.dcw    $01e0,$01e2,$01e4,$01e6,$01e8,$01ea,$01ec,$01ee,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$00e0,$00e2,$00e4,$00e6,$00e8,$00ea,$00ec,$00ee
.dcw    $0200,$0202,$0204,$0206,$0208,$020a,$020c,$020e,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

.dcw    $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0100,$0102,$0104,$0106,$0108,$010a,$010c,$010e
.dcw    $0220,$0222,$0224,$0226,$0228,$022a,$022c,$022e,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
f4cg_logo_map_data_end:


init_snes:
        pha                             ; Save registers used.
        php                             ; Save processor status.

        rep     #$30                    ; Set AXY to 16-bit
        sep     #$20                    ; Set A to 8-bit
        lda     #$8f                    ; Screen off, full brightness.
        sta     $2100                   ; Store to screen register.
        stz     $2101                   ; sprite register (size + address in VRAM)
        stz     $2102                   ; sprite registers (address of sprite memory [OAM])
        stz     $2103                   ; "
        stz     $2105                   ; set graphics Mode 0
        stz     $2106                   ; no planes, no mosiac
        stz     $2107                   ; plane 0 map VRAM location ($0000 vram)
        stz     $2108                   ; plane 1 map VRAM location
        stz     $2109                   ; plane 2 "
        stz     $210a                   ; plane 3 "
        stz     $210b                   ; plane 0+1 tile data location
        stz     $210c                   ; plane 0+2 "
        stz     $210d                   ; plane 0 scroll x (first 8 bits)
        stz     $210d                   ; plane 0 scroll x (last 3 bits) write to reg twice
        stz     $210e                   ; plane 0 scroll y "
        stz     $210e                   ; plane 0 scroll y "
        stz     $210f                   ; plane 1 scroll x (first 8 bits)
        stz     $210f                   ; plane 1 scroll x (last 3 bits) write to reg twice
        stz     $2110                   ; plane 1 scroll y "
        stz     $2110                   ; plane 1 scroll y "
        stz     $2111                   ; plane 2 scroll x (first 8 bits)
        stz     $2111                   ; plane 2 scroll x (last 3 bits) write to reg twice
        stz     $2112                   ; plane 2 scroll y "
        stz     $2112                   ; plane 2 scroll y "
        stz     $2113                   ; plane 3 scroll x (first 8 bits)
        stz     $2113                   ; plane 3 scroll x (last 3 bits) write to reg twice
        stz     $2114                   ; plane 3 scroll y "
        stz     $2114                   ; plane 3 scroll y "
        lda     #$80                    ; increase VRAM after writes to $2118.19
        sta     $2115                   ; store to VRAM increment register
        stz     $2116                   ; VRAM address low
        stz     $2117                   ; VRAM address hi
        stz     $211a                   ; init mode 7 setting reg
        stz     $211b                   ; mode 7 matrix parameter A register (low)
        stz     $211b                   ; Mode 7 matrix parameter A register (low)
        lda     #$01
        sta     $211b                   ; Mode 7 matrix parameter A register (high)
        stz     $211c                   ; Mode 7 matrix parameter B register (low)
        stz     $211c                   ; Mode 7 matrix parameter B register (high)
        stz     $211d                   ; Mode 7 matrix parameter C register (low)
        stz     $211d                   ; Mode 7 matrix parameter C register (high)
        stz     $211e                   ; Mode 7 matrix parameter D register (low)
        lda     #$01
        sta     $211e                   ; Mode 7 matrix parameter D register (high)
        stz     $211f                   ; Mode 7 center position X register (low)
        stz     $211f                   ; Mode 7 center position X register (high)
        stz     $2120                   ; Mode 7 center position Y register (low)
        stz     $2120                   ; Mode 7 center position Y register (high)
        stz     $2121                   ; Color number register ($0-ff)
        stz     $2123                   ; BG1 & BG2 Window mask setting register
        stz     $2124                   ; BG3 & BG4 Window mask setting register
        stz     $2125                   ; OBJ & Color Window mask setting register
        stz     $2126                   ; Window 1 left position register
        stz     $2127                   ; Window 2 left position register
        stz     $2128                   ; Window 3 left position register
        stz     $2129                   ; Window 4 left position register
        stz     $212a                   ; BG1, BG2, BG3, BG4 Window Logic register
        stz     $212b                   ; OBJ, Color Window Logic Register (or,and,xor,xnor)
        stz     $212c                   ; Main Screen designation (planes, sprites enable)
        stz     $212d                   ; Sub Screen designation
        stz     $212e                   ; Window mask for Main Screen
        stz     $212f                   ; Window mask for Sub Screen
        lda     #$30
        sta     $2130                   ; Color addition & screen addition init setting
        stz     $2131                   ; Add/Sub sub designation for screen, sprite, color
        lda     #$e0
        sta     $2132                   ; color data for addition/subtraction
        stz     $2133                   ; Screen setting (interlace x,y/enable SFXdata)
        stz     $4200                   ; Enable V-blank, interrupt, Joypad register
        lda     #$ff
        stz     $4201                   ; Programmable I/O port
        stz     $4202                   ; Multiplicand A
        stz     $4203                   ; Multiplier B
        stz     $4204                   ; Multiplier C
        stz     $4205                   ; Multiplicand C
        stz     $4206                   ; Divisor B
        stz     $4207                   ; Horizontal Count Timer
        stz     $4208                   ; Horizontal Count Timer MSB (most significant bit)
        stz     $4209                   ; Vertical Count Timer
        stz     $420a                   ; Vertical Count Timer MSB
        stz     $420b                   ; General DMA enable (bits 0-7)
        stz     $420c                   ; Horizontal DMA (HDMA) enable (bits 0-7)
        stz     $420d                   ; Access cycle designation (slow/fast rom)

        lda     #$80                    ; Clear VRAM.
        sta     $2115
        ldx     #$0000
        stx     $2116
        txa
        rep     #$30
-       sta     $2118
        inx
        cpx     #$8000
        bne     -
        sep     #$20

        stz     $2121                   ; Clear CGRAM.
        ldx     #$0000
-       stz     $2122
        inx
        cpx     #512
        bne     -

        plp                             ; Restore processor status.
        pla                             ; Restore all registers.
        rts

;---------------------------------------------------------
; PRO-PACK Unpack Source Code - Super NES, Method 1
;
; Copyright (c) 1992 Rob Northen Computing
;
; File: RNC_1.S
;
; Date: 9.03.92
;---------------------------------------------------------

;---------------------------------------------------------
; Unpack Routine - Super NES, Method 1
;
; To unpack a packed file (in any data bank) to an output
; buffer (in any data bank) Note: the packed and unpacked
; files are limited to 65536 bytes in length.
;
; To call (assumes 16-bit accumulator)
;
;   PEA pack_file&$FFFF     ; push low word of packed file
;   PEA ^pack_file          ; push high word of packed file
;   PEA destn_buf&$FFFF     ; push low word of output buffer
;   PEA ^destn_buf          ; push high word of output buffer
;   JSL UNPACK              ; unpack file to output buffer
;   PLA
;   PLA
;   PLA
;   PLA
;
; On exit,
;
; A, X, Y undefined, M=0, X=0
;---------------------------------------------------------

;---------------------------------------------------------
; Equates
;---------------------------------------------------------

BUFF1   EQU $40             ; 16-bit address of $21 byte z-page buffer
BUFF2   EQU $200            ; 24-bit address of $1A0 byte buffer

IN      EQU BUFF1
OUT     EQU IN+4
WRKBUF  EQU OUT+2
COUNTS  EQU WRKBUF+3
BLOCKS  EQU COUNTS+2
BITBUFL EQU BLOCKS+2
BITBUFH EQU BITBUFL+2
BUFBITS EQU BITBUFH+2
BITLEN  EQU BUFBITS+2
HUFCDE  EQU BITLEN+2
HUFBSE  EQU HUFCDE+2
TEMP1   EQU HUFBSE+2
TEMP2   EQU TEMP1+2
TEMP3   EQU TEMP2+2
TEMP4   EQU TEMP3+2

TMPTAB  EQU 0               ; indexed from BUFF2
RAWTAB  EQU TMPTAB+$20      ; indexed from BUFF2
POSTAB  EQU RAWTAB+$80      ; indexed from BUFF2
SLNTAB  EQU POSTAB+$80      ; indexed from BUFF2

;---------------------------------------------------------
.mem    16
.index  16
.detect on

UNPACK
        REP #$39             ; 16-bit AXY, clear D and C
        LDA 6,S             ; read low word of output address
        STA OUT
        LDA 8,S             ; read high word of packed file
        STA IN+2
        LDA 10,S            ; read low word of packed file
        STA IN

        LDA 4,S
        PHB                 ; save current data bank
        XBA
        PHA                 ; push 2 bytes
        PLB                 ; 0
        PLB                 ; make output buffer default data bank
        LDA #BUFF2&$FFFF
        STA WRKBUF
        LDA #((BUFF2>>16)&&$FFFF)
        STA WRKBUF+2

        LDA #17
        ADC IN
        STA IN
        LDA [IN]
        AND #$FF
        STA BLOCKS
        INC IN
        LDA [IN]
        STA BITBUFL
        STZ BUFBITS
        LDA #2
        JSR GTBITS

UNPACK2
        LDY #RAWTAB
        JSR MAKEHUFF
        LDY #POSTAB
        JSR MAKEHUFF
        LDY #SLNTAB
        JSR MAKEHUFF
        LDA #16
        JSR GTBITS
        STA COUNTS
        JMP UNPACK8

UNPACK3
        LDY #POSTAB
        JSR GTVAL
        STA TEMP2
        LDA OUT
        CLC
        SBC TEMP2
        STA TEMP3
        LDY #SLNTAB
        JSR GTVAL
        INC A
        INC A
        LSR A
        TAX
        LDY #0
        LDA TEMP2
        BNE UNPACK5
        SEP #$20             ; 8-bit accumulator
        LDA (TEMP3),Y
        XBA
        LDA (TEMP3),Y
        REP #$20             ; 16-bit accumulator
UNPACK4
        STA (OUT),Y
        INY
        INY
        DEX
        BNE UNPACK4
        BRA UNPACK6
UNPACK5
        LDA (TEMP3),Y
        STA (OUT),Y
        INY
        INY
        DEX
        BNE UNPACK5
UNPACK6
        BCC UNPACK7
        SEP #$20             ; 8-bit accumulator
        LDA (TEMP3),Y
        STA (OUT),Y
        INY
        REP #$21             ; 16-bit accumulator, clear carry
UNPACK7
        TYA
        ADC OUT
        STA OUT

UNPACK8
        LDY #RAWTAB
        JSR GTVAL
        TAX
        BEQ UNPACK14
        LDY #0
        LSR A
        BEQ UNPACK10
        TAX
UNPACK9
        LDA [IN],Y
        STA (OUT),Y
        INY
        INY
        DEX
        BNE UNPACK9
UNPACK10
        BCC UNPACK11
        SEP #$20         ; 8-bit accumulator
        LDA [IN],Y
        STA (OUT),Y
        REP #$21         ; 16-bit accumulator, clear carry
        INY
UNPACK11
        TYA
        ADC IN
        STA IN
        TYA
        ADC OUT
        STA OUT
        STZ BITBUFH
        LDA BUFBITS
        TAY
        ASL A
        TAX
        LDA [IN]
        CPY #0
        BEQ UNPACK13
UNPACK12
        ASL A
        ROL BITBUFH
        DEY
        BNE UNPACK12
UNPACK13
        STA TEMP1
        LDA.L MSKTAB,X
        AND BITBUFL
        ORA TEMP1
        STA BITBUFL
UNPACK14
        DEC COUNTS
        BEQ +
        JMP UNPACK3
+
        DEC BLOCKS
        BEQ +
        JMP UNPACK2
+
        PLB                 ; restore old data bank
        RTL

;-----------------------------------------------------------

GTVAL
        LDX BITBUFL
        BRA GTVAL3
GTVAL2
        INY
        INY
GTVAL3
        TXA
        AND [WRKBUF],Y
        INY
        INY
        CMP [WRKBUF],Y
        BNE GTVAL2
        TYA
        ADC #(15*4+1)
        TAY
        LDA [WRKBUF],Y
        PHA
        XBA
        AND #$FF
        JSR GTBITS
        PLA
        AND #$FF
        CMP #2
        BCC GTVAL4
        DEC A
        ASL A
        PHA
        LSR A
        JSR GTBITS
        PLX
        ORA.L BITTAB,X
GTVAL4
        RTS

BITTAB
        .DCW  1
        .DCW  2
        .DCW  4
        .DCW  8
        .DCW  $10
        .DCW  $20
        .DCW  $40
        .DCW  $80
        .DCW  $100
        .DCW  $200
        .DCW  $400
        .DCW  $800
        .DCW  $1000
        .DCW  $2000
        .DCW  $4000
        .DCW  $8000

;-----------------------------------------------------------

GTBITS
        TAY
        ASL A
        TAX
        LDA.L MSKTAB,X
        AND BITBUFL
        PHA
        LDA BITBUFH
        LDX BUFBITS
        BEQ GTBITS3
GTBITS2
        LSR A
        ROR BITBUFL
        DEY
        BEQ GTBITS4
        DEX
        BEQ GTBITS3
        LSR A
        ROR BITBUFL
        DEY
        BEQ GTBITS4
        DEX
        BNE GTBITS2
GTBITS3
        INC IN
        INC IN
        LDA [IN]
        LDX #16
        BRA GTBITS2
GTBITS4
        DEX
        STX BUFBITS
        STA BITBUFH
        PLA
GTBITS5
        RTS

MSKTAB
        .DCW  0
        .DCW  1
        .DCW  3
        .DCW  7
        .DCW  $F
        .DCW  $1F
        .DCW  $3F
        .DCW  $7F
        .DCW  $FF
        .DCW  $1FF
        .DCW  $3FF
        .DCW  $7FF
        .DCW  $FFF
        .DCW  $1FFF
        .DCW  $3FFF
        .DCW  $7FFF
        .DCW  $FFFF

;-----------------------------------------------------------

MAKEHUFF
        STY TEMP4
        LDA #5
        JSR GTBITS
        BEQ GTBITS5
        STA TEMP1
        STA TEMP2
        LDY #0
MAKEHUFF2
        PHY
        LDA #4
        JSR GTBITS
        PLY
        STA [WRKBUF],Y
        INY
        INY
        DEC TEMP2
        BNE MAKEHUFF2
        STZ HUFCDE
        LDA #$8000
        STA HUFBSE
        LDA #1
        STA BITLEN
MAKEHUFF3
        LDA BITLEN
        LDX TEMP1
        LDY #0
MAKEHUFF4
        CMP [WRKBUF],Y
        BNE MAKEHUFF8
        PHX
        STY TEMP3
        ASL A
        TAX
        LDA.L MSKTAB,X
        LDY TEMP4
        STA [WRKBUF],Y
        INY
        INY
        LDA #16
        SEC
        SBC BITLEN
        PHA
        LDA HUFCDE
        STA TEMP2
        LDX BITLEN
MAKEHUFF5
        ASL TEMP2
        ROR A
        DEX
        BNE MAKEHUFF5
        PLX
        BEQ MAKEHUFF7
MAKEHUFF6
        LSR A
        DEX
        BNE MAKEHUFF6
MAKEHUFF7
        STA [WRKBUF],Y
        INY
        INY
        STY TEMP4
        TYA
        CLC
        ADC #(15*4)
        TAY
        LDA BITLEN
        XBA
        SEP #$20             ; 8-bit accumulator
        LDA TEMP3
        LSR A
        REP #$21             ; 16-bit accumulator, clear carry
        STA [WRKBUF],Y
        LDA HUFBSE
        ADC HUFCDE
        STA HUFCDE
        LDA BITLEN
        LDY TEMP3
        PLX
MAKEHUFF8
        INY
        INY
        DEX
        BNE MAKEHUFF4
        LSR HUFBSE
        INC BITLEN
        CMP #16
        BNE MAKEHUFF3
        RTS
.detect off


scroll_font_tile_data:
.incbin "font-scr.rnc"
scroll_font_pal_data:
.incbin "font-scr.pbin"
scroll_font_xlat:
.dcw    $00,$00,$00,$00,$00,$00,$00,$00 ; 0
.dcw    $00,$00,$00,$00,$00,$00,$00,$00
.dcw    $00,$00,$00,$00,$00,$00,$00,$00
.dcw    $00,$00,$00,$00,$00,$00,$00,$00

.dcw    $00,$00,$00,$00,$00,$00,$00,$00 ; 32
.dcw    $a2,$a4,$8a,$8c,$00,$a0,$8e,$00
.dcw    $66,$68,$6a,$6c,$6e,$80,$82,$84
.dcw    $86,$88,$00,$00,$00,$a8,$00,$a6

.dcw    $00,$02,$04,$06,$08,$0a,$0c,$0e ; 64
.dcw    $20,$22,$24,$26,$28,$2a,$2c,$2e
.dcw    $40,$42,$44,$46,$48,$4a,$4c,$4e
.dcw    $60,$62,$64,$00,$00,$00,$00,$00

.dcw    $00,$00,$00,$00,$00,$00,$00,$00 ; 96
.dcw    $00,$00,$00,$00,$00,$00,$00,$00
.dcw    $00,$00,$00,$00,$00,$00,$00,$00
.dcw    $00,$00,$00,$00,$00,$00,$00,$00

f4cg_logo_pal_data:
.incbin "logo1.pbin"

f4cg_logo_tile_data:
.incbin "logo1.rnc"


; Music data
song            equ     0
latstelle       equ     $7f0ffe ;Where the music is located             

initmusic       equ     $7f0200 ;dessa2 ska ha samma
playmusic       equ     initmusic+8
sustain         equ     1
voice1          equ     0
voice2          equ     7
voice3          equ     14
freq            equ     0
retrig          equ     2
pulsevalue      equ     3
waveform        equ     4
adsr            equ     5


.base   $0000
sid     .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
equal   .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
decay   .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
var     .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
var1    .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
var2    .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
var3    .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
var4    .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
var5    .dsb 21           ; 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
work    .dsb 2            ; 0,0
retriga .dsb 1            ; 0
samp    .dsb 1            ; 0
ad_sr   .dsb 4            ; 0,0,0,0
majba   .dsb 1            ; 0
.end
.detect on

LIST = $0200
;

Music_Init:
        php
	sep     #$30
	ldx     #$00
	txa
hej     stz     $00,x
	inx
	bne     hej

	jsr     initram

	ldx     #$00
	txa
cler    sta.l     $7fd400,x
	inx
	bne     cler
	lda     #$0f
	sta.l   $7fd418
	sec
	xce
	lda     #song
	jsl     initmusic
	clc
	xce
	jsr     StartSending    ;Send Spc code/data
	stz     LIST+majba
	plp
	rts
;*************************************
Music_Play:
        php
	sep     #$30
	ldx     #$3f
	lda     $2100,x         ;Pal or NTSC
	and     #$10
	bne     gaga           ;if NTSC then play 5 frames out of 6
	inc     LIST+majba
	lda     LIST+majba
	cmp     #6
	bne     gaga
	stz     LIST+majba
	bra     gaga2
gaga    jsl     playmusic
	jsr     Send_Freq
gaga2   plp
	rts
;*********************************
;* Send Frequence
;*********************************
Send_Freq
	php
	sep     #$30
	lda     #$fd
again   cmp     $2140
	bne     again
	lda     #$fe            ;reset handshaking
	sta     $2140           ;for my routines
waita   cmp     $2140
	bne     waita




	lda     #$00
	sta     LIST+work+1
	ldx     #voice1
	jsr     getvoicedata
	inc     LIST+work+1
	ldx     #voice2
	jsr     getvoicedata
	inc     LIST+work+1
	ldx     #voice3
	jsr     getvoicedata



	ldx     #$00

loopx   lda     LIST+sid,x
	sta     $2141
	stx     $2140
jups    cpx     $2140
	beq     jups
	inx
nops    cpx     $2140
	bne     nops
	cpx     #21
        bne     loopx

	plp
	rts
;*********************************   ;Very Funny Alfatech to
getvoicedata			     ;add Commentsigns to yah Source!
	php			     ;Nicest Guy on Scene!? :(
	rep     #$20
	clc
	lda.l   $7fd400,x
	ldy     #$00
	lsr     a
	cmp.w   #$3000
	bcc     nops1
	clc
	lsr     a
	ldy     #1
nops1   sta     LIST+sid+freq,x
	tya
	sta     LIST+sid+retrig,x

	sep     #$20
	ldy     #$00
	lda     #$00
	sta     LIST+sid+waveform,x
	lda.l   $7fd404,x
	and     #$01
	beq     fade
	ldy     #$80
fade    sty     LIST+work
	lda.l   $7fd404,x
	and     #$f0
	sta     LIST+samp
	and     #$80
	beq     noss2
	lda     #$03
	sta     LIST+sid+waveform,x
	bra     getadsr
noss2
	lda     LIST+samp
	and     #$40
	beq     nopulse
	lda     #$02
	sta     LIST+sid+waveform,x
	lda     LIST+samp
	and     #$10
	beq     getadsr
	lda     #$22
	sta     LIST+sid+waveform,x
	bra     getadsr
nopulse
	lda     LIST+samp
	and     #$20
	beq     noss
	lda     #$01
	sta     LIST+sid+waveform,x
	bra     getadsr
noss
	lda     LIST+samp
	and     #$10
	beq     noss1
	lda     #$00
	sta     LIST+sid+waveform,x
	bra     getadsr
noss1
	lda     LIST+samp
	bne     getadsr
	lda     #36
	sta     LIST+sid+waveform,x
getadsr
	lda.l     $7fd405,x
	lsr     a
	lsr     a
	lsr     a
	lsr     a
	asl     a
	sta     LIST+ad_sr

	lda.l     $7fd405,x
	and     #$0f
	asl     a
	sta     LIST+ad_sr+1

	lda.l   $7fd406,x
	lsr     a
	lsr     a
	lsr     a
	lsr     a
	eor     #$0f
	asl     a
	sta     LIST+ad_sr+2

	lda.l   $7fd406,x
	and     #$0f
	asl     a
	sta     LIST+ad_sr+3

	lda.l   $7fd400+voice1+pulsevalue,x	;DAM1
	and     #$0f
	pha
	cmp     #$00
	bne     ok
	lda     $7fd400+voice1+retrig,x
	beq     ok     
	pla
	inc     a
	bra     ok+1
ok      pla
	sta     LIST+sid+pulsevalue,x

doadsr
	lda     LIST+work
	beq     decrease
	lda     LIST+decay,x
	bne     decay1

	rep     #$20
	lda     LIST+equal+adsr,x
	cmp.w   #$7fff
	beq     e
	ldy     LIST+ad_sr
	lda     LIST+equal+adsr,x
	clc
	adc     attack,y		;DAM2
	cmp.w   #$7fff
	bcc     nottop
	lda.w   #sustain
	sta     LIST+decay,x
	lda.w   #$7fff
nottop  sta     LIST+equal+adsr,x
	bra     endcalcdata
e
	lda.w   #sustain
	sta     LIST+decay,x
	bra     endcalcdata
decrease

	rep     #$20
	lda.w   #$00
	sta     LIST+decay,x
	lda     LIST+equal+adsr,x
	cmp.w   #$0000
	beq     endcalcdata
	jsr     checkvar
	bcc     endcalcdata
	ldy     LIST+ad_sr+3
	lda     LIST+equal+adsr,x
	sec
	sbc     release,y
	bpl     notbot
	lda.w   #$0000
notbot  sta     LIST+equal+adsr,x
	bra     endcalcdata
decay1
	rep     #$20
	ldy     LIST+ad_sr+2
	lda     LIST+equal+adsr,x
	cmp     sustain1,y
	beq     endcalcdata
	jsr     checkvar
	bcc     endcalcdata
	ldy     LIST+ad_sr+1
	lda     LIST+equal+adsr,x
	sec
	sbc     release,y
	ldy     LIST+ad_sr+2
	cmp     sustain1,y
	bcs     notsus
	lda     sustain1,y
notsus  sta     LIST+equal+adsr,x
endcalcdata
	lda     LIST+equal+adsr,x
	sta     $4204
	sep     #$30
	lda.l   $7fd418
	eor     #$0f
	and     #$0f
	bne     divid
full    rep     #$20
	lda     LIST+equal+adsr,x
	bra     full2
divid   sta     $4206
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	rep     #$20
	lda     $4214
full2   and.w   #$7fff
	sta     LIST+sid+adsr,x
	plp
	rts
checkvar
	lda     LIST+equal+adsr,x
	cmp.w   #$0001
	bmi     check6
	cmp.w   #$0c01
	bmi     check5
	cmp.w   #$1401
	bmi     check4
	cmp.w   #$2001
	bmi     check3
	cmp.w   #$2c01
	bmi     check2
	cmp.w   #$3801
	bmi     check1
subba   lda.w     #0
	sta     LIST+var,x
	sta     LIST+var1,x
	sta     LIST+var2,x
	sta     LIST+var3,x
	sta     LIST+var4,x
	sta     LIST+var5,x
	sec
	rts
checko
	jmp     check6
check1
	inc     LIST+var,x
	lda     LIST+var,x
	cmp.w     #2
	beq     subba
	clc
	rts
check2
	inc     LIST+var1,x
	lda     LIST+var1,x
	cmp.w     #3
	beq     subba
	clc
	rts
check3
	inc     LIST+var2,x
	lda     LIST+var2,x
	cmp.w     #4
	beq     subba
	clc
	rts
check4
	inc     LIST+var3,x
	lda     LIST+var3,x
	cmp.w     #4
	beq     subba
	clc
	rts
check5
	inc     LIST+var4,x
	lda     LIST+var4,x
	cmp.w     #5
	beq     subba
	clc
	rts
check6
	inc     LIST+var5,x
	lda     LIST+var5,x
	cmp.w     #6
	beq     subba
	clc
	rts


attack         ;attack verde ... hur snabb okning fran nuvarande
		;till fullljudstyrka
        .dcw   32767,32767,32767,27306,17246,11565,9637,8192
        .dcw   6553,2621,1310,819,655,218,131,82
release        ;release/decay ... samma tabell
        .dcw   32767,27306,13653,9102,5748,3900,3212,2730
        .dcw   2184,873,436,273,218,72,43,27
sustain1
        .dcw   32767,30720,28672,26624,24576,22528,20480,18432
        .dcw   16384,14336,12288,10240,8192,6144,4096,2048,0
;*********************************	;AGAIN VERY FUNNY!




initram
	php
	rep     #$10
	sep     #$20
	ldx.w     #$00
copram  lda     ram,x		;DAM3
	sta     initmusic,x
	inx
	cpx.w     #endram-ram
	bne     copram
	ldx.w     #$00
copmus  lda     c64tune,x
	sta     latstelle,x
	inx
	cpx.w     #c64tuneend-c64tune
	bne     copmus
	plp
	rts
;	mode    a8x8   ; <---- WHAT THE HELL DOES THIS SHIT ON AMIGA ASSEMBLERS
ram		       ; ----- IT IS GETTING PUKING WITH THE (L)AMIGOS!
	phb
	phk
	plb
	jsr     initreal
	plb
	rtl
rum
	phb
	phk
	plb
	jsr     playreal
	plb
	rtl
endram
;**************************  		;OH NO!  :(

StartSending
	php
	SEP #$20
	phk
	pla
	STA $FF
	REP #$20
	LDA.w #code
	STA $FD
	JSR SendToSpc
	SEP #$20
	lda #$ff
	sta $2140
	Stz $2142
	plp
	RTS
SendToSpc
	PHP
	REP #$30
	LDY.w #$0000
	LDA.w #$BBAA
wait    CMP $2140
	BNE wait
	SEP #$20
	LDA #$CC
	BRA lab3
loop    LDA [$FD],y
	INY
	XBA
	LDA #$00
	BRA lab1
loop2   XBA
	LDA [$FD],y
	INY
	XBA
lab2    CMP $2140
	BNE lab2
	INC A
lab1    REP #$20
	STA $2140
	SEP #$20
	DEX
	BNE loop2
lab5    CMP $2140
	BNE lab5
lab4    ADC #$03
	BEQ lab4
lab3    PHA
	REP #$20
	LDA [$FD],y
	INY
	INY
	TAX
	LDA [$FD],y
	INY
	INY
	STA $2142
	SEP #$20
	CPX.w #$0001
	LDA #$00
	ROL A
	STA $2141
	ADC #$7F
	PLA
	STA $2140
lab6    CMP $2140
	BNE lab6
	BVS loop
	PLP
	RTS
;*****************************************
;*               SPC CODE                *
;*****************************************
code    
        .dcw   CodeEnd-CodeStart,$0400
CodeStart
        .bin    spc_code.bin
CodeEnd
        .dcw   0,$0400 ;start,address
        .dcb    "MusicRoutine  Alfatech/Censor 94"
;*****************************************

title_text:
; All text must be in uppercase.
;        0123456789012345               fill rest with blanks
.dcb    "    PRESENTS    "      \       .dsb    16
.dcb    "  BLING BLANG   "      \       .dsb    16
.dcb    "     BLONG      "      \       .dsb    16

scroll_text:
; All text must be in uppercase.  Not all characters used.
.dcb    "     "
.dcb    "HELLO THERE EVERYONE.  THIS IS AN F4CG INTRO. "
.dcb    "THANKS TO SOLAR, PAN, YOSHI, SHINOBI. "
.dcb    "SEE YOU IN THE NEXT RELEASE.   -MINUS "
scroll_text_end:
scroll_text_length = scroll_text_end-scroll_text

;*****************************************
c64tune
.incbin "jch8.bin"
;.incbin "strike_f.dat"
c64tuneend
;*****************************************

initreal        equ     $1000   ;Init
playreal        equ     $1003   ;Play

