varying vec2 texCoord;
//varying vec4 vColor;
uniform sampler2D colorMap;
uniform sampler2D nukecircleMap;
uniform float xc;
uniform float yc;
/*
void main (void)
{
	gl_FragColor = texture2D(colorMap, texCoord);
}
*/

/*
void main (void)
{
//vec2 nutexcoord;
//	nutexcoord=texCoord;
//	nutexcoord.x=1.0-nutexcoord.x;
    float offset=(1.0f-(texture2D(nukecircleMap, texCoord).r-0.5)/30.0f);
    float newx=texCoord.x/offset;
    float newy=texCoord.y/offset;
	gl_FragColor = texture2D(colorMap, vec2(newx,newy));
	//gl_FragColor = texture2D(colorMap, texCoord)*vColor;
	//gl_FragColor = texture2D(colorMap, nutexcoord);
}
*/

uniform vec2 iResolution= vec2(1920,1080);
uniform vec2 iMouse=vec2(0,0);
//uniform float alpha;
float lensfactor=0.65f; //0.15

#define EPSILON 0.000011


void main(void)//Drag mouse over rendering area
{
  //normalized coords with some cheat
  vec2 p = gl_FragCoord.xy / iResolution.x;

  //screen proportion
  float prop = iResolution.x / iResolution.y;
  //center coords
  //vec2 m = vec2(0.5, 0.5 / prop);
  vec2 m = vec2(xc/1920.0f,yc/1080.0f/ prop);
  //vector from center to current fragment
  vec2 d = p - m;
  // distance of pixel from center
  float r = sqrt(dot(d, d));
  float r_= 1.0f-r*2.0f;
  if (r_<0.3f) r_=0.3f;
  //amount of effect
  float power = ( lensfactor * 3.141592 / (2.0 * sqrt(dot(m, m))) ) * //WAS ORIGINALLY 2.0 * 3.14... then 1.4
		(iMouse.x / iResolution.x - 0.5);

  float factor=((texture2D(nukecircleMap, texCoord).r)); power=power*factor*r_;//*alpha;


  //radius of 1:1 effect
  float bind;
  if (power > 0.0) bind = sqrt(dot(m, m));//stick to corners
  else {if (prop < 1.0) bind = m.x; else bind = m.y;}//stick to borders

  //Weird formulas
  vec2 uv;
  if (power > 0.0)//fisheye
    uv = m + normalize(d) * tan(r * power) * bind / tan( bind * power);
  else if (power < 0.0)//antifisheye
   uv = m + normalize(d) * atan(r * -power * 10.0) * bind / atan(-power * bind * 10.0);
  else
    uv = p;//no effect for power = 1.0

  //Second part of cheat
  //for round effect, not elliptical
  uv.x=clamp(uv.x,0.0f,1.0f-0.00001f);
  uv.y=clamp(uv.y*prop,0.0f,1.0f-0.00001f);
  vec3 col = texture2D(colorMap, vec2(uv.x, uv.y)).xyz;

  gl_FragColor = vec4(col, 1.0);
}
