#version 330 core

/*

Copyright (c) 2015 miloszmaki

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:


The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

//downloaded from www.shadertoy.com and edited by dm/eastgate

uniform vec3      iResolution=vec3(1920,1080,0);           // viewport resolution (in pixels)

uniform float     iGlobalTime;           // shader playback time (in seconds)

uniform float     iChannelTime[4]={0,0,0,0};       // channel playback time (in seconds)
uniform vec3      iChannelResolution[4]=
                    {vec3(512,512,0),
                     vec3(512,512,0),
                     vec3(512,512,0),
                     vec3(512,512,0)};
                // channel resolution (in pixels)
uniform vec4      iMouse=vec4(0,0,0,0);                // mouse pixel coords. xy: current (if MLB down), zw: click
uniform vec4      iDate=vec4(0,0,0,0);                 // (year, month, day, time in seconds)
uniform float     iSampleRate=0.0f;           // sound sample rate (i.e., 44100)

uniform sampler2D iChannel0;
uniform sampler2D iChannel1; //..3;          // input channel. XX = 2D/Cube

//uniform int       iGlobalFrame;          // shader playback frame

varying vec2 texCoord;
uniform sampler2D colorAbber;
uniform sampler2D skyclouds;

#define saturate(x) clamp(x,0.,1.)
#define rgb(r,g,b) (vec3(r,g,b)/255.)

//uniform float     iGlobalTime;           // shader playback time (in seconds)

float rand(float x) { return fract(sin(x) * 1255552.5413291); }

float rand(vec2 x) { return rand(dot(x, vec2(13.4251, 15.5128))); }

float noise(vec2 x)
{
    vec2 i = floor(x);
    vec2 f = x - i;
    f *= f*(3.-2.*f);
    return  mix(mix(rand(i), rand(i+vec2(1,0)), f.x),
            mix(rand(i+vec2(0,1)), rand(i+vec2(1,1)), f.x), f.y);
}

float fbm(vec2 x)
{
    float r = 0.0, s = 1.0, w = 1.0;
    for (int i=0; i<5; i++)
    {
        s *= 2.0;
        w *= 0.5;
        r += w * noise(s * x);
    }
    return r;
}

float cloud(vec2 uv, float scalex, float scaley, float density, float sharpness, float speed)
{
    return pow(saturate(fbm(vec2(scalex,scaley)*(uv+vec2(speed,0)*iGlobalTime/2.0))-(1.0-density)), 1.0-sharpness);
}

vec3 render(vec2 uv)
{
    // sky
    vec3 color = mix(rgb(35,60,140), rgb(78,107,203), uv.y);
    vec3 color2 = color;

    // sun
    /*
    vec2 spos = uv - vec2(0.2, 0.4);
    float sun = exp(-40.*dot(spos,spos));
    vec3 scol = rgb(122,125,210) * sun * 0.7;
    color += scol;
    */

    // clouds
    #define YSC 1.50
    vec3 cl1 = mix(rgb(151,138,173), rgb(166,191,234),uv.y);
    float d1 = mix(0.9,0.1,pow(uv.y, 0.7));

    color = mix(color, cl1, cloud(uv,2.,8./YSC,d1,0.4,0.04));
    color = mix(color, vec3(0.9), 6.*cloud(uv,14.,18./YSC,0.9,0.75,0.02) * cloud(uv,2.,5./YSC,0.6,0.15,0.01)*(uv.y*1.4f));
    color = mix(color, vec3(0.8), 5.*cloud(uv,12.,15./YSC,0.9,0.75,0.03) * cloud(uv,2.,8./YSC,0.5,0.0,0.02)*(uv.y*2.0f));

    // post

    color *= vec3(0.85,0.85,1.0)*1.04;
    color = mix(0.75*rgb(120,144,220), color, smoothstep(-0.1,0.3,1.0-uv.y));
    color = pow(color,vec3(1.1));

    color = mix(color,color2,0.75f);

    return color;

}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv.x -= 0.5;
    uv.x *= iResolution.x / iResolution.y;

	fragColor = vec4(render(uv),1.0);
}

void main (){
vec4 pixel;

    vec2 fragCoord=gl_FragCoord.xy;
    mainImage(pixel, fragCoord);

	float xc=(pixel.r+pixel.g+pixel.b)/3.0f;
	gl_FragColor = texture2D(colorAbber,vec2(clamp(xc,0.0f,0.9f),texCoord.y))+texture2D(skyclouds,texCoord);

	//gl_FragColor=pixel;
}
