#ifdef LINUX

typedef unsigned short u16;
typedef unsigned int u32;

#endif

#ifndef _stdio_h
#define _stdio_h

#define R( c )	( ( ((u16)c>>3) & 0x1F) << 11 )
#define G( c )	( ( ((u16)c>>3) & 0x1F) <<  6 )
#define B( c )	( ( ((u16)c>>3) & 0x1F)       )
#define RGB(r,g,b) (u16)( R(r) | G(g) | B(b) )

#define WHITE RGB(255,255,255)
#define GREY RGB(128,128,128)
#define BLACK RGB(0,0,0)

#define RED RGB( 255,0,0 )
#define GREEN RGB( 0,255,0 )
#define BLUE RGB( 0,0,255 )

#define YELLOW RGB( 255,255,0 )

typedef struct FB {
	u16	x,y;
	u16	startx;
	u16	screen_wd;
	u16	screen_ht;
	u16	*fb0;
	u16	*fb1;
	u16	color;
} FB;

typedef union {
	unsigned char uc;
	char c;
	unsigned int us;
	int s;
	unsigned int ui;
	int i;
	double	f;  /* FOR SOME REASON GCC PASSES FLOATS AS DOUBLES */
	char *str;
} Arg;

void	printf(FB *, int, char *, ...);
void	printm(FB *, int, Mtx *);
void	cvt(int,char **,Arg,int,int,int);
void	rasterize();
void	blit();

#endif
