#include <ultra64.h>

#include "math.h"
#include "stdio.h"
#include "gfxlib.h"
#include "main.h"
#include "M_breakup.h"

float	logo_rx=0, logo_ry=45, logo_rz=0;

float	logo_tx = 0;
float	logo_ty = -60;
float	logo_tz = -120;

#define NEAR_CLIP   3
#define FAR_CLIP    18000

float camera_xEye=0, camera_yEye=0, camera_zEye=300;
float camera_xAt=0, camera_yAt=0, camera_zAt=0;
float camera_xUp=0, camera_yUp=1, camera_zUp=0;

extern Lights1 thelit;

extern Gfx M_breakup_M_cvt_brk1_brk1_dl[];

extern u16	_cfb[2][SCREEN_WD*SCREEN_HT];
extern u16	_zbuffer[2][SCREEN_WD*SCREEN_HT];

extern void	explode( Gfx * );
Gfx	*M_logo;

float fov=50;

/* defined in ld.script */
extern char _codeSegmentEnd[];
extern char _staticSegmentRomStart[], _staticSegmentRomEnd[];
char		*staticSegment;

/*
 * Stacks for the threads as well as message queues for synchronization
 */
u64	bootStack[STACKSIZE/sizeof(u64)];

static void	idle(void *);
static void	mainproc(void *);

OSThread	idleThread;
u64	idleThreadStack[STACKSIZE/sizeof(u64)];

OSThread	mainThread;
u64	mainThreadStack[STACKSIZE/sizeof(u64)];

OSContStatus	statusdata[MAXCONTROLLERS];
OSContPad	controllerdata[MAXCONTROLLERS];
int	controller;

#define NUM_PI_MSGS     8

OSMesg PiMessages[NUM_PI_MSGS];
OSMesgQueue PiMessageQ;

OSMesgQueue	dmaMessageQ, rspMessageQ, rdpMessageQ, retraceMessageQ;
OSMesg		dmaMessageBuf, rspMessageBuf, rdpMessageBuf, retraceMessageBuf;
OSIoMesg	dmaIOMessageBuf;	/* see man page to understand this */

OSMesgQueue	    serialMsgQ;
OSMesg	    serialMsg;

/*
 * Dynamic data.
 */
Dynamic dynamic;

/*
 * Task descriptor.
 */
OSTask	tlist =
{
    M_GFXTASK,			/* task type */
    OS_TASK_DP_WAIT,		/* task flags */
    NULL,			/* boot ucode pointer (fill in later) */
    0,				/* boot ucode size (fill in later) */
    NULL,			/* task ucode pointer (fill in later) */
    SP_UCODE_SIZE,		/* task ucode size */
    NULL,			/* task ucode data pointer (fill in later) */
    SP_UCODE_DATA_SIZE,		/* task ucode data size */
    &(dram_stack[0]),		/* task dram stack pointer */
    SP_DRAM_STACK_SIZE8,	/* task dram stack size */
    NULL,		/* task output buffer ptr (not always used) */
    NULL,		/* task output buffer size ptr */
    NULL,			/* task data pointer (fill in later) */
    0,				/* task data size (fill in later) */
    NULL,			/* task yield buffer ptr (not used here) */
    0				/* task yield buffer size (not used here) */
};

Gfx		*glistp;	/* global for test case procs */

/*
 * global variables
 */
int      draw_buffer;

void
boot(void)
{
    int i;
    char *ap;
    u32 *argp;
    
    osInitialize();

    osCreateThread(&idleThread, 1, idle, (void *)0,
		   idleThreadStack+STACKSIZE/sizeof(u64), 10);
    osStartThread(&idleThread);

    /* never reached */
}

static void
idle(void *arg)
{
    /* Initialize video */
    osCreateViManager(OS_PRIORITY_VIMGR);
    osViSetMode(&osViModeTable[OS_VI_NTSC_LAN1]);	/* LAN1=2 */
    /* Added by S@NTSC 06/24/96
     *  for Dithering
     */
    osViSetSpecialFeatures(OS_VI_DITHER_FILTER_ON);
    /* End of Patch */
    
    /*
     * Start PI Mgr for access to cartridge
     */
    osCreatePiManager((OSPri)OS_PRIORITY_PIMGR, &PiMessageQ, PiMessages, 
		      NUM_PI_MSGS);
    
    /*
     * Create main thread
     */
    osCreateThread(&mainThread, 3, mainproc, arg,
		   mainThreadStack+STACKSIZE/sizeof(u64), 10);
    
	osStartThread(&mainThread);

    /*
     * Become the idle thread
     */
    osSetThreadPri(0, 0);

    for (;;);
}

/*
 *
 * Return the lowest number controller connected to system
 */
static int initControllers(void)
{
    int		    i;
    u8		    pattern;

    osContInit(&serialMsgQ, &pattern, &statusdata[0]);

    for (i = 0; i < MAXCONTROLLERS; i++) {
	if ((pattern & (1<<i)) &&
		!(statusdata[i].errno & CONT_NO_RESPONSE_ERROR))
	    return i;
    }
    return -1;
}

/* print framebuffer def */
FB	fb;

#include "M_breakup_init.c"

static void
mainproc(void *arg)
{
    OSTask		*tlistp;
    Dynamic		*dynamicp;
    u16                 perspNorm;
    register	OSContPad	*pad;
    int   usejoy = 0;
    register	u16    lastbutton = 0;
    register	s8    lastx;
    register	s8    lasty;
    register	s8    lastxinc;
    register	s8    lastyinc;
    float camX = 0; float camY = 0; float camZ = 0;
    int i,j;
    int printstuff,firsttime=1;
	int	ctime,otime;
	int	pause=0;

    draw_buffer = 0;
    printstuff=0;

    /* setup framebuffer for printing */
    fb.startx = 4;		/* left most char */
    fb.x = 4; fb.y = 0;		/* in characters */
    fb.color = WHITE;		/* char color */
    fb.screen_wd = SCREEN_WD;	/* in pixels */
    fb.screen_ht = SCREEN_HT;
    fb.fb0 = _cfb[0];
    fb.fb1 = _cfb[1];

    /*
     * Setup the message queues
     */
    osCreateMesgQueue(&dmaMessageQ, &dmaMessageBuf, 1);
    
    osCreateMesgQueue(&rspMessageQ, &rspMessageBuf, 1);
    osSetEventMesg(OS_EVENT_SP, &rspMessageQ, NULL);
    
    osCreateMesgQueue(&rdpMessageQ, &rdpMessageBuf, 1);
    osSetEventMesg(OS_EVENT_DP, &rdpMessageQ, NULL);
    
    osCreateMesgQueue(&retraceMessageQ, &retraceMessageBuf, 1);
    osViSetEvent(&retraceMessageQ, NULL, 1);
    
    /*
     * Stick the static segment right after the code/data segment
     */
    staticSegment = _codeSegmentEnd;
    osPiStartDma(&dmaIOMessageBuf, OS_MESG_PRI_NORMAL, OS_READ,
		 (u32)_staticSegmentRomStart, staticSegment,
		 (u32)_staticSegmentRomEnd - (u32)_staticSegmentRomStart,
		 &dmaMessageQ);

	M_logo = (Gfx *)(((u32)&(M_breakup_M_cvt_brk1_brk1_dl) & 0x00FFFFFF) 
		+ staticSegment);

    /*
     * Wait for DMA to finish
     */
    (void)osRecvMesg(&dmaMessageQ, NULL, OS_MESG_BLOCK);

    osCreateMesgQueue(&serialMsgQ, &serialMsg, 1);
    osSetEventMesg(OS_EVENT_SI, &serialMsgQ, (OSMesg)1);

    controller = initControllers();

    /*
     * Main loop
     */

while (1) {
	fb.y=2;

	if (controller>=0) {
        osContStartReadData(&serialMsgQ);
             
        (void)osRecvMesg(&serialMsgQ, NULL, OS_MESG_BLOCK);
             
        osContGetReadData(controllerdata);
 
        pad = &controllerdata[controller];

		switch ( pad->button ) {
			case CONT_START:
        		if (!(lastbutton & CONT_START)) {
          			printstuff++;
          			printstuff %= 2;
        		}
				break;
        
        	case CONT_R:
				logo_tz -= 20;
				break;
        
        	case CONT_L:
				logo_tz += 20;
				break;

        	case R_CBUTTONS: 
				break;

        	case L_CBUTTONS: 
				break;

        	case U_CBUTTONS: 
				break;

        	case D_CBUTTONS: 
				break;

			case CONT_LEFT:
				logo_tx -= 20;
				break;

			case CONT_RIGHT:
				logo_tx += 20;
				break;
        
			case CONT_DOWN:
				logo_ty -= 20;
				break;

			case CONT_UP:
				logo_ty += 20;
				break;
        
			case CONT_A:
	  			camX = camY = camZ = 0;
				break;

			case CONT_B:
				break;
        
			case CONT_G:
				break;

			default:
				break;
		}	/* end switch */
			
		pad->stick_x = pad->stick_x;
		pad->stick_y = pad->stick_y;

		lastxinc = pad->stick_x - lastx;
		lastyinc = pad->stick_y - lasty;

	    lastx = pad->stick_x;
    	lasty = pad->stick_y;

		logo_rx += (2 * lastyinc);
		logo_ry += (2 * lastxinc);

    	lastbutton = pad->button;
	}

      /*
       * pointers to build the display list.
       */
      tlistp = &tlist;
      dynamicp = &dynamic;
        
      glistp = dynamicp->glist;

      /*
       * Tell RCP where each segment is
       */
      gSPSegment(glistp++, 0, 0x0);	/* Physical address segment */
      gSPSegment(glistp++, STATIC_SEGMENT, OS_K0_TO_PHYSICAL(staticSegment));
      gSPSegment(glistp++, CFB_SEGMENT, OS_K0_TO_PHYSICAL(_cfb[draw_buffer]));
        
      /*
       * Initialize RDP state.
       */
      gSPDisplayList(glistp++, rdpinit_dl);

      /*
       * Initialize RSP state.
       */
      gSPDisplayList(glistp++, rspinit_dl);

      /* Clear the Z buffer. */
      	gSPDisplayList(glistp++, clearZbfr_dl);

      /* Set the Z buffer */
      gDPSetDepthImage(glistp++, _zbuffer);

      /*
       * Clear color framebuffer.
       */
        gSPDisplayList(glistp++, clearcfb_dl);

      /* Setup the camera */
      guPerspective(&dynamicp->projection, &perspNorm, fov,
		    1.333, NEAR_CLIP, FAR_CLIP, 1.0);

       guLookAt(&dynamicp->viewing, 
		camera_xEye, camera_yEye, camera_zEye,
		camera_xAt,  camera_yAt,  camera_zAt,
		camera_xUp,  camera_yUp, camera_zUp);

      gSPDisplayList(glistp++, cam_proj);
      gSPDisplayList(glistp++, cam_viewing);

      gSPPerspNormalize(glistp++, perspNorm);

      gSPDisplayList(glistp++, lits_dl);

      pause++;
      if (pause>90) explode( M_logo );

      init_M_breakup();
      gSPDisplayList(glistp++, M_breakup_dl);
      osWritebackDCache(&dynamic, sizeof(Vtx_tn) 
		* NVtx_M_breakup_M_cvt_brk1_brk1);

      gDPFullSync(glistp++);
      gSPEndDisplayList(glistp++);

      /* 
       * Build graphics task:
       *
       */
      tlistp->t.ucode_boot = (u64 *) rspbootTextStart;
      tlistp->t.ucode_boot_size = (u32)rspbootTextEnd - (u32)rspbootTextStart;

      /* RSP output over XBUS to RDP: */
      tlistp->t.ucode = (u64 *) gspFast3DTextStart;
      tlistp->t.ucode_data = (u64 *) gspFast3DDataStart;
	
      /* initial display list: */
      tlistp->t.data_ptr = (u64 *) dynamicp->glist;
      tlistp->t.data_size = (u32)((glistp - dynamicp->glist) * sizeof(Gfx));

      /*
       * Write back dirty cache lines that need to be read by the RCP.
       */
      osWritebackDCache(&dynamic, sizeof(dynamic));
	
      /*
       * start up the RSP task
       */
      osSpTaskStart(tlistp);

      /* wait for SP completion */
      (void)osRecvMesg(&rspMessageQ, NULL, OS_MESG_BLOCK);
      (void)osRecvMesg(&rdpMessageQ, NULL, OS_MESG_BLOCK);

      if ( printstuff == 0 ) {
		printf(&fb,draw_buffer,"logo %f %f %f\n",logo_tx,logo_ty,logo_tz);
      }

      if ( printstuff == 1 ) {
	    otime = ctime;
	    ctime = time();
		printf(&fb,draw_buffer,"FPS %d\n",(int)(TIMER_CPS/(ctime-otime)));
      }

      /* setup to swap buffers */
      osViSwapBuffer(_cfb[draw_buffer]);

      /* Make sure there isn't an old retrace in queue 
       * (assumes queue has a depth of 1) 
       */
      if (MQ_IS_FULL(&retraceMessageQ))
        (void)osRecvMesg(&retraceMessageQ, NULL, OS_MESG_BLOCK);
	
      /* Wait for Vertical retrace to finish swap buffers */
      (void)osRecvMesg(&retraceMessageQ, NULL, OS_MESG_BLOCK);

      draw_buffer ^= 1;
    }
}
