#include <ultra64.h>

/* do set tabstop=4 in vi to view this correctly */

/* these are the test case for parsing gbi stuff (null objects) */
/* i *think* this is the correct way to do it */
Gfx	Triangle = { gsSP1Triangle( 0,0,0,0 ) };
Gfx	Vertex = { gsSPVertex( 0,0,0 ) };
Gfx	EndDl = { gsSPEndDisplayList() };

typedef	struct x_tri {
	float	sin,cos;
	float	time;
} x_tri;

/* this where rom get relocated to in ram */
extern char	*staticSegment;

/* bogus physics */
#define ACCEL 15
#define GRAVITY 2

/* explosions radius gets incremented by this */
#define EXPLOSIONSPEED 5

/* don't let the explosion go too long.. it hangs eventually */
#define ENDTIME 400

/* explosion radius. Gets incremented over time */
float	explosion=0;

/* explosion tri list (makka=1202 tri's) */
#define MAX_TRI 1250
x_tri	tri[MAX_TRI];


/*           			*/
/*    *** WARNING ***	*/
/*           			*/
/* this routine trashes the model's */
/* vertices!!! you have to re-DMA it from rom */
/* if you want to use it later! */

explode( model )
Gfx *model;
{
	int	eof=0;
	unsigned	int	v0,v1,v2,dmasize,nverts;
	Vtx_tn	*vtxaddr,*vcache[16];
	float	dx,dy,dz;
	float	tm=0;
	register	float	x0,x1,x2,y0,y1,y2,z0,z1,z2;
	register	float	x_c,y_c,z_c;
	register	float	xt,yt,zt;
	int		v;
	int		curr_tri=0,i;

	/* init structs */
	if ( explosion == 0 )
		for (i=0; i<MAX_TRI; i++)
			tri[i].time=0;

	/* only tri's in this radius get exploded */
    explosion += EXPLOSIONSPEED;

	while ( !eof ) {
		/* triangle? */
		if ( ((*model).words.w0 & 0xFF000000)  
		== ( Triangle.words.w0 & 0xFF000000 ) ) {

			/* vertex indices in vertex cache */
			v0 = ( (*model).words.w1 & 0x00FF0000 ) >> 16;
			v0 /= 10;

			v1 = ( (*model).words.w1 & 0x0000FF00 ) >>  8;
			v1 /= 10;

			v2 =   (*model).words.w1 & 0x000000FF        ;
			v2 /= 10;

			/* tri's center */
			/* for when i put random rotation in */
			x_c = ( (*vcache[v0]).ob[0] + (*vcache[v1]).ob[0]
					+ (*vcache[v2]).ob[0] ) / 3;
			y_c = ( (*vcache[v0]).ob[1] + (*vcache[v1]).ob[1]
					+ (*vcache[v2]).ob[1] ) / 3;
			z_c = ( (*vcache[v0]).ob[2] + (*vcache[v1]).ob[2]
					+ (*vcache[v2]).ob[2] ) / 3;

			/* tri center mag */
			tm = x_c * x_c + y_c * y_c + z_c * z_c;
			tm = sqrtf(tm);

			dx = ACCEL * x_c / tm;
			dy = ACCEL * y_c / tm;
			dz = ACCEL * z_c / tm;

			/* add explosion factors if it's reach triangle */
			if ( tri[curr_tri].time == 0 ) {
				if ( explosion > tm ) {
					tri[curr_tri].time = 1;
				}
			}
			else {
				tri[curr_tri].time++;

				if ( tri[curr_tri].time < ENDTIME ) {

					tri[curr_tri].sin = sinf( ((int)tri[curr_tri].time % 7)*8.0 );
					tri[curr_tri].cos = cosf( ((int)tri[curr_tri].time % 7)*8.0 );

					/* center vertices */
					/* for rotation */
					x0 = (*vcache[v0]).ob[0] - x_c;
					y0 = (*vcache[v0]).ob[1] - y_c;
					z0 = (*vcache[v0]).ob[2] - z_c;

					x1 = (*vcache[v1]).ob[0] - x_c;
					y1 = (*vcache[v1]).ob[1] - y_c;
					z1 = (*vcache[v1]).ob[2] - z_c;

					x2 = (*vcache[v2]).ob[0] - x_c;
					y2 = (*vcache[v2]).ob[1] - y_c;
					z2 = (*vcache[v2]).ob[2] - z_c;

					/* rotate tri */
					/* rotx vert0 */
					xt = x0;
					yt = tri[curr_tri].cos * y0 - tri[curr_tri].sin * z0;
					zt = tri[curr_tri].sin * y0 + tri[curr_tri].cos * z0;
					/* roty (same angle as rotx-for space reasons) */
					x0 = tri[curr_tri].cos * xt + tri[curr_tri].sin * zt;
					y0 = yt;
					z0 = -tri[curr_tri].sin * xt + tri[curr_tri].cos * zt;

					/* rotx vert1 */
					xt = x1;
					yt = tri[curr_tri].cos * y1 - tri[curr_tri].sin * z1;
					zt = tri[curr_tri].sin * y1 + tri[curr_tri].cos * z1;
					/* roty (same angle as rotx-for space reasons) */
					x1 = tri[curr_tri].cos * xt + tri[curr_tri].sin * zt;
					y1 = yt;
					z1 = -tri[curr_tri].sin * xt + tri[curr_tri].cos * zt;

					/* rotx vert2 */
					xt = x2;
					yt = tri[curr_tri].cos * y2 - tri[curr_tri].sin * z2;
					zt = tri[curr_tri].sin * y2 + tri[curr_tri].cos * z2;
					/* roty (same angle as rotx-for space reasons) */
					x2 = tri[curr_tri].cos * xt + tri[curr_tri].sin * zt;
					y2 = yt;
					z2 = -tri[curr_tri].sin * xt + tri[curr_tri].cos * zt;


					/* translate tri */
					x0 += dx;
					y0 += dy;
					z0 += dz;

					x1 += dx;
					y1 += dy;
					z1 += dz;

					x2 += dx;
					y2 += dy;
					z2 += dz;

					/* subtract gravity */
					y0 -= GRAVITY;
					y1 -= GRAVITY;
					y2 -= GRAVITY;

					/* add back center */
					x0 += x_c;
					y0 += y_c;
					z0 += z_c;

					x1 += x_c;
					y1 += y_c;
					z1 += z_c;

					x2 += x_c;
					y2 += y_c;
					z2 += z_c;

					/* update vertices */
					(*vcache[v0]).ob[0] = x0; 
					(*vcache[v0]).ob[1] = y0;
					(*vcache[v0]).ob[2] = z0;

					(*vcache[v1]).ob[0] = x1;
					(*vcache[v1]).ob[1] = y1;
					(*vcache[v1]).ob[2] = z1;

					(*vcache[v2]).ob[0] = x2;
					(*vcache[v2]).ob[1] = y2;
					(*vcache[v2]).ob[2] = z2;
				} /* time < 100 */
			}	/* curr_time == 0 */
			curr_tri++;
		} /* triangle */

		/* vertex load? */
		if ( ((*model).words.w0 & 0xFF000000)  
		== ( Vertex.words.w0 & 0xFF000000 ) ) {

			/* n vertices to load */
			nverts  = ( (*model).words.w0 & 0x00F00000 ) >> 20;
			nverts++;

			/* 1st vertex of cache to load */
			v0      = ( (*model).words.w0 & 0x000F0000 ) >> 16;

			dmasize = ( (*model).words.w0 & 0x0000FFFF ) >>  0;

			vtxaddr = (Vtx_tn *) (( (u32)(*model).words.w1 & 0x00FFFFFF )
					+ staticSegment);

			for ( v=0; v<nverts; v++,v0++ ) {
				vcache[v0] = &(vtxaddr[v]);
			}
		} /* end vertex */

		/* end of DL? */
		if ( ((*model).words.w0 & 0xFF000000)  
		== ( EndDl.words.w0 & 0xFF000000 ) ) {
			eof = 1;
		}

		/* update dl ptr */
		model++;
	}
}
