--      OBJ3D.PAS       -- by FAC / delabU alamA
--
--      this file is part of the 3d engine used in stupikeffyloopy
--      the demo doesn't show all the engine features, so a lot of
--      code here has been removed.

--      Before digging this code, take a look at VECTORS.PAS

--      All class members are declared as public for easy access
--      I think it's stupid to make a function like
--      function TVertex.GetX;  begin  GetX := x;  end;
--      specially for a small engine like this

unit Obj3D;

interface

uses Vectors, Triangle;

{ Constantes }
const MaxObjectVertex = 1024;  { Nmero mximo de vrtices en un objeto   }
      MaxPolyVertex = 3;       { Nmero mximo de vrtices en un polgono }
      MaxObjectPoly = 1024;    { Nmero mximo de polgonos en un objeto  }


-- polygon class definition

{ clase polgono (o mejor dicho, lista de polgonos) }
type PTPolygon = ^TPolygon;     { apuntador a un objeto polgono }

     TPolygon = object          { clase polgono                 }
              public
                    NumVertex : byte;   { nmero de vrtices }
                    normal : TVector;
                    Vertex : array[1..MaxPolyVertex] of PTVertex;
                    next : PTPolygon;

                    constructor Init;
                    destructor Done;

                    procedure AddVertex(v : PTVertex);
                    procedure Draw(where : dword);
                    procedure CalcNormal;
                    function Visible : boolean;
                    function ZOrder : single;
              end;


--  3D Object class definition

{ clase Objeto 3D }
type PTObject3D = ^TObject3D;   { apuntador a un objeto tridimensional }

     TObject3D = object         { clase objeto 3D }
               public
                     XCenter, YCenter : integer;
                     NumVertex : word;    { nmero de vrtices }
                     NumPolygons : word;  { nmero de polgonos }
                     Style : ShadingType;
                     Vertex : array[1..MaxObjectVertex] of PTVertex;
                     FirstPoly : PTPolygon;

                     constructor Init;
                     destructor Done;

                     procedure SetCenter(xc, yc : integer);

                     procedure AddVertex(nx, ny, nz : single);
                     procedure AddVertexUV(nx, ny, nz, nu, nv : single);
                     procedure AddPolygon(poly : PTPolygon);
                     procedure CalcNormals;
                     procedure Traslate(nx, ny, nz : single);
                     procedure Rotate(ax, ay, az : integer);
                     procedure Scale(sx, sy, sz : single);
                     procedure FlatFastRot(ax, ay, az : integer);
                     procedure NotFlatFastRot(ax, ay, az : integer);
                     procedure Draw(where : dword);
               end;

{ procedimientos para trabajar con objetos 3D }
procedure Load3DObject(filename : string; obj : PTObject3D);


implementation

uses LightSrc;

{ Arbol binario de polgonos ordenados de atrs hacia adelante }

-- the next class is a binary tree used to draw the polygons from
-- back to front.
-- maybe I should sort the polys using quicksort or something but
-- I came up with this idea and wanted to test it.

-- the tree works like this: the first polygon added becomes the root
-- of the tree. when we add another polygon, we compare it's zorder
-- value with the zorder of the other polys, starting from root. if
-- the new poly's zorder is smaller then we take the left branch, else
-- we go by the right branch, so at the end of all this mess, we end up
-- with a tree of polygons which are ordered from left to right.

-- then, to draw a polygon, first we draw whatever is on it's left side,
-- then we draw THAT polygon and finally we draw whatever's on it's right,
-- so if we draw root, then we draw all the tree.


-- class TreeNode: a single node of the tree

type PTTreeNode = ^TTreeNode;
     TTreeNode = object
               private
                      poly : PTPolygon; { a poly corresponding to this node }
                      Zorder : single;  { it's zorder }
                      left, right : PTTreeNode; { right and left branches }
                      constructor Init(p : PTPolygon; z : single);
                      destructor Done;
                      procedure Draw(where : dword);
               end;

-- class Tree:
     PTTree = ^TTree;
     TTree = object
           private
                  root : PTTreeNode;  { the root node }
                  constructor Init;
                  destructor Done;
                  procedure AddNode(p : PTPolygon);
                  procedure Draw(where : dword);
           end;

     { Implementacin de TTreeNode }
     constructor TTreeNode.Init(p : PTPolygon; z : single);
     begin
          poly := p;
          left := nil;
          right := nil;
          Zorder := z;
     end;

     destructor TTreeNode.Done;
     begin
          if left <> nil then dispose(left, Done);
          if right <> nil then dispose(right, Done);
     end;

     procedure TTreeNode.Draw(where : dword);
     begin
          if left <> nil then left^.Draw(where);   { first left branch     }
          poly^.Draw(where);                       { then self             }
          if right <> nil then right^.Draw(where); { finally, right branch }
     end;

     { Implementacin de TTree }
     constructor TTree.Init;
     begin
          root := nil;
     end;

     destructor TTree.Done;
     begin
          if root <> nil then dispose(root, Done);
     end;

{ this is the pain-in-the-ass procedure of the tree class       }
{ not a big deal if you know this kind of structures though     }
     procedure TTree.AddNode(p : PTPolygon);
     var temp : PTTreeNode;
         flag : boolean;
         Zorder : single;
     begin
          temp := root;         { we start comparing from root }
          flag := true;
          Zorder := p^.Zorder;  { zorder of the polygon we want to add }

          { first we check that there's already a root node }
          if temp = nil then root := new(PTTreeNode, init(p, Zorder))
          else  { and if not... }
          while flag do
                { we check to see if our poly goes to the left }
                if Zorder <= temp^.Zorder then
                   { cool, it goes left... }
                   if temp^.left = nil then
                   begin
                        temp^.left := new(PTTreeNode, init(p, Zorder));
                        flag := false;
                   end
                   else temp := temp^.left
                else
                    { if not.. then it goes to the right branch }
                    if temp^.right = nil then
                    begin
                         temp^.right := new(PTTreeNode, init(p, Zorder));
                         flag := false;
                    end
                    else temp := temp^.right;
     end;

     { to draw the whole tree, we only have to draw root }
     procedure TTree.Draw(where : dword);
     begin
          if root <> nil then root^.Draw(where);
     end;


{ polgonos }

-- implementation for the TPolygon class

{ Init - constructor }
constructor TPolygon.Init;
begin
     NumVertex := 0;
     next := nil;
end;

{ Done - destructor }
destructor TPolygon.Done;
begin
     if next <> nil then dispose(next, Done); { kill the whole list }
     next := nil;
end;

{ AddVertex - agregar vrtice }
procedure TPolygon.AddVertex(v : PTVertex);
begin
     if NumVertex = MaxPolyVertex then exit;
     inc(NumVertex);
     Vertex[NumVertex] := v;
end;

{ Draw - dibuja el polgono }

-- right now, the engine can only draw triangles, so when a polygon has
-- more than 3 vertex, it has to be split in triangles (which slows a
-- little the rendering). If the symbol _TrianglesOnly_ is defined, the
-- drawing function will consider all polys as triangles so no splitting
-- has to be done.

{$ifndef _TrianglesOnly_ }
procedure TPolygon.Draw(where : dword);
var v, c, wc : byte;
begin
     { the next line checks that the poly has at least 3 vertices       }
     { there's a lot of checkings like that in this code that could be  }
     { skipped to get some speed. But I left them for learning purposes }
     if NumVertex < 3 then exit;

     { If the poly is flatshaded we have to calculate it's color        }
     { but I won't explain how this is done.                            }
     if GlobalStyle = flatshaded then
     begin
          c := StartCol;
          wc := WidthCol shr 1;
          { change the drawing color }
          StartCol := trunc((DotProduct(normal, light) + 1) * wc) + StartCol;
     end;
     { we draw the whole polygon using only triangles }
     for v := 2 to (NumVertex - 1) do
         DrawTriangle(Vertex[1], Vertex[v], Vertex[v+1], where);

     { if we changed the drawing color, then we change it back }
     if GlobalStyle = flatshaded then StartCol := c;
end;
{$else}
{ this function is for _TrianglesOnly_                                  }
{ works the same way as the one above                                   }
procedure TPolygon.Draw(where : dword);
var c, wc : byte;
begin
     if GlobalStyle = flatshaded then
     begin
          c := StartCol;
          wc := WidthCol shr 1;
          StartCol := trunc((DotProduct(normal, light) + 1) * wc) + StartCol;
     end;
     DrawTriangle(Vertex[1], Vertex[2], Vertex[3], where);
     if GlobalStyle = flatshaded then StartCol := c;
end;
{$endif}

{ CalcNormal - calcula la normal }
{ this proc calculates the normal of a polygon }
procedure TPolygon.CalcNormal;
var a, b : TVector;
begin
     SubVectors(Vertex[1]^, Vertex[2]^, a);
     SubVectors(Vertex[3]^, Vertex[2]^, b);
     CrossProduct(b, a, normal);
     normal.Normalize;
end;

{ Visible - devuelve verdadero si un polgono est de frente al observador }
{ the camera is always in the Z+ axis, so this function is very simple }
function TPolygon.Visible;
begin
     Visible := (normal.z >= 0);
end;

{ Calcula el valor Z promedio del polgono (sirve para ordenarlos) }
{ The zorder is just the sumatory of the Z coord. of all the vertices }
function TPolygon.ZOrder : single;
var v : byte;
    z : single;
begin
     z := 0;
     for v := 1 to NumVertex do z := z + Vertex[v]^.z;
     ZOrder := z;
end;


{ Objeto 3D }

{ implementation for the Object3D class }

{ Init - constructor }
constructor TObject3D.Init;
begin
     XCenter := 0;
     YCenter := 0;
     NumVertex := 0;
     NumPolygons := 0;
     Style := FlatShaded;
     FirstPoly := nil;
end;

{ Done - destructor }
destructor TObject3D.Done;
var v : word;
begin
     if FirstPoly <> nil then dispose(FirstPoly, Done);
     for v := 1 to NumVertex do dispose(Vertex[v]);
     NumVertex := 0;
     NumPolygons := 0;
     FirstPoly := nil;
end;

{ this procedure sets the 3D origin within screen coordinates           }
{ so if you SetCenter(160, 100), then the origin will be the center     }
{ the screen. Note that there's no movement along the Z axis.           }
procedure TObject3D.SetCenter(xc, yc : integer);
begin
     XCenter := xc;
     YCenter := yc;
end;

{ AddVertex - agrega un vrtice - adds a vertex }
procedure TObject3D.AddVertex(nx, ny, nz : single);
begin
     if NumVertex = MaxObjectVertex then exit;
     inc(NumVertex);
     Vertex[NumVertex] := new(PTVertex, Init(nx, ny, nz));
end;

{ This one adds a vertex with it's UV (texture) coordinates }
procedure TObject3D.AddVertexUV(nx, ny, nz, nu, nv : single);
begin
     if NumVertex = MaxObjectVertex then exit;
     inc(NumVertex);
     Vertex[NumVertex] := new(PTVertex, Init(nx, ny, nz));
     Vertex[NumVertex]^.U := nu;
     Vertex[NumVertex]^.V := nv;
end;

{ AddPolygon - agrega una cara al objeto }
{ adds a polygon (face) to the object    }
procedure TObject3D.AddPolygon(poly : PTPolygon);
begin
     if NumPolygons = MaxObjectPoly then exit;
     inc(NumPolygons);
     poly^.next := FirstPoly;
     FirstPoly := poly;
end;

{ CalcNormals - calcula las normales de todo el objeto }
{ this calculates the normals of all the polygons and vertices of the object }
procedure TObject3D.CalcNormals;
var p : PTPolygon;
    v, pv : word;
begin
     { First, calculate the polygon's normals }
     p := FirstPoly;
     while p <> nil do
     begin
          p^.CalcNormal;
          p := p^.next;
     end;

     { Then, find the vertex normals }
     for v := 1 to NumVertex do
     begin
          Vertex[v]^.normal.SetP(0, 0, 0);
          p := FirstPoly;
          while p <> nil do
          begin
               for pv := 1 to p^.NumVertex do
                   if Vertex[V] = p^.Vertex[pv] then
                      AddVectors(Vertex[v]^.normal, p^.normal, Vertex[v]^.normal);
               p := p^.next;
          end;
          Vertex[v]^.normal.Normalize;
     end;
end;

{ Traslate - traslada un objeto 3D - ummm.... this traslates the object }
procedure TObject3D.Traslate(nx, ny, nz : single);
var v : word;
begin
     for v := 1 to NumVertex do Vertex[v]^.Traslate(nx, ny, nz);
end;

{ Rotate - rota un objeto 3D }
{ This procedure rotates all the vertices and normals of an object }
procedure TObject3D.Rotate(ax, ay, az : integer);
var v : word;
    p : PTPolygon;
begin
     for v := 1 to NumVertex do Vertex[v]^.VRotate(ax, ay, az);
     p := FirstPoly;
     while p <> nil do
     begin
          p^.normal.Rotate(ax, ay, az);
          p := p^.next;
     end;
end;

{ This one rotates all except the vertex normals, which aren't used     }
{ for flat shading... it's a little bit faster than Rotate              }
procedure TObject3D.FlatFastRot(ax, ay, az : integer);
var v : word;
    p : PTPolygon;
begin
     for v := 1 to NumVertex do Vertex[v]^.Rotate(ax, ay, az);
     p := FirstPoly;
     while p <> nil do
     begin
          p^.normal.Rotate(ax, ay, az);
          p := p^.next;
     end;
end;

{ This one rotates only the vertices. It doesn't rotate vertex normals  }
{ nor polygon normals. NOTE that the polygon normals are used to see if }
{ a polygon is visible or not, so you should do only Z-axis rotations   }
{ with this procedure or the object won't look good.                    }
procedure TObject3D.NotFlatFastRot(ax, ay, az : integer);
var v : word;
begin
     for v := 1 to NumVertex do Vertex[v]^.Rotate(ax, ay, az);
end;


{ the scaling procedure }
procedure TObject3D.Scale(sx, sy, sz : single);
var v : word;
begin
     for v := 1 to NumVertex do Vertex[v]^.Scale(sx, sy, sz);
end;

{ Draw - dibuja un objeto 3D }
{ and at last, the object drawing function }
procedure TObject3D.Draw(where : dword);
var v : word;
    p : PTPolygon;
    t : PTTree;
begin
     { first, we create a binary tree for sorting the polys }
     t := new(PTTree, Init);
     { then we calculate the 2D projection of all vertices  }
     for v := 1 to NumVertex do Vertex[v]^.Calc2D(XCenter, YCenter);
     { now, we add all the polygons to the tree             }
     p := FirstPoly;
     while p <> nil do
     begin
          if p^.Visible then t^.AddNode(p);
          p := p^.next;
     end;
     { and we draw them from the tree                       }
     t^.Draw(where);
     dispose(t, Done); { don't forget to delete the tree    }
end;


{ Procedimientos para trabajar con objetos 3D }

{ Load3DObject - Carga un objeto con formato VKX }
{ This loads a 3D object in .VKX format (my own 3D format) into         }
{ a TObject3D object.                                                   }
{ If you want a full description of the VKX format (which is very       }
{ simple), or the ASC2VKX utility, e-mail me...                         }
procedure Load3DObject(filename : string; obj : PTObject3D);
var f : file of longint;
    i, j, nv, np : word;
    x, y, z, u, v : longint;
    p : PTPolygon;
begin
     assign(f, filename);
     reset(f);
     read(f, x);

     { check the file ID }
     if (x and $FFFF0000) <> $1FAC0000 then
     begin
          close(f);
          exit;
     end;

     { make sure the object variable is "virgin" }
     if obj^.FirstPoly <> nil then obj^.Done;

     { get number of vertices }
     read(f, x);
     nv := x;

     { get number of polygons }
     read(f, x);
     np := x;

     for i := 1 to 5 do read(f, x); { unused stuff }

     { get vertex information }
     for i := 1 to nv do
     begin
          read(f, x);
          read(f, y);
          read(f, z);
          read(f, u);
          read(f, v);
          obj^.AddVertexUV(x / 65536, y / 65536, z / 65536, u / 65536, v / 65536);
     end;

     { get polygon information and add polygons to the object }
     for i := 1 to np do
     begin
          p := new(PTPolygon, Init);
          read(f, u);
          for j := 1 to u do
          begin
               read(f, v);
               inc(v);
               p^.AddVertex(obj^.Vertex[v]);
          end;
          obj^.AddPolygon(p);
     end;
     close(f);
     obj^.CalcNormals;  { calculate all normals }
end;

end.
