Unit devGUS;
{$define gusdebug}
---------------------------------------------------------------------
--  *** TMT Sound System ***                                       --
--  Device:Gravis Ultrasound  (NOT WORKING!!!)                     --
--                                                                 --
--                   by CiMEDIA/CiMEDIA iNC. [1/98]                --
--                   (a.k.a. Cesar Vellido)                        --
---------------------------------------------------------------------

interface

const
  GUS_BasePort:DWORD=$200;
  GUS_Mem:DWORD=0;
  GUS_Mode:DWORD=0;
  GUS_Present:Boolean=False;

Function  GUS_Detect(ShowInfo:boolean):boolean;
Procedure GUS_Reset;
Procedure GUS_PlaySample(n_smp,ofs,Chnl,Freq:DWORD);
Procedure GUS_SetChnlVol(Chnl,Vol:DWORD);
Procedure GUS_SetChnlBal(Chnl,Bal:DWORD);
Procedure DumpMODtoGUS;

implementation
uses TSS,ZMSystem,MiDebug;
    ---==============================================---
     --------------------------------------------------
const
  GUS_FreqDivisor:array[0..18]of word=
   (44100,41160,38587,36317,34300,32494,30870,29400,28063,26843,
    25725,24696,23746,22866,22050,21289,20580,19916,19293);

Procedure GUS_Delay;
Assembler;
ASM
  mov   dx, 0300h
  in    al, dx
  in    al, dx
  in    al, dx
  in    al, dx
  in    al, dx
  in    al, dx
  in    al, dx
End;
     --------------------------------------------------
Function GUS_Peek(Loc:DWORD):Byte;
begin
  Port[GUS_BasePort+$103]:=$43;
  Portw[GUS_BasePort+$104]:=Loc AND $FFFF;
  Port[GUS_BasePort+$103]:=$44;
  Port[GUS_BasePort+$105]:=LongInt(Loc AND $FF0000) SHR 16;
  Result:=Port[GUS_BasePort+$107];
end;
     --------------------------------------------------
Procedure GUS_Poke(Loc:DWORD;Data:Byte);
begin
  Port[GUS_BasePort+$103]:=$43;
  Portw[GUS_BasePort+$104]:=Loc AND $FFFF;
  Port[GUS_BasePort+$103]:=$44;
  Port[GUS_BasePort+$105]:=(Loc AND $FF0000) SHR 16;
  Port[GUS_BasePort+$107]:=Data;
end;
     --------------------------------------------------
Function GUS_Detected:Boolean;
begin
  Port[GUS_BasePort+$103]:=$4C;
  Port[GUS_BasePort+$105]:=0;
  GUS_Delay;
  GUS_Delay;
  Port[GUS_BasePort+$103]:=$4C;
  Port[GUS_BasePort+$105]:=1;
  GUS_Poke(0,$AA);
  GUS_Poke($100,$55); --???ok
  Result:=(GUS_Peek(0)=$AA)
end;
     --------------------------------------------------
Function GUS_FindMem:DWORD;
Var
  I : Longint;
  B : Byte;
Begin
  GUS_Poke($40000,$AA);
  If GUS_Peek($40000)<>$AA then
   Result:=$3FFFF
  else
   begin
     GUS_Poke($80000,$AA);
     If GUS_Peek($80000)<>$AA then
      Result:=$8FFFF
     else
      begin
        GUS_Poke($C0000,$AA);
        If GUS_Peek($C0000)<>$AA then
         Result:=$CFFFF
        else
         Result:=$FFFFF;
      end;
   end;
end;
     --------------------------------------------------
Function GUS_Detect(ShowInfo:boolean):Boolean;
label
  Exit;
begin
  If GUS_Present then
   Goto Exit;
  GUS_BasePort:=$200;
  repeat
    GUS_BasePort+:=$10;
  until GUS_Detected OR (GUS_BasePort=$280);
  If GUS_BasePort<$280 then
   begin
     Result:=True;
     GUS_Present:=True;
     GUS_Mem:=GUS_FindMem;
     If ShowInfo AND GUS_Present then
      WriteLn(' GUS detected at ',hex(GUS_BasePort),' (Mem:',(GUS_Mem+1) div 1024,')');
    end
   else
    Result:=False;
 Exit:
end;
     --------------------------------------------------
Procedure GUS_VoiceControl(Chnl,B:Byte);
Begin
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$103]:=0;
  Port [GUS_BasePort+$105]:=B;
End;
     --------------------------------------------------
Procedure GUS_SetChnlBal(Chnl,Bal:DWORD);
begin
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$102]:=Chnl; --no en gussdk
  Port [GUS_BasePort+$102]:=Chnl; --no en gussdk
  Port [GUS_BasePort+$103]:=$C;
  Port [GUS_BasePort+$105]:=Bal;
end;
     --------------------------------------------------
Procedure GUS_SetChnlVol(Chnl,Vol:DWORD);
begin
  {$ifdef gusdebug}
  Midebug.Green:=63;
  Border;
  {$endif}
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$103]:=9;
  Portw[GUS_BasePort+$104]:=Vol shl 8;
  {$ifdef gusdebug}
  Midebug.Green:=0;
  Border;
  {$endif}
end;
     --------------------------------------------------
Procedure GUS_SetLoopMode(Chnl:DWORD);
var
  t1:Byte;
begin
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$103]:=$80;
  t1:=Port[GUS_BasePort+$105];
  Port[GUS_BasePort+$103]:=0;
  Port[GUS_BasePort+$105]:=(t1 AND $E7) OR GUS_Mode;
end;
     --------------------------------------------------
Procedure GUS_StopChnl(Chnl:DWORD);
var
  t1:Byte;
begin
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$103]:=$80;
  t1:=Port[GUS_BasePort+$105];
  Port[GUS_BasePort+$103]:=0;
  Port[GUS_BasePort+$105]:=(t1 AND $df) OR 3;
  GUS_Delay;
  Port[GUS_BasePort+$103]:=0;
  Port[GUS_BasePort+$105]:=(t1 AND $df) OR 3;
end;
     --------------------------------------------------
Procedure GUS_SetFreq(Chnl,Freq:DWORD);
var
  Temp,Fc:DWORD;
begin
  Temp:=GUS_FreqDivisor[2];  --MAXCHNL+14!!! MaxChnl=KTE>14!!!
  Fc:=((Freq SHL 9)+(Temp SHR 1)) DIV Temp;
  Fc:=Fc SHL 1;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$103]:=1;
  Portw[GUS_BasePort+$104]:=Fc;
end;
     --------------------------------------------------
Procedure GUS_PlaySample(n_Smp,ofs,Chnl,Freq:DWORD);
var
  Mode:byte;
Begin
  {$ifdef gusdebug}
  Midebug.Red:=63;
  Border;
  {$endif}
  --Set Freq--
  GUS_SetFreq(Chnl,Freq);
  --Send Smp info--
  Port [GUS_BasePort+$102]:=Chnl;
  Port [GUS_BasePort+$102]:=Chnl;

  Port [GUS_BasePort+$103]:=$8D;  --Get Volume Control
  Mode:=Port [GUS_BasePort+$105];
  If (Mode AND $01)<>0 then --RollOver?
   Mode:=Mode OR $04
  else
   Mode:=Mode AND (NOT $04);
  Port [GUS_BasePort+$103]:=$0D;  --Set Volume Control
  Port [GUS_BasePort+$105]:=Mode; --Mode
  GUS_Delay;
  Port [GUS_BasePort+$105]:=Mode; --Mode

  Portw[GUS_BasePort+$104]:=((DWORD(Sample[n_Smp].BSPtr)+ofs) SHR 7) AND $1FFF;
  Port [GUS_BasePort+$103]:=$0B;
  Portw[GUS_BasePort+$104]:=((DWORD(Sample[n_Smp].BSPtr)+ofs) AND 127) SHL 9;
  Port [GUS_BasePort+$103]:=$02;
  Portw[GUS_BasePort+$104]:=(DWORD(Sample[n_Smp].BSPtr) SHR 7) AND $1FFF;
  Port [GUS_BasePort+$103]:=$03;
  Portw[GUS_BasePort+$104]:=(DWORD(Sample[n_Smp].BSPtr) AND 127) SHL 9;
  Port [GUS_BasePort+$103]:=$04;
  Portw[GUS_BasePort+$104]:=(DWORD(Sample[n_Smp].ESPtr) SHR 7) AND $1FFF;
  Port [GUS_BasePort+$103]:=$05;
  Portw[GUS_BasePort+$104]:=(DWORD(Sample[n_Smp].ESPtr) AND 127) SHL 9;
  --Mode--
  Port [GUS_BasePort+$102]:=Chnl;
  Port[GUS_BasePort+$103]:=$0;
  If DWORD(Sample[n_Smp].ELPtr)-DWORD(Sample[n_Smp].BLPtr)<=2 then
   Mode:=0  --No loop
  else
   Mode:=0; --Loop
  Port [GUS_BasePort+$105]:=Mode; --Mode
  GUS_Delay;
  Port [GUS_BasePort+$105]:=Mode; --Mode
  --Now GUS starts playing...
  {$ifdef gusdebug}
  Midebug.Red:=0;
  Border;
  {$endif}
end;
     --------------------------------------------------
Procedure GUS_Reset;
var
  i:DWORD;
  t:BYTE;
begin
  port [GUS_BasePort+$103]:=$4C;
  port [GUS_BasePort+$105]:=0;
  for i:=0 to 9 do
   GUS_Delay;
  port [GUS_BasePort+$103]:=$4C;
  port [GUS_BasePort+$105]:=1;
  for i:=0 to 9 do
   GUS_Delay;
  --Clear Interrupts--
  port [GUS_BasePort+$103]:=$41; --DMA
  port [GUS_BasePort+$105]:=0;
  port [GUS_BasePort+$103]:=$45; --Timer
  port [GUS_BasePort+$105]:=0;
  port [GUS_BasePort+$103]:=$49; --Sample
  port [GUS_BasePort+$105]:=0;
  --Set #voices--
  port [GUS_BasePort+$103]:=$0E;
  port [GUS_BasePort+$105]:=(16-1 OR $0C0); --16=MaxChnl
  --Clear Ints. on voices--
  t:=Port[GUS_BasePort+$6]; --IRQ Status
  Port[GUS_BasePort+$103]:=$41; --DMA control
  t:=Port[GUS_BasePort+$105];
  Port[GUS_BasePort+$103]:=$49; --Sample control
  t:=Port[GUS_BasePort+$105];
  Port[GUS_BasePort+$103]:=$8f; --Get IRQV
  t:=Port[GUS_BasePort+$105];

  for i:=0 to 16-1 do  --MaxChnl-1!
   begin
     --Select chnl
     port [GUS_BasePort+$102]:=i;
     --Stop voices--
     port [GUS_BasePort+$103]:=0;
     port [GUS_BasePort+$105]:=3;
     --Reset volumel--
     port [GUS_BasePort+$103]:=$D;
     port [GUS_BasePort+$105]:=3;

   end;

  port [GUS_BasePort+$103]:=$4C;
  port [GUS_BasePort+$105]:= 7;

end;
     --------------------------------------------------
Procedure DumpMODtoGUS;
var
  i,j:DWORD;
  Pos:DWORD;
  BS,LE:DWORD;
begin
  Pos:=0;
  for i:=1 to MaxSmp do
   begin
     BS:=Pos;
     LE:=DWORD(Sample[i].ESPtr)-DWORD(Sample[i].BSPtr);
     --Dump Sample data--
     for j:=0 to LE do
      begin
        GUS_Poke(Pos,Sample[i].BSPtr^[j]);
        Pos+:=1;

      end;
     If Pos>Gus_Mem then
      begin
        WriteLn('GUS error:Not enought Memory onboard');
        Halt; --Or modify the Status var!!!
      end;
     FreeMem(Sample[i].BSPtr,LE);
     Sample[i].BSPtr:=Pointer(BS);
     Sample[i].ESPtr:=Pointer(Pos-1);
     Sample[i].BLPtr:=Pointer(BS+DWORD(Sample[i].BLPtr)-DWORD(Sample[i].BSPtr));
     Sample[i].ELPtr:=Pointer(Pos-1);
   end;
end;
     --------------------------------------------------
     
end.
