
#include "vectors.h"
#include "lightsrc.h"
#include "triangle.h"
#include "globals.h"
#include "polygons.h"



int X_MIN[240], X_MAX[240], C_MIN[240], C_MAX[240];
double U_MIN[240], U_MAX[240], V_MIN[240], V_MAX[240];


// wireframe

void ClipDDALine(int x1, int y1, int x2, int y2, int color, TBitmap *where) {
	//	line clipping
	double m = (double)(y2 - y1) / (double)(x2 - x1);
	double im = 1 / m;
	if (x1 <= x2) {
                if ((x1 > 319) || (x2 < 0)) return;
		if (x1 < 0) { y1 += dtoi(-x1 * m); x1 = 0; }
                if (x2 > 319) { y2 -= dtoi((x2 - 319) * m); x2 = 319; }
	}
	else {
                if ((x1 < 0) || (x2 > 319)) return;
		if (x2 < 0) { y2 += dtoi(-x2 * m); x2 = 0; }
                if (x1 > 319) { y1 -= dtoi((x1 - 319) * m); x1 = 319; }
	}
	if (y1 <= y2) {
                if ((y1 > 239) || (y2 < 0)) return;
		if (y1 < 0) { x1 += dtoi(-y1 * im); y1 = 0; }
                if (y2 > 239) { x2 -= dtoi((y2 - 239) * im); y2 = 239; }
	}
	else {
                if ((y1 < 0) || (y2 > 239)) return;
		if (y2 < 0) { x2 += dtoi(-y2 * im); y2 = 0; }
                if (y1 > 239) { x1 -= dtoi((y1 - 239) * im); y1 = 239; }
	}
	
	int width = x2 - x1;
	int height = y2 - y1;
	if (width < 0) width = -width;
	if (height < 0) height = - height;
	if (width > height) {
		if (height == 0) height = 1;
		if (x1 > x2) {
			int temp = x1; x1 = x2; x2 = temp;
			temp = y1; y1 = y2; y2 = temp;
		}
		int dy = (height << 16) / width;
        int yinc = (y1 > y2) ? (-1280) : (1280);
        unsigned off = (unsigned)(where->datos + where->tablay[y1] + x1);
		_asm {
			mov edi, [off]
			mov esi, [yinc]
			mov eax, [color]
			mov edx, [dy]
			xor ebx, ebx
			mov ecx, [width]
			lloop:  stosd
                    add bx, dx
                    jnc cont
                    add edi, esi
			cont:   dec ecx
                    jnz lloop
		}
		return;
	}
	if (width < height) {
		if (width == 0) width = 1;
		if (y1 > y2) {
			int temp = y1; y1 = y2; y2 = temp;
			temp = x1; x1 = x2; x2 = temp;
		}
		int ddx = (width << 16) / height;
		int xinc = (x1 > x2) ? (-4) : (4);
        unsigned off = (unsigned)(where->datos + where->tablay[y1] + x1);
		_asm {
			mov edi, [off]
			mov esi, [xinc]
            mov eax, [color]
			mov edx, [ddx]
			xor ebx, ebx
			mov ecx, [height]
			lloop:  mov [edi], eax
                    add edi, 1280
                    add bx, dx
                    jnc cont
                    add edi, esi
			cont:   dec ecx
                    jnz lloop
		}
		return;
	}
	if (width == 0) width = 1;
	int dx = (x1 > x2) ? (-4) : (4);
    int dy = (y1 > y2) ? (-1280 + dx) : (1280 + dx);
    unsigned off = (unsigned)(where->datos + where->tablay[y1] + x1);
	_asm {
		mov edi, [off]
        mov eax, [color]
		mov ebx, [dy]
		mov ecx, [width]
		lloop:  mov [edi], eax
                add edi, ebx
                dec ecx
                jnz lloop
	}
}


void WirePolygon(TPolygon *p, TBitmap *where) {
        int x = p->Vertex[p->NumVertex - 1]->x2d;
        int y = p->Vertex[p->NumVertex - 1]->y2d;
        for (int i = 0; i < p->NumVertex; i++) {
                ClipDDALine(x, y, p->Vertex[i]->x2d, p->Vertex[i]->y2d, p->cstart, where);
                x = p->Vertex[i]->x2d;
                y = p->Vertex[i]->y2d;
        }
}


// flat
void FlatScanSide(TVertex *v1, TVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 240)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        if (y1 < 0) { x -= y1 * dxdy; y1 = 0; }
        if (y2 > 239) y2 = 239;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) X_MIN[y] = x;
                if (x > X_MAX[y]) X_MAX[y] = x;
                x += dxdy;
        }
}


void FlatPolygon(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) FlatScanSide(v0, p->Vertex[i]);
                else FlatScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        int c = dtoi((DotProduct(p->normal, Light) + 1.0) * p->crange);
        c = p->ctable[c];
        for (i = ymin; i <= ymax; i++) {
                xmin = X_MIN[i];
                xmax = X_MAX[i];
                if (xmin < 0) xmin = 0;
                if (xmax > 20905984) xmax = 20905984;
                if (xmin <= xmax) {
                        _asm {
                                mov eax, [c]
                                mov ecx, [xmax]
                                mov edi, [xmin]
                                shr ecx, 16
                                shr edi, 16
                                inc ecx
                                sub ecx, edi
                                shl edi, 2
                                add edi, [off]
                                rep stosd
                        }
                }
                off += bpsl;
        }
}
/*
// gouraud
void GouraudScanSide(TVertex *v1, TVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 240)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        int dcdy = ((v2->c - v1->c) << 8) / altura;
        int c = v1->c << 8;
        if (y1 < 0) { x -= y1 * dxdy; c -= y1 * dcdy; y1 = 0; }
        if (y2 > 239) y2 = 239;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) { X_MIN[y] = x; C_MIN[y] = c; }
                if (x > X_MAX[y]) { X_MAX[y] = x; C_MAX[y] = c; }
                x += dxdy;
                c += dcdy;
        }
}


void GouraudPolygon(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) GouraudScanSide(v0, p->Vertex[i]);
                else GouraudScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        unsigned int tableoff = (unsigned)p->ctable;
        int deltax, x, dcdx, c;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dcdx = (C_MAX[i] - C_MIN[i]) / deltax;
                c = C_MIN[i];
                if (x < 0) { c -= x * dcdx; deltax += x; x = 0; }
                if (X_MAX[i] > 20905984) deltax = 320 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [x]
                        mov ecx, [deltax]
                        shl edi, 2
                        mov eax, [c]
                        add edi, [off]
                        mov ebx, [dcdx]
                        mov esi, [tableoff]
                        ciclo:  movzx edx, ah
                                add eax, ebx
                        		mov edx, [esi + edx * 4]
                        		mov [edi], edx
                                add edi, 4
                                dec ecx
                                jnz ciclo
                }
                off += bpsl;
        }
}


void WeirdPolygon1(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) GouraudScanSide(v0, p->Vertex[i]);
                else GouraudScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        unsigned int tableoff = (unsigned)p->ctable;
        int deltax, x, dcdx, c;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dcdx = (C_MAX[i] - C_MIN[i]) / deltax;
                c = C_MIN[i];
                if (x < 0) { c -= x * dcdx; deltax += x; x = 0; }
                if (X_MAX[i] > 20905984) deltax = 320 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [x]
                        mov ecx, [deltax]
                        shl edi, 2
                        mov eax, [c]
                        add edi, [off]
                        mov ebx, [dcdx]
                        mov esi, [tableoff]
                        ciclo:  movzx edx, ah
                                add eax, ebx
                        		mov edx, [esi + edx * 4]
                        		mov [edi], edx
                                inc edi
                                dec ecx
                                jnz ciclo
                }
                off += bpsl;
        }
}
*/

// texture
void TextureScanSide(TVertex *v1, TVertex *v2) {
        int y1 = v1->y2d;
        int y2 = v2->y2d;
        int altura = y2 - y1;
        if (altura == 0) return;
        if ((y2 <= 0) || (y1 >= 240)) return;
        int dxdy = (((v2->x2d - v1->x2d) << 16) + 32768) / altura;
        int x = v1->x2d << 16;
        double dudy = (v2->u - v1->u) / (double)altura;
        double u = v1->u;
        double dvdy = (v2->v - v1->v) / (double)altura;
        double v = v1->v;
        if (y1 < 0) { x -= y1 * dxdy; u -= y1 * dudy; v -= y1 * dvdy; y1 = 0; }
        if (y2 > 239) y2 = 239;
        for (int y = y1; y <= y2; y++) {
                if (x < X_MIN[y]) { X_MIN[y] = x; U_MIN[y] = u; V_MIN[y] = v; }
                if (x > X_MAX[y]) { X_MAX[y] = x; U_MAX[y] = u; V_MAX[y] = v; }
                x += dxdy;
                u += dudy;
                v += dvdy;
        }
}


void TexturePolygon(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) TextureScanSide(v0, p->Vertex[i]);
                else TextureScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        unsigned int texture = (unsigned)p->texture->datos;
        unsigned int ctable = (unsigned)p->texture->paleta;
        int deltax, x, dudx, dvdx, u, v;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dudx = dtoi((U_MAX[i] - U_MIN[i]) * 65536.0) / deltax;
                dvdx = dtoi((V_MAX[i] - V_MIN[i]) * 65536.0) / deltax;
                u = dtoi(U_MIN[i] * 65536.0);
                v = dtoi(V_MIN[i] * 65536.0);
                if (x < 0) { u -= x * dudx; v -= x * dvdx; deltax += x; x = 0; }
                if (X_MAX[i] > 20905984) deltax = 320 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [x]
                        mov ecx, [deltax]
                        shl edi, 2
                        mov esi, [v]
                        mov edx, [u]
                        add edi, [off]
                        lp:     movzx ebx, si
                                add esi, [dvdx]
                                mov bl, dh
                                add edx, [dudx]
                                add ebx, [texture]
                                movzx eax, byte ptr [ebx]
                                shl eax, 2
                                add eax, [ctable]
                                mov eax, [eax]
                                mov [edi], eax
                                add edi, 4
                                dec ecx
                                jnz lp
                }
                off += bpsl;
        }
}

/*
void TransTexturePolygon(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) TextureScanSide(v0, p->Vertex[i]);
                else TextureScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        unsigned int texture = (unsigned)p->texture->datos;
        unsigned int ctable = (unsigned)p->texture->paleta;
        int deltax, x, dudx, dvdx, u, v;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dudx = dtoi((U_MAX[i] - U_MIN[i]) * 65536.0) / deltax;
                dvdx = dtoi((V_MAX[i] - V_MIN[i]) * 65536.0) / deltax;
                u = dtoi(U_MIN[i] * 65536.0);
                v = dtoi(V_MIN[i] * 65536.0);
                if (x < 0) { u -= x * dudx; v -= x * dvdx; deltax += x; x = 0; }
                if (X_MAX[i] > 20905984) deltax = 320 - x;
                if (deltax > 0)
                _asm {
                        mov edi, [x]
                        mov ecx, [deltax]
                        shl edi, 2
                        mov esi, [v]
                        mov edx, [u]
                        add edi, [off]
                        lp:     movzx ebx, si
                                add esi, [dvdx]
                                mov bl, dh
                                add edx, [dudx]
                                add ebx, [texture]
                                movzx eax, byte ptr [ebx]
                                cmp eax, [TransparentColor]
                                je nope
                                shl eax, 2
                                add eax, [ctable]
                                mov eax, [eax]
                                mov [edi], eax
                        nope:   add edi, 4
                                dec ecx
                                jnz lp
                }
                off += bpsl;
        }
}


void BlendTexturePolygon(TPolygon *p, TBitmap *where) {
        int ymin = 0x7FFFFFFF;
        int ymax = -0x7FFFFFFF;
        int xmin = 0x7FFFFFFF;
        int xmax = -0x7FFFFFFF;
        for (int i = 0; i < p->NumVertex; i++) {
                if (p->Vertex[i]->y2d < ymin) ymin = p->Vertex[i]->y2d;
                if (p->Vertex[i]->y2d > ymax) ymax = p->Vertex[i]->y2d;
                if (p->Vertex[i]->x2d < xmin) xmin = p->Vertex[i]->x2d;
                if (p->Vertex[i]->x2d > xmax) xmax = p->Vertex[i]->x2d;
        }
        if (ymax == ymin) return;
        if ((ymin > 239) || (ymax < 0)) return;
        if ((xmin > 319) || (xmax < 0)) return;

        unsigned int off1 = (unsigned int)X_MIN;
        unsigned int off2 = (unsigned int)X_MAX;
        _asm {
                mov edi, [off1]
                mov eax, 7FFFFFFFh
                mov ecx, 240
                rep stosd
                mov edi, [off2]
                neg eax
                mov ecx, 240
                rep stosd
        }

        TVertex *v0 = p->Vertex[p->NumVertex - 1];
        for (i = 0; i < p->NumVertex; i++) {
                if (v0->y2d < p->Vertex[i]->y2d) TextureScanSide(v0, p->Vertex[i]);
                else TextureScanSide(p->Vertex[i], v0);
                v0 = p->Vertex[i];
        }

        if (ymin < 0) ymin = 0;
        if (ymax > 239) ymax = 239;
        unsigned int off = (unsigned)(where->datos + where->tablay[ymin]);
        unsigned int bpsl = where->ancho << 2;
        unsigned int texture = (unsigned)p->texture->datos;
        unsigned int ctable = (unsigned)p->texture->paleta;
        unsigned int bsource = (unsigned)BlendSource->datos + BlendSource->tablay[ymin];
        unsigned bstemp;
        int deltax, x, dudx, dvdx, u, v;
        for (i = ymin; i <= ymax; i++) {
                deltax = ((X_MAX[i] - X_MIN[i]) >> 16) + 1;
                x = X_MIN[i] >> 16;
                dudx = dtoi((U_MAX[i] - U_MIN[i]) * 65536.0) / deltax;
                dvdx = dtoi((V_MAX[i] - V_MIN[i]) * 65536.0) / deltax;
                u = dtoi(U_MIN[i] * 65536.0);
                v = dtoi(V_MIN[i] * 65536.0);
                if (x < 0) { u -= x * dudx; v -= x * dvdx; deltax += x; x = 0; }
                if (X_MAX[i] > 20905984) deltax = 320 - x;
                bstemp = bsource;
                if (deltax > 0)
                _asm {
                        mov edi, [x]
                        add [bstemp], edi
                        mov ecx, [deltax]
                        shl edi, 2
                        mov esi, [v]
                        mov edx, [u]
                        add edi, [off]
                        lp:     mov ebx, [bstemp]
                                xor eax, eax
                                inc [bstemp]
                                mov ah, [ebx]
                                movzx ebx, si
                                add esi, [dvdx]
                                mov bl, dh
                                add edx, [dudx]
                                add ebx, [texture]
                                mov al, byte ptr [ebx]
                                cmp al, byte ptr [TransparentColor]
                                je nope
                                and al, 0FCh
                                add eax, [ColorBlendMap]
                                mov eax, [eax]
                                mov [edi], eax
                        nope:   add edi, 4
                                dec ecx
                                jnz lp
                }
                off += bpsl;
                bsource += BlendSource->ancho;
        }
}
*/

// general
void DrawPolygon(TPolygon *p, TBitmap *where) {
        switch (p->style) {
                case nc_wireframe: WirePolygon(p, where); break;
                case c_wireframe: WirePolygon(p, where); break;
                case ca_wireframe: WirePolygon(p, where); break;
                case nc_flatshaded: FlatPolygon(p, where); break;
                case c_flatshaded: FlatPolygon(p, where); break;
                case ca_flatshaded: FlatPolygon(p, where); break;
//                case nc_gouraudshaded: GouraudPolygon(p, where); break;
//                case c_gouraudshaded: GouraudPolygon(p, where); break;
//                case ca_gouraudshaded: WeirdPolygon1(p, where); break;
//                case nc_texturemapped: BlendTexturePolygon(p, where); break;
                case c_texturemapped: TexturePolygon(p, where); break;
//                case ca_texturemapped: TransTexturePolygon(p, where); break;
        }
}

