//	triangle.cpp

#include "vectors.h"
#include "triangle.h"

// globals
unsigned int TextureOffset;

// global vars for trifillers
TVertex *larray[3], *rarray[3];
int lsection, rsection, lheight, rheight;
double leftx, leftdx, rightx, rightdx;
double leftu, leftdu, leftv, leftdv;	// for textured triangles


#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif



// all triangles use the same DoRightSide function
int DoRightSide() {
	TVertex *tv1 = rarray[rsection];
	TVertex *tv2 = rarray[rsection - 1];
	int height = tv2->y2d - tv1->y2d;
	if (height == 0) return 0;
	rightdx = (tv2->x2d - tv1->x2d) / (double)height;
	rightx = tv1->x2d;
	rheight = height;
	return height;
}


// LeftSide for texture mapping
int TextureDoLeftSide() {
	TVertex *tv1 = larray[lsection];
	TVertex *tv2 = larray[lsection - 1];
	int height = tv2->y2d - tv1->y2d;
	if (height == 0) return 0;
	leftdx = (tv2->x2d - tv1->x2d) / (double)height;
	leftdu = (tv2->u - tv1->u) / (double)height;
	leftdv = (tv2->v - tv1->v) / (double)height;
	leftx = tv1->x2d;
	leftu = tv1->u;
	leftv = tv1->v;
	lheight = height;
	return height;
}


// clipped texture mapped triangle
void DrawTriangle(TVertex *vt1, TVertex *vt2, TVertex *vt3, unsigned int where) {
	int u, v, du, dv;
	TVertex *v1 = vt1;
	TVertex *v2 = vt2;
	TVertex *v3 = vt3;
	if (v1->y2d > v2->y2d) { TVertex *v = v1; v1 = v2; v2 = v; }
	if (v1->y2d > v3->y2d) { TVertex *v = v1; v1 = v3; v3 = v; }
	if (v2->y2d > v3->y2d) { TVertex *v = v2; v2 = v3; v3 = v; }
	int height = v3->y2d - v1->y2d;
	if (height == 0) return;
	double temp = (v2->y2d - v1->y2d) / (double)height;
	double longest = temp * (v3->x2d - v1->x2d) + v1->x2d - v2->x2d;
	if (longest == 0.0) return;
	if (longest < 0.0) {
		rarray[0] = v3; rarray[1] = v2; rarray[2] = v1;
		rsection = 2;
		larray[0] = v3; larray[1] = v1;
		lsection = 1;
		if (TextureDoLeftSide() <= 0) return;
		if (DoRightSide() <= 0) {
			rsection--;
			if (DoRightSide() <= 0) return;
		}
		if (longest > -1.0) longest = -1.0;
	}
	else {
		larray[0] = v3; larray[1] = v2; larray[2] = v1;
		lsection = 2;
		rarray[0] = v3; rarray[1] = v1;
		rsection = 1;
		if (DoRightSide() <= 0) return;
		if (TextureDoLeftSide() <= 0) {
			lsection--;
			if (TextureDoLeftSide() <= 0) return;
		}
		if (longest < 1.0) longest = 1.0;
	}
	double dudx = (temp * (v3->u - v1->u) + v1->u - v2->u) / longest;
	double dvdx = (temp * (v3->v - v1->v) + v1->v - v2->v) / longest;
	unsigned int clipymax = where + 63680;
	unsigned int off = where + v1->y2d * 320;
        unsigned int texoff = TextureOffset;
	while (1) {
		if ((off >= where) && (off <= clipymax)) {
			int x1 = dtoi(leftx);
			int x2 = dtoi(rightx);
			int width = x2 - x1;
			int clipflag = 0;
			if (x1 < 0) {
				width = x2;
				clipflag = -x1;
				x1 = 0;
			}
			if (x2 > 319) width = 319 - x1;
			if (width > 0) {
				u = dtoi(leftu * 65536.0);
				v = dtoi(leftv * 65536.0);
				du = dtoi(dudx * 65536.0);
				dv = dtoi(dvdx * 65536.0);
				if (clipflag) {
					u += du * clipflag;
					v += dv * clipflag;
				}
				_asm {
					mov edi, [x1]
					mov esi, [v]
					mov edx, [u]
					add edi, [off]
					mov ecx, [width]
					dec edi
					loop1:  movzx ebx, si
							add esi, [dv]
							mov bl, dh
							inc edi
                                                        add ebx, [texoff]
							mov al, [ebx]
							add edx, [du]
							or al, al
							jz nope
							mov [edi], al
					nope:   dec ecx
							jnz loop1
				}
			}
		}
		off += 320;
		if (--lheight <= 0) {
			if (--lsection <= 0) return;
			if (TextureDoLeftSide() <= 0) return;
		}
		else {
			leftx += leftdx;
			leftu += leftdu;
			leftv += leftdv;
		}
		if (--rheight <= 0) {
			if (--rsection <= 0) return;
			if (DoRightSide() <= 0) return;
		}
		else rightx += rightdx;
	}
}
