
//	cuadro.cpp

#include "vectors.h"
#include "obj3d.h"
#include "cuadro.h"

void GeneraCuadro(int VertexPerSide, double Size, TObject3D *obj) {
	int i, j, a, b, c;
	double x, y, u, v;
	TPolygon *poly;
	double texinc = 0.996 / (double)(VertexPerSide - 1);
	y = - (int)(VertexPerSide / 2) * Size;
	if ((VertexPerSide & 1) == 0) y += Size / 2.0;
	v = 0.0;
	for (j = 0; j < VertexPerSide; j++) {
		x = - (int)(VertexPerSide / 2) * Size;
		if ((VertexPerSide & 1) == 0) x += Size / 2.0;
		u = 0.0;
		for (i = 0; i < VertexPerSide; i++) {
			obj->AddVertexUV(x, y, 0.0, u, v);
			x += Size;
			u += texinc;
		}
		y += Size;
		v += texinc;
	}
	
	for (j = 0; j < (VertexPerSide - 1); j++)
		for (i = 0; i < (VertexPerSide - 1); i++) {
			a = j * VertexPerSide + i;
			b = a + 1;
			c = a + VertexPerSide;
			poly = new TPolygon();
			poly->AddVertex(obj->Vertex[a]);
			poly->AddVertex(obj->Vertex[b]);
			poly->AddVertex(obj->Vertex[c]);
			obj->AddPolygon(poly);
			a = c + 1;
			poly = new TPolygon();
			poly->AddVertex(obj->Vertex[a]);
			poly->AddVertex(obj->Vertex[c]);
			poly->AddVertex(obj->Vertex[b]);
			obj->AddPolygon(poly);
		}
	obj->CalcNormals();
}
