'$DYNAMIC
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z
DEFSNG J
TYPE PicData
	Height AS INTEGER
	Width AS INTEGER
	Colors AS INTEGER
END TYPE
TYPE LibHeaderType
	FileName AS STRING * 12
	Offset AS LONG
	Size AS LONG
END TYPE

DECLARE SUB GetSoundCardInfo ()
DECLARE SUB QTInit ()
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDone ()
DECLARE SUB FillCircle (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB FillCircle2 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB FillCircle3 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB FillCircle4 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB FillCircle5 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB FillCircle6 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB ClearCircle (BYVAL CX, BYVAL CY, BYVAL Radius)
DECLARE SUB ShadeCircle (CX, CY, Radius, Colr)
DECLARE SUB Shellsort (Array())
DECLARE FUNCTION ASin! (BYVAL A!)
DECLARE SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS PicData)
DECLARE SUB FPrint (Text$, X, Y)
DECLARE SUB TriFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
DECLARE SUB TriFill2 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
DECLARE SUB TriFill3 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
DECLARE SUB TriClear (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3)
DECLARE SUB TriGFill (BYVAL X1, BYVAL Y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
DECLARE SUB FadePalette (BYVAL Red, BYVAL Green, BYVAL Blue, Pal(), BYVAL Amount AS SINGLE)
DECLARE SUB GetPalette ()
DECLARE FUNCTION ASin! (BYVAL A!)
DECLARE SUB Line2 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL Col)
DECLARE FUNCTION GetLibOffset& (File$)

DIM SHARED VirtScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM SHARED BlankScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM SHARED Palett(0 TO 255, 1 TO 3)

DIM Ratio AS SINGLE
CONST pi = 3.14159
CONST Lib$ = "TTS.DAT"
RANDOMIZE TIMER

' *** SOUND INIT ***

DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
A& = SETMEM(-180000)  ' mem to free for BWSB - adjust as needed
GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
'ErrorFlag = LoadMSE("SOUND.DAT", Device(Dev), 45, 4096, Port, IRQ, DMA)
ErrorFlag = LoadMSE(Lib$, GetLibOffset("SOUND.DAT") - 1 + Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
	PRINT "EMS is required for a non-GUS soundcard.": END 'StopBanner: END
END IF

' *** ASPECT RATIO ***

SCREEN 13
CLS

DIM Pic(0, 0) AS STRING * 1, PicD AS PicData
LoadBMP "aspect.bmp", Pic(), PicD
FOR L = 0 TO PicD.Colors - 1
	 OUT &H3C8, L
	 FOR M = 1 TO 3: OUT &H3C9, Palett(L, M): NEXT M
NEXT L
PS = VARSEG(Pic(0, 0)): PO = VARPTR(Pic(0, 0))
WAIT &H3DA, 8
CALL BlockMove(PS, PO, &HA000, 0, 64000, 0)

DO
	A$ = INKEY$
	SELECT CASE A$
	CASE "1": Ratio = .83: Top = 25: Bottom = 174: EXIT DO
	CASE "2": Ratio = 1: Top = 10: Bottom = 189: EXIT DO
	CASE "3": Ratio = 1.11: Top = 0: Bottom = 199: EXIT DO
	CASE CHR$(27): END
	END SELECT
LOOP
ERASE Pic

OPEN "tts.ini" FOR OUTPUT AS 1
WRITE #1, Ratio, Dev, Port, IRQ, DMA: CLOSE 1

' ** MUSIC LOAD **

OPEN Lib$ FOR BINARY AS 1
'OPEN "chroma.gdm" FOR BINARY AS 1
LoadGDM FILEATTR(1, 2), GetLibOffset("CHROMA.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR J = 1 TO 32                  'Scan for used music channels
  IF ASC(MID$(ModHeader.PanMap, J, 1)) <> &HFF THEN
	 MusChans = MusChans + 1
  END IF
NEXT

OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(50)

'*** Intro (C4)
CLS : PALETTE
VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))
BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))
DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 2) - 80) ^ 2 + ((M - 100) / Ratio) ^ 2)
		P = 190 - N / 2
		IF P > 163 THEN P = 163
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 190: faces = 87
DIM fsort(points), ccolor(points)
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM Dx(points), Dy(points), Radius(points), rad(points) AS SINGLE, JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), fcolor(faces), zavg(faces)

DIM xrot AS SINGLE, yrot AS SINGLE, zrot AS SINGLE
DIM cosx AS SINGLE, sinx AS SINGLE
DIM cosy AS SINGLE, siny AS SINGLE
DIM cosz AS SINGLE, sinz AS SINGLE
DIM camdist AS SINGLE
Xoffset = 160: yoffset = 100

FOR L = 100 TO 163
	OUT &H3C8, L: OUT &H3C9, (L - 100) / 1.1: OUT &H3C9, (L - 100) / 1.05: OUT &H3C9, (L - 100) / 1
NEXT L
'OUT &H3C8, 15: OUT &H3C9, 57: OUT &H3C9, 60: OUT &H3C9, 63
GetPalette

FOR L = 1 TO 12
	X(L) = L * 9: Y(L) = 0: ccolor(L) = INT(RND * 32) + 33: rad(L) = 10
NEXT L

FOR L = 13 TO points
READ X(L), Y(L), ccolor(L), rad(L)
NEXT L
FOR L = 1 TO faces
READ F1(L), F2(L), F3(L), fcolor(L)
NEXT L

FOR L = 13 TO 31: X(L) = X(L) + 270: NEXT
FOR L = 32 TO points: X(L) = X(L) + 333: NEXT

QTInit

QTSetTimer 1, 32000
T1 = 32000
xrot = 0
yrot = 3.14
cosx = 1: sinx = 0
cosy = -1: siny = 0

DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	
	t = QTGetTimer(1)
	IF t < 2500 AND t > 1000 THEN
			FadePalette 63, 63, 63, Palett(), (t - 1000) / 1500
	END IF
	zrot = 0
	camdist = 25
	IF t < 28000 AND t > 20000 THEN zrot = SIN((28000 - t) / 637)
	IF t < 24000 AND t > 20000 THEN camdist = 25 + SIN((24000 - t) / 637) * 10
	IF t < 17000 AND t > 13000 THEN camdist = 25 - SIN((17000 - t) / 1273) * 20
	
	IF t < 17000 AND t > 13000 THEN zrot = (17000 - t) / 637
	IF t < 10600 AND t > 3535 THEN camdist = 25 - ABS(SIN((10600 - t) / 750)) * 20
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		IF t > 18000 OR (t < 13000 AND t > 10600) THEN
			X(P) = X(P) - (T1 - t) / 50
			IF X(P) < -50 AND P <= 12 THEN
				X(P) = X(P) + 12 * 9
				ccolor(P) = INT(RND * 20) + 40
				fcolor(1) = ccolor(6)
				fcolor(2) = ccolor(6)
				fcolor(5) = ccolor(8)
				fcolor(6) = ccolor(8)
				fcolor(7) = ccolor(8)
				fcolor(8) = ccolor(8)
			END IF
		ELSEIF t < 10600 AND t > 3535 THEN
			X(P) = X(P) - (T1 - t) / 250
			IF X(P) < -50 AND P <= 12 THEN
				X(P) = X(P) + 12 * 9
			END IF
		ELSEIF t < 3500 THEN
			X(P) = X(P) - (T1 - t) / 20
			IF X(P) < -50 AND P <= 12 THEN X(P) = X(P) + 12 * 9
		END IF
		IF t < 12000 AND t > 11500 THEN
				ccolor(72) = ccolor(1)
				ccolor(73) = ccolor(1)
				fcolor(29) = ccolor(1)
				fcolor(30) = ccolor(1)
				ccolor(125) = ccolor(3)
				ccolor(126) = ccolor(3)
				ccolor(142) = ccolor(3)
				ccolor(159) = ccolor(3)
				fcolor(54) = ccolor(3)
				fcolor(55) = ccolor(3)
				fcolor(60) = ccolor(3)
				fcolor(61) = ccolor(3)
				fcolor(70) = ccolor(3)
				fcolor(71) = ccolor(3)
		END IF
		' x-axis rotate
		JY1 = Y(P)
		JZ1 = z(P)
		' y-axis rotate
		JX1 = -X(P)
		JZ(P) = -JZ1
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		JZcam = JZ(P) + camdist
		
		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset

		IF rad(P) > 0 THEN Radius(P) = (rad(P) * 60) / JZcam
	NEXT P
	
	FOR M = 1 TO points
		IF rad(M) > 0 AND Radius(M) < 150 THEN
			IF ccolor(M) = 15 THEN
				ClearCircle Dx(M), Dy(M), Radius(M)
			ELSE
				FillCircle Dx(M), Dy(M), Radius(M), ccolor(M)
			END IF
		END IF
	NEXT M

	FOR M = 1 TO faces
		IF fcolor(M) = 15 THEN
			TriClear Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M))
		ELSE
			TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M)
		END IF
	NEXT M

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	Frames = Frames + 1
	T1 = t
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 1000

' *** CHESS2 ***

ERASE fsort, ccolor, X, Y, z, Dx, Dy, Radius, rad, JZ, F1, F2, F3, fcolor, zavg

points = 288: faces = 144
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces)
DIM Dx(points), Dy(points)
camdist = 150: Xoffset = 160: yoffset = 100

DEF SEG = BS
FOR L = 32 TO 95
	Palett(L, 1) = (L - 32) / 1
	Palett(L, 2) = 0
	Palett(L, 3) = 0
NEXT L
FOR L = 100 TO 163
	Palett(L, 1) = (L - 100) / 1
	Palett(L, 2) = (L - 100) / 1
	Palett(L, 3) = (L - 100) / 1
NEXT L
'GetPalette

FOR M = Top TO Bottom
	FOR L = 0 TO 319
		P = (L + M) / 20 + 42
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

FOR P = 1 TO points
	xoff = ((P - 1) MOD 48) \ 8
	yoff = ((P - 1) \ 48)
	X(P) = ((P - 1) MOD 2) + (((P - 1) \ 4) MOD 2) + xoff * 2
	Y(P) = (((P - 1) MOD 8) + 2) \ 4 + yoff * 2
	z(P) = 0

	X(P) = X(P) * 30 - 165
	Y(P) = Y(P) * 30 - 165
NEXT P

FOR P = 1 TO faces STEP 2
	F1(P) = P * 2 - 1
	F2(P) = P * 2
	F3(P) = P * 2 + 2
	F1(P + 1) = P * 2 - 1
	F2(P + 1) = P * 2 + 1
	F3(P + 1) = P * 2 + 2
NEXT P

QTSetTimer 1, 30000: T1 = 30000
xrot = 0
yrot = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 28500 THEN
		FadePalette 63, 63, 63, Palett(), (30000 - t) / 1500
	END IF
	IF t < 18000 AND t >= 17000 THEN
		FadePalette 63, 63, 63, Palett(), (t - 17000) / 1000
	END IF
	zrot = SIN(t / 2200) * 3
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		X(P) = X(P) - (T1 - t) / 4
		IF X(P) < -200 THEN
			FOR L = 0 TO 3
				X(P + L) = X(P + L) + 360
			NEXT L
		END IF
		' z-axis rotate
		JX = cosz * X(P) - sinz * Y(P)
		JY = sinz * X(P) + cosz * Y(P)
		' map 3d to 2d
		Dx(P) = (-JX * 150) / camdist + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / camdist + yoffset
	NEXT P
	FOR M = 1 TO faces
		TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), (Dx(F1(M)) + Dy(F1(M))) / 20 + 135
	NEXT M
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	Frames = Frames + 1
	T1 = t
LOOP UNTIL LEN(INKEY$) OR t <= 17000

' *** C1 ***
DEF SEG = &HA000
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		POKE L + M * 320, 15
NEXT L, M
PALETTE: GetPalette
ERASE X, Y, z, JZ, F1, F2, F3, Dx, Dy

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 1.5) - 105) ^ 2 + ((M - 100) / Ratio) ^ 2)
		P = 245 - N
		IF P > 163 THEN P = 163
		POKE L + M * 320, P
NEXT L, M

'GetPalette
FOR L = 100 TO 163
	Palett(L, 1) = (L - 100) / 1
	Palett(L, 2) = (L - 100) / 1
	Palett(L, 3) = (L - 100) / 1
NEXT L

FillCircle 40, 100 + 40 * Ratio, 30, 105
FillCircle 41, 100 + 39 * Ratio, 26, 50
FillCircle 40, 100 + 35 * Ratio, 7, 160
FillCircle 55, 100 + 35 * Ratio, 7, 160
FillCircle 42, 100 + 33 * Ratio, 3, 105
FillCircle 57, 100 + 33 * Ratio, 3, 105

IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 6
REDIM fsort(points), zavg(points)
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
REDIM Dx(points), Dy(points), Radius(points), JZ(points) AS SINGLE
camdist = 20: Xoffset = 160: yoffset = 100
X(1) = -15: Y(1) = 0: z(1) = 0
X(2) = -9: Y(2) = 0: z(2) = 0
X(3) = -3: Y(3) = 0: z(3) = 0
X(4) = 3: Y(4) = 0: z(4) = 0
X(5) = 9: Y(5) = 0: z(5) = 0
X(6) = 15: Y(6) = 0: z(6) = 0

QTSetTimer 1, 32000
xrot = 0

DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 63, 63, 63, Palett(), (32000 - t) / 1500
	END IF
	IF t < 15000 AND t >= 13500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 13500) / 1500
	END IF

	yrot = (COS(t / 2000)) * 3
	zrot = (SIN(t / 1000)) * 2

	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		JZcam = JZ(P) + camdist
		
		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 125) / JZcam + yoffset

		Radius(P) = 625 / JZcam
	NEXT P
	
	FOR L = 1 TO points
		fsort(L) = L
		zavg(L) = JZ(L)
	NEXT
	Shellsort zavg()

	FOR L = points TO 1 STEP -1
		M = fsort(L)
		IF Radius(M) < 150 THEN
			FillCircle2 Dx(M), Dy(M), Radius(M), 35 + M * 4
		END IF
	NEXT L

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 13500

' *** EXPLODE CUBE (cubex)
CLS ': PALETTE
ERASE X, Y, z, JZ, Dx, Dy

points = 324: faces = 108

REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
REDIM SX(points) AS SINGLE, SY(points) AS SINGLE, SZ(points) AS SINGLE
REDIM fcolor(faces)
REDIM zavg(faces)
REDIM SHARED fsort(faces)
REDIM Dx(points), Dy(points), JZ(points) AS SINGLE
REDIM F1(faces), F2(faces), F3(faces)
REDIM splodetime(faces), splodedist(faces) AS SINGLE

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 2) - 70) ^ 2 + ((M - 90) / Ratio) ^ 2)
		IF N >= 150 THEN P = 36 ELSE P = -10 + LOG(150 - N) * 10
		IF P > 36 THEN P = 36
		IF P < 0 THEN P = 0
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

camdist = 225: Xoffset = 140: yoffset = 100
FOR L = 0 TO 63: FOR M = 1 TO 3: Palett(L, M) = L: NEXT M, L
FOR L = 0 TO 31
	Palett(64 + L, 1) = L + 32: Palett(64 + L, 2) = 31 - L: Palett(64 + L, 3) = 31 - L
	Palett(96 + L, 1) = 31 - L: Palett(96 + L, 2) = L + 32: Palett(96 + L, 3) = 31 - L
	Palett(128 + L, 1) = 31 - L: Palett(128 + L, 2) = 31 - L: Palett(128 + L, 3) = L + 32
	Palett(160 + L, 1) = L + 32: Palett(160 + L, 2) = L + 32: Palett(160 + L, 3) = 31 - L
	Palett(192 + L, 1) = L + 32: Palett(192 + L, 2) = 32: Palett(192 + L, 3) = 31 - L
	Palett(224 + L, 1) = L + 32: Palett(224 + L, 2) = 31 - L: Palett(224 + L, 3) = L + 32
NEXT L

' back
FOR Y = 0 TO 2
	FOR X = 0 TO 2
		L = (Y * 3 + X) * 6 + 1
		X(L) = X * 30 - 45
		Y(L) = Y * 30 - 45
		z(L) = 45
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): z(L + 1) = z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: z(L + 2) = z(L)
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L + 1): z(L + 3) = z(L)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L + 2): z(L + 4) = z(L)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L) + 30: z(L + 5) = z(L)
NEXT X, Y
' front
FOR Y = 0 TO 2
	FOR X = 0 TO 2
		L = 54 + (Y * 3 + X) * 6 + 1
		X(L) = X * 30 - 45
		Y(L) = Y * 30 - 45
		z(L) = -45
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): z(L + 1) = z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: z(L + 2) = z(L)
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L + 1): z(L + 3) = z(L)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L + 2): z(L + 4) = z(L)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L) + 30: z(L + 5) = z(L)
NEXT X, Y
'left
FOR Y = 0 TO 2
	FOR z = 0 TO 2
		L = 54 * 2 + (Y * 3 + z) * 6 + 1
		X(L) = -45
		Y(L) = Y * 30 - 45
		z(L) = z * 30 - 45
		X(L + 1) = X(L): Y(L + 1) = Y(L): z(L + 1) = z(L) + 30
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: z(L + 2) = z(L)
		X(L + 3) = X(L): Y(L + 3) = Y(L + 1): z(L + 3) = z(L + 1)
		X(L + 4) = X(L): Y(L + 4) = Y(L + 2): z(L + 4) = z(L + 2)
		X(L + 5) = X(L): Y(L + 5) = Y(L) + 30: z(L + 5) = z(L) + 30
NEXT z, Y
'right
FOR Y = 0 TO 2
	FOR z = 0 TO 2
		L = 54 * 3 + (Y * 3 + z) * 6 + 1
		X(L) = 45
		Y(L) = Y * 30 - 45
		z(L) = z * 30 - 45
		X(L + 1) = X(L): Y(L + 1) = Y(L): z(L + 1) = z(L) + 30
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: z(L + 2) = z(L)
		X(L + 3) = X(L): Y(L + 3) = Y(L + 1): z(L + 3) = z(L + 1)
		X(L + 4) = X(L): Y(L + 4) = Y(L + 2): z(L + 4) = z(L + 2)
		X(L + 5) = X(L): Y(L + 5) = Y(L) + 30: z(L + 5) = z(L) + 30
NEXT z, Y
'top
FOR z = 0 TO 2
	FOR X = 0 TO 2
		L = 54 * 4 + (z * 3 + X) * 6 + 1
		X(L) = X * 30 - 45
		Y(L) = 45
		z(L) = z * 30 - 45
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): z(L + 1) = z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L): z(L + 2) = z(L) + 30
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L): z(L + 3) = z(L + 1)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L): z(L + 4) = z(L + 2)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L): z(L + 5) = z(L) + 30
NEXT X, z
'bottom
FOR z = 0 TO 2
	FOR X = 0 TO 2
		L = 54 * 5 + (z * 3 + X) * 6 + 1
		X(L) = X * 30 - 45
		Y(L) = -45
		z(L) = z * 30 - 45
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): z(L + 1) = z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L): z(L + 2) = z(L) + 30
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L): z(L + 3) = z(L + 1)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L): z(L + 4) = z(L + 2)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L): z(L + 5) = z(L) + 30
NEXT X, z
FOR P = 1 TO points
	SX(P) = X(P): SY(P) = Y(P): SZ(P) = z(P)
NEXT

FOR L = 1 TO faces
	F1(L) = (L - 1) * 3 + 1
	F2(L) = (L - 1) * 3 + 2
	F3(L) = (L - 1) * 3 + 3
	fcolor(L) = ((L - 1) \ 18) * 32 + 83
	splodetime(L) = INT(RND * 3000) + 26000
NEXT L

QTSetTimer 1, 32767
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 31267 THEN
		FadePalette 0, 0, 0, Palett(), (32767 - t) / 1500
	END IF
	IF t < 23000 AND t >= 22000 THEN
		FadePalette 0, 0, 0, Palett(), (t - 22000) / 1000
	END IF
	xrot = t / 1200
	yrot = t / 1200
	zrot = 0
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR L = 1 TO faces
		
		IF t < splodetime(L) THEN
			splodedist(L) = (splodetime(L) - t) / 10
			SX(F1(L)) = X(F1(L)) + splodedist(L) * (X(F1(L)) / 45)
			SX(F2(L)) = X(F2(L)) + splodedist(L) * (X(F1(L)) / 45)
			SX(F3(L)) = X(F3(L)) + splodedist(L) * (X(F1(L)) / 45)
			SY(F1(L)) = Y(F1(L)) + splodedist(L) * (Y(F1(L)) / 45)
			SY(F2(L)) = Y(F2(L)) + splodedist(L) * (Y(F1(L)) / 45)
			SY(F3(L)) = Y(F3(L)) + splodedist(L) * (Y(F1(L)) / 45)
			SZ(F1(L)) = z(F1(L)) + splodedist(L) * (z(F1(L)) / 45)
			SZ(F2(L)) = z(F2(L)) + splodedist(L) * (z(F1(L)) / 45)
			SZ(F3(L)) = z(F3(L)) + splodedist(L) * (z(F1(L)) / 45)

		END IF
	NEXT L

	FOR P = 1 TO points
		
		' x-axis rotate
		JY1 = cosx * SY(P) - sinx * SZ(P)
		JZ1 = sinx * SY(P) + cosx * SZ(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * SX(P)
		JZ(P) = cosy * JZ1 - siny * SX(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		IF JZ(P) < -100 THEN JZ(P) = -100
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * Ratio * 150) / (JZ(P) + camdist) + yoffset
		
	NEXT P
	FOR L = 1 TO faces STEP 2
		fsort(L) = L
		fsort(L + 1) = L + 1
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L)) + JZ(F1(L + 1)) + JZ(F2(L + 1)) + JZ(F3(L + 1))) / 6
		zavg(L + 1) = zavg(L)
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) > -100 AND zavg(L) < 100 AND splodedist(M) < 150 THEN
			TriGFill Dx(F1(M)), Dy(F1(M)), fcolor(M) - JZ(F1(M)) / 10, Dx(F2(M)), Dy(F2(M)), fcolor(M) - JZ(F2(M)) / 10, Dx(F3(M)), Dy(F3(M)), fcolor(M) - JZ(F3(M)) / 10
		END IF
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 22000

' *** LARGE BALLS (C3) ***
CLS ': PALETTE
ERASE X, Y, z, SX, SY, SZ, fcolor, zavg, fsort, Dx, Dy, JZ, F1, F2, F3, splodetime, splodedist

points = 20
REDIM fsort(points), zavg(points)
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
REDIM Dx(points), Dy(points), Radius(points), JZ(points) AS SINGLE
DIM Font(0, 0) AS STRING * 1, FontD AS PicData
DIM Text$(1 TO 4)

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 1: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

camdist = 28: Xoffset = 160: yoffset = 100

X(1) = -10: Y(1) = 10: z(1) = -10
X(2) = 0: Y(2) = 10: z(2) = -10
X(3) = 10: Y(3) = 10: z(3) = -10
X(4) = -10: Y(4) = 0: z(4) = -10
X(5) = 10: Y(5) = 0: z(5) = -10
X(6) = -10: Y(6) = -10: z(6) = -10
X(7) = 0: Y(7) = -10: z(7) = -10
X(8) = 10: Y(8) = -10: z(8) = -10
X(9) = -10: Y(9) = 10: z(9) = 10
X(10) = 0: Y(10) = 10: z(10) = 10
X(11) = 10: Y(11) = 10: z(11) = 10
X(12) = -10: Y(12) = 0: z(12) = 10
X(13) = 10: Y(13) = 0: z(13) = 10
X(14) = -10: Y(14) = -10: z(14) = 10
X(15) = 0: Y(15) = -10: z(15) = 10
X(16) = 10: Y(16) = -10: z(16) = 10
X(17) = -10: Y(17) = 10: z(17) = 0
X(18) = 10: Y(18) = 10: z(18) = 0
X(19) = -10: Y(19) = -10: z(19) = 0
X(20) = 10: Y(20) = -10: z(20) = 0

DIM BallX(0 TO 49)
DIM Ball(0 TO (100 * 50) - 1) AS STRING * 1
BallS = VARSEG(Ball(0)): BallO = VARPTR(Ball(0))

FOR Y = 0 TO 49
	Angle! = ASin(1 - Y / 50)
	BallX(Y) = (50 - COS(Angle!) * 50)
	FOR X = 0 TO 99
		Dist = SQR((X - 50) ^ 2 + (Y - 50) ^ 2)
		IF Dist < 50 THEN
			Ball(X + Y * 100) = CHR$(20 + 32 * COS(Dist / 24))
		END IF
NEXT X, Y

LoadBMP "font2.bmp", Font(), FontD
FOR L = 0 TO FontD.Colors - 1
	 FOR M = 1 TO 3
		Palett(L + 200, M) = Palett(L, M)
	 NEXT M
NEXT L
FS = VARSEG(Font(0, 0)): FO = VARPTR(Font(0, 0))
FOR L = 1 TO 63: FOR M = 1 TO 3: Palett(L, M) = L: NEXT M, L

FOR L = 1 TO 4: READ Text$(L): NEXT
Text$(1) = CHR$(34) + Text$(1): Text$(4) = Text$(4) + CHR$(34)
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

QTSetTimer 1, 32000
QTSetTimer 2, 2000
TRows = 1: TChar = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	xrot = 0
	yrot = (COS(t / 2000)) * 3
	zrot = (SIN(t / 1000)) * 2

	IF t > 30000 THEN
		yoffset = 100 + ((t - 30000) / 10) * Ratio
	ELSE
		yoffset = 100
	END IF
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 16000 AND t >= 14500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 14500) / 1500
	END IF

	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		JZcam = JZ(P) + camdist
		
		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset

		Radius(P) = 625 / JZcam
	NEXT P
	
	FOR L = 1 TO points
		fsort(L) = L
		zavg(L) = JZ(L)
	NEXT
	Shellsort zavg()

	FOR L = points TO 1 STEP -1
		M = fsort(L)
		IF Radius(M) <= 50 THEN
			ShadeCircle Dx(M), Dy(M), Radius(M), 40 + M * 3
		END IF
	NEXT L

	T2 = QTGetTimer(2)
	IF T2 = 0 THEN
		TChar = TChar + 1
		IF TChar > LEN(Text$(TRows)) AND TRows < 4 THEN
			TRows = TRows + 1: TChar = 1
		END IF
		QTSetTimer 2, 50
	END IF
	FOR Y = 1 TO TRows
		IF Y < TRows THEN
			FPrint Text$(Y), 150, Y * 14 + 100
		ELSE
			FPrint LEFT$(Text$(Y), TChar), 150, Y * 14 + 100
		END IF
	NEXT Y

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 14500

' *** Wavy cube (CUBE4)
CLS : WAIT &H3DA, 8: PALETTE
ERASE fsort, zavg, X, Y, z, Dx, Dy, Radius, JZ, BallX, Ball

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 200: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 8: faces = 12
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), fcolor(faces)
DIM zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points)
DIM JZ(points) AS SINGLE

camdist = 210: Xoffset = 160: yoffset = 100
FOR L = 0 TO 63
'Palett(L, 1) = L / 1.3: Palett(L, 2) = L: Palett(L, 3) = L / 1.3
'Palett(L + 64, 1) = L: Palett(L + 64, 2) = L / 1.3: Palett(L + 64, 3) = L
'Palett(L + 128, 1) = L / 1.3: Palett(L + 128, 2) = L / 1.3: Palett(L + 128, 3) = L
OUT &H3C8, L: OUT &H3C9, L / 1.3: OUT &H3C9, L: OUT &H3C9, L / 1.3
OUT &H3C8, L + 64: OUT &H3C9, L: OUT &H3C9, L / 1.3: OUT &H3C9, L
OUT &H3C8, L + 128: OUT &H3C9, L / 1.3: OUT &H3C9, L / 1.3: OUT &H3C9, L
NEXT L
GetPalette

X(1) = -60: Y(1) = -60: z(1) = -60
X(2) = -60: Y(2) = 60: z(2) = -60
X(3) = 60: Y(3) = 60: z(3) = -60
X(4) = 60: Y(4) = -60: z(4) = -60
X(5) = -60: Y(5) = -60: z(5) = 60
X(6) = -60: Y(6) = 60: z(6) = 60
X(7) = 60: Y(7) = 60: z(7) = 60
X(8) = 60: Y(8) = -60: z(8) = 60
F1(1) = 1: F2(1) = 2: F3(1) = 3
F1(2) = 1: F2(2) = 3: F3(2) = 4
F1(3) = 5: F2(3) = 6: F3(3) = 7
F1(4) = 5: F2(4) = 7: F3(4) = 8
F1(5) = 1: F2(5) = 5: F3(5) = 6
F1(6) = 1: F2(6) = 2: F3(6) = 6
F1(7) = 3: F2(7) = 7: F3(7) = 8
F1(8) = 3: F2(8) = 4: F3(8) = 8
F1(9) = 1: F2(9) = 4: F3(9) = 8
F1(10) = 1: F2(10) = 5: F3(10) = 8
F1(11) = 2: F2(11) = 3: F3(11) = 7
F1(12) = 2: F2(12) = 6: F3(12) = 7
fcolor(1) = 0: fcolor(2) = 0
fcolor(3) = 0: fcolor(4) = 0
fcolor(5) = 64: fcolor(6) = 64
fcolor(7) = 64: fcolor(8) = 64
fcolor(9) = 128: fcolor(10) = 128
fcolor(11) = 128: fcolor(12) = 128

QTSetTimer 1, 32000
xrot = 0: yrot = 0: zrot = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 17000 AND t >= 15500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 15500) / 1500
	END IF
	xrot = t / 1500
	yrot = t / 1200
	zrot = t / 1200
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces STEP 2
		fsort(L) = L
		fsort(L + 1) = L + 1
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L)) + JZ(F1(L + 1)) + JZ(F2(L + 1)) + JZ(F3(L + 1))) / 6
		zavg(L + 1) = zavg(L)
	NEXT
	Shellsort zavg()
	FOR L = faces / 1.5 TO 1 STEP -1
		M = fsort(L)
		TriGFill Dx(F1(M)), Dy(F1(M)), fcolor(M) + 18 - JZ(F1(M)) / 3, Dx(F2(M)), Dy(F2(M)), fcolor(M) + 18 - JZ(F2(M)) / 3, Dx(F3(M)), Dy(F3(M)), fcolor(M) + 18 - JZ(F3(M)) / 3
	NEXT L
	FOR L = Top TO Bottom
		M = L + COS(L / 8 + t / 300) * 6 * Ratio
		IF M < Top THEN M = Top
		IF M > Bottom THEN M = Bottom
		CALL BlockMove(VS, VO + M * 320 + 0, &HA000, L * 320, 320, 0)
	NEXT L
LOOP UNTIL LEN(INKEY$) OR t <= 15500

' *** Spiral (SPIRAL2) ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, F1, F2, F3, fcolor, zavg, fsort, Dx, Dy, JZ

points = 300: faces = 200
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM Dx(points), Dy(points), JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), zavg(faces)
DIM SHARED fsort(faces)

camdist = 100: Xoffset = 160: yoffset = 100

FOR L = 1 TO 200 STEP 4
	X(L) = COS(L / 5.3) * 50
	X(L + 1) = COS((L + 4) / 5.3) * 50
	X(L + 2) = COS(L / 5.3) * 40
	X(L + 3) = COS((L + 4) / 5.3) * 40
	Y(L) = SIN(L / 5.3) * 50
	Y(L + 1) = SIN((L + 4) / 5.3) * 50
	Y(L + 2) = SIN(L / 5.3) * 40
	Y(L + 3) = SIN((L + 4) / 5.3) * 40
	z(L) = L * 2 - 200
	z(L + 1) = L * 2 - 192
	z(L + 2) = L * 2 - 200
	z(L + 3) = L * 2 - 192
NEXT L
FOR L = 201 TO points
	X(L) = RND * 20 - 10
	Y(L) = RND * 20 - 10
	z(L) = RND * 400 + 600
NEXT L

FOR L = 1 TO 99 STEP 2
	F1(L) = L * 2 - 1: F2(L) = L * 2: F3(L) = L * 2 + 1
	F1(L + 1) = L * 2: F2(L + 1) = L * 2 + 1: F3(L + 1) = L * 2 + 2
NEXT L
FOR L = 101 TO faces
	F1(L) = L + 100: F2(L) = L + 100: F3(L) = L + 100
NEXT L

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 2) - 80) ^ 2 + ((M - 100) / Ratio) ^ 2)
		P = 270 - N / 2
		IF P > 255 THEN P = 255
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
FOR L = 200 TO 255
	'Palett(L, 1) = 0: Palett(L, 2) = 0: Palett(L, 3) = L - 200
	OUT &H3C8, L: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, L - 200
NEXT
FOR L = 1 TO 63
	'Palett(L, 1) = L: Palett(L, 2) = L: Palett(L, 3) = 63
	OUT &H3C8, L: OUT &H3C9, L: OUT &H3C9, L: OUT &H3C9, 63
NEXT
GetPalette

QTSetTimer 1, 32767
T1 = 32767
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 31267 THEN
		FadePalette 0, 0, 0, Palett(), (32767 - t) / 1500
	END IF
	IF t < 12000 AND t >= 10500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 10500) / 1500
	END IF
	xrot = t / 2000
	yrot = t / 2000
	zrot = t / 1500
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	t0! = (T1 - t) / 20
	FOR P = 1 TO points
		IF P <= 200 THEN z(P) = z(P) - t0! ELSE z(P) = z(P) - t0! * 2
		IF z(P) < -200 THEN
			z(P) = z(P) + 400
			IF P <= 200 THEN z((P MOD 200) + 1) = z((P MOD 200) + 1) + 400
		END IF
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		IF JZ(P) < -79 THEN JZ(P) = -79
		JZcam = JZ(P) + camdist
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		IF L > 100 THEN
			zavg(L) = JZ(F1(L))
		ELSE
			zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) \ 3
		END IF
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) > -75 THEN
			IF M <= 100 THEN
				TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), -zavg(L) \ 5 + 45
			ELSE
				FillCircle3 Dx(F1(M)), Dy(F1(M)), 7 - zavg(L) \ 10, -JZ(F1(M)) \ 5 + 45
			END IF
		END IF
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	Frames = Frames + 1
	T1 = t
LOOP UNTIL LEN(INKEY$) OR t < 10500

' *** Circles with outlines (C2)
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, Dx, Dy, JZ, F1, F2, F3, zavg, fsort

FOR L = 100 TO 163
	'Palett(L, 1) = 0
	OUT &H3C8, L
	OUT &H3C9, 0
	IF L < 140 THEN OUT &H3C9, 140 - L ELSE OUT &H3C9, 0
	'IF L < 140 THEN Palett(L, 2) = 140 - L ELSE Palett(L, 2) = 0
	IF L > 120 THEN OUT &H3C9, L - 120 ELSE OUT &H3C9, 0
	'IF L > 120 THEN Palett(L, 3) = L - 120 ELSE Palett(L, 3) = 0
NEXT
GetPalette
Palett(7, 1) = 32: Palett(7, 2) = 32: Palett(7, 3) = 32
Palett(9, 1) = 20: Palett(9, 2) = 20: Palett(9, 3) = 53

DEF SEG = BS
FOR M = Top TO Bottom: FOR L = 0 TO 319: POKE L + M * 320, 132 + SIN((M * Ratio) / 30) * 5 + COS((L + M * Ratio) / 20) * 5: NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 20
REDIM fsort(points), zavg(points)
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
REDIM Dx(points), Dy(points), rad(points) AS SINGLE, Radius(points), JZ(points) AS SINGLE
Xoffset = 160: yoffset = 100

FOR L = 1 TO points
	X(L) = INT(RND * 30) - 15
	Y(L) = INT(RND * 30) - 15
	z(L) = INT(RND * 30) - 15
	rad(L) = INT(RND * 20) + 20
NEXT L

QTSetTimer 1, 32000
xrot = 0

DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 17000 AND t >= 15500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 15500) / 1500
	END IF
	yrot = (COS(t / 2000)) * 2
	zrot = (SIN(t / 1000)) * 3
	camdist = 70 + COS(t / 1000) * 80 + COS(t / 500) * 40

	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		'IF JZ(P) < -49 THEN JZ(P) = -49
		JZcam = JZ(P) + camdist
		IF JZcam < 1 THEN JZcam = 1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 125) / JZcam + yoffset

		Radius(P) = (rad(P) * 20) / JZcam
	NEXT P
	
	FOR L = 1 TO points
		fsort(L) = L
		zavg(L) = JZ(L)
	NEXT
	Shellsort zavg()

	FOR L = points TO 1 STEP -1
		M = fsort(L)
		IF Radius(M) < 150 THEN
			FillCircle Dx(M), Dy(M), Radius(M) + 8, 7
		END IF
	NEXT L
	FOR L = points TO 1 STEP -1
		M = fsort(L)
		IF Radius(M) < 150 THEN
			FillCircle Dx(M), Dy(M), Radius(M), 9
		END IF
	NEXT L

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	Frames = Frames + 1
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 15500

' *** spike torus (donut3) ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, Dx, Dy, JZ, fsort, zavg, rad, Radius

points = 144 + 64: faces = 288 + 64
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), fcolor(faces)
DIM zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points)
DIM JZ(points) AS SINGLE

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 0: NEXT M, L
TriFill 230, Bottom, 319, 100, 319, 100 + 10 * Ratio, 22
TriFill 319, 100 + 10 * Ratio, 230, Bottom, 242, Bottom, 22
TriFill 90, Top, 0, 100, 0, 100 - 10 * Ratio, 22
TriFill 0, 100 - 10 * Ratio, 90, Top, 78, Top, 22
TriFill 245, Bottom, 319, 100 + 15 * Ratio, 319, 100 + 25 * Ratio, 18
TriFill 319, 100 + 25 * Ratio, 245, Bottom, 257, Bottom, 18
TriFill 75, Top, 0, 100 - 15 * Ratio, 0, 100 - 25 * Ratio, 18
TriFill 0, 100 - 25 * Ratio, 75, Top, 63, Top, 18

IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

camdist = 300: Xoffset = 160: yoffset = 100
tr = 90: RR = 30
FOR L = 0 TO 63
'Palett(L, 1) = L: Palett(L, 2) = L: Palett(L, 3) = L
'Palett(L + 64, 1) = L / 1.5 + 21: Palett(L + 64, 2) = L / 1.5 + 21: Palett(L + 64, 3) = L
'Palett(L + 128, 1) = L \ 2: Palett(L + 128, 2) = L / 1.5: Palett(L + 128, 3) = L
'Palett(L + 192, 1) = L \ 2: Palett(L + 192, 2) = L / 1.5 + 16: Palett(L + 192, 3) = L
OUT &H3C8, L: OUT &H3C9, L: OUT &H3C9, L: OUT &H3C9, L
OUT &H3C8, L + 64: OUT &H3C9, L / 1.5 + 21: OUT &H3C9, L / 1.5 + 21: OUT &H3C9, L
OUT &H3C8, L + 128: OUT &H3C9, L \ 2: OUT &H3C9, L / 1.5: OUT &H3C9, L
OUT &H3C8, L + 192: OUT &H3C9, L \ 2: OUT &H3C9, L / 1.5 + 16: OUT &H3C9, L
NEXT L
GetPalette

PC = 0
FOR P = 1 TO 144
	rang! = ((P - 1) \ 12) / (12 / (pi * 2))  ' ring angle
	rx! = COS(rang!) * tr
	ry! = SIN(rang!) * tr
	dang! = (P MOD 12) / (12 / (pi * 2))      ' dot angle
	 IF (P AND 1) = 0 AND ((P \ 12) AND 1) = 0 THEN
		  rr2 = RR * 2.2
	 ELSE
		  rr2 = RR
	 END IF
	X(P) = rx! + (rr2 * COS(dang!) * COS(rang!))
	Y(P) = ry! + (rr2 * COS(dang!) * SIN(rang!))
	z(P) = rr2 * SIN(dang!)
	IF (P AND 1) = 0 AND ((P \ 12) AND 1) = 0 THEN
		PC = PC + 1
		X(144 + PC) = X(P): Y(144 + PC) = Y(P): z(144 + PC) = z(P)
	END IF

	IF P < points - 11 THEN
		F1(P * 2) = P
		F2(P * 2) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
		F3(P * 2) = P + 12
		fcolor(P * 2) = 0
		F1(P * 2 - 1) = P + (SGN(P MOD 12) * 12) - 11
		F2(P * 2 - 1) = P + 12
		F3(P * 2 - 1) = P + (SGN(P MOD 12) * 12) + 1 'p+17 or p+1
		fcolor(P * 2 - 1) = 128
	END IF
NEXT P
FOR P = 144 - 11 TO 144
	F1(P * 2) = P
	F2(P * 2) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
	F3(P * 2) = ((P - 1) MOD 12) + 1
	fcolor(P * 2) = 0
	F1(P * 2 - 1) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
	F2(P * 2 - 1) = ((P - 1) MOD 12) + 1
	F3(P * 2 - 1) = ((P - 1) MOD 12) + (SGN(P MOD 12) * 12) - 10 'p-14 or p+2
	fcolor(P * 2 - 1) = 128
NEXT P
FOR L = 289 TO 288 + PC
' set all 3 points of the particle "faces" to the same one
	F1(L) = L - 144: F2(L) = L - 144: F3(L) = L - 144
NEXT L

QTSetTimer 1, 32000
	yrot = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 17000 AND t >= 15500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 15500) / 1500
	END IF
	Xoffset = SIN(t / 1000) * 80 + 160

	xrot = t / 1000
	zrot = t / 1200
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) / 3
	NEXT
	Shellsort zavg()
	FOR L = faces / 1.2 TO 1 STEP -1
		M = fsort(L)
		IF M <= 288 THEN
			TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M) + 18 - zavg(L) / 4
		ELSE
			FillCircle4 Dx(F1(M)), Dy(F1(M)), 6 - zavg(L) \ 20, 0 '-JZ(F1(M)) \ 5 + 32
		END IF
	NEXT L

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 15500

' *** grid landscape (land2a) ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, rad, fcolor, F1, F2, F3, fsort, zavg, Dx, Dy, JZ

points = 30
DIM X2(points, points) AS SINGLE, Y2(points, points) AS SINGLE, Z2(points, points) AS SINGLE
DIM JZ2(points, points) AS SINGLE
DIM Dx2(points, points) AS SINGLE, Dy2(points, points) AS SINGLE
DIM XT AS SINGLE, YT AS SINGLE
camdist = 100: Xoffset = 160: yoffset = 70

GetPalette
FOR L = 1 TO 16
	'OUT &H3C8, L
	'OUT &H3C9, 0
	'OUT &H3C9, 0
	'OUT &H3C9, 20 - L * 2
	Palett(L, 1) = 0: Palett(L, 2) = 0: Palett(L, 3) = 20 - L * 2
NEXT L
FOR L = 17 TO 31
	Palett(L, 1) = (L - 16) * 4: Palett(L, 2) = (L - 16) * 4: Palett(L, 3) = (L - 16) * 4
NEXT L

DEF SEG = BS
FOR M = Top TO Bottom
FOR L = 0 TO 319
	N = INT(((M - Top) / Ratio!) / 15)
	IF N < 1 THEN N = 1
	IF N > 10 THEN N = 10
	POKE L + M * 320, N
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

FOR M = 1 TO points
	FOR L = 1 TO points
	X2(L, M) = (L - 1) * 20 - 295
	Y2(L, M) = (M - 1) * 20 - 295
	Z2(L, M) = COS(L) * 10 + SIN(L / 2) * 6 + SIN(M) * 10 + COS(M / 2) * 10 + RND * 10 - 60
NEXT L, M

QTSetTimer 1, 32000
T1 = 32000
	xrot = 1.57
	zrot = 3.14
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t0 = QTGetTimer(1)
	IF t0 > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t0) / 1500
	END IF
	IF t0 < 15000 AND t0 >= 13500 THEN
		FadePalette 63, 63, 63, Palett(), (t0 - 13500) / 1500
	END IF


	FOR P = 0 TO 1
	t = t0 - P * 30

	yrot = SIN(t / 4000) * 3
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	X0 = points \ 2 - SIN(t / 1000) * 10
	Y0 = points \ 2 - COS(t / 2000) * 10
	IF X0 < 8 THEN X0 = 8
	IF Y0 < 8 THEN Y0 = 8
	IF X0 > points - 7 THEN X0 = points - 7
	IF Y0 > points - 7 THEN Y0 = points - 7
	FOR M = Y0 - 7 TO Y0 + 7 '1 TO points
	FOR L = X0 - 7 TO X0 + 7 '1 TO points
		XT = X2(L, M) + SIN(t / 1000) * 200
		YT = Y2(L, M) + COS(t / 2000) * 200
		
		' x-axis rotate
		JY1 = cosx * YT - sinx * Z2(L, M)
		JZ1 = sinx * YT + cosx * Z2(L, M)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * XT
		JZ2(L, M) = cosy * JZ1 - siny * XT
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		JZcam = JZ2(L, M) + camdist
		IF JZcam < 1 THEN JZcam = 1
		Dx2(L, M) = (-JX * 150) / JZcam + Xoffset
		Dy2(L, M) = (-JY * 150 * Ratio) / JZcam + yoffset
	NEXT L, M
	FOR M = Y0 - 7 TO Y0 + 6 '1 TO points
	FOR L = X0 - 7 TO X0 + 6 '1 TO points
		IF Dx2(L, M) > -10 AND Dx2(L, M) < 330 THEN
		IF JZ2(L, M) > -80 THEN
			IF M < points THEN Line2 Dx2(L, M), Dy2(L, M), Dx2(L, M + 1), Dy2(L, M + 1), 16
			IF L < points THEN Line2 Dx2(L, M), Dy2(L, M), Dx2(L + 1, M), Dy2(L + 1, M), 16
		END IF
		END IF
	NEXT L, M
	NEXT P
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	'T1 = t
LOOP UNTIL LEN(INKEY$) OR t0 <= 13500

' *** icosahedrons (ICO3) ***
DEF SEG = &HA000
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		POKE L + M * 320, 15
NEXT L, M
'PALETTE
ERASE X2, Y2, Z2, Dx2, Dy2, JZ2

points = 12: faces = 20
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points)
camdist = 200: Xoffset = 160: yoffset = 80

DEF SEG = BS
FOR M = Top TO 100
FOR L = 0 TO 319
P = 64 - SQR(((L \ 2) - 80) ^ 2 + ((M - 100) / Ratio) ^ 2) \ 2
IF P > 31 THEN P = 31
POKE L + M * 320, P
NEXT L, M
FOR M = 101 TO Bottom
FOR L = 0 TO 319
POKE L + M * 320, 31
NEXT L, M

IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

X(1) = 0: Y(1) = 1: z(1) = 1.618
X(2) = 0: Y(2) = 1: z(2) = -1.618
X(3) = 0: Y(3) = -1: z(3) = 1.618
X(4) = 0: Y(4) = -1: z(4) = -1.618
X(5) = 1: Y(5) = 1.618: z(5) = 0
X(6) = 1: Y(6) = -1.618: z(6) = 0
X(7) = -1: Y(7) = 1.618: z(7) = 0
X(8) = -1: Y(8) = -1.618: z(8) = 0
X(9) = 1.618: Y(9) = 0: z(9) = 1
X(10) = 1.618: Y(10) = 0: z(10) = -1
X(11) = -1.618: Y(11) = 0: z(11) = 1
X(12) = -1.618: Y(12) = 0: z(12) = -1

FOR L = 1 TO points: X(L) = X(L) * 40: Y(L) = Y(L) * 40: z(L) = z(L) * 40: NEXT

F1(1) = 1: F2(1) = 3: F3(1) = 9
F1(2) = 1: F2(2) = 5: F3(2) = 9
F1(3) = 1: F2(3) = 5: F3(3) = 7
F1(4) = 1: F2(4) = 7: F3(4) = 11
F1(5) = 1: F2(5) = 3: F3(5) = 11
F1(6) = 2: F2(6) = 5: F3(6) = 10
F1(7) = 2: F2(7) = 4: F3(7) = 10
F1(8) = 2: F2(8) = 4: F3(8) = 12
F1(9) = 2: F2(9) = 7: F3(9) = 12
F1(10) = 2: F2(10) = 5: F3(10) = 7
F1(11) = 6: F2(11) = 3: F3(11) = 8
F1(12) = 6: F2(12) = 3: F3(12) = 9
F1(13) = 6: F2(13) = 4: F3(13) = 10
F1(14) = 6: F2(14) = 9: F3(14) = 10
F1(15) = 6: F2(15) = 4: F3(15) = 8
F1(16) = 7: F2(16) = 11: F3(16) = 12
F1(17) = 8: F2(17) = 11: F3(17) = 12
F1(18) = 8: F2(18) = 4: F3(18) = 12
F1(19) = 5: F2(19) = 9: F3(19) = 10
F1(20) = 3: F2(20) = 8: F3(20) = 11

FOR L = 0 TO 31
	'Palett(L, 1) = L * 2: Palett(L, 2) = L * 2: Palett(L, 3) = L * 2
	OUT &H3C8, L: OUT &H3C9, L * 2: OUT &H3C9, L * 2: OUT &H3C9, L * 2
NEXT
FOR L = 32 TO 63
	'Palett(L, 1) = (L - 32) * 2: Palett(L, 2) = 0: Palett(L, 3) = 0
	OUT &H3C8, L: OUT &H3C9, (L - 32) * 2: OUT &H3C9, 0: OUT &H3C9, 0
NEXT L
FOR L = 1 TO 20
	FOR M = 0 TO 7
		'Palett(L * 8 + M + 64, 1) = (M * 8) + (63 - (M * 8)) * (L / 20)
		'Palett(L * 8 + M + 64, 2) = (L / 20) * 64 - 1
		'Palett(L * 8 + M + 64, 3) = (L / 20) * 64 - 1
		OUT &H3C8, L * 8 + M + 64
		OUT &H3C9, (M * 8) + (63 - (M * 8)) * (L / 20)
		OUT &H3C9, (L / 20) * 64 - 1
		OUT &H3C9, (L / 20) * 64 - 1
	NEXT M
NEXT L
GetPalette

QTSetTimer 1, 32000
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 63, 63, 63, Palett(), (32000 - t) / 1500
	END IF
	IF t < 15000 AND t >= 13500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 13500) / 1500
	END IF
	xrot = t / 500
	yrot = 0
	zrot = t / 1000
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) \ 3
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		TriFill2 Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), -zavg(L) / 3.5 + 48 'fcolor(M)
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 13500

' *** scrolling circwaves (C5C) ***

CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, Dx, Dy, JZ, F1, F2, F3, fsort, zavg

DIM Fill(0 TO 63) AS STRING * 30
FS = VARSEG(Fill(0)): FO = VARPTR(Fill(0))
DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 1: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
points = 100
REDIM fsort(points), zavg(points)
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
REDIM Dx(points), Dy(points), Radius(points), JZ(points) AS SINGLE

camdist = 40: Xoffset = 160: yoffset = 100
FOR L = 1 TO points
X(L) = ((L - 1) MOD 10) * 10 + 45
Y(L) = ((L - 1) \ 10) * 10 - 45
z(L) = 0
NEXT L

FOR L = 1 TO 63
	Palett(L, 1) = L / 2 + 32
	Palett(L, 2) = L / 1.2 + 11
	Palett(L, 3) = L / 1.2 + 11
	'OUT &H3C8, L: OUT &H3C9, L / 2 + 32: OUT &H3C9, L / 1.2 + 11: OUT &H3C9, L / 1.2 + 11
	Fill(L) = STRING$(30, L)
NEXT
'GetPalette

QTSetTimer 1, 32000
T1 = 32000
cosx = 1: sinx = 0
cosy = 1: siny = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 17000 AND t >= 15500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 15500) / 1500
	END IF
	
	zrot = (SIN(t / 2000)) * 2
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		X(P) = X(P) - (T1 - t) / 30
		IF X(P) < -45 THEN X(P) = X(P) + 100
		z(P) = 0 + (COS(X(P) / 10 + t / 800) + SIN(Y(P) / 10 + t / 800)) * 4

		' z-axis rotate
		JX = cosz * X(P) - sinz * Y(P)
		JY = sinz * X(P) + cosz * Y(P)
		JZcam = z(P) + camdist

		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset
		
		Radius(P) = 625 / JZcam
		fsort(P) = P
		zavg(P) = z(P)

	NEXT P
	Shellsort zavg()

	FOR L = points TO 1 STEP -1
		M = fsort(L)
		FillCircle5 Dx(M), Dy(M), Radius(M), -z(M) * 2.6 + 24
	NEXT L
	FillCircle 285, 100 + 55 * Ratio, 30, 60
	FillCircle 285, 100 + 55 * Ratio, 28, 0
	FillCircle 295, 100 + 45 * Ratio, 12, 60
	FillCircle 294, 100 + 41 * Ratio, 5, 0
	FillCircle 297, 100 + 48 * Ratio, 5, 0
	FillCircle 294, 100 + 41 * Ratio, 2, 60
	FillCircle 297, 100 + 48 * Ratio, 2, 60


	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 15500

' *** growing shadebobs (BOBS) ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, Dx, Dy, Fill, JZ, Radius, zavg, fsort

points = 300
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM Dx(points), Dy(points), JZ(points) AS SINGLE
DIM Radius(points)

camdist = 130: Xoffset = 160: yoffset = 100

X(1) = 0: Y(1) = 0: z(1) = 0: Radius(1) = 9
X(2) = 0: Y(2) = 0: z(2) = 0: Radius(2) = 9
XYang! = RND * pi: zang! = RND * pi
XYang2! = pi * 2 - XYang!: Zang2! = pi * 2 - zang!
FOR L = 3 TO points STEP 2
	X(L) = X(L - 2) + COS(XYang!) * 5
	Y(L) = Y(L - 2) + SIN(XYang!) * 5
	z(L) = z(L - 2) + SIN(zang!) * 5
	Radius(L) = INT(RND * 5) + 6
	X(L + 1) = X(L - 1) + COS(XYang2!) * 5
	Y(L + 1) = Y(L - 1) + SIN(XYang2!) * 5
	z(L + 1) = z(L - 1) + SIN(Zang2!) * 5
	Radius(L + 1) = INT(RND * 5) + 6
	XYang! = XYang! + (RND - .5) * 4
	zang! = zang! + (RND - .5) * 4
	XYang2! = XYang2! + (RND - .5) * 4
	Zang2! = Zang2! + (RND - .5) * 4
NEXT L

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 199: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
OUT &H3C8, 199: OUT &H3C9, 12: OUT &H3C9, 0: OUT &H3C9, 9
GetPalette
LoadBMP "font2.bmp", Font(), FontD
FOR L = 0 TO FontD.Colors - 1
	 FOR M = 1 TO 3: Palett(L + 200, M) = Palett(L, M): NEXT M
	 'OUT &H3C8, L + 200
	 'FOR M = 1 TO 3: OUT &H3C9, Palett(L, M): NEXT M
NEXT L
FS = VARSEG(Font(0, 0)): FO = VARPTR(Font(0, 0))
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
'Palett(199, 1) = 12: Palett(199, 2) = 0: Palett(199, 3) = 9



QTSetTimer 1, 32767
QTSetTimer 2, 50
Dots = 1
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 31267 THEN
		FadePalette 0, 0, 0, Palett(), (32767 - t) / 1500
	END IF
	IF t < 11500 AND t >= 10000 THEN
		FadePalette 0, 0, 0, Palett(), (t - 10000) / 1500
	END IF
	T2 = QTGetTimer(2)
	xrot = t / 1000
	yrot = t / 2000
	zrot = t / 1500
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)

	IF T2 = 0 AND Dots < points THEN
		Dots = Dots + 1
		QTSetTimer 2, 50
	END IF
	
	FOR P = 1 TO Dots
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		JZcam = JZ(P) + camdist
		IF JZcam < 1 THEN JZcam = 1
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio!) / JZcam + yoffset
	NEXT P
	FOR L = 1 TO Dots
		IF JZ(L) > -100 THEN
			FillCircle6 Dx(L), Dy(L), Radius(L) - JZ(L) \ 16, -JZ(L) \ 15 + 64
		END IF
	NEXT L
	FPrint STR$(Dots) + " 3D shadebobs", 150, Bottom - 20
	DEF SEG = VS
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 10000

' *** chessboard Z-rot (CHESS3A) ***
CLS ': PALETTE
ERASE X, Y, z, Dx, Dy, JZ, Radius

points = 512: faces = 256
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE
DIM JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces)
DIM Dx(points), Dy(points)
camdist = 150: Xoffset = 160: yoffset = 100

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 1: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

FOR P = 1 TO points
	xoff = ((P - 1) MOD 64) \ 8
	yoff = ((P - 1) \ 64)
	X(P) = ((P - 1) MOD 2) + (((P - 1) \ 4) MOD 2) + xoff * 2
	z(P) = (((P - 1) MOD 8) + 2) \ 4 + yoff * 2
	Y(P) = -60

	X(P) = X(P) * 30 - 225
	z(P) = z(P) * 30 + 300
NEXT P

FOR P = 1 TO faces STEP 2
	F1(P) = P * 2 - 1
	F2(P) = P * 2
	F3(P) = P * 2 + 2
	F1(P + 1) = P * 2 - 1
	F2(P + 1) = P * 2 + 1
	F3(P + 1) = P * 2 + 2
NEXT P

'OUT &H3C8, 1: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 32
FOR L = 32 TO 63
	'Palett(L, 1) = (L - 32) * 2
	'Palett(L, 2) = (L - 32) * 2
	'Palett(L, 3) = L
	OUT &H3C8, L
	OUT &H3C9, (L - 32) * 2
	OUT &H3C9, (L - 32) * 2
	OUT &H3C9, L
NEXT L
GetPalette
Palett(1, 1) = 0: Palett(1, 2) = 0: Palett(1, 3) = 32
QTSetTimer 1, 32000: T1 = 32000
xrot = 0
yrot = 0
cosx = 1: sinx = 0
cosy = 1: sinx = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 31000 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1000
	END IF
	IF t < 16000 AND t >= 14500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 14500) / 1500
	END IF
	zrot = SIN(t / 2200) * 3
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		z(P) = z(P) - (T1 - t) / 5
		IF z(P) < -140 THEN
			FOR L = 0 TO 3
				z(P + L) = z(P + L) + 360
			NEXT L
		END IF
		' x-axis rotate
		' y-axis rotate
		' z-axis rotate
		JX = cosz * X(P) - sinz * Y(P)
		JY = sinz * X(P) + cosz * Y(P)
		IF z(P) + camdist < 1 THEN z(P) = 1 - camdist
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (z(P) + camdist) + Xoffset
		Dy(P) = (-JY * 150 * Ratio!) / (z(P) + camdist) + yoffset
	NEXT P
	FOR M = 1 TO faces
		IF z(F1(M)) > -130 AND z(F1(M)) < 250 THEN
			TriFill3 Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), 53 - z(F1(M)) \ 12
		END IF
	NEXT M
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL LEN(INKEY$) OR t <= 14500

' *** wavy torus (donut4) ***

CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, z, Dx, Dy, JZ, F1, F2, F3

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 200: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 144: faces = 288
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), fcolor(faces)
DIM zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points)
DIM JZ(points) AS SINGLE

camdist = 250: Xoffset = 160: yoffset = 100
tr = 90: RR = 40    ' torus radius, ring radius
FOR L = 0 TO 63
'Palett(L, 1) = L: Palett(L, 2) = L: Palett(L, 3) = L
'Palett(L + 64, 1) = L: Palett(L + 64, 2) = L \ 2: Palett(L + 64, 3) = 0
OUT &H3C8, L: OUT &H3C9, L:  OUT &H3C9, L: OUT &H3C9, L
OUT &H3C8, L + 64: OUT &H3C9, L: OUT &H3C9, L \ 2: OUT &H3C9, 0
NEXT L
GetPalette

FOR P = 1 TO points
	rang! = ((P - 1) \ 12) / (12 / (pi * 2))  ' ring angle
	rx! = COS(rang!) * tr
	ry! = SIN(rang!) * tr
	dang! = (P MOD 12) / (12 / (pi * 2))      ' dot angle
	X(P) = rx! + (RR * COS(dang!) * COS(rang!))
	Y(P) = ry! + (RR * COS(dang!) * SIN(rang!))
	z(P) = RR * SIN(dang!)

	IF P <= points - 12 THEN
		F1(P * 2) = P
		F2(P * 2) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
		F3(P * 2) = P + 12
		fcolor(P * 2) = 0
		F1(P * 2 - 1) = P + (SGN(P MOD 12) * 12) - 11
		F2(P * 2 - 1) = P + 12
		F3(P * 2 - 1) = P + (SGN(P MOD 12) * 12) + 1 'p+17 or p+1
		fcolor(P * 2 - 1) = 64
	END IF
NEXT P
FOR P = points - 11 TO points
	F1(P * 2) = P
	F2(P * 2) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
	F3(P * 2) = ((P - 1) MOD 12) + 1
	fcolor(P * 2) = 0
	F1(P * 2 - 1) = P + (SGN(P MOD 12) * 12) - 11 'p+1 or p-15
	F2(P * 2 - 1) = ((P - 1) MOD 12) + 1
	F3(P * 2 - 1) = ((P - 1) MOD 12) + (SGN(P MOD 12) * 12) - 10 'p-14 or p+2
	fcolor(P * 2 - 1) = 64
NEXT P

QTSetTimer 1, 32000
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 16000 AND t >= 14500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 14500) / 1500
		L = MusicVolume((t - 14500) \ 29)
	END IF
	xrot = t / 1000
	yrot = t / 1500
	zrot = t / 1500
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * z(P)
		JZ1 = sinx * Y(P) + cosx * z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * 150 * Ratio!) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) / 3
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) < 50 THEN
			TriGFill Dx(F1(M)), Dy(F1(M)), fcolor(M) + 20 - JZ(F1(M)) / 3, Dx(F2(M)), Dy(F2(M)), fcolor(M) + 20 - JZ(F2(M)) / 3, Dx(F3(M)), Dy(F3(M)), fcolor(M) + 20 - JZ(F3(M)) / 3
		END IF
	NEXT L
	FOR L = Top TO Bottom
		M = L + COS(L / 8 + t / 300) * 4 * Ratio!
		IF M < Top THEN M = Top
		IF M > Bottom THEN M = Bottom
		N = SIN(L / 18 + t / 600) * 10
		CALL BlockMove(VS, VO + M * 320 + N, &HA000, L * 320, 320, 0)
	NEXT L

LOOP UNTIL LEN(INKEY$) OR t <= 14500


' *** END ***
TheEnd:
SCREEN 0: WIDTH 80
QTDone

StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
'StopBanner                              'Do not show BWSB banner
FreeMSE                                 'Remove MSE from memory

RUN "PART2.EXE"
END

' inner circles
DATA 0,0,15,5
DATA 9,0,15,5
DATA 18,0,15,5
' poly points
'd
DATA 2,3,0,0
DATA 4,1,0,0
DATA 3,7,0,0
DATA 5,8,0,0
'c
DATA 9,0,0,0
DATA 14,4,0,0
DATA 14,-4,0,0
'5
DATA 18,0,0,0
DATA 14,4,0,0
DATA 14,-4,0,0
DATA 15,2.5,0,0
DATA 16.5,1.75,0,0
DATA 16.5,8,0,0
DATA 18,6,0,0
DATA 23,8,0,0
DATA 22,6,0,0
'T
DATA -3.05,-1,0,0
DATA -2.85,-1,0,0
DATA -3.05,.7,0,0
DATA -2.85,.7,0,0
DATA -3.5,.7,0,0
DATA -2.3,.7,0,0
DATA -3.5,1,0,0
DATA -2.3,1,0,0
'H
DATA -2.1,-1,0,0
DATA -1.8,-1,0,0
DATA -2.1,1,0,0
DATA -1.8,1,0,0
DATA -1.8,.15,0,0
DATA -1.2,.15,0,0
DATA -1.8,-.15,0,0
DATA -1.2,-.15,0,0
DATA -1.2,-1,0,0
DATA -.9,-1,0,0
DATA -1.2,1,0,0
DATA -.9,1,0,0
'A
DATA -.7,-1,0,0
DATA -.4,-1,0,0
DATA -.25,1,0,0
DATA 0.05,1,0,0
DATA .2,-1,0,0
DATA .5,-1,0,0
DATA -.5,-.1,0,0
DATA .3,-.1,0,0
DATA -.5,-.4,0,0
DATA .3,-.4,0,0
'T
DATA .95,-1,0,0
DATA 1.25,-1,0,0
DATA .95,.7,0,0
DATA 1.25,.7,0,0
DATA .5,.7,0,0
DATA 1.7,.7,0,0
DATA .5,1,0,0
DATA 1.7,1,0,0
'S
DATA 2.95,.4,0,1.3
DATA 3.15,-.5,0,1.3
DATA 2.95,.4,1,.4
DATA 3.15,-.5,1,.4
DATA 2.7,.4,0,0
DATA 3.5,.9,0,0
DATA 3.5,-.1,0,0
DATA 3.4,-.5,0,0
DATA 2.6,0,0,0
DATA 2.6,-1,0,0
DATA 2.4,-.8,0,0
DATA 3,-1,0,0
DATA 2.5,-.5,0,0
DATA 3,-.7,0,0
DATA 3.7,.8,0,0
DATA 3,1,0,0
DATA 3.6,.5,0,0
DATA 3,.7,0,0
''
DATA 2.0,.7,0,0
DATA 2.1,1.1,0,0
DATA 2.4,1.1,0,0
'T
DATA 7.45,-1,0,0
DATA 7.75,-1,0,0
DATA 7.45,.7,0,0
DATA 7.75,.7,0,0
DATA 7,.7,0,0
DATA 8.2,.7,0,0
DATA 7,1,0,0
DATA 8.2,1,0,0
'H
DATA 8.4,-1,0,0
DATA 8.7,-1,0,0
DATA 8.4,1,0,0
DATA 8.7,1,0,0
DATA 8.7,.15,0,0
DATA 9.3,.15,0,0
DATA 8.7,-.15,0,0
DATA 9.3,-.15,0,0
DATA 9.3,-1,0,0
DATA 9.6,-1,0,0
DATA 9.3,1,0,0
DATA 9.6,1,0,0
'E
DATA 9.8,1,0,0
DATA 11,1,0,0
DATA 11,.7,0,0
DATA 10.1,.7,0,0
DATA 10.1,.15,0,0
DATA 11,.15,0,0
DATA 11,-.15,0,0
DATA 10.1,-.15,0,0
DATA 10.1,-.7,0,0
DATA 11,-.7,0,0
DATA 11,-1,0,0
DATA 9.8,-1,0,0
'S
DATA 14.95,.4,0,1.3
DATA 15.15,-.5,0,1.3
DATA 14.95,.4,1,.4
DATA 15.15,-.5,1,.4
DATA 14.7,.4,0,0
DATA 15.5,.9,0,0
DATA 15.5,-.1,0,0
DATA 15.4,-.5,0,0
DATA 14.6,0,0,0
DATA 14.6,-1,0,0
DATA 14.4,-.8,0,0
DATA 15,-1,0,0
DATA 14.5,-.5,0,0
DATA 15,-.7,0,0
DATA 15.7,.8,0,0
DATA 15,1,0,0
DATA 15.6,.5,0,0
DATA 15,.7,0,0
'P
DATA 16.5,.4,0,1.3
DATA 16.5,.4,1,.5
DATA 15.8,1,0,0
DATA 16.1,.7,0,0
DATA 15.8,-1,0,0
DATA 16.1,-1,0,0
DATA 16.5,1,0,0
DATA 16.5,.7,0,0
DATA 16.1,.7,0,0
DATA 16.1,.1,0,0
DATA 16.5,.1,0,0
DATA 16.1,-.2,0,0
DATA 16.5,-.2,0,0
'I
DATA 17.2,1,0,0
DATA 17.5,1,0,0
DATA 17.2,-1,0,0
DATA 17.5,-1,0,0
'R
DATA 18.4,.4,0,1.3
DATA 18.4,.4,1,.5
DATA 17.7,1,0,0
DATA 18,.7,0,0
DATA 17.7,-1,0,0
DATA 18,-1,0,0
DATA 18.4,1,0,0
DATA 18.4,.7,0,0
DATA 18,.7,0,0
DATA 18,.1,0,0
DATA 18.4,.1,0,0
DATA 18,-.2,0,0
DATA 18.4,-.2,0,0
DATA 18.1,-.2,0,0
DATA 19,-1,0,0
DATA 18.7,-1,0,0
'I
DATA 19.1,1,0,0
DATA 19.4,1,0,0
DATA 19.1,-1,0,0
DATA 19.4,-1,0,0
'T
DATA 20.05,-1,0,0
DATA 20.35,-1,0,0
DATA 20.05,.7,0,0
DATA 20.35,.7,0,0
DATA 19.6,.7,0,0
DATA 20.8,.7,0,0
DATA 19.6,1,0,0
DATA 20.8,1,0,0
'!
DATA 21,1,0,0
DATA 21.3,1,0,0
DATA 21,-.3,0,0
DATA 21.3,-.3,0,0
DATA 21.15,-.85,0,.5

'FACES
'd
DATA 16,17,18,0
DATA 17,18,19,0
'c
DATA 20,21,22,15
'5
DATA 23,24,25,15
DATA 26,27,28,0
DATA 27,28,29,0
DATA 28,29,30,0
DATA 29,30,31,0
'T
DATA 32,33,34,0
DATA 33,34,35,0
DATA 36,37,38,0
DATA 37,38,39,0
'H
DATA 40,41,42,0
DATA 41,42,43,0
DATA 44,45,46,0
DATA 45,46,47,0
DATA 48,49,50,0
DATA 49,50,51,0
'A
DATA 52,53,54,0
DATA 53,54,55,0
DATA 54,55,56,0
DATA 55,56,57,0
DATA 58,59,60,0
DATA 59,60,61,0
'T
DATA 62,63,64,0
DATA 63,64,65,0
DATA 66,67,68,0
DATA 67,68,69,0
'S
DATA 74,75,76,1
DATA 77,78,79,1
DATA 80,81,82,0
DATA 81,82,83,0
DATA 84,85,86,0
DATA 85,86,87,0
''
DATA 88,89,90,0
'T
DATA 91,92,93,0
DATA 92,93,94,0
DATA 95,96,97,0
DATA 96,97,98,0
'H
DATA 99,100,101,0
DATA 100,101,102,0
DATA 103,104,105,0
DATA 104,105,106,0
DATA 107,108,109,0
DATA 108,109,110,0
'E
DATA 111,112,113,0
DATA 113,114,111,0
DATA 115,116,117,0
DATA 117,118,115,0
DATA 119,120,121,0
DATA 121,122,119,0
DATA 119,122,111,0
DATA 119,111,114,0

'S
DATA 127,128,129,1
DATA 130,131,132,1
DATA 133,134,135,0
DATA 134,135,136,0
DATA 137,138,139,0
DATA 138,139,140,0
'P
DATA 144,148,150,1
DATA 148,150,151,1
DATA 143,144,145,0
DATA 144,145,146,0
DATA 143,147,148,0
DATA 148,149,143,0
DATA 150,151,152,0
DATA 151,152,153,0
'I
DATA 154,155,156,0
DATA 155,156,157,0
'R
DATA 161,165,167,1
DATA 165,167,168,1
DATA 160,161,162,0
DATA 161,162,163,0
DATA 160,164,165,0
DATA 165,166,160,0
DATA 167,168,169,0
DATA 168,169,170,0
DATA 170,171,172,0
DATA 171,172,173,0
'I
DATA 174,175,176,0
DATA 175,176,177,0
'T
DATA 178,179,180,0
DATA 179,180,181,0
DATA 182,183,184,0
DATA 183,184,185,0
'!
DATA 186,187,188,0
DATA 187,188,189,0

DATA I've got some
DATA really big balls..
DATA would you like
DATA to see them?

DEFINT J

REM $STATIC
FUNCTION ASin! (BYVAL A!)
	IF ABS(A!) <> 1 THEN
		ASin! = ATN(A! / SQR(1 - A! * A!))
	ELSE
		ASin! = 1.5708 * SGN(A!)
	END IF
END FUNCTION

SUB ClearCircle (BYVAL CX, BYVAL CY, BYVAL Radius)
SHARED Ratio AS SINGLE, Top, Bottom, BS, BO, VS, VO
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					IF M >= 0 AND M < 320 THEN
						CALL BlockMove(BS, BO + M + Y1, VS, VO + M + Y1, 1, 0)
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y - 1 <= Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					IF M >= 0 AND M < 320 THEN
						CALL BlockMove(BS, BO + M + Y1, VS, VO + M + Y1, 1, 0)
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FadePalette (BYVAL Red, BYVAL Green, BYVAL Blue, Pal(), BYVAL Amount AS SINGLE)
	' Amount = 0: full R/G/B color, 1: full Pal colors
	FOR L = 1 TO 255
		OUT &H3C8, L
		OUT &H3C9, Red + (Pal(L, 1) - Red) * Amount
		OUT &H3C9, Green + (Pal(L, 2) - Green) * Amount
		OUT &H3C9, Blue + (Pal(L, 3) - Blue) * Amount
	NEXT
END SUB

SUB FillCircle (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	RR = Radius * Ratio
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * RR
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				IF CX - X < 0 THEN XL = 0 ELSE XL = CX - X
				IF CX + X > 319 THEN XR = 319 ELSE XR = CX + X
				FOR M = XL TO XR
					POKE M + Y1, Colr
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y - 1 <= Bottom THEN
				Y1 = (CY - Y - 1) * 320
				IF CX - X < 0 THEN XL = 0 ELSE XL = CX - X
				IF CX + X > 319 THEN XR = 319 ELSE XR = CX + X
				FOR M = XL TO XR
					POKE M + Y1, Colr
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

REM $DYNAMIC
SUB FillCircle2 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P > 100 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y - 1 <= Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P > 100 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FillCircle3 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P < 40 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y < Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P < 40 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FillCircle4 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					IF M >= 0 AND M < 320 THEN
						P = PEEK(M + Y1) + 46 + Radius * 5
						IF P > 127 AND P < 192 THEN P = 127
						IF P > 255 THEN P = 255
						POKE M + Y1, P
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y < Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					IF M >= 0 AND M < 320 THEN
						P = PEEK(M + Y1) + 46 + Radius * 5
						IF P > 127 AND P < 192 THEN P = 127
						IF P > 255 THEN P = 255
						POKE M + Y1, P
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FillCircle5 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom, FS, FO, VS, VO
	FC30 = FO + Colr * 30
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	RR = Radius * Ratio
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * RR
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				IF CX - X < 0 THEN XL = 0 ELSE XL = CX - X
				IF CX + X > 319 THEN XR = 319 ELSE XR = CX + X
				IF XL <= 319 AND XR >= 0 THEN
				CALL BlockMove(FS, FC30, VS, VO + XL + Y1, (XR - XL) + 1, 0)
				END IF
			END IF
			IF CY - Y > Top AND CY - Y - 1 <= Bottom THEN
				Y1 = (CY - Y - 1) * 320
				IF CX - X < 0 THEN XL = 0 ELSE XL = CX - X
				IF CX + X > 319 THEN XR = 319 ELSE XR = CX + X
				IF XL <= 319 AND XR >= 0 THEN
				CALL BlockMove(FS, FC30, VS, VO + XL + Y1, (XR - XL) + 1, 0)
				END IF
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FillCircle6 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P = 0 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y < Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P = 0 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FPrint (Text$, X, Y)
SHARED VS, VO, FS, FO, FontD AS PicData
FOR L = 0 TO LEN(Text$) - 1
	C = ASC(MID$(Text$, L + 1, 1)) - 32
	FX = C * 9
	'FY = (C \ 40) * 8
	FOR VY = 1 TO 12
		FYW = VY * FontD.Width
		VY320 = (Y + VY) * 320
		'CALL BlockMove(FS, FO + FX + FYW, VS, VO + X + L * 9 + VY320, 9, 0)
		FOR VX = 0 TO 8
			DEF SEG = FS
			C = PEEK(FO + FX + VX + FYW)
			IF C <> 2 THEN
				DEF SEG = VS
				POKE VO + X + VX + L * 9 + VY320, C + 200
			END IF
		NEXT VX
	NEXT VY

NEXT L
END SUB

REM $STATIC
FUNCTION GetLibOffset& (File$)
	DIM LibHeader AS LibHeaderType
	GetLibOffset& = 0
	H = FREEFILE
	OPEN Lib$ FOR BINARY AS H
	SEEK H, 7: GET H, , F
	FOR L = 1 TO F
		GET H, , LibHeader
		IF UCASE$(File$) = RTRIM$(UCASE$(LibHeader.FileName)) THEN
			GetLibOffset& = LibHeader.Offset
			EXIT FOR
		END IF
	NEXT L
	CLOSE H
END FUNCTION

SUB GetPalette
	FOR L = 0 TO 255
		OUT &H3C8, L
		FOR M = 1 TO 3
			Palett(L, M) = INP(&H3C9)
	NEXT M, L
END SUB

REM $DYNAMIC
SUB GetSoundCardInfo
SHARED Dev, Port, IRQ, DMA
	IF INSTR(COMMAND$, "SETUP") THEN Setup = 1
	IF LEN(ENVIRON$("ULTRASND")) AND Setup = 0 THEN
'     PRINT "Gravis Ultrasound detected."
		Dev = 1: Port = &HFFFF: IRQ = &HFF: DMA = &HFF
	ELSEIF LEN(ENVIRON$("BLASTER")) AND Setup = 0 THEN
		t$ = MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "T") + 1, 1)
		SELECT CASE t$
		CASE "1"
'        PRINT "Sound Blaster 1.x detected."
			Dev = 2
		CASE "2"
'        PRINT "Sound Blaster 2.x detected."
			Dev = 3
		CASE "4"
'        PRINT "Sound Blaster Pro detected."
			Dev = 4
		CASE "6"
'        PRINT "Sound Blaster 16 detected."
			Dev = 5
		END SELECT
		Port = &HFFFF: IRQ = &HFF: DMA = &HFF
	ELSE
		PRINT "Select soundcard:"
		PRINT "1) Gravis Ultrasound"
		PRINT "2) Sound Blaster 1.x"
		PRINT "3) Sound Blaster 2.x"
		PRINT "4) Sound Blaster Pro"
		PRINT "5) Sound Blaster 16"
		PRINT "6) Pro Audio Spectrum"
		PRINT "0) Abort"
		DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "6"
		IF In$ = "0" THEN END ELSE Dev = ASC(In$) - 48
		PRINT "Port address (2x0h, 0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "9"
		IF In$ = "0" THEN Port = &HFFFF ELSE Port = (16 * (ASC(In$) - 48)) + 512
		PRINT "IRQ (in hex, 0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9") OR (In$ >= "a" AND In$ <= "f")
		IF In$ = "0" THEN
			IRQ = &HFF
		ELSEIF In$ <= "9" THEN IRQ = ASC(In$) - 48
		ELSE IRQ = ASC(In$) - 87
		END IF
		PRINT "DMA (0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9")
		IF In$ = "0" THEN DMA = &HFF ELSE DMA = ASC(In$) - 48
	END IF
END SUB

REM $STATIC
SUB Line2 (BYVAL A, BYVAL B, BYVAL C, BYVAL D, BYVAL Col)
SHARED Top, Bottom
	  U = C - A: V = D - B
	  d1x = SGN(U): d1y = SGN(V): d2x = SGN(U): d2y = 0
	  M = ABS(U): N = ABS(V)
	  IF M <= N THEN
			 d2x = 0: d2y = SGN(V)
			 M = ABS(V): N = ABS(U)
	  END IF
	  S = M \ 2
	  FOR I = 0 TO M
			 IF A >= 0 AND A < 320 AND B >= Top AND B <= Bottom THEN POKE A + B * 320, Col + PEEK(A + B * 320) \ 2
			 S = S + N
			 IF S > M THEN
					S = S - M: A = A + d1x: B = B + d1y
			 ELSE
					A = A + d2x: B = B + d2y
			 END IF
	  NEXT I
END SUB

SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS PicData)
	OPEN Lib$ FOR BINARY AS 1
	Offs& = GetLibOffset(BMPFile$) - 1&
	TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
	GET 1, Offs& + 11, Offset
	GET 1, Offs& + 19, Wid
	GET 1, Offs& + 23, Hei&
	GET 1, Offs& + 47, PalCount
	IF PalCount = 0 THEN PalCount = 256
	REDIM Array(Wid - 1, ABS(Hei&) - 1) AS STRING * 1
	PS = VARSEG(Array(0, 0)): PO = VARPTR(Array(0, 0))
	DEF SEG = PS

	SEEK 1, Offs& + 55
	FOR L = 0 TO (PalCount - 1)
		GET 1, , TmpLong$
		Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	NEXT L
	SEEK 1, Offs& + Offset + 1

	FOR Y = 0 TO ABS(Hei&) - 1
		YRow = Y * Wid: YRow2 = (ABS(Hei&) - Y - 1) * Wid
		FOR X = 0 TO Wid - 1
			GET 1, , TmpByte$
			A = ASC(TmpByte$)
			IF Hei& < 0 THEN
				POKE PO + X + YRow, A
			ELSE
				POKE PO + X + YRow2, A
			END IF
		NEXT X
		IF Wid MOD 4 = 3 THEN GET 1, , TmpByte$
		IF Wid MOD 4 = 2 THEN GET 1, , TmpInt$
		IF Wid MOD 4 = 1 THEN GET 1, , TmpInt$: GET 1, , TmpByte$
	NEXT Y

	CLOSE 1
	PData.Height = Hei&: PData.Width = Wid: PData.Colors = PalCount

END SUB

REM $DYNAMIC
SUB ShadeCircle (CX, CY, Radius, Colr)
SHARED Ratio AS SINGLE, Top, Bottom, BallO, BallS, VS, VO, BallX()
	OldY = 1
	IF CX + Radius < 0 OR CX - Radius > 319 THEN EXIT SUB
	IF CY + Radius < Top OR CY - Radius > Bottom THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		BallRow = INT((50 - SIN(L!) * 50) * .99)
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				IF CX > 0 THEN
					Xoffset = 0: Xlength = X
					IF CX - X < 0 THEN Xoffset = -(CX - X): Xlength = X - Xoffset
					IF CX > 319 THEN Xlength = X - (CX - 319)
					IF Xlength > 0 THEN CALL BlockMove(BallS, BallO + BallX(BallRow) + Xoffset + BallRow * 100, VS, VO + (CX - X) + Xoffset + Y1, Xlength, 0)
				END IF
				IF CX < 319 THEN
					Xoffset = 0: Xlength = X
					IF CX < 0 THEN Xoffset = -(CX): Xlength = X - Xoffset
					IF CX + X > 319 THEN Xlength = 319 - CX
					IF Xlength > 0 THEN CALL BlockMove(BallS, (BallO + (100 - BallX(BallRow)) - X) + Xoffset + BallRow * 100, VS, VO + CX + Xoffset + Y1, Xlength, 0)
				END IF
			END IF
			IF CY - Y > Top AND CY - Y - 1 <= Bottom THEN
				Y1 = (CY - Y - 1) * 320
				IF CX > 0 THEN
					Xoffset = 0: Xlength = X
					IF CX - X < 0 THEN Xoffset = -(CX - X): Xlength = X - Xoffset
					IF CX > 319 THEN Xlength = X - (CX - 319)
					IF Xlength > 0 THEN CALL BlockMove(BallS, BallO + BallX(BallRow) + Xoffset + BallRow * 100, VS, VO + (CX - X) + Xoffset + Y1, Xlength, 0)
				END IF
				IF CX < 319 THEN
					Xoffset = 0: Xlength = X
					IF CX < 0 THEN Xoffset = -(CX): Xlength = X - Xoffset
					IF CX + X > 319 THEN Xlength = 319 - CX
					IF Xlength > 0 THEN CALL BlockMove(BallS, (BallO + (100 - BallX(BallRow)) - X) + Xoffset + BallRow * 100, VS, VO + CX + Xoffset + Y1, Xlength, 0)
				END IF
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

REM $STATIC
SUB Shellsort (Array())
SHARED fsort()
Span = UBOUND(Array) \ 2
DO WHILE Span > 0
	 FOR I = Span TO UBOUND(Array) - 1
		  FOR J = (I - Span + 1) TO 1 STEP -Span
				IF Array(J) <= Array(J + Span) THEN EXIT FOR
				SWAP Array(J), Array(J + Span)
				SWAP fsort(J), fsort(J + Span)
		  NEXT J
	 NEXT I
	 Span = Span \ 2
LOOP
END SUB

SUB TriClear (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3)
SHARED Top, Bottom, VS, VO, BS, BO
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X1 + ((Y - Y1) / Y21) * X21
			BottomX = X1 + ((Y - Y1) / Y31) * X31
			FOR X = MidX TO BottomX STEP S
				IF X >= 0 AND X < 319 THEN
						CALL BlockMove(BS, BO + X + YRow, VS, VO + X + YRow, 1, 0)
				 END IF
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			FOR X = MidX TO TopX STEP S
				IF X >= 0 AND X < 319 THEN
						CALL BlockMove(BS, BO + X + YRow, VS, VO + X + YRow, 1, 0)
				END IF
			NEXT X
		END IF
	NEXT Y
END IF

END SUB

REM $DYNAMIC
SUB TriFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
SHARED Top, Bottom
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X1 + ((Y - Y1) / Y21) * X21
			BottomX = X1 + ((Y - Y1) / Y31) * X31
			IF S > 0 THEN
				IF BottomX >= 320 THEN BottomX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF BottomX < 0 THEN BottomX = 0
			END IF
			FOR X = MidX TO BottomX STEP S
				POKE X + YRow, Col
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			IF S > 0 THEN
				IF TopX >= 320 THEN TopX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF TopX < 0 THEN TopX = 0
			END IF
			FOR X = MidX TO TopX STEP S
				POKE X + YRow, Col
			NEXT X
		END IF
	NEXT Y
END IF
END SUB

SUB TriFill2 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
SHARED Ratio AS SINGLE
' sort point pairs top-to-bottom
GD! = Ratio * 2.4
YG = 50 + 45 * Ratio
SELECT CASE Ratio
CASE .83: R = 261: R2 = 191: GB = 60
CASE 1: R = 282: R2 = 202: GB = 55
CASE 1.11: R = 292: R2 = 207: GB = 52
END SELECT

IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y > 0 AND Y < 199 THEN
			YRow = Y * 320
			YRow2 = (Y \ 2 + 60) * 320
			YRowR = (R - Y) * 320
			YRow2R = (R2 - Y \ 2) * 320
			MidX = X1 + ((Y - Y1) / Y21) * X21
			BottomX = X1 + ((Y - Y1) / Y31) * X31
			ColG = (GB - INT(Y / GD!)) * 8 + 96
			FOR X = MidX TO BottomX STEP S
				P = PEEK(X + YRow)
				IF P = 15 THEN Col2 = Col ELSE Col2 = (Col + P) \ 2
				POKE X \ 2 - 20 + YRow2, Col2
				POKE X \ 2 + 180 + YRow2, Col2
				POKE X + YRow, Col2
				IF Y > YG THEN
					Col2 = (Col2 - 32) \ 4 + ColG
					POKE X \ 2 - 20 + YRow2R, Col2
					POKE X \ 2 + 180 + YRow2R, Col2
					POKE X + YRowR, Col2
				END IF
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y > 0 AND Y < 199 THEN
			YRow = Y * 320
			YRow2 = (Y \ 2 + 60) * 320
			YRowR = (R - Y) * 320
			YRow2R = (R2 - Y \ 2) * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			ColG = (GB - INT(Y / GD!)) * 8 + 96
			FOR X = MidX TO TopX STEP S
				P = PEEK(X + YRow)
				IF P = 15 THEN Col2 = Col ELSE Col2 = (Col + P) \ 2
				POKE X \ 2 - 20 + YRow2, Col2
				POKE X \ 2 + 180 + YRow2, Col2
				POKE X + YRow, Col2
				IF Y > YG THEN
					Col2 = (Col2 - 32) \ 4 + ColG
					POKE X \ 2 - 20 + YRow2R, Col2
					POKE X \ 2 + 180 + YRow2R, Col2
					POKE X + YRowR, Col2
				END IF
			NEXT X
		END IF
	NEXT Y
END IF
END SUB

SUB TriFill3 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
SHARED Top, Bottom
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X1 + ((Y - Y1) / Y21) * X21
			BottomX = X1 + ((Y - Y1) / Y31) * X31
			IF S > 0 THEN
				IF BottomX >= 320 THEN BottomX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF BottomX < 0 THEN BottomX = 0
			END IF
			FOR X = MidX TO BottomX STEP S
				POKE X + YRow, Col   ' PSET (X, Y), Col
				POKE (319 - X) + (64000 - YRow), Col
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			IF S > 0 THEN
				IF TopX >= 320 THEN TopX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF TopX < 0 THEN TopX = 0
			END IF
			FOR X = MidX TO TopX STEP S
				POKE X + YRow, Col
				POKE (319 - X) + (64000 - YRow), Col
			NEXT X
		END IF
	NEXT Y
END IF
END SUB

SUB TriGFill (BYVAL X1, BYVAL Y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
SHARED Top, Bottom
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1: SWAP Col2, Col1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1: SWAP Col3, Col1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2: SWAP Col3, Col2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
Col12 = Col1 - Col2: Col13 = Col1 - Col3: Col23 = Col2 - Col3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
		YRow = Y * 320
		MidX = X1 + ((Y - Y1) / Y21) * X21
		BottomX = X1 + ((Y - Y1) / Y31) * X31
		YC1 = Y - Y1
		A! = Col1 - YC1 / Y21 * Col12
		B! = Col1 - YC1 / Y31 * Col13
		BA! = B! - A!
		MBX = ABS(MidX - BottomX) + 1
			IF S > 0 THEN
				IF BottomX >= 320 THEN BottomX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF BottomX < 0 THEN BottomX = 0
			END IF
		FOR X = MidX TO BottomX STEP S
			Col = A! + (ABS(X - MidX) / MBX) * BA!
			POKE X + YRow, Col
		NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
		YRow = Y * 320
		MidX = X3 + ((Y - Y3) / Y23) * X23
		TopX = X3 + ((Y - Y3) / Y13) * X13
		YC3 = Y - Y3
		A! = Col3 + (YC3 / Y23) * Col23
		B! = Col3 + (YC3 / Y13) * Col13
		BA! = B! - A!
		MTX = ABS(MidX - TopX) + 1
			IF S > 0 THEN
				IF TopX >= 320 THEN TopX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF TopX < 0 THEN TopX = 0
			END IF
		FOR X = MidX TO TopX STEP S
			Col = A! + (ABS(X - MidX) / MTX) * BA!
			POKE X + YRow, Col
		NEXT X
		END IF
	NEXT Y
END IF
END SUB

