'$DYNAMIC
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z
DEFSNG J
TYPE PicData
	Height AS INTEGER
	Width AS INTEGER
	Colors AS INTEGER
END TYPE
TYPE LibHeaderType
	FileName AS STRING * 12
	Offset AS LONG
	Size AS LONG
END TYPE

DECLARE SUB QTInit ()
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDone ()
DECLARE SUB Shellsort (Array())
DECLARE SUB TriFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
DECLARE SUB TriGFill (BYVAL X1, BYVAL Y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
DECLARE SUB FillCircle (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB FillCircle2 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
DECLARE SUB ShadeCircle (CX, CY, Radius, Colr)
DECLARE SUB GetPalette ()
DECLARE FUNCTION ASin! (BYVAL A!)
DECLARE SUB FPrint (Text$, BYVAL X, BYVAL Y)
DECLARE SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS PicData)
DECLARE SUB TriClear (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3)
DECLARE SUB FadePalette (BYVAL Red, BYVAL Green, BYVAL Blue, Pal(), BYVAL Amount AS SINGLE)
DECLARE FUNCTION GetLibOffset& (File$)

DIM SHARED VirtScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM SHARED BlankScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM SHARED Palett(0 TO 255, 1 TO 3)

DIM Ratio AS SINGLE
CONST pi = 3.14159
CONST Lib$ = "TTS.DAT"

OPEN "tts.ini" FOR INPUT AS 1
INPUT #1, Ratio, Dev, Port, IRQ, DMA: CLOSE 1
	'SELECT CASE COMMAND$
	SELECT CASE Ratio
	CASE .83: Top = 25: Bottom = 174
	CASE 1: Top = 10: Bottom = 189
	CASE 1.11: Top = 0: Bottom = 199
	CASE ELSE: PRINT "No.": END
	END SELECT
SCREEN 13
CLS

' *** SOUND INIT ***

DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
A& = SETMEM(-180000)  ' mem to free for BWSB - adjust as needed
'GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
'ErrorFlag = LoadMSE("SOUND.DAT", Device(Dev), 45, 4096, Port, IRQ, DMA)
ErrorFlag = LoadMSE(Lib$, GetLibOffset("SOUND.DAT") - 1 + Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
	PRINT "EMS is required for a non-GUS soundcard.": END 'StopBanner: END
END IF

' ** MUSIC LOAD **

OPEN Lib$ FOR BINARY AS 1
'OPEN "dynamo2.gdm" FOR BINARY AS 1
LoadGDM FILEATTR(1, 2), GetLibOffset("DYNAMO2.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR J = 1 TO 32                  'Scan for used music channels
  IF ASC(MID$(ModHeader.PanMap, J, 1)) <> &HFF THEN
	 MusChans = MusChans + 1
  END IF
NEXT

OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(50)

VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))
BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))


' *** greets (B2) ***
CLS ': PALETTE

DEF SEG = BS
FOR L = Top TO Bottom: FOR M = 0 TO 319: POKE M + L * 320, 1: NEXT M, L
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 50
DIM fsort(points), zavg(points)
DIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE
DIM Dx(points), Dy(points), Radius(points), JZ(points) AS SINGLE
DIM BallX(0 TO 49)
DIM Ball(0 TO (100 * 50) - 1) AS STRING * 1
DIM Text$(1 TO 10)
DIM Font(0, 0) AS STRING * 1, FontD AS PicData
DIM xrot AS SINGLE, yrot AS SINGLE, zrot AS SINGLE
DIM cosx AS SINGLE, sinx AS SINGLE
DIM cosy AS SINGLE, siny AS SINGLE
DIM cosz AS SINGLE, sinz AS SINGLE
DIM camdist AS SINGLE


camdist = 90: Xoffset = 160: yoffset = 100
FOR L = 1 TO points
X(L) = RND * 80 - 40: Y(L) = RND * 80 - 40: Z(L) = RND * 80 - 40
NEXT L

BallS = VARSEG(Ball(0)): BallO = VARPTR(Ball(0))
FOR Y = 0 TO 49
	Angle! = ASin(1 - Y / 50)
	BallX(Y) = (50 - COS(Angle!) * 50)
	FOR X = 0 TO 99
		Dist = SQR((X - 50) ^ 2 + (Y - 50) ^ 2)
		IF Dist < 52 THEN
			Ball(X + Y * 100) = CHR$(20 + 32 * COS(Dist / 24))
		END IF
NEXT X, Y

LoadBMP "font2.bmp", Font(), FontD
FOR L = 0 TO FontD.Colors - 1
	 'OUT &H3C8, L + 200
	 'FOR M = 1 TO 3: OUT &H3C9, Palett(L, M): NEXT M
	 FOR M = 1 TO 3: Palett(L + 200, M) = Palett(L, M): NEXT M
NEXT L
'GetPalette
FS = VARSEG(Font(0, 0)): FO = VARPTR(Font(0, 0))
FOR L = 1 TO 48
	Palett(L, 1) = 0: Palett(L, 2) = (L + 15) / 2: Palett(L, 3) = L + 15
'OUT &H3C8, L: OUT &H3C9, 0: OUT &H3C9, (L + 15) / 2: OUT &H3C9, L + 15
NEXT
FOR L = 49 TO 63
	Palett(L, 1) = L - 48: Palett(L, 2) = L - 16: Palett(L, 3) = 63
'OUT &H3C8, L: OUT &H3C9, L - 48: OUT &H3C9, L - 16:OUT &H3C9, 63
NEXT

FOR L = 1 TO 10: READ Text$(L): NEXT
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

QTInit
QTSetTimer 1, 32000
QTSetTimer 2, 500
T1 = 32000
TRows = 1: TChar = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	T2 = QTGetTimer(2)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 12000 AND t >= 10500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 10500) / 1500
	END IF
	
	xrot = 0
	yrot = (COS(t / 2000)) * 3
	zrot = (SIN(t / 3000)) * 2
	camdist = 50

	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		Z(P) = Z(P) - (T1 - t) / 15
		IF Z(P) < -40 THEN Z(P) = Z(P) + 80
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * Z(P)
		JZ1 = sinx * Y(P) + cosx * Z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		JZcam = JZ(P) + camdist
		IF JZcam < 1 THEN JZcam = 1
		
		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 125) / JZcam + yoffset

		Radius(P) = 450 / JZcam
		
	NEXT P
	
	FOR L = 1 TO points
		fsort(L) = L
		zavg(L) = JZ(L)
	NEXT
	Shellsort zavg()

	FOR L = points TO 1 STEP -1
		M = fsort(L)
		IF Radius(M) < 50 THEN
			ShadeCircle Dx(M), Dy(M), Radius(M), 40 + M * 3
		END IF
	NEXT L

	IF T2 = 0 THEN
		TChar = TChar + 1
		IF TChar > LEN(Text$(TRows)) AND TRows < 10 THEN
			TRows = TRows + 1: TChar = 1
		END IF
		QTSetTimer 2, 40
	END IF
	FOR Y = 1 TO TRows
		IF Y < TRows THEN
			FPrint Text$(Y), 10, Y * 14 + 20
		ELSE
			FPrint LEFT$(Text$(Y), TChar), 10, Y * 14 + 20
		END IF
	NEXT Y

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 10500

'*** BIRDS ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, fsort, zavg, Radius, BallX, Ball

points = 256: faces = 128
DIM X(points) AS SINGLE
DIM Y(points) AS SINGLE
DIM Z(points) AS SINGLE
DIM JZ(points) AS SINGLE, Height(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), zavg(faces)
DIM fcolor(faces)
DIM SHARED fsort(faces)
DIM Dx(points)
DIM Dy(points)

camdist = 250: Xoffset = 160: yoffset = 110

FOR L = 128 TO 159
	OUT &H3C8, L
	OUT &H3C9, L - 128
	OUT &H3C9, L - 128
	OUT &H3C9, 63
NEXT L
FOR L = 160 TO 223
	OUT &H3C8, L
	OUT &H3C9, 32 + (L - 160) \ 4
	OUT &H3C9, 32 + (L - 160) \ 4
	OUT &H3C9, 42 + (223 - L) \ 3
NEXT L
FOR L = 224 TO 255
	OUT &H3C8, L
	OUT &H3C9, 32 - (L - 224) \ 2
	OUT &H3C9, 32 + (L - 224) \ 2
	OUT &H3C9, 32 - (L - 224) \ 2
NEXT L
GetPalette

DEF SEG = BS
FOR M = Top TO Bottom
FOR L = 0 TO 319
	POKE L + M * 320, INT(((M - Top) / Ratio) / 1.5) + 128
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

	FOR Y = 0 TO 7
		FOR X = 0 TO 7
			FOR L = 1 TO 4
				I = Y * 4 + X * 32 + L
				X(I) = (X * 50) + RND * 10 + 300 '- 185
				Y(I) = (Y * 50) + RND * 10 - 185
				SELECT CASE L
					CASE 1: Y(I) = Y(I) - 20
					CASE 2: X(I) = X(I) - 10
					CASE 3: X(I) = X(I) + 10
					CASE 4: Y(I) = Y(I) + 20
				END SELECT
				IF L = 1 THEN
					Height(I) = RND * 3
				ELSE Height(I) = Height(I - 1)
				END IF
NEXT L, X, Y

FOR L = 0 TO faces \ 2 - 1
	F1(L * 2 + 1) = (L * 4 + 1): F2(L * 2 + 1) = (L * 4 + 2): F3(L * 2 + 1) = (L * 4 + 3)
	F1(L * 2 + 2) = (L * 4 + 2): F2(L * 2 + 2) = (L * 4 + 3): F3(L * 2 + 2) = (L * 4 + 4)
	fcolor(L * 2 + 1) = RND * 50 + 50: fcolor(L * 2 + 2) = fcolor(L * 2 + 1) + 1
NEXT L

QTSetTimer 1, 29500: T1 = 29500
xrot = -1.57
zrot = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 28000 THEN
		FadePalette 0, 0, 0, Palett(), (29500 - t) / 1500
	END IF
	IF t < 10000 AND t >= 8500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 8500) / 1500
	END IF
	yrot = t / 2000
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		X(P) = X(P) - (T1 - t) / 10
		IF X(P) < -225 AND P MOD 4 = 1 THEN
			FOR L = 0 TO 3: X(P + L) = X(P + L) + 450: NEXT L
		END IF
		Z(P) = COS(t / 500 + Height(P)) * 30 + 30
		IF P MOD 4 = 0 OR P MOD 4 = 1 THEN Z(P) = Z(P) + COS(t / 200 + (P - 1) \ 4) * 20
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * Z(P)
		JZ1 = sinx * Y(P) + cosx * Z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		JZcam = JZ(P) + camdist
		IF JZcam < 5 THEN JZcam = 5
		IF P > 1000 THEN
			Dx(P) = (-JX * 150) / JZcam + 10
			Dy(P) = (-JY * 150 * Ratio) / JZcam + 10
		ELSE
			Dx(P) = (-JX * 150) / JZcam + Xoffset
			Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset
		END IF
	NEXT P

	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) / 3
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		IF zavg(L) > -200 AND zavg(L) < 400 THEN
			M = fsort(L)
			TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M)
		END IF
	NEXT L
	
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL LEN(INKEY$) OR t <= 8500

' *** BLOB ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, F1, F2, F3, zavg, fcolor, fsort, Height
DEF SEG = BS

FOR M = Top TO Bottom: FOR L = 0 TO 319: POKE L + M * 320, 120 + SIN(M / 30) * 5 + COS((L + M) / 20) * 5: NEXT L, M
Y = 100 + 60 * Ratio
FillCircle2 200, Y, 20, 85
FillCircle2 260, Y, 20, 85
FillCircle2 305, Y, 20, 85
FillCircle2 200, Y, 10, 120
FillCircle2 260, Y, 10, 120
FillCircle2 305, Y, 10, 120
Y2 = 100 + 28 * Ratio: Y3 = 100 + 24 * Ratio: Y4 = 100 + 80 * Ratio
TriFill 285, Y2, 285, Y, 293, Y, 85
TriFill 285, Y2, 293, Y3, 293, Y, 85
TriFill 180, Y2, 180, Y, 188, Y, 85
TriFill 180, Y2, 188, Y3, 188, Y, 85
TriFill 180, Y2, 180, Y, 188, Y, 85
TriFill 180, Y2, 188, Y3, 188, Y, 85
TriFill 225, Y2, 235, Y3, 225, Y4, 85
TriFill 235, Y3, 225, Y4, 235, Y4, 85

IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

FOR L = 1 TO 47
	OUT &H3C8, L: OUT &H3C9, L: OUT &H3C9, L: OUT &H3C9, L
NEXT L
FOR L = 48 TO 63
	OUT &H3C8, L: OUT &H3C9, L: OUT &H3C9, L: OUT &H3C9, L
NEXT L
FOR L = 64 TO 79
	OUT &H3C8, L: OUT &H3C9, 125 - L: OUT &H3C9, 125 - L: OUT &H3C9, 63
NEXT L
FOR L = 80 TO 95
	OUT &H3C8, L: OUT &H3C9, 46: OUT &H3C9, 46: OUT &H3C9, 48 + 95 - L
NEXT L
FOR L = 100 TO 163
	OUT &H3C8, L: OUT &H3C9, L - 100: OUT &H3C9, 0: OUT &H3C9, L - 100
NEXT L
GetPalette

points = 64: faces = 128
DIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE, R(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), fcolor(faces), zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points)
DIM JZ(points) AS SINGLE

camdist = 250: Xoffset = 160: yoffset = 100

FOR P = 1 TO points
	R(P) = RND * 3.14

	IF P MOD 8 <> 0 AND P < points - 7 THEN
		F1(P * 2) = P
		F2(P * 2) = P + 1
		F3(P * 2) = P + 8
		fcolor(P * 2) = P + 40
		F1(P * 2 - 1) = P + 1
		F2(P * 2 - 1) = P + 8
		F3(P * 2 - 1) = P + 9
		fcolor(P * 2 - 1) = P + 40
	END IF
NEXT P
FOR P = points - 7 TO points - 1
	F1(P * 2) = P
	F2(P * 2) = P + 1
	F3(P * 2) = ((P - 1) MOD 8) + 1
	fcolor(P * 2) = P + 40
	F1(P * 2 - 1) = P + 1
	F2(P * 2 - 1) = ((P - 1) MOD 8) + 1
	F3(P * 2 - 1) = ((P - 1) MOD 8) + 2
	fcolor(P * 2 - 1) = P + 40
NEXT P

QTSetTimer 1, 32000
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 17000 AND t >= 15500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 15500) / 1500
	END IF
	IF t > 30000 THEN
		Xoffset = 160 - (t - 30000) \ 10
	END IF
	xrot = t / 1500
	yrot = t / 1500
	zrot = t / 1500
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		IF P MOD 8 = 1 OR P MOD 8 = 0 THEN rad = 100 ELSE rad = 100 + COS(t / 300 + R(P)) * 25

		ang! = ((P - 1) MOD 8) / 2.228
		X(P) = COS(ang!) * rad: Y(P) = SIN(ang!) * rad
		zang! = ((P - 1) \ 8) / 1.273
		Z(P) = COS(zang!) * Y(P): Y(P) = SIN(zang!) * Y(P)
		
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * Z(P)
		JZ1 = sinx * Y(P) + cosx * Z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) \ 3
	NEXT
	Shellsort zavg()
	FOR L = faces / 1.8 TO 1 STEP -1
		M = fsort(L)
		TriGFill Dx(F1(M)), Dy(F1(M)), 20 - JZ(F1(M)) \ 2, Dx(F2(M)), Dy(F2(M)), 20 - JZ(F2(M)) \ 2, Dx(F3(M)), Dy(F3(M)), 20 - JZ(F3(M)) \ 2
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 15500


' *** SPIRAL3 ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, R, F1, F2, F3, fsort, zavg, fcolor

points = 300: faces = 200
DIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE
DIM Dx(points), Dy(points), JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), zavg(faces)
DIM SHARED fsort(faces)

camdist = 100: Xoffset = 160: yoffset = 100

FOR L = 1 TO 200 STEP 4
	X(L) = COS(L / 5.3) * (70 + COS(L * 2) * 25)
	X(L + 1) = COS((L + 4) / 5.3) * (70 + COS((L + 4) * 2) * 25)
	X(L + 2) = COS(L / 5.3) * (60 + COS(L * 2) * 25)
	X(L + 3) = COS((L + 4) / 5.3) * (60 + COS((L + 4) * 2) * 25)
	Y(L) = SIN(L / 5.3) * (70 + COS(L * 2) * 25)
	Y(L + 1) = SIN((L + 4) / 5.3) * (70 + COS((L + 4) * 2) * 25)
	Y(L + 2) = SIN(L / 5.3) * (60 + COS(L * 2) * 25)
	Y(L + 3) = SIN((L + 4) / 5.3) * (60 + COS((L + 4) * 2) * 25)
	Z(L) = L * 2 - 200
	Z(L + 1) = L * 2 - 192
	Z(L + 2) = L * 2 - 200
	Z(L + 3) = L * 2 - 192
NEXT L
FOR L = 201 TO points
	X(L) = COS(L / 4) * 40
	Y(L) = SIN(L / 4) * 40
	Z(L) = (L - 200) * 4
NEXT L

FOR L = 1 TO 99 STEP 2
	F1(L) = L * 2 - 1: F2(L) = L * 2: F3(L) = L * 2 + 1
	F1(L + 1) = L * 2: F2(L + 1) = L * 2 + 1: F3(L + 1) = L * 2 + 2
NEXT L
FOR L = 101 TO faces
	' set all 3 points of the particle "faces" to the same one, will ID them later and get the Z sorting right
	F1(L) = L + 100: F2(L) = L + 100: F3(L) = L + 100
NEXT L

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 1.25) - 130) ^ 2 + ((M - 100) / Ratio) ^ 2)
		P = 246 - N / 1.2
		IF P > 163 THEN P = 163
		IF P < 100 THEN P = 100
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

FOR L = 1 TO 63: OUT &H3C8, L: OUT &H3C9, L \ 4 + 16: OUT &H3C9, L / 1.55 + 16: OUT &H3C9, L / 1.55 + 16: NEXT
FOR L = 100 TO 163: OUT &H3C8, L: OUT &H3C9, (L - 100) \ 2: OUT &H3C9, (L - 100) / 1.1: OUT &H3C9, (L - 100) / 1.1: NEXT
GetPalette

QTSetTimer 1, 32000
T1 = 32000
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 14000 AND t >= 12500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 12500) / 1500
	END IF
	xrot = SIN(t / 800) / 4
	yrot = COS(t / 800) / 4
	zrot = 0
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	T0! = (T1 - t) / 18
	FOR P = 1 TO points
		IF P <= 200 THEN Z(P) = Z(P) - T0! ELSE Z(P) = Z(P) - T0! * 2
		IF Z(P) < -200 THEN
			Z(P) = Z(P) + 400
			IF P <= 200 THEN Z((P MOD 200) + 1) = Z((P MOD 200) + 1) + 400
		END IF
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * Z(P)
		JZ1 = sinx * Y(P) + cosx * Z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		JZcam = JZ(P) + camdist
		IF JZcam < 1 THEN JZcam = 1
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		IF L > 200 THEN
			zavg(L) = JZ(F1(L))
		ELSE
			zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) \ 3
		END IF
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) > -80 THEN
			IF M <= 100 THEN
				' triangle
				TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), zavg(L) \ 5 + 20 'fcolor(M)
			ELSE
				' particle
				FillCircle Dx(F1(M)), Dy(F1(M)), 7 - zavg(L) \ 12, -JZ(F1(M)) \ 5 + 22
			END IF
		END IF
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL LEN(INKEY$) OR t <= 12500

' *** CHESS4 ****
CLS ': PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, F1, F2, F3, fsort, zavg

DEF SEG = BS
FOR M = Top TO Bottom: FOR L = 0 TO 319: POKE L + M * 320, 1: NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

points = 576: faces = 288
DIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE
DIM JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points)

camdist = 50: Xoffset = 160: yoffset = 100

FOR L = 0 TO 1
FOR P = 1 TO 288
	xoff = ((P - 1) MOD 48) \ 8
	yoff = ((P - 1) \ 48)
	X1! = ((P - 1) MOD 2) + (((P - 1) \ 4) MOD 2) + xoff * 2
	Z1! = (((P - 1) MOD 8) + 2) \ 4 + yoff * 2
	Y(L * 288 + P) = L * 140 - 70

	X(L * 288 + P) = X1! * 30 - 165
	Z(L * 288 + P) = Z1! * 30 - 165
NEXT P
NEXT L

FOR P = 1 TO faces STEP 2
	F1(P) = P * 2 - 1
	F2(P) = P * 2
	F3(P) = P * 2 + 2
	F1(P + 1) = P * 2 - 1
	F2(P + 1) = P * 2 + 1
	F3(P + 1) = P * 2 + 2
NEXT P

Palett(1, 1) = 0: Palett(1, 2) = 0: Palett(1, 3) = 32
'OUT &H3C8, 1: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 32
FOR L = 32 TO 63
	Palett(L, 1) = (L - 32) * 2
	Palett(L, 2) = (L - 32) * 2
	Palett(L, 3) = L
	'OUT &H3C8, L
	'OUT &H3C9, (L - 32) * 2
	'OUT &H3C9, (L - 32) * 2
	'OUT &H3C9, L
NEXT L
'GetPalette

QTSetTimer 1, 32000: T1 = 32000
	yrot = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 30500 THEN
		FadePalette 0, 0, 0, Palett(), (32000 - t) / 1500
	END IF
	IF t < 14000 AND t >= 12500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 12500) / 1500
	END IF
	xrot = t / 1000
	zrot = SIN(t / 2200) * 3
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		Z(P) = Z(P) - (T1 - t) / 5
		IF Z(P) < -180 THEN
			FOR L = 0 TO 3
				Z(P + L) = Z(P + L) + 360
			NEXT L
		END IF
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * Z(P)
		JZ1 = sinx * Y(P) + cosx * Z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		JZcam = JZ(P) + camdist
		IF JZcam < 5 THEN JZcam = 5
		Dx(P) = (-JX * 150) / JZcam + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam + yoffset
	NEXT P
	FOR L = 1 TO faces
		fsort(L) = L
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) \ 3
	NEXT
	Shellsort zavg()
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) > 0 THEN
			TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), 62 - JZ(F1(M)) \ 7
		END IF
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL LEN(INKEY$) OR t <= 12500

' *** SPLODECUBE (CUBEX2) ***
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, F1, F2, F3, fsort, zavg

points = 576: faces = 192
DIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE
DIM SX(points) AS SINGLE, SY(points) AS SINGLE, SZ(points) AS SINGLE
DIM fcolor(faces)
DIM zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points), JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces)
DIM splodetime(faces), splodedist(faces) AS SINGLE
DIM splodex(faces) AS SINGLE, splodey(faces) AS SINGLE, splodez(faces) AS SINGLE

DIM BallX(0 TO 49)
DIM Ball(0 TO (100 * 50) - 1) AS STRING * 1

camdist = 350: Xoffset = 160: yoffset = 100

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 1.3) - 180) ^ 2 + ((M - 90) / Ratio) ^ 2)
		P = 32 - N / 7
		IF P > 32 THEN P = 32
		IF P < 1 THEN P = 1
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

' back
FOR Y = 0 TO 3
	FOR X = 0 TO 3
		L = (Y * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = Y * 30 - 60
		Z(L) = 60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L)
NEXT X, Y
' front
FOR Y = 0 TO 3
	FOR X = 0 TO 3
		L = 96 + (Y * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = Y * 30 - 60
		Z(L) = -60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L)
NEXT X, Y
'left
FOR Y = 0 TO 3
	FOR Z = 0 TO 3
		L = 96 * 2 + (Y * 4 + Z) * 6 + 1
		X(L) = -60
		Y(L) = Y * 30 - 60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L): Y(L + 1) = Y(L): Z(L + 1) = Z(L) + 30
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L): Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L) + 30
NEXT Z, Y
'right
FOR Y = 0 TO 3
	FOR Z = 0 TO 3
		L = 96 * 3 + (Y * 4 + Z) * 6 + 1
		X(L) = 60
		Y(L) = Y * 30 - 60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L): Y(L + 1) = Y(L): Z(L + 1) = Z(L) + 30
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L): Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L) + 30
NEXT Z, Y
'top
FOR Z = 0 TO 3
	FOR X = 0 TO 3
		L = 96 * 4 + (Z * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = 60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L): Z(L + 2) = Z(L) + 30
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L): Z(L + 5) = Z(L) + 30
NEXT X, Z
'bottom
FOR Z = 0 TO 3
	FOR X = 0 TO 3
		L = 96 * 5 + (Z * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = -60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L): Z(L + 2) = Z(L) + 30
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L): Z(L + 5) = Z(L) + 30
NEXT X, Z
FOR P = 1 TO points
	X(P) = X(P) - 100: SX(P) = X(P): SY(P) = Y(P): SZ(P) = Z(P)
NEXT

FOR L = 1 TO faces
	F1(L) = (L - 1) * 3 + 1
	F2(L) = (L - 1) * 3 + 2
	F3(L) = (L - 1) * 3 + 3
	fcolor(L) = ((L - 1) \ 32) * 3 + 60
	splodetime(L) = 29500 - X(F1(L)) * ((RND * 2) + 4) 'INT(RND * 1000) + 30000
	splodex(L) = (RND + 2) * 1.5
	splodey(L) = (RND - .5) * 1.5
	splodez(L) = (RND - .5) * 1.5
NEXT L

FOR L = 1 TO 48: OUT &H3C8, L: OUT &H3C9, 0: OUT &H3C9, (L + 15) / 2: OUT &H3C9, L + 15: NEXT
FOR L = 49 TO 63: OUT &H3C8, L: OUT &H3C9, L - 48: OUT &H3C9, L - 16: OUT &H3C9, 63: NEXT
GetPalette
FOR L = 128 TO 191
Palett(L, 1) = L - 128: Palett(L, 2) = L - 128: Palett(L, 3) = L - 128
NEXT
BallS = VARSEG(Ball(0)): BallO = VARPTR(Ball(0))
FOR Y = 0 TO 49
	Angle! = ASin(1 - Y / 50)
	BallX(Y) = (50 - COS(Angle!) * 50)
	FOR X = 0 TO 99
		Dist = SQR((X - 50) ^ 2 + (Y - 50) ^ 2)
		IF Dist < 52 THEN
			Ball(X + Y * 100) = CHR$(151 + 32 * COS(Dist / 24))
		END IF
NEXT X, Y

QTSetTimer 1, 32767
	xrot = 0
	zrot = 0
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 31267 THEN
		FadePalette 0, 0, 0, Palett(), (32767 - t) / 1500
	END IF
	IF t < 27000 AND t >= 26500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 26500) / 500
	END IF
	yrot = t / 5000 - 6.2
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR L = 1 TO faces
		IF t < splodetime(L) THEN
			splodedist(L) = (splodetime(L) - t) / 9
			SX(F1(L)) = X(F1(L)) + splodedist(L) * splodex(L)
			SX(F2(L)) = X(F2(L)) + splodedist(L) * splodex(L)
			SX(F3(L)) = X(F3(L)) + splodedist(L) * splodex(L)
			SY(F1(L)) = Y(F1(L)) + splodedist(L) * splodey(L)
			SY(F2(L)) = Y(F2(L)) + splodedist(L) * splodey(L)
			SY(F3(L)) = Y(F3(L)) + splodedist(L) * splodey(L)
			SZ(F1(L)) = Z(F1(L)) + splodedist(L) * splodez(L)
			SZ(F2(L)) = Z(F2(L)) + splodedist(L) * splodez(L)
			SZ(F3(L)) = Z(F3(L)) + splodedist(L) * splodez(L)

		END IF
	NEXT L

	FOR P = 1 TO points
		
		' x-axis rotate
		JY1 = cosx * SY(P) - sinx * SZ(P)
		JZ1 = sinx * SY(P) + cosx * SZ(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * SX(P)
		JZ(P) = cosy * JZ1 - siny * SX(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * Ratio * 150) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces STEP 2
		fsort(L) = L
		fsort(L + 1) = L + 1
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L)) + JZ(F1(L + 1)) + JZ(F2(L + 1)) + JZ(F3(L + 1))) / 6
		zavg(L + 1) = zavg(L)
	NEXT
	Shellsort zavg()
	ShadeCircle (t - 29150) / 5, 100, 30, 40 + M * 3
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) > -100 AND splodedist(M) < 150 THEN
			TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M)
		END IF
	NEXT L
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 26500

' *** SPLODECUBE2 (cubex2a)
CLS : WAIT &H3DA, 8: PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, F1, F2, F3, fsort, zavg, SX, SY, SZ, splodetime, splodedist, splodex, splodey, splodez, BallX, Ball, fcolor

points = 576: faces = 192

DIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE
DIM SX(points) AS SINGLE, SY(points) AS SINGLE, SZ(points) AS SINGLE
DIM fcolor(faces)
DIM zavg(faces)
DIM SHARED fsort(faces)
DIM Dx(points), Dy(points), JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces)
DIM splodetime(faces), splodedist(faces) AS SINGLE
DIM splodex(faces) AS SINGLE, splodey(faces) AS SINGLE, splodez(faces) AS SINGLE
DIM BallX(0 TO 49)
DIM Ball(0 TO (100 * 50) - 1) AS STRING * 1

camdist = 350: Xoffset = 160: yoffset = 100

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		N = SQR(((L / 1.3) - 180) ^ 2 + ((M - 90) / Ratio) ^ 2)
		P = 32 - N / 7
		IF P > 32 THEN P = 32
		IF P < 1 THEN P = 1
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

' back
FOR Y = 0 TO 3
	FOR X = 0 TO 3
		L = (Y * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = Y * 30 - 60
		Z(L) = 60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L)
NEXT X, Y
' front
FOR Y = 0 TO 3
	FOR X = 0 TO 3
		L = 96 + (Y * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = Y * 30 - 60
		Z(L) = -60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L)
NEXT X, Y
'left
FOR Y = 0 TO 3
	FOR Z = 0 TO 3
		L = 96 * 2 + (Y * 4 + Z) * 6 + 1
		X(L) = -60
		Y(L) = Y * 30 - 60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L): Y(L + 1) = Y(L): Z(L + 1) = Z(L) + 30
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L): Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L) + 30
NEXT Z, Y
'right
FOR Y = 0 TO 3
	FOR Z = 0 TO 3
		L = 96 * 3 + (Y * 4 + Z) * 6 + 1
		X(L) = 60
		Y(L) = Y * 30 - 60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L): Y(L + 1) = Y(L): Z(L + 1) = Z(L) + 30
		X(L + 2) = X(L): Y(L + 2) = Y(L) + 30: Z(L + 2) = Z(L)
		X(L + 3) = X(L): Y(L + 3) = Y(L + 1): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L): Y(L + 4) = Y(L + 2): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L): Y(L + 5) = Y(L) + 30: Z(L + 5) = Z(L) + 30
NEXT Z, Y
'top
FOR Z = 0 TO 3
	FOR X = 0 TO 3
		L = 96 * 4 + (Z * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = 60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L): Z(L + 2) = Z(L) + 30
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L): Z(L + 5) = Z(L) + 30
NEXT X, Z
'bottom
FOR Z = 0 TO 3
	FOR X = 0 TO 3
		L = 96 * 5 + (Z * 4 + X) * 6 + 1
		X(L) = X * 30 - 60
		Y(L) = -60
		Z(L) = Z * 30 - 60
		X(L + 1) = X(L) + 30: Y(L + 1) = Y(L): Z(L + 1) = Z(L)
		X(L + 2) = X(L): Y(L + 2) = Y(L): Z(L + 2) = Z(L) + 30
		X(L + 3) = X(L + 1): Y(L + 3) = Y(L): Z(L + 3) = Z(L + 1)
		X(L + 4) = X(L + 2): Y(L + 4) = Y(L): Z(L + 4) = Z(L + 2)
		X(L + 5) = X(L) + 30: Y(L + 5) = Y(L): Z(L + 5) = Z(L) + 30
NEXT X, Z
FOR P = 1 TO points
	X(P) = X(P) - 100: SX(P) = X(P): SY(P) = Y(P): SZ(P) = Z(P)
NEXT

FOR L = 1 TO faces
	F1(L) = (L - 1) * 3 + 1
	F2(L) = (L - 1) * 3 + 2
	F3(L) = (L - 1) * 3 + 3
	fcolor(L) = ((L - 1) \ 32) * 3 + 60
	splodetime(L) = 29000 - X(F1(L)) * ((RND * 5) + 9) 'INT(RND * 1000) + 30000
	'xyang(L) = ATN(Y(F1(L)) / X(F1(L)))
	'zyang(L) = ATN(Y(F1(L)) / Z(F1(L)))
	splodex(L) = (RND + 2) * 1.5
	splodey(L) = (RND - .5) * 1.5
	splodez(L) = (RND - .5) * 1.5
NEXT L

GetPalette

BallS = VARSEG(Ball(0)): BallO = VARPTR(Ball(0))
FOR Y = 0 TO 49
	Angle! = ASin(1 - Y / 50)
	BallX(Y) = (50 - COS(Angle!) * 50)
	FOR X = 0 TO 99
		Dist = SQR((X - 50) ^ 2 + (Y - 50) ^ 2)
		IF Dist < 52 THEN
			Ball(X + Y * 100) = CHR$(151 + 32 * COS(Dist / 24))
		END IF
NEXT X, Y

LoadBMP "font2.bmp", Font(), FontD
FOR L = 0 TO FontD.Colors - 1
	 'OUT &H3C8, L + 200
	 'FOR M = 1 TO 3: OUT &H3C9, Palett(L, M): NEXT M
	 FOR M = 1 TO 3: Palett(L + 200, M) = Palett(L, M): NEXT M
NEXT L
FS = VARSEG(Font(0, 0)): FO = VARPTR(Font(0, 0))
FOR L = 1 TO 48
'OUT &H3C8, L: OUT &H3C9, 0: OUT &H3C9, (L + 15) / 2: OUT &H3C9, L + 15
Palett(L, 1) = 0: Palett(L, 2) = (L + 15) / 2: Palett(L, 3) = L + 15
NEXT
FOR L = 49 TO 63
Palett(L, 1) = L - 48: Palett(L, 2) = L - 16: Palett(L, 3) = 63
'OUT &H3C8, L: OUT &H3C9, L - 48: OUT &H3C9, L - 16: OUT &H3C9, 63
NEXT
FOR L = 128 TO 191
Palett(L, 1) = L - 128: Palett(L, 2) = L - 128: Palett(L, 3) = L - 128
NEXT
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

QTSetTimer 1, 32767
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	IF t > 32267 THEN
		FadePalette 0, 0, 0, Palett(), (32767 - t) / 500
	END IF
	IF t < 23500 AND t >= 22000 THEN
		FadePalette 63, 63, 63, Palett(), (t - 22000) / 1500
	END IF
	xrot = 0
	yrot = t / 10000 - 3.1
	zrot = 0
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR L = 1 TO faces
		IF t < splodetime(L) THEN
			splodedist(L) = (splodetime(L) - t) / 30
			SX(F1(L)) = X(F1(L)) + splodedist(L) * splodex(L)
			SX(F2(L)) = X(F2(L)) + splodedist(L) * splodex(L)
			SX(F3(L)) = X(F3(L)) + splodedist(L) * splodex(L)
			SY(F1(L)) = Y(F1(L)) + splodedist(L) * splodey(L)
			SY(F2(L)) = Y(F2(L)) + splodedist(L) * splodey(L)
			SY(F3(L)) = Y(F3(L)) + splodedist(L) * splodey(L)
			SZ(F1(L)) = Z(F1(L)) + splodedist(L) * splodez(L)
			SZ(F2(L)) = Z(F2(L)) + splodedist(L) * splodez(L)
			SZ(F3(L)) = Z(F3(L)) + splodedist(L) * splodez(L)

		END IF
	NEXT L

	FOR P = 1 TO points
		
		' x-axis rotate
		JY1 = cosx * SY(P) - sinx * SZ(P)
		JZ1 = sinx * SY(P) + cosx * SZ(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * SX(P)
		JZ(P) = cosy * JZ1 - siny * SX(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		Dx(P) = (-JX * 150) / (JZ(P) + camdist) + Xoffset
		Dy(P) = (-JY * Ratio * 150) / (JZ(P) + camdist) + yoffset
	NEXT P
	FOR L = 1 TO faces STEP 2
		fsort(L) = L
		fsort(L + 1) = L + 1
		zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L)) + JZ(F1(L + 1)) + JZ(F2(L + 1)) + JZ(F3(L + 1))) / 6
		zavg(L + 1) = zavg(L)
	NEXT
	Shellsort zavg()
	ShadeCircle (t - 24800) / 25, 100, 30, 40 + M * 3
	FOR L = faces TO 1 STEP -1
		M = fsort(L)
		IF zavg(L) > -100 AND splodedist(M) < 150 THEN
			TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M)
		END IF
	NEXT L
	IF (t \ 500) MOD 2 = 0 THEN
		FPrint "R", 300, Top + 10
	END IF
	DEF SEG = VS
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
LOOP UNTIL LEN(INKEY$) OR t <= 22000

' *** the end ***
DEF SEG = &HA000
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		POKE L + M * 320, 15
NEXT L, M

PALETTE
ERASE X, Y, Z, Dx, Dy, JZ, F1, F2, F3, fsort, zavg, SX, SY, SZ, splodetime, splodedist, splodex, splodey, splodez, BallX, Ball, fcolor

DEF SEG = BS
FOR M = Top TO Bottom
	FOR L = 0 TO 319
		P = 20 + SIN(L / 6) * 10 + SIN((M / Ratio) / 6) * 10 + SIN((L + (M / Ratio) * 1.1) / 5) * 5
		IF P > 45 THEN P = 45
		IF P < 1 THEN P = 1
		POKE L + M * 320, P
NEXT L, M
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS

GetPalette
FOR L = 1 TO 63
	Palett(L, 1) = L / 1: Palett(L, 2) = L / 1.1: Palett(L, 3) = L / 1
	'OUT &H3C8, L: OUT &H3C9, L / 1: OUT &H3C9, L / 1.1: OUT &H3C9, L / 1
NEXT L
Palett(100, 1) = 53: Palett(100, 2) = 0: Palett(100, 3) = 0
'OUT &H3C8, 100: OUT &H3C9, 53: OUT &H3C9, 0: OUT &H3C9, 0

points = 25: faces = 11
REDIM fsort(points), ccolor(points)
REDIM X(points) AS SINGLE, Y(points) AS SINGLE, Z(points) AS SINGLE
REDIM Dx(points), Dy(points), Radius(points), rad(points), JZ(points) AS SINGLE
DIM F1(faces), F2(faces), F3(faces), fcolor(faces), zavg(faces)

camdist = 25: Xoffset = 160: yoffset = 100

t = 100
T1 = 0
' outer circles
X(1) = -9: Y(1) = 0: Z(1) = 0: ccolor(1) = t: rad(1) = 10
X(2) = 0: Y(2) = 0: Z(2) = 0: ccolor(2) = t: rad(2) = 10
X(3) = 9: Y(3) = 0: Z(3) = 0: ccolor(3) = t: rad(3) = 10
' inner circles
X(4) = -9: Y(4) = 0: Z(4) = 0: ccolor(4) = T1: rad(4) = 5
X(5) = 0: Y(5) = 0: Z(5) = 0: ccolor(5) = T1: rad(5) = 5
X(6) = 9: Y(6) = 0: Z(6) = 0: ccolor(6) = T1: rad(6) = 5
' poly points
'e
X(7) = -4: Y(7) = -1: Z(7) = 0
X(8) = -9: Y(8) = -1: Z(8) = 0
X(9) = -4: Y(9) = -4: Z(9) = 0
X(10) = -12.9: Y(10) = .9: Z(10) = 0
X(11) = -5.1: Y(11) = .9: Z(11) = 0
X(12) = -12.9: Y(12) = -.9: Z(12) = 0
X(13) = -5.1: Y(13) = -.9: Z(13) = 0
F1(1) = 7: F2(1) = 8: F3(1) = 9: fcolor(1) = T1
F1(2) = 10: F2(2) = 11: F3(2) = 12: fcolor(2) = t
F1(3) = 11: F2(3) = 12: F3(3) = 13: fcolor(3) = t
'n
X(14) = -2.2: Y(14) = 0: Z(14) = 0
X(15) = 2.2: Y(15) = 0: Z(15) = 0
X(16) = -3: Y(16) = -4.25: Z(16) = 0
X(17) = 1.4: Y(17) = -4.25: Z(17) = 0
X(18) = -4.1: Y(18) = 0: Z(18) = 0
X(19) = 4.1: Y(19) = 0: Z(19) = 0
X(20) = -4.9: Y(20) = -4.25: Z(20) = 0
X(21) = 3.3: Y(21) = -4.25: Z(21) = 0
F1(4) = 14: F2(4) = 15: F3(4) = 16: fcolor(4) = T1
F1(5) = 15: F2(5) = 16: F3(5) = 17: fcolor(5) = T1
F1(6) = 18: F2(6) = 20: F3(6) = 16: fcolor(6) = t
F1(7) = 19: F2(7) = 21: F3(7) = 17: fcolor(7) = t
F1(8) = 18: F2(8) = 14: F3(8) = 16: fcolor(8) = t

F1(9) = 19: F2(9) = 15: F3(9) = 17: fcolor(9) = t
'd
X(22) = 12.2: Y(22) = 6: Z(22) = 0
X(23) = 14: Y(23) = 7: Z(23) = 0
X(24) = 11.2: Y(24) = 0: Z(24) = 0
X(25) = 13: Y(25) = 0: Z(25) = 0
F1(10) = 22: F2(10) = 23: F3(10) = 24: fcolor(10) = t
F1(11) = 23: F2(11) = 24: F3(11) = 25: fcolor(11) = t

QTSetTimer 1, 32000
T1 = 32000
	xrot = 0
	yrot = 3.14
DO
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	t = QTGetTimer(1)
	zrot = COS(t / 2000) * 7
	IF t > 30500 THEN
		FadePalette 63, 63, 63, Palett(), (32000 - t) / 1500
	END IF
	IF t < 21000 AND t >= 19500 THEN
		FadePalette 0, 0, 0, Palett(), (t - 19500) / 1500
		L = MusicVolume((t - 19500) \ 36)
	END IF
	IF t > 28000 THEN
		camdist = (32000 - t) / 100 + 5
	ELSEIF t < 25000 AND t > 20000 THEN
		camdist = (t - 21000) / 100 + 5
	END IF

	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR P = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(P) - sinx * Z(P)
		JZ1 = sinx * Y(P) + cosx * Z(P)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(P)
		JZ(P) = cosy * JZ1 - siny * X(P)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		JZcam! = JZ(P) + camdist
		IF JZcam! < 2 THEN JZcam! = 2
		' map 3d to 2d
		Dx(P) = (-JX * 150) / JZcam! + Xoffset
		Dy(P) = (-JY * 150 * Ratio) / JZcam! + yoffset

		Radius(P) = (rad(P) * 60) / JZcam!
	NEXT P
	
	FOR M = 1 TO 6
		IF Radius(M) < 300 THEN
			FillCircle2 Dx(M), Dy(M), Radius(M), ccolor(M)
		END IF
	NEXT M

	FOR M = 1 TO faces
		'IF JZ(F1(M)) > 0 THEN
			IF fcolor(M) = 0 THEN
				TriClear Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M))
			ELSE
				TriFill Dx(F1(M)), Dy(F1(M)), Dx(F2(M)), Dy(F2(M)), Dx(F3(M)), Dy(F3(M)), fcolor(M)
			END IF
		'END IF
	NEXT M

	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	T1 = t
LOOP UNTIL INKEY$ = CHR$(27) OR t <= 19500


TheEnd:
' *** END ***
SCREEN 0: WIDTH 80
QTDone

StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
'StopBanner                              'Do not show BWSB banner
FreeMSE                                 'Remove MSE from memory

PRINT "                   "
PRINT "                 "
PRINT "                   "
PRINT "                 "
PRINT "              "
PRINT "               "
PRINT "                        "
PRINT "                        "
PRINT "                               "
PRINT "    That's the spirit!      "
PRINT "another QuickBasic demo for"
PRINT "@party 2011, Harvard MA USA"
END

DATA ">> Obligatory Greetings Part! <<"
DATA "________________________________"
DATA " Alpha Design - Ate Bit - Baoum"
DATA "Bawlz - Blerx - (B) - CMUCC - UD"
DATA "Ctrix - Disaster Area - DKD/RNO"
DATA "Megahawks - Noice - Nuance - PWP"
DATA "Optimus - Quebarium - Razor 1911"
DATA "SROPE - SVATG - THEMM - Traktor"
DATA "TPOLM - Trilobit - UpRough - YUP"
DATA " Amiga! Atari! C64! ZX! Vic20!"

REM $STATIC
DEFINT J
FUNCTION ASin! (BYVAL A!)
	IF ABS(A!) <> 1 THEN
		ASin! = ATN(A! / SQR(1 - A! * A!))
	ELSE
		ASin! = 1.5708 * SGN(A!)
	END IF
END FUNCTION

REM $DYNAMIC
DEFSNG J
SUB FadePalette (BYVAL Red, BYVAL Green, BYVAL Blue, Pal(), BYVAL Amount AS SINGLE)
	' Amount = 0: full R/G/B color, 1: full Pal colors
	FOR L = 1 TO 255
		OUT &H3C8, L
		OUT &H3C9, Red + (Pal(L, 1) - Red) * Amount
		OUT &H3C9, Green + (Pal(L, 2) - Green) * Amount
		OUT &H3C9, Blue + (Pal(L, 3) - Blue) * Amount
	NEXT
END SUB

REM $STATIC
DEFINT J
SUB FillCircle (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P < 40 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y < Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					P = PEEK(M + Y1)
					IF M >= 0 AND M < 320 THEN
						IF P < 40 THEN
							POKE M + Y1, Colr
						ELSE
							POKE M + Y1, (Colr + P) \ 2
						END IF
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

SUB FillCircle2 (BYVAL CX, BYVAL CY, BYVAL Radius, BYVAL Colr)
SHARED Ratio AS SINGLE, Top, Bottom, BS, BO, VS, VO
	OldY = 1
	IF Radius < 1 THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				FOR M = CX - X TO CX + X
					IF M >= 0 AND M < 320 THEN
						IF Colr = 0 THEN
							CALL BlockMove(BS, BO + M + Y1, VS, VO + M + Y1, 1, 0)
						ELSE
							POKE M + Y1, Colr
						END IF
					END IF
				NEXT M
			END IF
			IF CY - Y > Top AND CY - Y < Bottom THEN
				Y1 = (CY - Y - 1) * 320
				FOR M = CX - X TO CX + X
					IF M >= 0 AND M < 320 THEN
						IF Colr = 0 THEN
							CALL BlockMove(BS, BO + M + Y1, VS, VO + M + Y1, 1, 0)
						ELSE
							POKE M + Y1, Colr
						END IF
					END IF
				NEXT M
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

REM $DYNAMIC
DEFSNG J
SUB FPrint (Text$, BYVAL X, BYVAL Y)
SHARED VS, VO, FS, FO, FontD AS PicData
FOR L = 0 TO LEN(Text$) - 1
	C = ASC(MID$(Text$, L + 1, 1)) - 32
	FX = C * 9
	'FY = (C \ 40) * 8
	FOR VY = 1 TO 12
		FYW = VY * FontD.Width
		VY320 = (Y + VY) * 320
		FOR VX = 0 TO 8
			DEF SEG = FS
			C = PEEK(FO + FX + VX + FYW)
			IF C <> 2 THEN
				DEF SEG = VS
				POKE VO + X + VX + L * 9 + VY320, C + 200
			END IF
		NEXT VX
	NEXT VY

NEXT L
END SUB

REM $STATIC
DEFINT J
FUNCTION GetLibOffset& (File$)
	DIM LibHeader AS LibHeaderType
	GetLibOffset& = 0
	H = FREEFILE
	OPEN Lib$ FOR BINARY AS H
	SEEK H, 7: GET H, , F
	FOR L = 1 TO F
		GET H, , LibHeader
		IF UCASE$(File$) = RTRIM$(UCASE$(LibHeader.FileName)) THEN
			GetLibOffset& = LibHeader.Offset
			EXIT FOR
		END IF
	NEXT L
	CLOSE H
END FUNCTION

DEFSNG J
SUB GetPalette
	FOR L = 0 TO 255
		OUT &H3C8, L
		FOR M = 1 TO 3
			Palett(L, M) = INP(&H3C9)
	NEXT M, L
END SUB

REM $DYNAMIC
SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS PicData)
	OPEN Lib$ FOR BINARY AS 1
	Offs& = GetLibOffset(BMPFile$) - 1&
	TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
	GET 1, Offs& + 11, Offset
	GET 1, Offs& + 19, Wid
	GET 1, Offs& + 23, Hei&
	GET 1, Offs& + 47, PalCount
	IF PalCount = 0 THEN PalCount = 256
	REDIM Array(Wid - 1, ABS(Hei&) - 1) AS STRING * 1
	PS = VARSEG(Array(0, 0)): PO = VARPTR(Array(0, 0))
	DEF SEG = PS

	SEEK 1, Offs& + 55
	FOR L = 0 TO (PalCount - 1)
		GET 1, , TmpLong$
		Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	NEXT L
	SEEK 1, Offs& + Offset + 1

	FOR Y = 0 TO ABS(Hei&) - 1
		YRow = Y * Wid: YRow2 = (ABS(Hei&) - Y - 1) * Wid
		FOR X = 0 TO Wid - 1
			GET 1, , TmpByte$
			A = ASC(TmpByte$)
			IF Hei& < 0 THEN
				POKE PO + X + YRow, A
			ELSE
				POKE PO + X + YRow2, A
			END IF
		NEXT X
		IF Wid MOD 4 = 3 THEN GET 1, , TmpByte$
		IF Wid MOD 4 = 2 THEN GET 1, , TmpInt$
		IF Wid MOD 4 = 1 THEN GET 1, , TmpInt$: GET 1, , TmpByte$
	NEXT Y

	CLOSE 1
	PData.Height = Hei&: PData.Width = Wid: PData.Colors = PalCount

END SUB

REM $STATIC
DEFINT J
SUB ShadeCircle (CX, CY, Radius, Colr)
SHARED Ratio AS SINGLE, Top, Bottom, BallO, BallS, VS, VO, BallX()
	OldY = 1
	IF CX + Radius < 0 OR CX - Radius > 319 THEN EXIT SUB
	IF CY + Radius < Top OR CY - Radius > Bottom THEN EXIT SUB
	FOR L! = 0 TO 1.57 STEP ((1 / Ratio) / Radius)
		X = COS(L!) * Radius: Y = SIN(L!) * Radius * Ratio
		BallRow = INT((50 - SIN(L!) * 50) * .99)
		IF Y <> OldY THEN
			IF CY + Y >= Top AND CY + Y <= Bottom THEN
				Y1 = (CY + Y) * 320
				IF CX > 0 THEN
					Xoffset = 0: Xlength = X
					IF CX - X < 0 THEN Xoffset = -(CX - X): Xlength = X - Xoffset
					IF CX > 319 THEN Xlength = X - (CX - 319)
					IF Xlength > 0 THEN CALL BlockMove(BallS, BallO + BallX(BallRow) + Xoffset + BallRow * 100, VS, VO + (CX - X) + Xoffset + Y1, Xlength, 0)
				END IF
				IF CX < 319 THEN
					Xoffset = 0: Xlength = X
					IF CX < 0 THEN Xoffset = -(CX): Xlength = X - Xoffset
					IF CX + X > 319 THEN Xlength = 319 - CX
					IF Xlength > 0 THEN CALL BlockMove(BallS, (BallO + (100 - BallX(BallRow)) - X) + Xoffset + BallRow * 100, VS, VO + CX + Xoffset + Y1, Xlength, 0)
				END IF
			END IF
			IF CY - Y > Top AND CY - Y < Bottom THEN
				Y1 = (CY - Y - 1) * 320
				IF CX > 0 THEN
					Xoffset = 0: Xlength = X
					IF CX - X < 0 THEN Xoffset = -(CX - X): Xlength = X - Xoffset
					IF CX > 319 THEN Xlength = X - (CX - 319)
					IF Xlength > 0 THEN CALL BlockMove(BallS, BallO + BallX(BallRow) + Xoffset + BallRow * 100, VS, VO + (CX - X) + Xoffset + Y1, Xlength, 0)
				END IF
				IF CX < 319 THEN
					Xoffset = 0: Xlength = X
					IF CX < 0 THEN Xoffset = -(CX): Xlength = X - Xoffset
					IF CX + X > 319 THEN Xlength = 319 - CX
					IF Xlength > 0 THEN CALL BlockMove(BallS, (BallO + (100 - BallX(BallRow)) - X) + Xoffset + BallRow * 100, VS, VO + CX + Xoffset + Y1, Xlength, 0)
				END IF
			END IF
		END IF
		OldY = Y
	NEXT L!
END SUB

DEFSNG J
SUB Shellsort (Array())
SHARED fsort()
Span = UBOUND(Array) \ 2
DO WHILE Span > 0
	 FOR I = Span TO UBOUND(Array) - 1
		  FOR J = (I - Span + 1) TO 1 STEP -Span
				IF Array(J) <= Array(J + Span) THEN EXIT FOR
				SWAP Array(J), Array(J + Span)
				SWAP fsort(J), fsort(J + Span)
		  NEXT J
	 NEXT I
	 Span = Span \ 2
LOOP
END SUB

REM $DYNAMIC
SUB TriClear (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3)
SHARED Top, Bottom, VS, VO, BS, BO
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X1 + ((Y - Y1) / Y21) * X21
			BottomX = X1 + ((Y - Y1) / Y31) * X31
			FOR X = MidX TO BottomX STEP S
				IF X >= 0 AND X < 319 THEN
						CALL BlockMove(BS, BO + X + YRow, VS, VO + X + YRow, 1, 0)
				 END IF
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			FOR X = MidX TO TopX STEP S
				IF X >= 0 AND X < 319 THEN
						CALL BlockMove(BS, BO + X + YRow, VS, VO + X + YRow, 1, 0)
				END IF
			NEXT X
		END IF
	NEXT Y
END IF

END SUB

SUB TriFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, Col)
SHARED Top, Bottom
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X1 + ((Y - Y1) / Y21) * X21
			BottomX = X1 + ((Y - Y1) / Y31) * X31
			IF S > 0 THEN
				IF BottomX >= 320 THEN BottomX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF BottomX < 0 THEN BottomX = 0
			END IF
			FOR X = MidX TO BottomX STEP S
				POKE X + YRow, Col   ' PSET (X, Y), Col
			NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
			YRow = Y * 320
			MidX = X3 + ((Y - Y3) / Y23) * X23
			TopX = X3 + ((Y - Y3) / Y13) * X13
			IF S > 0 THEN
				IF TopX >= 320 THEN TopX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF TopX < 0 THEN TopX = 0
			END IF
			FOR X = MidX TO TopX STEP S
				POKE X + YRow, Col   ' PSET (X, Y), Col
			NEXT X
		END IF
	NEXT Y
END IF
END SUB

SUB TriGFill (BYVAL X1, BYVAL Y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
SHARED Top, Bottom
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1: SWAP Col2, Col1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1: SWAP Col3, Col1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2: SWAP Col3, Col2
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
Col12 = Col1 - Col2: Col13 = Col1 - Col3: Col23 = Col2 - Col3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB
IF Y1 <> Y2 THEN
	FOR Y = Y1 TO Y2
		IF Y >= Top AND Y <= Bottom THEN
		YRow = Y * 320
		MidX = X1 + ((Y - Y1) / Y21) * X21
		BottomX = X1 + ((Y - Y1) / Y31) * X31
		YC1 = Y - Y1
		A! = Col1 - YC1 / Y21 * Col12
		B! = Col1 - YC1 / Y31 * Col13
		BA! = B! - A!
		MBX = ABS(MidX - BottomX) + 1
			IF S > 0 THEN
				IF BottomX >= 320 THEN BottomX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF BottomX < 0 THEN BottomX = 0
			END IF
		FOR X = MidX TO BottomX STEP S
			Col = A! + (ABS(X - MidX) / MBX) * BA!
			POKE X + YRow, Col
		NEXT X
		END IF
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y >= Top AND Y <= Bottom THEN
		YRow = Y * 320
		MidX = X3 + ((Y - Y3) / Y23) * X23
		TopX = X3 + ((Y - Y3) / Y13) * X13
		YC3 = Y - Y3
		A! = Col3 + (YC3 / Y23) * Col23
		B! = Col3 + (YC3 / Y13) * Col13
		BA! = B! - A!
		MTX = ABS(MidX - TopX) + 1
			IF S > 0 THEN
				IF TopX >= 320 THEN TopX = 319
				IF MidX < 0 THEN MidX = 0
			ELSE
				IF MidX >= 320 THEN MidX = 319
				IF TopX < 0 THEN TopX = 0
			END IF
		FOR X = MidX TO TopX STEP S
			Col = A! + (ABS(X - MidX) / MTX) * BA!
			POKE X + YRow, Col
		NEXT X
		END IF
	NEXT Y
END IF
END SUB

