'$DYNAMIC
'$INCLUDE: 'QBX.BI'
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z

TYPE XMSItemType
	Width AS INTEGER
	Height AS INTEGER
	Size AS LONG
	Handle AS INTEGER
	Segment AS INTEGER
	Offset AS INTEGER
END TYPE

TYPE OverlayType
	ImageName AS STRING * 8
	Width AS INTEGER
	Height AS INTEGER
	Size AS LONG
	XMSOffset AS LONG
	X AS INTEGER
	Y AS INTEGER
END TYPE

TYPE LibHeaderType
	FileName AS STRING * 12
	Offset AS LONG
	Size AS LONG
END TYPE

DECLARE SUB QTInit ()
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDone ()

DECLARE FUNCTION IsXMSInstalled ()
DECLARE FUNCTION AllocateXMS (BYVAL Bytes&)
DECLARE SUB DeallocateXMS (BYVAL Handle)
DECLARE FUNCTION FreeXMSmemory& ()
DECLARE SUB MoveXMS (BYVAL SourceHandle, BYVAL SourceOffset&, BYVAL DestHandle, BYVAL DestOffset&, BYVAL Bytes&)
DECLARE SUB MoveToXMS (BYVAL Handle, BYVAL Segment, BYVAL Offset, BYVAL Bytes&, BYVAL XMSOffset&)
DECLARE SUB MoveFromXMS (BYVAL Handle, BYVAL Segment, BYVAL Offset, BYVAL Bytes&, BYVAL XMSOffset&)

DECLARE SUB Tunnel (BYVAL duration, BYVAL TunType, BYVAL TunTexture, BYVAL RotSpeed, BYVAL RotRange, BYVAL script)
DECLARE SUB Tunnel2 (BYVAL duration, BYVAL TunType, BYVAL TunTexture, BYVAL RotSpeed, BYVAL RotRange, BYVAL script)
DECLARE SUB Rotozoom (BYVAL duration, BYVAL texture, BYVAL RotSpeed, BYVAL ZoomSpeed, BYVAL ZoomRange, BYVAL ZoomDepth, BYVAL script)
DECLARE SUB Rotozoom2 (BYVAL duration, BYVAL version, BYVAL texture, BYVAL RotSpeed, BYVAL ZoomSpeed, BYVAL ZoomRange, BYVAL ZoomDepth, BYVAL script)
DECLARE SUB W3D (BYVAL duration, BYVAL background, BYVAL reverse, BYVAL shaded, BYVAL script)
DECLARE SUB W3Di (BYVAL duration, BYVAL reverse, BYVAL shaded, BYVAL script)
DECLARE SUB Final ()

DECLARE SUB GetSoundCardInfo ()
DECLARE SUB PreLoad ()
DECLARE SUB PalAdjust (BYVAL effect, BYVAL t2, BYVAL duration2, N() AS DOUBLE)
DECLARE SUB LoadBMP (BMPFile$, Array())
DECLARE SUB LoadBMP2 (BMPFile$, Array() AS STRING * 1)
DECLARE FUNCTION GetLibOffset& (File$)

CONST Lib$ = "TRANQ.DAT"

DIM SHARED XMSItem(15) AS XMSItemType
DIM SHARED Overlay(15) AS OverlayType
DIM SHARED Interactive AS INTEGER

' *** SOUND INIT ***
DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
A& = SETMEM(-150000)  ' mem to free for BWSB - adjust as needed
PRINT A&; "k base RAM free"
GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
ErrorFlag = LoadMSE(Lib$, GetLibOffset("SOUND.DAT") - 1 + Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
	PRINT "EMS is required for a non-GUS soundcard.": END
END IF

' *** XMS INIT, LOAD ***
IF IsXMSInstalled = -1 THEN
	PRINT FreeXMSmemory& \ 1024; "k extended memory detected."
ELSE
	PRINT "Extended memory (XMS) required.": END
END IF

' ** LOAD INTO XMS **
PreLoad
'Print FreeXMSmemory& \ 1024; "k extended memory free."

' ** MUSIC LOAD **
PRINT "Loading music"
OPEN Lib$ FOR BINARY AS 1
LoadGDM FILEATTR(1, 2), GetLibOffset("TRANQ.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR J = 1 TO 32                  'Scan for used music channels
  IF ASC(MID$(ModHeader.PanMap, J, 1)) <> &HFF THEN
	 MusChans = MusChans + 1
  END IF
NEXT

IF INSTR(COMMAND$, "GOOBERS") > 0 THEN
	Interactive = 1
	PRINT "Interactive Wolf3D mode."
	PRINT "See moreinfo.txt for keys. Have fun!"
	DO: LOOP UNTIL LEN(INKEY$)
END IF

' VGA mode
DIM regs AS RegType
regs.ax = &H13
CALL INTERRUPT(&H10, regs, regs)

' Start Music
OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(40) ' doesn't seem to work right after startmusic

QTInit

IF Interactive = 1 THEN
	W3D 32000, 1, 0, 1, 0
	GOTO TheEnd
END IF

' ** The effects! **
Tunnel 12000, 0, 0, 100, 1, 3 'title
L = MusicVolume(40)
Rotozoom 8000, 1, 6, 4, 3, 5, 1  'slow intro
Tunnel 10000, 1, 0, 36, 120, 2   'rotate w barcode
Rotozoom2 10000, 1, 0, 2, 4, 4, 5, 2   'polar effect w/colflash
Tunnel2 8000, 0, 0, 16, 32, 1 'os tunnel w glitch
Rotozoom 8000, 2, 3, 1, 3, 4, 2  'jerky w squeeze and flip
Tunnel 8000, 0, 0, 16, 32, 4  'wavy w noise
Rotozoom 8000, 0, 3, 3, 4, 5, 4  'color/jump w lizard
W3Di 16000, 0, 1, 1  ' w3d reveal
Rotozoom2 8000, 0, 2, 1, 2, 4, 5, 1 ' polar with row jump and flash
Tunnel 3000, 2, -1, 16, 32, 5 ' quick plasma tunnel
W3Di 16000, 0, 0, 2  ' rooms w reflection
Tunnel2 17000, 0, 0, 16, 32, 2   ' tunnel w greets
W3D 8000, 1, 0, 0, 2 ' plasma rotate
Rotozoom 3000, 0, 3, 1, 4, 5, 2  'jerky w squeeze and flip
Tunnel 3000, 0, -1, 16, 128, 5   ' quick plasma tunnel
W3D 8000, 2, 0, 1, 3 ' w3d w wave and bounce
Tunnel 8000, 1, 0, 36, 120, 2 'rotate w barcode
Rotozoom 8000, 2, 3, 3, 4, 5, 4  'color/jump w lizard
W3Di 12000, 1, 1, 3  ' w3d bright fisheye
Rotozoom 8000, 1, 3, 1, 3, 3, 3  'quick rz with title flash
Rotozoom2 8000, 1, 2, 2, 4, 5, 4, 3 'polar effect w/overlay
W3D 16000, 3, 0, 0, 4   ' w3d wall effects
Tunnel2 8000, 2, -1, 16, 32, 3   ' os plasma tunnel
Tunnel 8000, 0, 0, 36, 120, 1 'warped tunnel with bounce
W3Di 23000, 0, 0, 4  ' w3d final flythru
StopMusic: StopOutput
OverRate& = StartOutput(MusChans, 0): StartMusic
A = MusicOrder(28): A = MusicVolume(24)
Final

' ** shut down **
TheEnd:
QTDone

StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
FreeMSE                                 'Remove MSE from memory

regs.ax = &H3
CALL INTERRUPT(&H10, regs, regs)
CLS

FOR Slot = 1 TO 15
	IF XMSItem(Slot).Handle > 0 THEN DeallocateXMS XMSItem(Slot).Handle
NEXT

END


ImageList:
'  ImageName as String * 8
'  Width AS Integer
'  Height AS Integer
'  X AS Integer
'  Y AS Integer
DATA Tranq1, 320, 45, 0, 80
DATA Tranq2, 120, 48, 200, 152
DATA Tranq4, 320, 20, 0, 180
DATA tranq5, 84, 36, 118, 82
DATA TranqG1, 160, 20, 10, 10
DATA TranqG2, 160, 20, 50, 180
DATA TranqG3, 160, 20, 180, 30
DATA TranqG4, 160, 20, 100, 120
DATA TranqG5, 160, 20, 0, 160
DATA TranqG6, 160, 20, 130, 10
DATA TranqG7, 160, 20, 100, 100
DATA TranqG8, 160, 20, 10, 30
DATA TranqG9, 160, 20, 150, 170
DATA TranqG10, 160, 20, 180, 40
DATA tranqend, 120, 120, 0, 0

W3Dboard:
DATA "1111111111111111111111111111114444411111111111111111111111111111"
DATA "1                            1     1                           1"
DATA "1                            1     1      2222                 1"
DATA "1                            1  3  1111111    1111             1"
DATA "1                            1                    1            1"
DATA "1                            1     1111111    111  1        1  1"
DATA "1                            1  3  1      2222   1 1       1 1 1"
DATA "1                    111111111     1             1 1      1   11"
DATA "1    1111111111111111              1          1111 1111111     1"
DATA "1    1                          3  1         1                 1"
DATA "1    1                 1111111     1        1  1111111 111     1"
DATA "1    1                1      1     1       1  1111   3 3 1     1"
DATA "1    1   1111 1111   1       1  3  1      1      1   3 3 1     1"
DATA "1    1   1       1   1       1     1     1  1111  1 33 3311    1"
DATA "1    1   1       1   1       1     1     1  1   2 223   3111   1"
DATA "1    1   1       1   1       1444441     1  1   2       41     1"
DATA "1    1   1111 1111   1    1111111111  2222  222233333   31     1"
DATA "1    1      1 1      1    1        1  22      22    334311     1"
DATA "1    1   2222 2222    1   1        1  2        2         1     1"
DATA "1    1   2       2     1111        1122        2         1     1"
DATA "1    1   2       2                              2        1   111"
DATA "1    1   2       2                              2        1    11"
DATA "1    1   2222 2222     1111        1122        2         1     1"
DATA "1    1                1   1        1  2        2         1     1"
DATA "1    1               1    1        1  22      22         1     1"
DATA "1    11111111111111111    111   1111  2222  2222         11    1"
DATA "1                            1  1        2  2            111   1"
DATA "1                            1  1        3  3            11    1"
DATA "1         11111           4444  4444  3333  3333      1  1     1"
DATA "1       11     11    3    4        4  33      33 1    1111     1"
DATA "1      4         3        4        4  3        3 1    1        1"
DATA "1     4    111    3       4        4433        3      1        1"
DATA "1    4   11   11   3      4                    3      1111     1"
DATA "1   1   1       1   1     4                    3         1     1"
DATA "1   1  1   111   1   1    4        4433        3         1     1"
DATA "1   1  1   1  1  11  1    4        4  3        3         1    11"
DATA "1    1  11   1  1 1  1    4        4  33      33         1     1"
DATA "1     1   111   1 2  2    4444  4444  3333333333         1     1"
DATA "1      1       1  2  2       1  1                        11    1"
DATA "1       11   111  1  1       1  1                        11    1"
DATA "1         111     1  1       1  1                        1     1"
DATA "1                1    1      1  1                        1     1"
DATA "1               1      1     1  1      1413223141        1   111"
DATA "1              1        1    1  1    12          12      1    11"
DATA "1             1          1   1  1  13              13    1     1"
DATA "1      1111111            1111  114                  41111     1"
DATA "1     1            44                                          1"
DATA "1    1             44                                          1"
DATA "1   1    1 111            11111111                    1111     1"
DATA "1  1     1 1  1          1        2    3        3    2   1     1"
DATA "1 1      1 1   1        1          1   4        4   1    111   1"
DATA "11       1 1    1      1           3       23       3    11    1"
DATA "1        1 1     1    1           12       32       21   1     1"
DATA "1        1 1      1  1            1                  1   1     1"
DATA "1       1   1     1  1        11114    22      22    41111     1"
DATA "1      1     1    1  1        1        21      12        1    11"
DATA "1     1       1   1  1        1111  1              1  1111     1"
DATA "1    1         1  1  1           3                    3  1     1"
DATA "1    1         1  1  1111111111111        4  4        1111     1"
DATA "111111         1  1                                            1"
DATA "1     1       1   1                                            1"
DATA "1      1  2  1    1                                            1"
DATA "1111111111111111111111111111111111111413411221143141111111111111"
DATA "1111111111111111111111111111111111111111111111111111111111111111"

w3ddata1:
' start x, start y, start z, start angle
DATA 30, 60, 0, 4.71
' duration, forward distance (negative = backward), right distance (negative = left), right turn deg (negative = left), height (negative = up), effect
' effect and:
' 1: fisheye
' 2: plasma wall (#4)
' 4: rotozoom wall (#3)
' 8: tv wall (#2)
' 16: screen wave
' 32: vert screen bounce
' 64: gray flash OR
' 128: color flash
' 256: white flash
' 2048: fade in
' 4096: fade out
DATA 10000, 0, 13.5, 0, 0, 0
DATA 1000, 1, 1, 0, 0, 0
DATA 1000, 1, 0, 0, 0, 0
DATA 1000, 1, -1, 0, 0, 0
DATA 1000, 1, 0, 0, 0, 0
DATA 1000, 1, 0, 1.57, 0, 0
DATA 1000, 1, 0, 0, 0, 0

w3ddata2:
' revolve around plasma
DATA 20, 49.5, 0, 4.71
'DATA 8000, 0, 16, -6.28, 0, 2
DATA 4000, 0, 8, -3.14, 0, 2
DATA 2000, 0, 4, -1.57, 0, 34
DATA 2000, 0, 4, -1.57, 0, 2

w3ddata3:
' wave and bounce
DATA 30, 21, 0, 3.14
DATA 2000, 8, 0, 0, 0, 16
DATA 500, 1, 0, -1.25, 0, 16
DATA 500, 2.3, 0, 0, 0, 16
DATA 1000, 0, 0, 2.8, 0, 16
DATA 2500, 0, -12, 0, 0, 16
DATA 500, 1, -1, 0, 0, 16
DATA 1000, 6, 0, 0, 0, 4112

w3ddata4:
' turn on effects
DATA 42, 48, 0, 1.57
DATA 1500, 3, 0, 0, 0, 0
DATA 1500, 2, 0, 0, 0, 2
DATA 1000, 2, 0, -1, 0, 6
DATA 1000, 3, 0, 0, 0, 14
DATA 4000, 13, 0, 5.1, 0, 14
DATA 4000, 6, 0, 0, 0, 14
DATA 3000, 8, 0, -1.2, 0, 14

w3didata1:
' start x, start y, start z, start angle
DATA 30, 60, 0, 4.71
' duration, forward distance (negative = backward), right distance (negative = left), right turn deg (negative = left), height (negative = up), effect
' effect and:
' 1: fisheye
' 2: reflection
' 4: shadow
' 8:
' 64: gray flash OR
' 128: color flash
' 256: white flash
' 2048: fade in
' 4096: fade out
DATA 2000, 0, 3.5, 0, 0, 2048
DATA 6000, 0, 10, 0, 0, 0
DATA 1000, 1, 1, 0, 0, 0
DATA 1000, 1, 0, 0, 0, 0
DATA 1000, 1, -1, 0, 0, 0
DATA 1000, 1, 0, 0, 0, 0
DATA 1000, 1, 0, 1.57, 0, 0
DATA 3000, 2, 0, 0, 0, 0

w3didata2:
' rooms with reflection
DATA 31, 41, 0, 4.71
DATA 2000, 5, 0, 0, -.2, 2
DATA 2000, 5, 0, 1.57, .4, 2
DATA 2000, 5, 0, 0, -.4, 2
DATA 2000, 5, 0, -1.57, .4, 2
DATA 2000, 5, 0, 0, -.4, 2
DATA 2000, 5, 0, -1.57, .4, 2
DATA 2000, 5, 0, 0, -.4, 2
DATA 2000, 5, 0, -1.57, .4, 4098

w3didata3:
' reverse, fisheye, flash
DATA 62, 34, 0, 4.8
DATA 2000, 8, 0, -.4, 0, 1
DATA 2000, 8, 0, .4, 0, 1
DATA 2000, 7, 0, -.4, 0, 1
DATA 2000, 8, 0, -3, 0, 1
DATA 1000, 2, 0, 0, 0, 1
DATA 1000, 1, 0, 1.57, 0, 1
DATA 2000, 3, 0, 0, 0, 1

w3didata4:
' final
DATA 10, 36, 0, 4.71
DATA 1800, 7, 0, 2.5, 0, 2052
DATA 2000, 6, 0, 2.1, 0, 4
DATA 400, 1.8, 0, 0, 0, 4
DATA 2500, 10, 0, 2.5, 0, 68
DATA 3000, 15, 0, 2.2, 0, 68
DATA 1200, 7, 0, 0, 0, 68
DATA 300, 2, 0, -.7, 0, 68
DATA 200, 1, 0, 0, 0, 68
DATA 300, 2, 0, -.7, -.4, 68
DATA 1200, 8, 0, 0, 0, 132
DATA 400, 2, 0, .62, .2, 132
DATA 2500, 18, 0, 0, 0, 132
DATA 300, 2, 0, -.62, 0, 132
DATA 1500, 9.5, 0, 0, .2, 132
DATA 500, 3, 0, -1.65, 0, 132
DATA 500, 3, -1, 0, 0, 132
DATA 500, 5, 2, 0, -.3, 132
DATA 500, 5, -2, 0, 0, 132
DATA 500, 5, 2, 0, .3, 133
DATA 500, 5, -2, 0, 0, 133
DATA 500, 6, 2, 0, .1, 133
DATA 500, 6, -2, 0, .1, 133
DATA 500, 6, 2, 0, .1, 133
DATA 500, 5, 0, -1.57, .1, 133
DATA 300, 0, 0, 0, 0, 260
DATA 16000, 0, 0, 0, 0, 0

w3didata5:
'DATA 60, 9.5, 0, 3.14
'DATA 16000, 0, 0, 0, 0, 0

tunneldata1:
' duration, move speed, overlay #, effect
' effect and:
' 1: horiz wave
' 2: vert wave
' 4: pixel noise
' 8: row jump
' 16: screen wave
' 32: vert screen bounce
' 64: gray flash OR
' 128: color flash
' 256: white flash
' 512: fade in overlay
' 1024: fade out overlay
' 2048: fade in
' 4096: fade out
DATA 2000, 1, 0, 33
DATA 2000, 1, 0, 1
DATA 1000, 1, 0, 2
DATA 1500, 1, 0, 166
DATA 1500, 1, 0, 4134

tunneldata2:
DATA 1000, 1, 4, 2048
DATA 8000, 1, 4, 0
DATA 1000, 1, 4, 4096

tunneldata3:
' intro
DATA 4000, 1, 0, 2048
DATA 4000, 1, 1, 512
DATA 2000, 1, 1, 0
DATA 1000, 1, 1, 1024
DATA 1000, 1, 0, 4096

tunneldata4:
' wave and noise
DATA 1000, 1, 0, 272
DATA 2000, 1, 0, 16
DATA 5000, 1, 0, 20

tunneldata5:
' plasma
DATA 8000, 1, 0, 2048

tunnel2data1:
' duration, move speed, overlay #, effect
' effect and:
' 1: horiz wave
' 2: vert wave
' 4: texture glitch
' 8: row jump
' 16: screen wave
' 32: vert screen bounce
' 64: gray flash OR
' 128: color flash
' 256: white flash
' 512: fade in overlay
' 1024: fade out overlay
' 2048: fade in
' 4096: fade out
DATA 1000, 1, 0, 0
DATA 1000, 1, 3, 512
DATA 2000, 1, 3, 0
DATA 1000, 1, 3, 4
DATA 1000, 1, 3, 0
DATA 1000, 1, 3, 4
DATA 1000, 1, 3, 4096

tunnel2data2:
' greets
DATA 800, 1, 5, 512
DATA 800, 1, 5, 1024
DATA 800, 1, 6, 512
DATA 800, 1, 6, 1024
DATA 800, 1, 7, 512
DATA 800, 1, 7, 1024
DATA 800, 1, 8, 512
DATA 800, 1, 8, 1024
DATA 800, 1, 9, 512
DATA 800, 1, 9, 1024
DATA 800, 1, 10, 512
DATA 800, 1, 10, 1024
DATA 800, 1, 11, 512
DATA 800, 1, 11, 1024
DATA 800, 1, 12, 512
DATA 800, 1, 12, 1024
DATA 800, 1, 13, 512
DATA 800, 1, 13, 1024
DATA 800, 1, 14, 512
DATA 800, 1, 14, 1024

tunnel2data3:
' plasma
DATA 1000, 1, 0, 0
DATA 4000, 1, 0, 16
DATA 2000, 1, 0, 48
DATA 1000, 1, 0, 24

rzdata1:
' duration, overlay #, effect
' effect and:
' 1: squeeze rotate
' 2: jerky rotate
'
' 8: row jump
' 16: screen wave
' 32: vert screen bounce
' 64: gray flash OR
' 128: color flash
' 256: white flash
' 512: fade in overlay OR
' 1024: fade out overlay
' 2048: fade in OR
' 4096: fade out

' slow intro
DATA 2000, 0, 2048
DATA 2000, 0, 0
DATA 3000, 0, 64
DATA 1000, 0, 4096

rzdata2:
' jerky
DATA 4000, 0, 2
DATA 2000, 0, 35
DATA 2000, 0, 2

rzdata3:
DATA 1000, 3, 514
DATA 3000, 3, 0
DATA 2000, 3, 130
DATA 500, 3, 258
DATA 500, 3, 2
DATA 1000, 3, 1026

'DATA 1000, 0, 256
'DATA 1000, 1, 514
'DATA 1000, 1, 1026
'DATA 1000, 1, 514
'DATA 1000, 1, 1026
'DATA 1000, 1, 514
'DATA 1000, 1, 1026
'DATA 1000, 0, 4096

rzdata4:
DATA 2000, 2, 513
DATA 1000, 2, 1
DATA 1000, 2, 137
DATA 1000, 2, 1
DATA 1000, 2, 143
DATA 1000, 2, 1
DATA 1000, 2, 4097

rz2data1:
' duration, overlay #, effect
' effect and:
' 8: row jump
' 64: gray flash OR
' 128: color flash
' 256: white flash
' 512: fade in overlay OR
' 1024: fade out overlay
' 2048: fade in OR
' 4096: fade out
DATA 1000, 0, 256
DATA 2000, 0, 72
DATA 1000, 0, 0
DATA 2000, 0, 136
DATA 1000, 0, 72
DATA 1000, 0, 4096

rz2data2:
DATA 2000, 0, 2048
DATA 2000, 0, 0
DATA 3000, 0, 64
DATA 2000, 0, 0
DATA 1000, 0, 4096

rz2data3:
DATA 1000, 0, 0
DATA 1000, 1, 512
DATA 1000, 1, 1024
DATA 1000, 1, 512
DATA 1000, 1, 1024
DATA 1000, 1, 512
DATA 1000, 1, 1024
DATA 1000, 0, 0

'DATA 1000, 3, 512
'DATA 3000, 3, 0
'DATA 2000, 3, 128
'DATA 500, 3, 256
'DATA 500, 3, 0
'DATA 1000, 3, 1024

SUB Final
QTSetTimer 1, 12000
OUT &H3C8, 0
FOR L = 0 TO 63: FOR M = 1 TO 3: OUT &H3C9, L: NEXT M, L
DEF SEG = &HA000
OvNum = 15
FOR Y = 0 TO 199: FOR X = 0 TO 319: POKE X + Y * 320, 0: NEXT X, Y
FOR Y = 35 TO 153: FOR X = 0 TO 163: POKE X + Y * 320, 32: NEXT X, Y
FOR Y = 38 TO 150: FOR X = 38 TO 160: POKE X + Y * 320, 0: NEXT X, Y
	DIM Pic2(0 TO Overlay(OvNum).Width - 1, 0 TO Overlay(OvNum).Height - 1)
	MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Overlay(OvNum).Size, Overlay(OvNum).XMSOffset
	FOR Y = 0 TO Overlay(OvNum).Height - 1
	FOR X = 0 TO Overlay(OvNum).Width - 1
	POKE (Y + 35) * 320 + (X + 170), Pic2(X, Y)
	NEXT X, Y
DO
	T = QTGetTimer(1)
	A = MusicVolume(T \ 500)
	M = M + 1
	Div! = SIN(T / 1000) * 3 + 10
	FOR Y = 40 TO 148 '+ R STEP 2
		YRow = Y * 320 - 60
		Y1! = SIN((Y + T / 1000) / 20)
		Y2! = SIN(Y / Div!) / 2
		FOR X = 100 TO 218
			A = (SIN(X / 16) + Y1! + SIN(X / Div!) / 2 + Y2! + SIN((X / 2 + Y) / 15)) * 7 + 14
			B = ((A + M) MOD 40) + 130
			POKE X + YRow, B
	NEXT X, Y
	IF INKEY$ = CHR$(27) THEN EXIT DO
	'R = R XOR 1
LOOP UNTIL T = 0
END SUB

FUNCTION GetLibOffset& (File$)
	DIM LibHeader AS LibHeaderType
	GetLibOffset& = 0
	H = FREEFILE
	OPEN Lib$ FOR BINARY AS H
	SEEK H, 7: GET H, , F
	FOR L = 1 TO F
		GET H, , LibHeader
		IF UCASE$(File$) = RTRIM$(UCASE$(LibHeader.FileName)) THEN
			GetLibOffset& = LibHeader.Offset
			EXIT FOR
		END IF
	NEXT L
	CLOSE H
END FUNCTION

SUB GetSoundCardInfo
SHARED Dev, Port, IRQ, DMA
	IF INSTR(COMMAND$, "SETUP") THEN Setup = 1
	IF LEN(ENVIRON$("ULTRASND")) AND Setup = 0 THEN
		PRINT "Gravis Ultrasound detected."
		Dev = 1: Port = &HFFFF: IRQ = &HFF: DMA = &HFF
	ELSEIF LEN(ENVIRON$("BLASTER")) AND Setup = 0 THEN
		T$ = MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "T") + 1, 1)
		SELECT CASE T$
		CASE "1"
			PRINT "Sound Blaster 1.x detected."
			Dev = 2
		CASE "2"
			PRINT "Sound Blaster 2.x detected."
			Dev = 3
		CASE "4"
			PRINT "Sound Blaster Pro detected."
			Dev = 4
		CASE "6"
			PRINT "Sound Blaster 16 detected."
			Dev = 5
		END SELECT
		Port = &HFFFF: IRQ = &HFF: DMA = &HFF
	ELSE
		PRINT "Select soundcard:"
		PRINT "1) Gravis Ultrasound"
		PRINT "2) Sound Blaster 1.x"
		PRINT "3) Sound Blaster 2.x"
		PRINT "4) Sound Blaster Pro"
		PRINT "5) Sound Blaster 16"
		PRINT "6) Pro Audio Spectrum"
		PRINT "0) Abort"
		DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "6"
		IF In$ = "0" THEN END ELSE Dev = ASC(In$) - 48
		PRINT "Port address (2x0h, 0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "9"
		IF In$ = "0" THEN Port = &HFFFF ELSE Port = (16 * (ASC(In$) - 48)) + 512
		PRINT "IRQ (in hex, 0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9") OR (In$ >= "a" AND In$ <= "f")
		IF In$ = "0" THEN
			IRQ = &HFF
		ELSEIF In$ <= "9" THEN IRQ = ASC(In$) - 48
		ELSE IRQ = ASC(In$) - 87
		END IF
		PRINT "DMA (0 to autodetect):"
		DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9")
		IF In$ = "0" THEN DMA = &HFF ELSE DMA = ASC(In$) - 48
	END IF
END SUB

SUB LoadBMP (BMPFile$, Array())
	OPEN Lib$ FOR BINARY AS 1
	Offs& = GetLibOffset(BMPFile$) - 1&

	TmpByte$ = " "
	GET 1, Offs& + 11, Offset
	GET 1, Offs& + 19, Wid
	GET 1, Offs& + 23, Hei&
	'Get 1, 47, PalCount
	'REDIM Array(Wid - 1, ABS(Hei&) - 1) AS STRING * 1
	'SEEK 1, 55
	'FOR L = 0 TO PalCount - 1
		'GET 1, , TmpLong$
		'Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		'Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		'Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	'NEXT L
	SEEK 1, Offs& + Offset + 1

	FOR Y = 0 TO ABS(Hei&) - 1
		FOR X = 0 TO Wid - 1
			GET 1, , TmpByte$
			IF Hei& < 0 THEN
				Array(X, Y) = ASC(TmpByte$)
			ELSE
				Array(X, ABS(Hei&) - Y - 1) = ASC(TmpByte$)
			END IF
		NEXT X
		IF Wid MOD 2 = 1 THEN GET 1, , TmpByte$
	NEXT Y
	CLOSE 1
	
END SUB

REM $STATIC
SUB LoadBMP2 (BMPFile$, Array() AS STRING * 1)
	OPEN Lib$ FOR BINARY AS 1
	Offs& = GetLibOffset(BMPFile$) - 1&

	TmpByte$ = " "
	GET 1, Offs& + 11, Offset
	GET 1, Offs& + 19, Wid
	GET 1, Offs& + 23, Hei&
	'Get 1, 47, PalCount
	'REDIM Array(Wid - 1, ABS(Hei&) - 1) AS STRING * 1
	'SEEK 1, 55
	'FOR L = 0 TO PalCount - 1
		'GET 1, , TmpLong$
		'Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		'Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		'Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	'NEXT L
	SEEK 1, Offs& + Offset + 1

	FOR Y = 0 TO ABS(Hei&) - 1
		FOR X = 0 TO Wid - 1
			GET 1, , TmpByte$
			IF Hei& < 0 THEN
				Array(X, Y) = TmpByte$
			ELSE
				Array(X, ABS(Hei&) - Y - 1) = TmpByte$
			END IF
		NEXT X
		IF Wid MOD 2 = 1 THEN GET 1, , TmpByte$
	NEXT Y
	CLOSE 1

END SUB

SUB PalAdjust (BYVAL effect, BYVAL t2, BYVAL duration2, N() AS DOUBLE)
DIM Fade2 AS SINGLE
'STATIC N() AS DOUBLE
	IF t2 < 0 THEN t2 = 0
	IF (effect AND (128 + 64)) <> 0 THEN
			IF (effect AND 64) = 64 THEN
				O# = RND / 2 - .25
				FOR M = 1 TO 3
					N(M) = N(M) + O#
					IF N(M) < .5 THEN N(M) = .5
					IF N(M) > 1.5 THEN N(M) = 1.5
				NEXT M
			ELSEIF (effect AND 128) = 128 THEN
				FOR M = 1 TO 3
					N(M) = N(M) + RND / 2 - .25
					IF N(M) < .8 THEN N(M) = .8
					IF N(M) > 1.2 THEN N(M) = 1.2
				NEXT M
			END IF
			OUT &H3C8, 0
			FOR M = 1 TO 63
				FOR N = 1 TO 3
					IF M * N(N) > 63 THEN OUT &H3C9, 63 ELSE OUT &H3C9, M * N(N)
			NEXT N, M
		ELSEIF (effect AND (4096 + 2048 + 256)) <> 0 THEN
			IF (effect AND 256) = 256 THEN
				' fade from white
				A = 63: Fade2 = t2 / duration2
			ELSEIF (effect AND 2048) = 2048 THEN
				' fade from black
				A = 0: Fade2 = t2 / duration2
			ELSEIF (effect AND 4096) = 4096 THEN
				' fade to black
				A = 0: Fade2 = (duration2 - t2) / duration2
			END IF
				OUT &H3C8, 0
				FOR M = 0 TO 63
					FOR N = 1 TO 3
						OUT &H3C9, M + Fade2 * (A - M)
					NEXT N
				NEXT M
				FOR M = 64 TO 80
					FOR N = 1 TO 3
						OUT &H3C9, 63 + Fade2 * (A - 63)
					NEXT N
				NEXT M
		END IF
END SUB

REM $DYNAMIC
SUB PreLoad
	' tunnel texture
	XMSItem(1).Height = 64: XMSItem(1).Width = 64: XMSItem(1).Size = 64 * 64 * 2&
	' oversized tunnel info
	XMSItem(2).Height = 240: XMSItem(2).Width = 150: XMSItem(2).Size = 240 * 150&
	XMSItem(3).Height = 240: XMSItem(3).Width = 150: XMSItem(3).Size = 240 * 150&
	' oversized tunnel shade
	XMSItem(4).Height = 120: XMSItem(4).Width = 75: XMSItem(4).Size = 120 * 75 * 4&
	' test fade pic
	'XMSItem(5).Height = 150: XMSItem(5).Width = 50: XMSItem(5).Size = 150 * 50 * 2&
	' tunnel info
	XMSItem(6).Height = 160: XMSItem(6).Width = 100: XMSItem(6).Size = 160 * 100 * 2&
	XMSItem(7).Height = 160: XMSItem(7).Width = 100: XMSItem(7).Size = 160 * 100 * 2&
	' tunnel shade
	XMSItem(8).Height = 80: XMSItem(8).Width = 50: XMSItem(8).Size = 80 * 50 * 4&
	' tunnel noise
	XMSItem(9).Height = 10: XMSItem(9).Width = 320: XMSItem(9).Size = 10 * 320 * 2&
	' rotozoom texture
	XMSItem(10).Height = 32: XMSItem(10).Width = 32: XMSItem(10).Size = 32 * 32 * 2&
	' distance lookup
	XMSItem(11).Size = 160 * 100&
	' arctan lookup
	XMSItem(12).Size = 160 * 100 * 4&
	' cosine/sine lookup
	'XMSItem(13).Size = 1257 * 4&: XMSItem(14).Size = 1257 * 4&
	' wolf3d textures
	XMSItem(13).Size = 64 * 64 * 4 * 2&
	' wolf3d board
	XMSItem(14).Height = 64: XMSItem(14).Width = 64: XMSItem(14).Size = 64 * 64 * 2&
	' wolf3d background
	XMSItem(15).Size = 320 * 200&
		
	DIM texture(0 TO 63, 0 TO 63)
	DIM tx2(0 TO 239, 0 TO 149) AS STRING * 1
	DIM ty2(0 TO 239, 0 TO 149) AS STRING * 1
	DIM shade(0 TO 119, 0 TO 74) AS SINGLE
	XMSItem(1).Segment = VARSEG(texture(0, 0)): XMSItem(1).Offset = VARPTR(texture(0, 0))
	XMSItem(2).Segment = VARSEG(tx2(0, 0)): XMSItem(2).Offset = VARPTR(tx2(0, 0))
	XMSItem(3).Segment = VARSEG(ty2(0, 0)): XMSItem(3).Offset = VARPTR(ty2(0, 0))
	XMSItem(4).Segment = VARSEG(shade(0, 0)): XMSItem(4).Offset = VARPTR(shade(0, 0))
	'XMSItem(5).Segment = Varseg(Pic2(0, 0)): XMSItem(5).Offset = VarPtr(Pic2(0, 0))
	
	PRINT "Loading XMS data";

	'texture generator
	FOR Y = 1 TO 64
	FOR X = 1 TO 64
		texture(X - 1, Y - 1) = 2.5 * (SIN(X / 2) * SIN(X / 5) * 3 + SIN(Y / 2) * COS(Y / 2) * 2 + SIN(X / 4) * 4 + SIN(Y / 4) * 4 + SIN((X + Y) / 2) * 2 + COS(X / 2 + Y / 4) * 2) + 32
	NEXT X, Y
	L = 1
	XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size)
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0
	PRINT ".";

	'tunnel generator
	XMSItem(2).Handle = AllocateXMS(XMSItem(2).Size * 3)
	XMSItem(3).Handle = AllocateXMS(XMSItem(3).Size * 3)
	A = 41: B = 40
	FOR L = 0 TO 2
	IF L = 2 THEN A = 10: B = 40
	tx2s = VARSEG(tx2(0, 0)): tx2o = VARPTR(tx2(0, 0))
	ty2s = VARSEG(ty2(0, 0)): ty2o = VARPTR(ty2(0, 0))
	FOR Y = 0 TO 149
		FOR X = 1 TO 239
			IF X = 120 AND Y < 75 THEN
				Angle! = 1.57
			ELSEIF X = 120 AND Y >= 75 THEN
				Angle! = 4.71
			ELSE
				Angle! = ATN((Y * 2.4 - 180) / (X * 2 - 240))
			END IF
	
			IF X < 120 AND Y >= 75 THEN
				Angle! = 3.14 - Angle!
			ELSEIF Y < 75 AND X < 120 THEN Angle! = 3.14 - Angle!
			ELSEIF Y >= 75 AND X > 120 THEN Angle! = 6.28 - Angle!
	  
			END IF

			Radius = SQR((X * 2 - 240) ^ 2 + (Y * 2.4 - 180) ^ 2)
			DEF SEG = ty2s
			ty2v = (Radius * 220&) / (Radius + B)
			POKE ty2o, ty2v
			DEF SEG = tx2s
			POKE tx2o, ABS((Angle! * A) MOD 64)
			'tx2(X, Y) = CHR$(ABS((Angle! * 38) MOD 64))
			IF L = 1 THEN POKE tx2o, (PEEK(tx2o) - (SIN(ty2v / 20) * 30) + 64) MOD 64 ' for wavy tunnel
			'If L = 1 THEN tx2(X, Y) = chr$( (Asc(tx2(X, Y)) - (SIN(Asc(ty2(X, Y)) / 20) * 30) + 64) MOD 64) ' for wavy tunnel
			'ty2(X, Y) = CHR$((Radius * 220&) / (Radius + 40)) ' depth & aperture
			tx2o = tx2o + 1: ty2o = ty2o + 1
		NEXT X
		tx2(0, Y) = tx2(1, Y): ty2(0, Y) = ty2(1, Y)
		tx2o = tx2o + 1: ty2o = ty2o + 1
	NEXT Y
	MoveToXMS XMSItem(2).Handle, XMSItem(2).Segment, XMSItem(2).Offset, XMSItem(2).Size, XMSItem(2).Size * L
	MoveToXMS XMSItem(3).Handle, XMSItem(3).Segment, XMSItem(3).Offset, XMSItem(3).Size, XMSItem(3).Size * L
	NEXT L
	PRINT ".";
		
	' oversized shade generator
	FOR Y = 0 TO 74: FOR X = 0 TO 119
		s! = EXP(SQR((X - 60) ^ 2 + ((Y - 37) * 1.2) ^ 2) / 10 - 3)
		IF s! > 1 THEN s! = 1
		shade(X, Y) = s!
	NEXT X, Y
	L = 4
	XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size)
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0
	PRINT ".";

	' overlay pics
	RESTORE ImageList
	TotalSize& = 0
	FOR L = 1 TO UBOUND(Overlay)
		READ Overlay(L).ImageName, Overlay(L).Width, Overlay(L).Height, Overlay(L).X, Overlay(L).Y
		Overlay(L).Size = Overlay(L).Height * Overlay(L).Width * 2&
		IF L = 1 THEN Overlay(L).XMSOffset = 0 ELSE Overlay(L).XMSOffset = Overlay(L - 1).XMSOffset + Overlay(L - 1).Size
		TotalSize& = TotalSize& + Overlay(L).Size
	NEXT L
	XMSItem(5).Handle = AllocateXMS(TotalSize&)
	FOR L = 1 TO UBOUND(Overlay)
		REDIM Pic2(0 TO Overlay(L).Width - 1, 0 TO Overlay(L).Height - 1)
		LoadBMP RTRIM$(Overlay(L).ImageName) + ".bmp", Pic2()

		'FOR X = 0 TO UBOUND(Pic2, 1)
		'  FOR Y = 0 TO UBOUND(Pic2, 2)
		'     Pic2(X, Y) = (((X + Y * L) \ 5) MOD 2) * 63
		'NEXT Y, X

		MoveToXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Overlay(L).Size, Overlay(L).XMSOffset
		PRINT "o";
		
	NEXT L
	
	ERASE tx2, ty2, shade, texture, Pic2
	DIM tx(0 TO 159, 0 TO 99)
	DIM ty(0 TO 159, 0 TO 99)
	DIM shade(0 TO 79, 0 TO 49) AS SINGLE
	DIM noise(0 TO 9, 0 TO 319)
	DIM Pic(0 TO 31, 0 TO 31)
	
	XMSItem(6).Segment = VARSEG(tx(0, 0)): XMSItem(6).Offset = VARPTR(tx(0, 0))
	XMSItem(7).Segment = VARSEG(ty(0, 0)): XMSItem(7).Offset = VARPTR(ty(0, 0))
	XMSItem(8).Segment = VARSEG(shade(0, 0)): XMSItem(8).Offset = VARPTR(shade(0, 0))
	XMSItem(9).Segment = VARSEG(noise(0, 0)): XMSItem(9).Offset = VARPTR(noise(0, 0))
	XMSItem(10).Segment = VARSEG(Pic(0, 0)): XMSItem(10).Offset = VARPTR(Pic(0, 0))
	
	'noise generator
	FOR Y = 2 TO 9
		FOR X = 0 TO 319
			noise(Y, X) = INT(RND * 10)
		NEXT X
	NEXT Y
	PRINT ".";

	'tunnel generators
	XMSItem(6).Handle = AllocateXMS(XMSItem(6).Size * 3)
	XMSItem(7).Handle = AllocateXMS(XMSItem(7).Size * 3)
	A = 41: B = 40
	FOR L = 0 TO 2
	IF L = 2 THEN A = 10: B = 40
	FOR Y = 0 TO 99
		FOR X = 0 TO 159
			IF X = 80 AND Y < 49 THEN
				Angle! = 1.57
			ELSEIF X = 80 AND Y >= 49 THEN
				Angle! = 4.71
			ELSE
				Angle! = ATN((Y * 2.4 - 120) / (X * 2 - 160))
			END IF

			IF X < 80 AND Y >= 49 THEN
				Angle! = 3.14 - Angle!
			ELSEIF Y < 49 AND X < 80 THEN Angle! = 3.14 - Angle!
			ELSEIF Y >= 49 AND X > 80 THEN Angle! = 6.28 - Angle!
  
			END IF
			Radius = SQR((X * 2 - 160) ^ 2 + (Y * 2.4 - 120) ^ 2)
			tx(X, Y) = ABS((Angle! * A) MOD 64)
			ty(X, Y) = (Radius * 220&) / (Radius + B) ' wide texture
			IF L = 1 THEN tx(X, Y) = (tx(X, Y) - SIN(ty(X, Y) / 20) * 30) MOD 64 ' for wavy tunnel
		NEXT X
		'tx(0, Y) = tx(1, Y): ty(0, Y) = ty(1, Y)
	NEXT Y
	MoveToXMS XMSItem(6).Handle, XMSItem(6).Segment, XMSItem(6).Offset, XMSItem(6).Size, XMSItem(6).Size * L
	MoveToXMS XMSItem(7).Handle, XMSItem(7).Segment, XMSItem(7).Offset, XMSItem(7).Size, XMSItem(7).Size * L
	NEXT L
	PRINT ".";

	' shade generator
	FOR Y = 0 TO 49: FOR X = 0 TO 79
		s! = EXP(SQR((X - 40) ^ 2 + ((Y - 25) * 1.2) ^ 2) / 10 - 3)
		IF s! > 1 THEN s! = 1
		shade(X, Y) = s!
	NEXT X, Y
	FOR L = 8 TO 9: XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size): NEXT
	FOR L = 8 TO 9: MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0: NEXT
	PRINT ".";
	
	' rotozoom texture generator
	L = 10
	FOR X = 0 TO 31
		FOR Y = 0 TO 31
			Pic(X, Y) = SIN(X / 2.5) * 12 + SIN((X XOR Y) / 2.5) * 4 + SIN(Y / 2.5) * 12 + SIN((X + Y) / 1.25) * 4 + 32
	NEXT Y, X
	XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size * 3)
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0
	PRINT ",";
	LoadBMP "tranq6.bmp", Pic()
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, XMSItem(L).Size
	PRINT ",";
	FOR X = 0 TO 31
		FOR Y = 0 TO 31
			Pic(X, Y) = SIN(X / 2.5) * 12 + SIN((X + Y) / 1.25) * 4 + SIN(Y / 2.5) * 12 + 32
	NEXT Y, X
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, XMSItem(L).Size * 2
	ERASE noise, tx, ty, shade
	
	DIM Dist(0 TO 159, 0 TO 99) AS STRING * 1
	DIM ATan(0 TO 159, 0 TO 99) AS SINGLE
	'DIM Cosine(-628 TO 628) AS SINGLE, Sine(-628 TO 628) AS SINGLE
	XMSItem(11).Segment = VARSEG(Dist(0, 0)): XMSItem(11).Offset = VARPTR(Dist(0, 0))
	XMSItem(12).Segment = VARSEG(ATan(0, 0)): XMSItem(12).Offset = VARPTR(ATan(0, 0))
	'XMSItem(13).Segment = VARSEG(Cosine(-628)): XMSItem(13).Offset = VARPTR(Cosine(-628))
	'XMSItem(14).Segment = VARSEG(Sine(-628)): XMSItem(14).Offset = VARPTR(Sine(-628))
	
	' rotozoom brute-force lookup generators
	Ratio! = .8

	FOR Y = 0 TO 99
		FOR X = 0 TO 159
			D = SQR((((Y - 50) / Ratio!) ^ 2) + ((X - 80) ^ 2))
			Dist(X, Y) = CHR$(D)
	NEXT X, Y
	PRINT ".";
	
	FOR Y = 0 TO 99
	Y2 = (Y - 50) / Ratio!
	FOR X = 0 TO 159
		X2 = X - 80
		IF X2 = 0 THEN
			A! = ATN(Y2 / .001)
		ELSE
			A! = ATN(Y2 / X2)
		END IF
		IF X2 < 0 AND Y2 >= 0 THEN A! = 3.14159 + A!
		IF X2 < 0 AND Y2 < 0 THEN A! = -3.14159 + A!
		ATan(X, Y) = A!
	NEXT X
	NEXT Y
	PRINT ".";
	
	'FOR X = LBOUND(Cosine) TO UBOUND(Cosine)
	'   Cosine(X) = COS(X / 100!)
	'   Sine(X) = SIN(X / 100!)
	'NEXT X
	'PRINT ".";

	FOR L = 11 TO 12: XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size): NEXT
	FOR L = 11 TO 12: MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0: NEXT
	
	ERASE Dist, ATan, Pic
	
	DIM pic3(0 TO 16383)
	DIM Pic(0 TO 63, 0 TO 63)
	DIM board(0 TO 63, 0 TO 63)
	DIM BlankScr(0 TO 319, 0 TO 199) AS STRING * 1
	XMSItem(13).Segment = VARSEG(pic3(0)): XMSItem(13).Offset = VARPTR(pic3(0))
	XMSItem(14).Segment = VARSEG(board(0, 0)): XMSItem(14).Offset = VARPTR(board(0, 0))
	XMSItem(15).Segment = VARSEG(BlankScr(0, 0)): XMSItem(15).Offset = VARPTR(BlankScr(0, 0))
	
	' wolf3d generators
	LoadBMP "tranqw2.bmp", Pic()
	CALL BlockMove(VARSEG(Pic(0, 0)), VARPTR(Pic(0, 0)), VARSEG(pic3(0)), VARPTR(pic3(0)), 64 * 64 * 2, 0)
	LoadBMP "tranqw1.bmp", Pic()
	CALL BlockMove(VARSEG(Pic(0, 0)), VARPTR(Pic(0, 0)), VARSEG(pic3(4096)), VARPTR(pic3(4096)), 64 * 64 * 2, 0)
	LoadBMP "tranqw3.bmp", Pic()
	CALL BlockMove(VARSEG(Pic(0, 0)), VARPTR(Pic(0, 0)), VARSEG(pic3(8192)), VARPTR(pic3(8192)), 64 * 64 * 2, 0)
	PRINT ",";

	L = 13
	XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size * 2)
	' w3d walls
	FOR Y = 0 TO 63     'Generate interesting bitmaps (without loading a file)
		FOR X = 0 TO 63
			'pic3(X * 64 + Y + 0) = (X + Y) \ 2 + 0
			'pic3(X * 64 + Y + 4096) = ((X XOR Y) * .875 + RND * 64 * .125) * .8
			'pic3(X * 64 + Y + 8192) = ((X OR Y) * .875 + RND * 64 * .125) * .8
			pic3(X * 64 + Y + 12288) = (X + Y) \ 2 + 0 '(X * X + Y * Y) \ 128
		NEXT X
	NEXT Y
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0
	PRINT ",";
	' w3di walls
	FOR Y = 0 TO 63
		FOR X = 0 TO 63
			'pic3(X * 64 + Y + 0) = (X + Y) \ 2 + 0
			'pic3(X * 64 + Y + 4096) = ((X XOR Y) * .875 + RND * 64 * .125) * .5 '+ 64
			'pic3(X * 64 + Y + 8192) = ((X OR Y) * .875 + RND * 64 * .125) * .5 '+ 128
			pic3(X * 64 + Y + 12288) = (X + Y) \ 2 + 0  '(X * X + Y * Y) \ 128 '+ 192
		NEXT X
	NEXT Y
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, XMSItem(L).Size
	PRINT ".";

	RESTORE W3Dboard
	FOR Y = 0 TO 63
		READ A$
		FOR X = 0 TO 63
			B$ = MID$(A$, X + 1, 1)
			IF B$ = "1" OR B$ = "2" OR B$ = "3" OR B$ = "4" THEN
				board(X, Y) = ASC(B$) - 48
			ELSE
				board(X, Y) = 0
			END IF
	NEXT X, Y
	L = 14
	XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size)
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, 0
	PRINT ".";

	' draw ceiling/floor screen
	L = 15
	XMSItem(L).Handle = AllocateXMS(XMSItem(L).Size * 4)
	FOR M = 1 TO 4
	LoadBMP2 "back" + CHR$(M + 48) + ".bmp", BlankScr()
	MoveToXMS XMSItem(L).Handle, XMSItem(L).Segment, XMSItem(L).Offset, XMSItem(L).Size, (M - 1) * XMSItem(L).Size
	PRINT ":";
	NEXT M
	PRINT "!"

	
END SUB

' *** ROTOZOOM ***
SUB Rotozoom (BYVAL duration, BYVAL texture, BYVAL RotSpeed, BYVAL ZoomSpeed, BYVAL ZoomRange, BYVAL ZoomDepth, BYVAL script)
DIM Rot AS SINGLE, Zoom AS SINGLE, Zoom2 AS SINGLE, Fade AS SINGLE, Fade1 AS SINGLE
DIM YRow AS LONG
DIM N(3) AS DOUBLE
FOR M = 1 TO 3: N(M) = 1: NEXT

DIM Pic(0 TO 31, 0 TO 31)
MoveFromXMS XMSItem(10).Handle, VARSEG(Pic(0, 0)), VARPTR(Pic(0, 0)), XMSItem(10).Size, texture * XMSItem(10).Size

DEF SEG = &HA000

SELECT CASE script
CASE 1: RESTORE rzdata1
CASE 2: RESTORE rzdata2
CASE 3: RESTORE rzdata3
CASE 4: RESTORE rzdata4
END SELECT

OUT &H3C8, 0
FOR L = 0 TO 63: OUT &H3C9, L: OUT &H3C9, L: OUT &H3C9, L: NEXT L

QTSetTimer 1, duration
L = 0: R = 0: t2 = 0: OvNum = 0
RotSpeed = RotSpeed * 250: ZoomSpeed = ZoomSpeed * 500

DO
	T = QTGetTimer(1)
	L = (duration - T) \ 30
	IF t2 = 0 THEN
		READ duration2, OvNum2, effect
		IF OvNum2 <> OvNum AND OvNum2 <> 0 THEN
			REDIM Pic2(0 TO Overlay(OvNum2).Width - 1, 0 TO Overlay(OvNum2).Height - 1)
			MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Overlay(OvNum2).Size, Overlay(OvNum2).XMSOffset
		END IF
		OvNum = OvNum2
		QTSetTimer 2, duration2
	END IF
	t2 = QTGetTimer(2)
	
	rowoffset = 0: screenoffset = 0
	
	Rot = T / RotSpeed
	CR! = COS(Rot): SR! = SIN(Rot)
	Zoom = COS(T / ZoomSpeed) * ZoomRange + ZoomDepth
	Zoom2 = Zoom
	IF (effect AND 2) = 2 THEN Zoom2 = SIN(T / ZoomSpeed) * ZoomRange + ZoomDepth

	PalAdjust effect, t2, duration, N()

	IF (effect AND 8) = 8 THEN randomrow = SIN((duration2 - t2) / 1600) * 10
	IF (effect AND 32) = 32 THEN screenoffset = SIN(L / 16) * 320 + 0
	IF (effect AND 16) = 16 THEN sincol! = SIN(L / 16) * 30
		IF OvNum > 0 THEN
			IF (effect AND 512) = 512 THEN
				Fade = (duration2 - t2) / duration2
			ELSEIF (effect AND 1024) = 1024 THEN
				Fade = t2 / duration2
			ELSE
				Fade = 1
			END IF
			Fade1 = 1 - Fade
		END IF
		
	Y = 0: PicY = R2
	DO
		IF (effect AND 8) = 8 THEN
			YRow = (Y + INT(RND * randomrow) - randomrow \ 2) * 640 + R
		ELSE
			YRow = Y * 640 + R + screenoffset
		END IF
		Y2 = 50 - Y
		CRY! = CR! * Y2 / Zoom
		IF (effect AND 1) = 1 THEN
			SRY! = SR! * Y2 * Zoom2
		ELSE SRY! = SR! * Y2 / Zoom2
		END IF
		X = 80: X2 = YRow + rowoffset: PicX = 0
		IF (effect AND 16) = 16 THEN rowoffset = SIN((Y + L) / 10) * sincol!
		DO
			C = Pic((CR! * X / Zoom + SRY!) AND 31, (SR! * X / Zoom2 - CRY!) AND 31)
			C1 = C: C2 = C
			IF OvNum > 0 THEN
				IF PicY >= Overlay(OvNum).Y AND PicX >= Overlay(OvNum).X AND PicY < Overlay(OvNum).Y + Overlay(OvNum).Height AND PicX < Overlay(OvNum).X + Overlay(OvNum).Width THEN
					A = Pic2(PicX - Overlay(OvNum).X, PicY - Overlay(OvNum).Y)
					B = Pic2(PicX - Overlay(OvNum).X + 1, PicY - Overlay(OvNum).Y)
					IF A <> 0 THEN C1 = C * Fade1 + A * Fade
					IF B <> 0 THEN C2 = C * Fade1 + B * Fade
				END IF
			END IF
			
			POKE X2, C1: POKE X2 + 1, C2
			X = X - 1: X2 = X2 + 2: PicX = PicX + 2
		LOOP UNTIL X = -80
		Y = Y + 1: PicY = PicY + 2
	LOOP UNTIL Y > 99
	R = R XOR 320
	R2 = R2 XOR 1
	'L = L + 1
LOOP UNTIL INKEY$ = CHR$(27) OR T = 0
END SUB

' *** BRUTE FORCE ROTOZOOM (with warp effects) ***
SUB Rotozoom2 (BYVAL duration, BYVAL version, BYVAL texture, BYVAL RotSpeed, BYVAL ZoomSpeed, BYVAL ZoomRange, BYVAL ZoomDepth, BYVAL script)
DIM Dist(0 TO 159, 0 TO 99) AS STRING * 1
DS = VARSEG(Dist(0, 0)): DOff = VARPTR(Dist(0, 0))
MoveFromXMS XMSItem(11).Handle, DS, DOff, XMSItem(11).Size, 0
DIM ATan(0 TO 159, 0 TO 99) AS SINGLE
MoveFromXMS XMSItem(12).Handle, VARSEG(ATan(0, 0)), VARPTR(ATan(0, 0)), XMSItem(12).Size, 0
'DIM Cosine(-628 TO 628) AS SINGLE, Sine(-628 TO 628) AS SINGLE
'MoveFromXMS XMSItem(13).Handle, VARSEG(Cosine(-628)), VARPTR(Cosine(-628)), XMSItem(13).Size, 0
'MoveFromXMS XMSItem(14).Handle, VARSEG(Sine(-628)), VARPTR(Sine(-628)), XMSItem(14).Size, 0

DIM Pic(0 TO 31, 0 TO 31)
MoveFromXMS XMSItem(10).Handle, VARSEG(Pic(0, 0)), VARPTR(Pic(0, 0)), XMSItem(10).Size, texture * XMSItem(10).Size

DIM Pic2(0 TO 149, 0 TO 49)
MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), XMSItem(5).Size, 0

DIM Rot AS SINGLE, Zoom AS SINGLE, Fade AS SINGLE, Fade1 AS SINGLE
DIM N(3) AS DOUBLE
FOR M = 1 TO 3: N(M) = 1: NEXT
DIM YRow AS LONG
DEF SEG = &HA000

SELECT CASE script
CASE 1: RESTORE rz2data1
CASE 2: RESTORE rz2data2
CASE 3: RESTORE rz2data3
END SELECT

OUT &H3C8, 0
FOR L = 0 TO 63: OUT &H3C9, L: OUT &H3C9, L: OUT &H3C9, L: NEXT L

QTSetTimer 1, duration
RotSpeed = RotSpeed * 500: ZoomSpeed = ZoomSpeed * 500
L = 0: R = 0: t2 = 0: OvNum = 0

DO
	T = QTGetTimer(1)
	L = (duration - T) \ 30
	IF t2 = 0 THEN
		READ duration2, OvNum2, effect
		IF OvNum2 <> OvNum AND OvNum2 <> 0 THEN
			REDIM Pic2(0 TO Overlay(OvNum2).Width - 1, 0 TO Overlay(OvNum2).Height - 1)
			MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Overlay(OvNum2).Size, Overlay(OvNum2).XMSOffset
		END IF
		OvNum = OvNum2
		QTSetTimer 2, duration2
	END IF
	t2 = QTGetTimer(2)

	Rot = T / RotSpeed
	DO UNTIL Rot < 3.14159: Rot = Rot - 6.283: LOOP
	Zoom = COS(T / ZoomSpeed) * ZoomRange + ZoomDepth
	IF Zoom = 0 THEN Zoom = .1

	t1 = DOff + SIN(T / 1000) * 60
	IF version = 1 THEN
		xoff = 30
	ELSE
		xoff = 0
	END IF
	
	PalAdjust effect, t2, duration2, N()

	IF (effect AND 8) = 8 THEN randomrow = SIN((duration2 - t2) / 1600) * 10
		IF OvNum > 0 THEN
			IF (effect AND 512) = 512 THEN
				Fade = (duration2 - t2) / duration2
			ELSEIF (effect AND 1024) = 1024 THEN
				Fade = t2 / duration2
			ELSE
				Fade = 1
			END IF
			Fade1 = 1 - Fade
		END IF
	Y = 0: PicY = R2
	DO
		IF (effect AND 8) = 8 THEN
			YRow = (Y + INT(RND * randomrow) - randomrow \ 2) * 640 + R
		ELSE
			YRow = Y * 640 + R
		END IF
		IF version = 1 THEN
			Y160 = Y + 800
		ELSE
			Y160 = t1 + Y * 160
		END IF
		X2 = YRow: X = 0: PicX = 0
		DO
			DEF SEG = DS
			Dist = PEEK(X + xoff + Y160)
			'Dist = SQR(((Y - 50) ^ 2) + ((X - 80) ^ 2))
			DEF SEG = &HA000

			'ang = (ATan(X, Y) + Rot) * 100
			ang! = (ATan(X, Y) + Rot)
			X1 = COS(ang!) * Dist / Zoom
			Y1 = SIN(ang!) * Dist / Zoom
			'X1 = Cosine(ang) * Dist / Zoom
			'Y1 = Sine(ang) * Dist / Zoom
			C = Pic((X1 + 256) AND 15, (Y1 + 256) AND 15)
			C1 = C: C2 = C
			IF OvNum > 0 THEN
				IF PicY >= Overlay(OvNum).Y AND PicX >= Overlay(OvNum).X AND PicY < Overlay(OvNum).Y + Overlay(OvNum).Height AND PicX < Overlay(OvNum).X + Overlay(OvNum).Width THEN
					A = Pic2(PicX - Overlay(OvNum).X, PicY - Overlay(OvNum).Y)
					B = Pic2(PicX - Overlay(OvNum).X + 1, PicY - Overlay(OvNum).Y)
					IF A <> 0 THEN C1 = C * Fade1 + A * Fade
					IF B <> 0 THEN C2 = C * Fade1 + B * Fade
				END IF
			END IF
			POKE X2, C1: POKE X2 + 1, C2
			X2 = X2 + 2: X = X + 1: PicX = PicX + 2
		LOOP UNTIL X = 160
		Y = Y + 1: PicY = PicY + 2
	LOOP UNTIL Y > 99
	R = R XOR 320
	R2 = R2 XOR 1
	'L = L + 1
LOOP UNTIL INKEY$ = CHR$(27) OR T = 0
END SUB

' *** TUNNEL ***
SUB Tunnel (BYVAL duration, BYVAL TunType, BYVAL TunTexture, BYVAL RotSpeed, BYVAL RotRange, BYVAL script)
DIM texture(0 TO 63, 0 TO 63)
IF TunTexture >= 0 THEN MoveFromXMS XMSItem(1).Handle, VARSEG(texture(0, 0)), VARPTR(texture(0, 0)), XMSItem(1).Size, TunTexture * XMSItem(1).Size
DIM tx(0 TO 159, 0 TO 99)
MoveFromXMS XMSItem(6).Handle, VARSEG(tx(0, 0)), VARPTR(tx(0, 0)), XMSItem(6).Size, TunType * XMSItem(6).Size
DIM ty(0 TO 159, 0 TO 99)
MoveFromXMS XMSItem(7).Handle, VARSEG(ty(0, 0)), VARPTR(ty(0, 0)), XMSItem(7).Size, TunType * XMSItem(7).Size
DIM shade(0 TO 79, 0 TO 49) AS SINGLE
MoveFromXMS XMSItem(8).Handle, VARSEG(shade(0, 0)), VARPTR(shade(0, 0)), XMSItem(8).Size, 0
'Dim Pic2(0 TO 149, 0 TO 49)
'MoveFromXMS XMSItem(5).Handle, Varseg(Pic2(0, 0)), Varptr(Pic2(0, 0)), XMSItem(5).Size, 0
DIM noise(0 TO 9, 0 TO 319)
MoveFromXMS XMSItem(9).Handle, VARSEG(noise(0, 0)), VARPTR(noise(0, 0)), XMSItem(9).Size, 0

DIM N(3) AS DOUBLE
FOR M = 1 TO 3: N(M) = 1: NEXT
DIM YRow AS LONG
DIM Fade AS SINGLE, Fade1 AS SINGLE
DEF SEG = &HA000

	SELECT CASE script
	CASE 1: RESTORE tunneldata1
	CASE 2: RESTORE tunneldata2
	CASE 3: RESTORE tunneldata3
	CASE 4: RESTORE tunneldata4
	CASE 5: RESTORE tunneldata5
	END SELECT
	
	'palette
	OUT &H3C8, 0
	FOR L = 1 TO 63: FOR M = 1 TO 3: OUT &H3C9, L: NEXT M, L
	FOR L = 1 TO 13: FOR M = 1 TO 3: OUT &H3C9, 63: NEXT M, L

	L = 0: R = 0: t2 = 0: OvNum = 0
	
	QTSetTimer 1, duration

	DO
		T = QTGetTimer(1)
		IF t2 = 0 THEN
			READ duration2, Speed, OvNum2, effect
			IF OvNum2 <> OvNum AND OvNum2 <> 0 THEN
				REDIM Pic2(0 TO Overlay(OvNum2).Width - 1, 0 TO Overlay(OvNum2).Height - 1)
				MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Overlay(OvNum2).Size, Overlay(OvNum2).XMSOffset
			END IF
			OvNum = OvNum2
			QTSetTimer 2, duration2
		END IF
		t2 = QTGetTimer(2)
		L = ((duration - T) \ 30) * Speed
		
		rotate = SIN(T / (RotSpeed * 50)) * RotRange + RotRange
		sinx = 0: siny = 0: screenoffset = 0
		IF (effect AND 8) = 8 THEN randomrow = SIN((duration2 - t2) / 1600) * 10
		IF (effect AND 32) = 32 THEN screenoffset = SIN(L / 16) * 320 + 0
		IF (effect AND 16) = 16 THEN sincol! = SIN(L / 16) * 30
		rowoffset = 0
		IF OvNum > 0 THEN
			IF (effect AND 512) = 512 THEN
				Fade = (duration2 - t2) / duration2
			ELSEIF (effect AND 1024) = 1024 THEN
				Fade = t2 / duration2
			ELSE
				Fade = 1
			END IF
			Fade1 = 1 - Fade
		END IF
		'Fade = SIN(T / 1000) / 2 + .5
		
		IF TunTexture = -1 THEN
			' plasma
			Div! = SIN(T / 1000) * 3 + 10
			FOR Y = 0 TO 63
				Y1! = SIN((Y + T / 1000) / 20)
				Y2! = SIN(Y / Div!) / 2
				FOR X = 0 TO 63
					A = (SIN(X / 16) + Y1! + SIN(X / Div!) / 2 + Y2! + SIN((X / 2 + Y) / 15)) * 7 + 14
					B = ((A + L) MOD 40)
					texture(X, Y) = B
			NEXT X, Y
		END IF

		PalAdjust effect, t2, duration2, N()

		FOR Y = 0 TO 99
			IF (effect AND 8) = 8 THEN
				YRow = (Y + INT(RND * randomrow) - randomrow \ 2) * 640 + R
			ELSE
				YRow = Y * 640 + R + screenoffset
			END IF
			Y2 = Y \ 2
			PicY = Y * 2 + R2
			X2 = rowoffset: X3 = 0: half = 1
			
			IF (effect AND 1) = 1 THEN sinx = SIN(Y / 4) * 4
			IF (effect AND 2) = 2 THEN siny = SIN(Y / 5) * 6
			IF (effect AND 16) = 16 THEN rowoffset = SIN((Y + L) / 10) * sincol!
			IF (effect AND 4) = 4 THEN
				IF rotate MOD 2 = 0 THEN noiserow = RND * 10 ELSE noiserow = 0
				FOR X = 0 TO 159
					tex = texture((tx(X, Y) - rotate - sinx) AND 63, (ty(X, Y) - L - siny) AND 63) * shade(X3, Y2)
					POKE X2 + YRow, tex + noise(noiserow, X2)
					POKE X2 + 1 + YRow, tex + noise(noiserow, X2 + 1)
					X2 = X2 + 2: half = half XOR 1: X3 = X3 + half
				NEXT X
			ELSEIF TunTexture = -1 THEN
				' no shading or overlays - for plasma
				FOR X = 0 TO 159
					tex = texture((tx(X, Y) - rotate - sinx) AND 63, (ty(X, Y) - L - siny) AND 63) + 130
					POKE X2 + YRow, tex
					POKE X2 + 1 + YRow, tex
					X2 = X2 + 2
				NEXT X
			ELSE
				FOR X = 0 TO 159
					tex = texture((tx(X, Y) - rotate - sinx) AND 63, (ty(X, Y) - L - siny) AND 63) * shade(X3, Y2)
					tex1 = tex: tex2 = tex
					IF OvNum > 0 THEN
						IF PicY >= Overlay(OvNum).Y AND X2 >= Overlay(OvNum).X AND PicY < Overlay(OvNum).Y + Overlay(OvNum).Height AND X2 < Overlay(OvNum).X + Overlay(OvNum).Width THEN
							A = Pic2(X * 2 - Overlay(OvNum).X, PicY - Overlay(OvNum).Y)
							B = Pic2(X * 2 - Overlay(OvNum).X + 1, PicY - Overlay(OvNum).Y)
							IF A <> 0 THEN tex1 = tex * Fade1 + A * Fade
							IF B <> 0 THEN tex2 = tex * Fade1 + B * Fade
						END IF
					END IF
					
					POKE X2 + YRow, tex1
					POKE X2 + 1 + YRow, tex2
					X2 = X2 + 2: half = half XOR 1: X3 = X3 + half
				NEXT X
			END IF
		NEXT Y
			
		'L = L + Speed
		R = R XOR 320
		R2 = R2 XOR 1
	LOOP UNTIL LEN(INKEY$) OR T = 0
END SUB

' *** OVERSIZED TUNNEL ***
SUB Tunnel2 (BYVAL duration, BYVAL TunType, BYVAL TunTexture, BYVAL RotSpeed, BYVAL RotRange, BYVAL script)
DIM texture(0 TO 63, 0 TO 63)
IF TunTexture >= 0 THEN MoveFromXMS XMSItem(1).Handle, VARSEG(texture(0, 0)), VARPTR(texture(0, 0)), XMSItem(1).Size, TunTexture * XMSItem(1).Size
DIM tx(0 TO 239, 0 TO 149) AS STRING * 1
MoveFromXMS XMSItem(2).Handle, VARSEG(tx(0, 0)), VARPTR(tx(0, 0)), XMSItem(2).Size, TunType * XMSItem(2).Size
DIM ty(0 TO 239, 0 TO 149) AS STRING * 1
MoveFromXMS XMSItem(3).Handle, VARSEG(ty(0, 0)), VARPTR(ty(0, 0)), XMSItem(3).Size, TunType * XMSItem(3).Size
DIM shade(0 TO 119, 0 TO 74) AS SINGLE
MoveFromXMS XMSItem(4).Handle, VARSEG(shade(0, 0)), VARPTR(shade(0, 0)), XMSItem(4).Size, 0
DIM Pic2(0 TO 149, 0 TO 49)
MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), XMSItem(5).Size, 0
DIM N(3) AS DOUBLE
FOR M = 1 TO 3: N(M) = 1: NEXT
DIM YRow AS LONG
DIM Fade AS SINGLE, Fade1 AS SINGLE
DIM tx1 AS INTEGER, ty1 AS INTEGER
DEF SEG = &HA000
SELECT CASE script
CASE 1: RESTORE tunnel2data1
CASE 2: RESTORE tunnel2data2
CASE 3: RESTORE tunnel2data3
END SELECT

'palette
OUT &H3C8, 0
FOR L = 1 TO 63: FOR M = 1 TO 3: OUT &H3C9, L: NEXT M, L
FOR L = 1 TO 13: FOR M = 1 TO 3: OUT &H3C9, 63: NEXT M, L

TXS = VARSEG(tx(0, 0)): TYS = VARSEG(ty(0, 0))
TXO = VARPTR(tx(0, 0)): TYO = VARPTR(ty(0, 0))

L = 0: R = 0: t2 = 0: OvNum = 0
QTSetTimer 1, duration
DO
	T = QTGetTimer(1)
	L = ((duration - T) \ 30) * Speed
		IF t2 = 0 THEN
			READ duration2, Speed, OvNum2, effect
			IF OvNum2 <> OvNum AND OvNum2 <> 0 THEN
				REDIM Pic2(0 TO Overlay(OvNum2).Width - 1, 0 TO Overlay(OvNum2).Height - 1)
				MoveFromXMS XMSItem(5).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), Overlay(OvNum2).Size, Overlay(OvNum2).XMSOffset
			END IF
			OvNum = OvNum2
			QTSetTimer 2, duration2
		END IF
		t2 = QTGetTimer(2)

	rotate = SIN(L / RotSpeed) * RotRange + RotRange
	sinx = 0: siny = 0: screenoffset = 0
	xt = COS(L / 17) * 40 + 40
	yt = SIN(L / 17) * 25 + 25
	IF (effect AND 8) = 8 THEN randomrow = SIN((duration2 - t2) / 1600) * 10
	IF (effect AND 32) = 32 THEN screenoffset = SIN(L / 16) * 320 + 0
	IF (effect AND 16) = 16 THEN sincol! = SIN(L / 16) * 30
	rowoffset = 0
		IF OvNum > 0 THEN
			IF (effect AND 512) = 512 THEN
				Fade = (duration2 - t2) / duration2
			ELSEIF (effect AND 1024) = 1024 THEN
				Fade = t2 / duration2
			ELSE
				Fade = 1
			END IF
			Fade1 = 1 - Fade
		END IF
	
		IF TunTexture = -1 THEN
			' plasma
			Div! = SIN(T / 1000) * 3 + 10
			FOR Y = 0 TO 63
				Y1! = SIN((Y + T / 1000) / 20)
				Y2! = SIN(Y / Div!) / 2
				FOR X = 0 TO 63
					A = (SIN(X / 16) + Y1! + SIN(X / Div!) / 2 + Y2! + SIN((X / 2 + Y) / 15)) * 7 + 14
					B = ((A + L) MOD 40)
					texture(X, Y) = B
			NEXT X, Y
		END IF

		PalAdjust effect, t2, duration2, N()
	
	FOR Y = 0 TO 99
		Y3 = Y + yt
		IF (effect AND 8) = 8 THEN
			YRow = (Y + INT(RND * randomrow) - randomrow \ 2) * 640 + R
		ELSE
			YRow = Y * 640 + R + screenoffset
		END IF
		Y2 = Y3 \ 2
		Y240 = Y3 * 240
		PicY = Y * 2 + R2
		IF (effect AND 1) = 1 THEN sinx = SIN(Y / 4) * 4
		IF (effect AND 2) = 2 THEN siny = SIN(Y / 5) * 6
		IF (effect AND 16) = 16 THEN rowoffset = SIN((Y + L) / 10) * sincol!
		xpeek = TXO + xt + Y240
		ypeek = TYO + xt + Y240
		X2 = rowoffset
		X3 = xt \ 2: half = 0
		FOR X = 0 TO 159
			IF TunTexture = -1 THEN
				' no shading or overlays - for plasma
				IF (effect AND 4) <> 4 THEN DEF SEG = TXS   ' skip def seg, get cool noise shit :)
				tx1 = PEEK(xpeek)
				DEF SEG = TYS
				ty1 = PEEK(ypeek)
				tex = texture((tx1 - rotate - sinx) AND 63, (ty1 - L - siny) AND 63) + 130
				DEF SEG = &HA000
				POKE X2 + YRow, tex
				POKE X2 + 1 + YRow, tex
				xpeek = xpeek + 1: ypeek = ypeek + 1: X2 = X2 + 2
			ELSE

				IF (effect AND 4) <> 4 THEN DEF SEG = TXS   ' skip def seg, get cool noise shit :)
				tx1 = PEEK(xpeek)
				DEF SEG = TYS
				ty1 = PEEK(ypeek)
				tex = texture((tx1 - rotate - sinx) AND 63, (ty1 - L - siny) AND 63) * shade(X3, Y2)
				tex1 = tex: tex2 = tex
				IF OvNum > 0 THEN
					IF PicY >= Overlay(OvNum).Y AND X2 >= Overlay(OvNum).X AND PicY < Overlay(OvNum).Y + Overlay(OvNum).Height AND X2 < Overlay(OvNum).X + Overlay(OvNum).Width THEN
						A = Pic2(X * 2 - Overlay(OvNum).X, PicY - Overlay(OvNum).Y)
						B = Pic2(X * 2 - Overlay(OvNum).X + 1, PicY - Overlay(OvNum).Y)
						IF A <> 0 THEN tex1 = tex * Fade1 + A * Fade
						IF B <> 0 THEN tex2 = tex * Fade1 + B * Fade
					END IF
				END IF
				DEF SEG = &HA000
				POKE X2 + YRow, tex1
				POKE X2 + 1 + YRow, tex2
				half = half XOR 1
				xpeek = xpeek + 1: ypeek = ypeek + 1: X2 = X2 + 2: X3 = X3 + half
			END IF
		NEXT X
	NEXT Y
		
	'L = L + Speed
	R = R XOR 320
	R2 = R2 XOR 1
LOOP UNTIL LEN(INKEY$) OR T = 0
END SUB

' *** WOLF 3D ***
SUB W3D (BYVAL duration, BYVAL background, BYVAL reverse, BYVAL shaded, BYVAL script)
CONST XDIM = 320&, YDIM = 200&, PI = 3.14159265358979#
DIM BlankScr(0 TO 319, 0 TO 199) AS STRING * 1
BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))
DIM N(3) AS DOUBLE
DIM rowoffset(0 TO YDIM - 1)

SELECT CASE script
CASE 1: RESTORE w3ddata1
CASE 2: RESTORE w3ddata2
CASE 3: RESTORE w3ddata3
CASE 4: RESTORE w3ddata4
END SELECT

DIM VirtScr(0 TO 319, 0 TO 199) AS STRING * 1
VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))
DEF SEG = VS
'DEF SEG = &HB000
'RANDOMIZE TIMER
hval = 128 'Square aspect is actually XDIM*.5, but I think 128 looks nicer

OUT &H3C8, 0  'Make palette
IF reverse = 0 THEN
	FOR X = 1 TO 63: OUT &H3C9, X: OUT &H3C9, X: OUT &H3C9, X: NEXT X
ELSE
	FOR X = 1 TO 63: OUT &H3C9, 63 - X: OUT &H3C9, 63 - X: OUT &H3C9, 63 - X: NEXT X
END IF

DIM Pic(0 TO 64 * 64 * 4 - 1), board(0 TO 63, 0 TO 63)
MoveFromXMS XMSItem(13).Handle, VARSEG(Pic(0)), VARPTR(Pic(0)), XMSItem(13).Size, 0
MoveFromXMS XMSItem(14).Handle, VARSEG(board(0, 0)), VARPTR(board(0, 0)), XMSItem(14).Size, 0
MoveFromXMS XMSItem(15).Handle, BS, BO, XMSItem(15).Size, background * XMSItem(15).Size
DIM Pic2(0 TO 31, 0 TO 31) ' rotozoom pic
MoveFromXMS XMSItem(10).Handle, VARSEG(Pic2(0, 0)), VARPTR(Pic2(0, 0)), XMSItem(10).Size, 0

'Since the 2D board map is 64*64, posx# and posy# range from 0-64
'posz# ranges from -.5 to .5 (0 is the middle)

IF Interactive = 1 THEN
	posx# = 32: posy# = 32: posz# = 0: ang# = 0
ELSE
	READ posx#, posy#, posz#, ang#
END IF
oldang# = ang#
QTSetTimer 1, duration
t2 = duration: t1 = duration
shade# = 1

FOR M = 1 TO 3: N(M) = 1: NEXT
DO
	T = QTGetTimer(1)
	L = (duration - T) \ 30
	CALL BlockMove(BS, BO, VS, VO, 64000, 0)

	fisheye# = 1: screenoffset& = 0

	IF (effect AND 16) = 16 THEN
		sincol! = SIN(L / 16) * 10
		FOR Y = 0 TO YDIM - 1: rowoffset(Y) = SIN((Y + L) / 10) * sincol!: NEXT Y
	END IF
	IF (effect AND 32) = 32 THEN screenoffset& = INT(SIN(L / 10) * 200) * 320

	cosang# = COS(ang#)
	sinang# = SIN(ang#)
	vxinc# = sinang# * -2# / XDIM: vx# = cosang# + sinang# + vxinc# * .5
	vyinc# = cosang# * 2# / XDIM: vy# = sinang# - cosang# + vyinc# * .5

	IF (effect AND 2) = 2 THEN
		' wall effect - plasma
		M = M + 1
		Div! = COS(T / 300) * 2 + 8
		FOR X = 0 TO 63
			X1! = SIN(X / 10)
			X2! = SIN(X / Div!) / 2
			XRow = X * 64 + 12288
			FOR Y = 0 TO 63
				A = (X1! + SIN(Y / 10) + X2! + SIN(Y / Div!) / 2) * 10 + 16
				B = ((A + M) MOD 40) + 130
				Pic(XRow + Y) = B
				Pic(XRow + Y + 1) = B
		NEXT Y, X
	END IF
	IF (effect AND 4) = 4 THEN
		' wall effect - rotozoom
		ARZ! = T / 1200
		CARZ! = COS(ARZ!): SARZ! = SIN(ARZ!)
		FOR X = 0 TO 63
			CX! = CARZ! * X
			sx! = SARZ! * X
			XRow = X * 64 + 8192
			FOR Y = 0 TO 63
				Pic(XRow + Y) = Pic2((CX! + SARZ! * Y) AND 31, (sx! - CARZ! * Y) AND 31)
		NEXT Y, X
	END IF
	IF (effect AND 8) = 8 THEN
		' wall effect - tv
		DEF SEG = &HA000
		FOR X = 6 TO 58
			XRow = X * 64 + 4096
			FOR Y = 6 TO 58
				Pic(XRow + Y) = PEEK(X * 5 + Y * 3 * 320)
		NEXT Y, X
		DEF SEG = VS
	END IF
	
	PalAdjust effect, T - (t2 - duration2), duration2, N()
	
	FOR sx = 0 TO XDIM - 1
		IF (effect AND 1) = 1 THEN
			fisheye# = (SIN(sx / 102) + .3) * 1.25
			vxinc# = (sinang# * -2# / XDIM) / fisheye#
			vyinc# = (cosang# * 2# / XDIM) / fisheye#
		END IF
		
		'Raytrace in 2D to see what block is hit, and where it gets hit
		xscan = INT(posx#): xdir = SGN(vx#): incx# = ABS(vx#)
		yscan = INT(posy#): ydir = SGN(vy#): incy# = ABS(vy#)
		xtemp# = posx# - xscan: IF xdir > 0 THEN xtemp# = 1 - xtemp#
		ytemp# = posy# - yscan: IF ydir > 0 THEN ytemp# = 1 - ytemp#
		D# = xtemp# * incy# - ytemp# * incx#
		DO
			IF D# < 0 THEN
				xscan = xscan + xdir
				IF board(xscan, yscan) THEN
					hx# = xscan: IF xdir < 0 THEN hx# = hx# + 1
					hy# = posy# + vy# * (hx# - posx#) / vx#
					bx = INT((hy# - INT(hy#)) * 64)
					IF xdir < 0 THEN bx = 63 - bx
					EXIT DO
				END IF
				D# = D# + incy#
			ELSE
				yscan = yscan + ydir
				IF board(xscan, yscan) THEN
					hy# = yscan: IF ydir < 0 THEN hy# = hy# + 1
					hx# = posx# + vx# * (hy# - posy#) / vy#
					bx = INT((hx# - INT(hx#)) * 64)
					IF ydir > 0 THEN bx = 63 - bx
					EXIT DO
				END IF
				D# = D# - incx#
			END IF
		LOOP
		Dist# = (cosang# * (hx# - posx#) + sinang# * (hy# - posy#)) / fisheye#
	  
		'Find the ceiling & floor borders, and the texture mapping equation
		IF Dist# > 1# / 64# THEN
			sy1 = INT(YDIM \ 2 + (-posz# - .5) * hval / Dist#)
			sy2 = INT(YDIM \ 2 + (-posz# + .5) * hval / Dist#)
			IF sy1 < 0 THEN sy1 = 0
			IF sy2 > YDIM THEN sy2 = YDIM
			byi& = INT(Dist# * 65536# * 64# / hval)
			by& = (sy1 + 1 - YDIM \ 2) * byi& + (posz# + .5) * 65536# * 64# - 1
			by& = by& + ((board(xscan, yscan) - 1) * 4096& + bx * 64&) * 65536

		ELSE
			sy1 = YDIM \ 2: sy2 = sy1
		END IF
		  
		IF shaded <> 0 THEN
			shade# = Dist# / 3
			IF shade# < 1 THEN shade# = 1
		END IF

		'Draw vertical line at column sx:
		p& = XDIM * sy1 + sx: p2& = XDIM * (sy2 - 1) + sx
		
		IF (effect AND 16) = 16 THEN
			row = sy1
			DO WHILE p& < p2&
				p& = XDIM * row + rowoffset(row) + sx
				POKE p&, Pic(by& / 65536) / shade#
				row = row + 1
				by& = by& + byi&
			LOOP
		ELSE
			DO WHILE p& < p2&
				POKE p&, Pic(by& / 65536) / shade#
				p& = p& + XDIM: by& = by& + byi&
			LOOP
		END IF
		vx# = vx# + vxinc#
		vy# = vy# + vyinc#
	NEXT sx

	'Flip page
	CALL BlockMove(VS, VO, &HA000, screenoffset&, 64000, 0)

	IF Interactive = 0 THEN

		IF t2 - T >= duration2 THEN
			ang# = oldang# + rottrans#
			READ duration2, fwdtrans!, sidetrans!, rottrans#, heighttrans!, effect
			oldang# = ang#
			t2 = T
		END IF

		elapsed# = (t1 - T) / duration2
		posx# = posx# + cosang# * fwdtrans! * elapsed#
		posy# = posy# + sinang# * fwdtrans! * elapsed#
		posx# = posx# - sinang# * sidetrans! * elapsed#
		posy# = posy# + cosang# * sidetrans! * elapsed#
		posz# = posz# + heighttrans! * elapsed#
		ang# = ang# + rottrans# * elapsed#
	ELSE
		SELECT CASE I$
			CASE CHR$(0) + CHR$(72)
				 IF board(INT(posx# + cosang# * .4), INT(posy# + sinang# * .4)) = 0 THEN
					posx# = posx# + cosang# * .4
					posy# = posy# + sinang# * .4
				 END IF
			CASE CHR$(0) + CHR$(75)
				 ang# = ang# - .2
			CASE CHR$(0) + CHR$(77)
				 ang# = ang# + .2
			CASE CHR$(0) + CHR$(155), CHR$(4)
				 IF board(INT(posx# + sinang# * .4), INT(posy# - cosang# * .4)) = 0 THEN
					posx# = posx# + sinang# * .4
					posy# = posy# - cosang# * .4
				 END IF
			CASE CHR$(0) + CHR$(157), CHR$(6)
				 IF board(INT(posx# - sinang# * .4), INT(posy# + cosang# * .4)) = 0 THEN
					posx# = posx# - sinang# * .4
					posy# = posy# + cosang# * .4
				 END IF
			CASE CHR$(0) + CHR$(80)
				 IF board(INT(posx# - cosang# * .4), INT(posy# - sinang# * .4)) = 0 THEN
					posx# = posx# - cosang# * .4
					posy# = posy# - sinang# * .4
				 END IF
			CASE CHR$(0) + CHR$(73)
				posz# = posz# - .1
			CASE CHR$(0) + CHR$(81)
				posz# = posz# + .1
			CASE CHR$(27)
				EXIT DO
			CASE "1": effect = effect XOR 1
			CASE "2": effect = effect XOR 2
			CASE "3": effect = effect XOR 4
			CASE "4": effect = effect XOR 8
			CASE "5": effect = effect XOR 16
			CASE "6": effect = effect XOR 32
			CASE "7": effect = effect XOR 64
			CASE "8": effect = effect XOR 128
			CASE CHR$(0) + CHR$(59)
				MoveFromXMS XMSItem(15).Handle, BS, BO, XMSItem(15).Size, 0
			CASE CHR$(0) + CHR$(60)
				MoveFromXMS XMSItem(15).Handle, BS, BO, XMSItem(15).Size, 1 * XMSItem(15).Size
			CASE CHR$(0) + CHR$(61)
				MoveFromXMS XMSItem(15).Handle, BS, BO, XMSItem(15).Size, 2 * XMSItem(15).Size
			CASE CHR$(0) + CHR$(62)
				MoveFromXMS XMSItem(15).Handle, BS, BO, XMSItem(15).Size, 3 * XMSItem(15).Size
			END SELECT
			IF T = 0 THEN QTSetTimer 1, 32000: T = 32000
	END IF
	
	'Don't let your view escape the board
	IF posx# < 1.25 THEN posx# = 1.25
	IF posy# < 1.25 THEN posy# = 1.25
	IF posx# > 62.75 THEN posx# = 62.75
	IF posy# > 62.75 THEN posy# = 62.75
	IF posz# < -.5 THEN posz# = -.5
	IF posz# > .5 THEN posz# = .5

	'L = L + 1
	t1 = T
	I$ = INKEY$
LOOP UNTIL I$ = CHR$(27) OR T = 0
END SUB

' *** WOLF3D interlaced ***
SUB W3Di (BYVAL duration, BYVAL reverse, BYVAL shaded, BYVAL script)

CONST XDIM = 320&, YDIM = 200&, PI = 3.14159265358979#
DIM N(3) AS DOUBLE

SELECT CASE script
CASE 1: RESTORE w3didata1
CASE 2: RESTORE w3didata2
CASE 3: RESTORE w3didata3
CASE 4: RESTORE w3didata4
CASE 5: RESTORE w3didata5
END SELECT

DEF SEG = &HA000
hval = 128 'Square aspect is actually XDIM*.5, but I think 128 looks nicer

OUT &H3C8, 0

IF reverse = 0 THEN
	FOR X = 1 TO 63: OUT &H3C9, X: OUT &H3C9, X: OUT &H3C9, X: NEXT X
	FOR X = 0 TO 63: OUT &H3C9, X / 1.2: OUT &H3C9, X / 1.2: OUT &H3C9, X: NEXT X
ELSE
	FOR X = 1 TO 63: OUT &H3C9, 63 - X: OUT &H3C9, 63 - X: OUT &H3C9, 63 - X: NEXT X
	FOR X = 0 TO 63: OUT &H3C9, 63 - X / 1.2: OUT &H3C9, 63 - X / 1.2: OUT &H3C9, 63 - X: NEXT X
END IF

DIM Pic(0 TO 64 * 64 * 4 - 1), board(0 TO 63, 0 TO 63)
MoveFromXMS XMSItem(13).Handle, VARSEG(Pic(0)), VARPTR(Pic(0)), XMSItem(13).Size, XMSItem(13).Size
MoveFromXMS XMSItem(14).Handle, VARSEG(board(0, 0)), VARPTR(board(0, 0)), XMSItem(14).Size, 0

READ posx#, posy#, posz#, ang#
xint = 0: shade# = 1
oldang# = ang#
QTSetTimer 1, duration
t1 = duration: t2 = duration
FOR M = 1 TO 3: N(M) = 1: NEXT
DO
	T = QTGetTimer(1)
	L = (duration - T) \ 30
	fisheye# = 1
	
	cosang# = COS(ang#)
	sinang# = SIN(ang#)
	vxinc# = sinang# * -4# / XDIM: vx# = cosang# + sinang# + vxinc# * .5
	vyinc# = cosang# * 4# / XDIM: vy# = sinang# - cosang# + vyinc# * .5
	
	PalAdjust effect, duration2 - (t2 - T), duration2, N()
	
	FOR sx = 0 + xint TO XDIM - 2 + xint STEP 2
		IF (effect AND 1) = 1 THEN
			fisheye# = (SIN(sx / 102) + .3) * 1.25
			vxinc# = (sinang# * -4# / XDIM) / fisheye#
			vyinc# = (cosang# * 4# / XDIM) / fisheye#
		END IF
		
		'Raytrace in 2D to see what block is hit, and where it gets hit
		xscan = INT(posx#): xdir = SGN(vx#): incx# = ABS(vx#)
		yscan = INT(posy#): ydir = SGN(vy#): incy# = ABS(vy#)
		xtemp# = posx# - xscan: IF xdir > 0 THEN xtemp# = 1 - xtemp#
		ytemp# = posy# - yscan: IF ydir > 0 THEN ytemp# = 1 - ytemp#
		D# = xtemp# * incy# - ytemp# * incx#
		DO
			IF D# < 0 THEN
				xscan = xscan + xdir
				IF board(xscan, yscan) THEN
					hx# = xscan: IF xdir < 0 THEN hx# = hx# + 1
					hy# = posy# + vy# * (hx# - posx#) / vx#
					bx = INT((hy# - INT(hy#)) * 64)
					IF xdir < 0 THEN bx = 63 - bx
					EXIT DO
				END IF
				D# = D# + incy#
			ELSE
				yscan = yscan + ydir
				IF board(xscan, yscan) THEN
					hy# = yscan: IF ydir < 0 THEN hy# = hy# + 1
					hx# = posx# + vx# * (hy# - posy#) / vy#
					bx = INT((hx# - INT(hx#)) * 64)
					IF ydir > 0 THEN bx = 63 - bx
					EXIT DO
				END IF
				D# = D# - incx#
			END IF
		LOOP
		Dist# = (cosang# * (hx# - posx#) + sinang# * (hy# - posy#)) / fisheye#
	  
		'Find the ceiling & floor borders, and the texture mapping equation
		IF Dist# > 1# / 64# THEN
			sy1 = INT(YDIM \ 2 + (-posz# - .5) * hval / Dist#)
			sy2 = INT(YDIM \ 2 + (-posz# + .5) * hval / Dist#)
			IF sy1 < 0 THEN sy1 = 0
			IF sy2 > YDIM THEN sy2 = YDIM
			byi& = INT(Dist# * 65536# * 64# / hval)
			by& = (sy1 + 1 - YDIM \ 2) * byi& + (posz# + .5) * 65536# * 64# - 1
			by& = by& + ((board(xscan, yscan) - 1) * 4096& + bx * 64&) * 65536

		ELSE
			sy1 = YDIM \ 2: sy2 = sy1
		END IF
		  
		IF shaded <> 0 THEN
			shade# = Dist# / 3
			IF shade# < 1 THEN shade# = 1
		END IF
		
		'Draw vertical line at column sx:
		p& = sx: row = 0
		p1& = XDIM * sy1 + sx: p2& = XDIM * (sy2 - 1) + sx: pe& = 64000
		
		rowp = 0
		DO WHILE p& < p1&: row = row + 1: POKE p&, 50 - row \ 2: p& = p& + XDIM: LOOP 'Ceilings
		IF (effect AND 2) = 2 THEN   'with reflection
			pr& = p2& + (p2& - p1&)
			DO WHILE p& < p2&
				A = Pic(by& / 65536) / shade#
				POKE p&, A
				IF pr& < pe& THEN POKE pr&, A + 64
				p& = p& + XDIM: by& = by& + byi&
				pr& = pr& - XDIM
				row = row + 1
			LOOP
			p& = p& + (p2& - p1&)
			row = row + (sy2 - sy1) - 100
			DO WHILE p& < pe&: row = row + 1: POKE p&, row \ 4 + 64: p& = p& + XDIM: LOOP 'Floors
		ELSE
			DO WHILE p& < p2&
				POKE p&, Pic(by& / 65536) / shade#
				p& = p& + XDIM: by& = by& + byi&
				row = row + 1
			LOOP
			IF (effect AND 4) = 4 THEN row = 100  ' false reflection/shadow
			DO WHILE p& < pe&: POKE p&, row \ 2 - 50: row = row + 1: p& = p& + XDIM: LOOP 'Floors
		END IF

		vx# = vx# + vxinc#
		vy# = vy# + vyinc#
	NEXT sx

	IF t2 - T >= duration2 THEN
			ang# = oldang# + rottrans#
			READ duration2, fwdtrans!, sidetrans!, rottrans#, heighttrans!, effect
			oldang# = ang#
		t2 = T
	END IF
	
	elapsed# = (t1 - T) / duration2
	posx# = posx# + cosang# * fwdtrans! * elapsed#
	posy# = posy# + sinang# * fwdtrans! * elapsed#
	posx# = posx# - sinang# * sidetrans! * elapsed#
	posy# = posy# + cosang# * sidetrans! * elapsed#
	posz# = posz# + heighttrans! * elapsed#
	ang# = ang# + rottrans# * elapsed#

	'Don't let your view escape the board
	IF posx# < 1.25 THEN posx# = 1.25
	IF posy# < 1.25 THEN posy# = 1.25
	IF posx# > 62.75 THEN posx# = 62.75
	IF posy# > 62.75 THEN posy# = 62.75
	IF posz# < -.5 THEN posz# = -.5
	IF posz# > .5 THEN posz# = .5

	'L = L + 1
	t1 = T
	
	xint = xint XOR 1
LOOP UNTIL INKEY$ = CHR$(27) OR T = 0
END SUB

