'$DYNAMIC
'$INCLUDE: 'QBX.BI'
'$INCLUDE: 'BWSB\INCLUDE\BWSB.BI'
'$INCLUDE: 'BWSB\INCLUDE\GDMTYPE.BI'
DEFINT A-Z
DEFSNG J
OPTION BASE 1
TYPE ImageType
	ImageName AS STRING * 8
	Title AS STRING * 20
	Width AS LONG
	Height AS LONG
	Size AS LONG
	Colors AS INTEGER
	Segment AS INTEGER
	Offset AS INTEGER
	XMSOffset AS LONG
	X AS INTEGER
	Y AS INTEGER
	Palett(0 TO 255, 1 TO 3) AS INTEGER
	points AS INTEGER
END TYPE
TYPE RGBType
	red AS INTEGER
	green AS INTEGER
	blue AS INTEGER
END TYPE

DECLARE SUB QTInit ()
DECLARE SUB QTSetTimer (BYVAL Channel, BYVAL Time)
DECLARE FUNCTION QTGetTimer (BYVAL Channel)
DECLARE SUB QTDelay (BYVAL Time)
DECLARE SUB QTDone ()
DECLARE SUB LineBres2 (BYVAL a, BYVAL B, BYVAL C, BYVAL D, BYVAL Col)
DECLARE SUB TriFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, BYVAL Col)
DECLARE SUB TriFill2 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, BYVAL Col)
DECLARE SUB TriTFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, BYVAL face, BYVAL ftex)
DECLARE SUB TriGFill (BYVAL X1, BYVAL Y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
DECLARE SUB Shellsort (Array(), Index())
DECLARE SUB PrintOneColumn (BYVAL X, BYVAL Y, BYVAL Char, BYVAL Column)
DECLARE SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS ImageType)
DECLARE FUNCTION min! (BYVAL a!, BYVAL B!)
DECLARE SUB HSL2RGB (BYVAL Hue, BYVAL S!, BYVAL L!)
DECLARE FUNCTION HSL2RGBf! (BYVAL N, BYVAL Hue, BYVAL S!, BYVAL L!)

DECLARE SUB ShowBMP (BMPFile$, PData AS ImageType, BYVAL X0, BYVAL Y0, BYVAL SetPal)
DECLARE SUB GetSoundCardInfo ()
DECLARE FUNCTION GetLibOffset& (File$)

TYPE LibHeaderType
	FileName AS STRING * 12
	Offset AS LONG
	Size AS LONG
END TYPE

CONST pi = 3.14159, MainVol = 20
CONST Lib$ = "EXCON.DAT"
S = 12
points = S * S: faces = S * S * 2: lines = S * S * 2
facediv = 6: gshade = 5
DIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points)
DIM F1(faces), F2(faces), F3(faces), fcolor(faces)
DIM L1(lines), L2(lines)
dots = 49 * 6
DIM Top(5), Bottom(5)
DIM Xd(dots) AS SINGLE, Yd(dots) AS SINGLE, Zd(dots) AS SINGLE, faced(dots)
DIM DXd(dots), DYd(dots)
DIM JZd(dots) AS SINGLE
DIM zavg(faces), zavgglz(24)
DIM fsort(faces), fsortglz(24)
DIM DX(points), DY(points)
DIM JZ(points) AS SINGLE
DIM facetex(faces)
DIM SHARED tex(6, 0 TO 63, 0 TO 63)
DIM SHARED tx1(faces), ty1(faces), tx2(faces), ty2(faces), tx3(faces), ty3(faces)

DIM xrot AS SINGLE, yrot AS SINGLE, zrot AS SINGLE
DIM cosx AS SINGLE, sinx AS SINGLE
DIM cosy AS SINGLE, siny AS SINGLE
DIM cosz AS SINGLE, sinz AS SINGLE
DIM camdist AS SINGLE
DIM SHARED Top, Bottom
DIM RGB AS RGBType
DIM PD AS ImageType

points = 14: faces = 12: lines = 12

' *** SOUND INIT ***
DIM ModHeader AS GDMHeader
DIM Flags AS INTEGER, MusChans AS INTEGER
DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12278: Device(3) = 22708: Device(4) = 33155: Device(5) = 44722: Device(6) = 56138
'DIM Device(6) AS LONG: Device(1) = 0: Device(2) = 12126: Device(3) = 22552: Device(4) = 32999: Device(5) = 44566: Device(6) = 55982
a& = SETMEM(-160000)   ' mem to free for BWSB - adjust as needed
'PRINT A&; "k base RAM free"
GetSoundCardInfo        ' gets Dev, Port, IRQ, & DMA
'ErrorFlag = LoadMSE("SOUND.DAT", Device(Dev), 45, 4096, Port, IRQ, DMA)
ErrorFlag = LoadMSE(Lib$, GetLibOffset("SOUND.DAT") - 1 + Device(Dev), 45, 4096, Port, IRQ, DMA)
ERASE Device
Flags = EmsExist AND 1
IF Dev > 1 AND Flags = 0 THEN
	PRINT "EMS is required for a non-GUS soundcard.": END
END IF

' ** MUSIC LOAD **
PRINT "Loading music"
'OPEN "dcplus.gdm" FOR BINARY AS 1
OPEN Lib$ FOR BINARY AS 1
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
LoadGDM FILEATTR(1, 2), GetLibOffset("DCPLUS.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 0
FOR L = 1 TO 32                  'Scan for used music channels
	IF ASC(MID$(ModHeader.PanMap, L, 1)) <> &HFF THEN
		MusChans = MusChans + 1
	END IF
NEXT

' create frame buffers
DIM SHARED VirtScr(0 TO 319, 0 TO 199) AS STRING * 1
DIM SHARED BlankScr2(0 TO 319) AS STRING * 1
FOR L = 0 TO 319: BlankScr2(L) = CHR$(0): NEXT L
VS = VARSEG(VirtScr(0, 0)): VO = VARPTR(VirtScr(0, 0))
'BS = VARSEG(BlankScr(0, 0)): BO = VARPTR(BlankScr(0, 0))
BS = &HB000: BO = 0
DEF SEG = BS
FOR L = 0 TO 319: FOR M = 0 TO 199: POKE M * 320 + L, 0: NEXT M, L
B2S = VARSEG(BlankScr2(0)): B2O = VARPTR(BlankScr2(0))

'Top(1) = 0: Bottom(1) = 49
'Top(2) = 50: Bottom(2) = 99
'Top(3) = 100: Bottom(3) = 149
'Top(4) = 150: Bottom(4) = 199
'Top(5) = 200: Bottom(5) = 249
Top(1) = 0: Bottom(1) = 199
Top(2) = 0: Bottom(2) = -1
Top(3) = 0: Bottom(3) = -1
Top(4) = 0: Bottom(4) = -1
Top(5) = 0: Bottom(5) = -1

'FOR L = 3 TO 6
'FOR Y = 0 TO 63
'   FOR X = 0 TO 63
'      tex(L, X, Y) = 120 + SIN(X / 10) * 3 - COS(X / 4) * 3 + SIN(Y / 10) * 3 - COS(Y / 4) * 3
'NEXT X, Y
'NEXT L

' define cube textures
FOR L = 1 TO faces
	facetex(L) = (L + 1) \ 2
NEXT L
SWAP facetex(3), facetex(7): SWAP facetex(4), facetex(8)
tx1(1) = 0: ty1(1) = 0: tx2(1) = 0: ty2(1) = 63: tx3(1) = 63: ty3(1) = 63
tx1(2) = 0: ty1(2) = 0: tx2(2) = 63: ty2(2) = 63: tx3(2) = 63: ty3(2) = 0
tx1(3) = 0: ty1(3) = 0: tx2(3) = 0: ty2(3) = 63: tx3(3) = 63: ty3(3) = 63
tx1(4) = 0: ty1(4) = 0: tx2(4) = 63: ty2(4) = 63: tx3(4) = 63: ty3(4) = 0
tx1(5) = 0: ty1(5) = 0: tx2(5) = 0: ty2(5) = 63: tx3(5) = 63: ty3(5) = 63
tx1(6) = 0: ty1(6) = 0: tx2(6) = 63: ty2(6) = 63: tx3(6) = 63: ty3(6) = 0
tx1(7) = 0: ty1(7) = 63: tx2(7) = 63: ty2(7) = 63: tx3(7) = 63: ty3(7) = 0
tx1(8) = 0: ty1(8) = 63: tx2(8) = 63: ty2(8) = 0: tx3(8) = 0: ty3(8) = 0
tx1(9) = 0: ty1(9) = 0: tx2(9) = 0: ty2(9) = 63: tx3(9) = 63: ty3(9) = 63
tx1(10) = 0: ty1(10) = 0: tx2(10) = 63: ty2(10) = 63: tx3(10) = 63: ty3(10) = 0
tx1(11) = 0: ty1(11) = 0: tx2(11) = 0: ty2(11) = 63: tx3(11) = 63: ty3(11) = 63
tx1(12) = 0: ty1(12) = 0: tx2(12) = 63: ty2(12) = 63: tx3(12) = 63: ty3(12) = 0

camdist = 245: xoffset = 160: yoffset = 100

' define cube points
X(1) = -60: Y(1) = -60: z(1) = -60
X(2) = -60: Y(2) = 60: z(2) = -60
X(3) = 60: Y(3) = 60: z(3) = -60
X(4) = 60: Y(4) = -60: z(4) = -60
X(5) = -60: Y(5) = -60: z(5) = 60
X(6) = -60: Y(6) = 60: z(6) = 60
X(7) = 60: Y(7) = 60: z(7) = 60
X(8) = 60: Y(8) = -60: z(8) = 60

' define glenz cube points
X(9) = 0: Y(9) = 0: z(9) = -60
X(10) = 0: Y(10) = 0: z(10) = 60
X(11) = -60: Y(11) = 0: z(11) = 0
X(12) = 60: Y(12) = 0: z(12) = 0
X(13) = 0: Y(13) = -60: z(13) = 0
X(14) = 0: Y(14) = 60: z(14) = 0

' define cube faces
F1(1) = 1: F2(1) = 2: F3(1) = 3
F1(2) = 1: F2(2) = 3: F3(2) = 4
F1(3) = 5: F2(3) = 6: F3(3) = 7
F1(4) = 5: F2(4) = 7: F3(4) = 8
F1(5) = 1: F2(5) = 5: F3(5) = 6
F1(6) = 1: F2(6) = 6: F3(6) = 2
F1(7) = 3: F2(7) = 7: F3(7) = 8
F1(8) = 3: F2(8) = 8: F3(8) = 4
F1(9) = 1: F2(9) = 4: F3(9) = 8
F1(10) = 1: F2(10) = 8: F3(10) = 5
F1(11) = 2: F2(11) = 3: F3(11) = 7
F1(12) = 2: F2(12) = 7: F3(12) = 6

' define glenz cube faces
F1(13) = 1: F2(13) = 2: F3(13) = 9
F1(14) = 2: F2(14) = 3: F3(14) = 9
F1(15) = 3: F2(15) = 4: F3(15) = 9
F1(16) = 4: F2(16) = 1: F3(16) = 9
F1(17) = 5: F2(17) = 6: F3(17) = 10
F1(18) = 6: F2(18) = 7: F3(18) = 10
F1(19) = 7: F2(19) = 8: F3(19) = 10
F1(20) = 8: F2(20) = 5: F3(20) = 10
F1(21) = 2: F2(21) = 6: F3(21) = 11
F1(22) = 5: F2(22) = 6: F3(22) = 11
F1(23) = 1: F2(23) = 5: F3(23) = 11
F1(24) = 1: F2(24) = 2: F3(24) = 11
F1(25) = 4: F2(25) = 8: F3(25) = 12
F1(26) = 7: F2(26) = 8: F3(26) = 12
F1(27) = 3: F2(27) = 7: F3(27) = 12
F1(28) = 3: F2(28) = 4: F3(28) = 12
F1(29) = 1: F2(29) = 4: F3(29) = 13
F1(30) = 1: F2(30) = 5: F3(30) = 13
F1(31) = 5: F2(31) = 8: F3(31) = 13
F1(32) = 4: F2(32) = 8: F3(32) = 13
F1(33) = 2: F2(33) = 3: F3(33) = 14
F1(34) = 2: F2(34) = 6: F3(34) = 14
F1(35) = 6: F2(35) = 7: F3(35) = 14
F1(36) = 3: F2(36) = 7: F3(36) = 14
FOR L = 13 TO 36: fcolor(L) = (L MOD 2) * 1 + 2: NEXT L

' define cube lines
L1(1) = 1: L2(1) = 2
L1(2) = 2: L2(2) = 3
L1(3) = 3: L2(3) = 4
L1(4) = 1: L2(4) = 4
L1(5) = 5: L2(5) = 6
L1(6) = 6: L2(6) = 7
L1(7) = 7: L2(7) = 8
L1(8) = 5: L2(8) = 8
L1(9) = 1: L2(9) = 5
L1(10) = 2: L2(10) = 6
L1(11) = 3: L2(11) = 7
L1(12) = 4: L2(12) = 8

' define dots on sides of cube
dot = 1
FOR Y = -60 TO 60 STEP 20
	FOR X = -60 TO 60 STEP 20
		Xd(dot) = X: Yd(dot) = Y: Zd(dot) = -60
		faced(dot) = 1
	dot = dot + 1
NEXT X, Y
FOR Y = -60 TO 60 STEP 20
	FOR X = -60 TO 60 STEP 20
		Xd(dot) = X: Yd(dot) = Y: Zd(dot) = 60
		faced(dot) = 2
	dot = dot + 1
NEXT X, Y
FOR z = -60 TO 60 STEP 20
	FOR Y = -60 TO 60 STEP 20
		Xd(dot) = -60: Yd(dot) = Y: Zd(dot) = z
		faced(dot) = 3
	dot = dot + 1
NEXT Y, z
FOR z = -60 TO 60 STEP 20
	FOR Y = -60 TO 60 STEP 20
		Xd(dot) = 60: Yd(dot) = Y: Zd(dot) = z
		faced(dot) = 4
	dot = dot + 1
NEXT Y, z
FOR z = -60 TO 60 STEP 20
	FOR X = -60 TO 60 STEP 20
		Xd(dot) = X: Yd(dot) = -60: Zd(dot) = z
		faced(dot) = 5
	dot = dot + 1
NEXT X, z
FOR z = -60 TO 60 STEP 20
	FOR X = -60 TO 60 STEP 20
		Xd(dot) = X: Yd(dot) = 60: Zd(dot) = z
		faced(dot) = 6
	dot = dot + 1
NEXT X, z

SCREEN 13
CLS
'DIM regs AS RegType
'regs.Ax = &H13
'CALL Interrupt(&H10, regs, regs)
OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(40)

QTInit

OUT &H3C8, 0
FOR L = 0 TO 255
	OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
NEXT L
ShowBMP "dcplus0.bmp", PD, 0, 0, 1

' fade in
FOR L = 1 TO 63
	FOR M = 0 TO 255
		OUT &H3C8, M
		FOR N = 1 TO 3
			OUT &H3C9, PD.Palett(M, N) * (L / 63)
		NEXT N
	NEXT M
	WAIT &H3DA, 8
NEXT L

' show animation
RESTORE LogoData
FOR L = 1 TO 12
	QTSetTimer 1, 90
	READ X0, Y0
	ShowBMP "dcplus" + LTRIM$(STR$(L)) + ".bmp", PD, X0, Y0, 0
	DO: LOOP UNTIL QTGetTimer(1) = 0
NEXT L
QTDelay 2000

' fade out
FOR L = 62 TO 0 STEP -1
	FOR M = 0 TO 255
		OUT &H3C8, M
		FOR N = 1 TO 3
			OUT &H3C9, PD.Palett(M, N) * (L / 63)
		NEXT N
	NEXT M
	WAIT &H3DA, 8
NEXT L

CLS
StopMusic
StopOutput
UnloadModule

FOR L = 0 TO 31
	OUT &H3C8, L + 16
	OUT &H3C9, L * 2
	OUT &H3C9, L * 2
	OUT &H3C9, L * 2
NEXT L
OUT &H3C8, 9: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
FOR L = 0 TO 15
	OUT &H3C8, L + 48
	OUT &H3C9, L * 4: OUT &H3C9, L * 4: OUT &H3C9, L * 3 + 15
NEXT L

' load textures
DIM Textures(0 TO 0, 0 TO 0) AS STRING * 1, TexData AS ImageType
LoadBMP "textures.bmp", Textures(), TexData
FOR L = 0 TO 143
	OUT &H3C8, L + 80
	OUT &H3C9, TexData.Palett(L, 1)
	OUT &H3C9, TexData.Palett(L, 2)
	OUT &H3C9, TexData.Palett(L, 3)
NEXT L
FOR L = 0 TO 5
	FOR Y = 0 TO 63
		FOR X = 0 TO 63
			tex(L + 1, X, Y) = ASC(Textures(X + L * 64, Y)) + 80
	NEXT X, Y
NEXT L
ERASE Textures

' load font
DIM Font(0 TO 0, 0 TO 0) AS STRING * 1, FontData AS ImageType
DIM CharWidth(32 TO 122), CharOffs(32 TO 122)
LoadBMP "c20font.bmp", Font(), FontData
RESTORE FontData
CharOff = 0
FOR L = 32 TO 122
	READ CharWidth(L)
	CharOffs(L) = CharOff
	CharOff = CharOff + CharWidth(L)
NEXT
FontData.Segment = VARSEG(Font(0, 0)): FontData.Offset = VARPTR(Font(0, 0))
DIM ScrollScr(0 TO 319, 0 TO FontData.Height - 1) AS STRING * 1
SS = VARSEG(ScrollScr(0, 0)): SO = VARPTR(ScrollScr(0, 0))
DEF SEG = SS
FOR L = 0 TO 319: FOR M = 0 TO FontData.Height - 1: POKE L + M * 320, 0: NEXT M, L
FOR Y = 0 TO FontData.Height - 1
	FOR X = 0 TO FontData.Width - 1
		IF ASC(Font(X, Y)) < 16 THEN Font(X, Y) = CHR$(ASC(Font(X, Y)) + 240)
NEXT X, Y
FOR L = 0 TO 15
	OUT &H3C8, L + 240
	OUT &H3C9, FontData.Palett(L, 1)
	OUT &H3C9, FontData.Palett(L, 2)
	OUT &H3C9, FontData.Palett(L, 3)
NEXT L
'OUT &H3C8, 240: OUT &H3C9, 5: OUT &H3C9, 20: OUT &H3C9, 40
'OUT &H3C8, 240: OUT &H3C9, 30: OUT &H3C9, 5: OUT &H3C9, 15

' load bob
DIM Bob(0 TO 0, 0 TO 0) AS STRING * 1, BobData AS ImageType
LoadBMP "ball2.bmp", Bob(), BobData
BobData.Segment = VARSEG(Bob(0, 0)): BobData.Offset = VARPTR(Bob(0, 0))
FOR Y = 0 TO BobData.Height - 1
	FOR X = 0 TO BobData.Width - 1
		Bob(X, Y) = CHR$(ASC(Bob(X, Y)) + 64)
NEXT X, Y
BDW2 = BobData.Width \ 2: BDH2 = BobData.Height \ 2
FOR L = 0 TO 15
	OUT &H3C8, L + 64
	OUT &H3C9, BobData.Palett(L, 1)
	OUT &H3C9, BobData.Palett(L, 2)
	OUT &H3C9, BobData.Palett(L, 3)
NEXT L
DIM BobLeft(0 TO BobData.Height - 1), BobWidth(0 TO BobData.Height - 1)
BobLeft(0) = 2: BobLeft(1) = 1: BobLeft(2) = 0: BobLeft(3) = 0: BobLeft(4) = 0: BobLeft(5) = 1: BobLeft(6) = 2
BobWidth(0) = 4: BobWidth(1) = 6: BobWidth(2) = 8: BobWidth(3) = 8: BobWidth(4) = 8: BobWidth(5) = 6: BobWidth(6) = 4

' load logo/bg
DIM Logo(0 TO 0, 0 TO 0) AS STRING * 1, LogoData AS ImageType
LoadBMP "dc5logo3.bmp", Logo(), LogoData
BS = VARSEG(Logo(0, 0)): BO = VARPTR(Logo(0, 0))
FOR Y = 0 TO LogoData.Height - 1
	FOR X = 0 TO LogoData.Width - 1
		Logo(X, Y) = CHR$(ASC(Logo(X, Y)) + 224)
		'IF ASC(Logo(X, Y)) > 0 THEN Logo(X, Y) = CHR$(ASC(Logo(X, Y)) + 224)
NEXT X, Y
'OUT &H3C8, 224: OUT &H3C9, 0: OUT &H3C9, 5: OUT &H3C9, 15
FOR L = 0 TO 15
	OUT &H3C8, L + 224
	OUT &H3C9, LogoData.Palett(L, 1)
	OUT &H3C9, LogoData.Palett(L, 2)
	OUT &H3C9, LogoData.Palett(L, 3)
NEXT L

RESTORE TextData
DO
	READ T$
	Text$ = Text$ + T$ + " "
LOOP UNTIL T$ = ""

' load main music
OPEN Lib$ FOR BINARY AS 1
'LoadGDM FILEATTR(1, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
LoadGDM FILEATTR(1, 2), GetLibOffset("CTRIX.GDM") - 1, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE 1
MusChans = 4
OverRate& = StartOutput(MusChans, 0)
StartMusic
L = MusicVolume(MainVol)

' init vars
Char = 1: CC = 0: Ending = 0
CharAsc = ASC(MID$(Text$, Char))
IF VS < 0 THEN DEF SEG = 65536 + VS ELSE DEF SEG = VS
QTSetTimer 1, 32000
OldT = 32000
OldHue = INT(32000 / 88.9) MOD 360
Lap = 1
xrot = 0: yrot = 0: zrot = 0
mode = 1

' main loop
DO
	T = QTGetTimer(1)
	'FOR L = 1 TO 5: PRINT Top(L); Bottom(L): NEXT
	IF Lap = 1 THEN
		yoffset = 300

		IF T > 28000 THEN
			FOR Y = 0 TO 199
				CALL BlockMove(B2S, B2O, VS, VO + Y * 320, 320, 0)
			NEXT Y
		ELSEIF T > 20000 THEN
			'BlankTop = (T - 30000) \ 14
			BlankTop = ABS(SIN((T - 25600) / 500)) * ((T - 20000) \ 40)
			CALL BlockMove(BS, BO + BlankTop * 320, VS, VO, (200 - BlankTop) * 320, 0)
			FOR Y = 200 - BlankTop TO 199
				CALL BlockMove(B2S, B2O, VS, VO + Y * 320, 320, 0)
			NEXT Y
		ELSE
			CALL BlockMove(BS, BO, VS, VO, 64000, 0)
			IF T < 18000 AND T > 16000 THEN
				yoffset = 100 + (T - 16000) \ 10
			ELSEIF T < 16000 THEN
				yoffset = 100
				IF T < 4000 AND T > 2000 THEN
					Bottom(1) = (T - 2000) \ 10
					Top(2) = (T - 2000) \ 10
					Bottom(2) = 199
				END IF
			END IF
		END IF
	ELSE
		IF Lap = 2 THEN
			IF T < 24000 AND T > 22000 THEN
				Bottom(2) = (T - 22000) \ 10
				Top(3) = (T - 22000) \ 10
				Bottom(3) = 199
			ELSEIF T < 10000 AND T > 8000 THEN
				Bottom(3) = (T - 8000) \ 10
				Top(4) = (T - 8000) \ 10
				Bottom(4) = 199
			END IF
		ELSEIF Lap = 3 THEN
			IF T < 24000 AND T > 22000 THEN
				Bottom(4) = (T - 22000) \ 10
				Top(5) = (T - 22000) \ 10
				Bottom(5) = 199
			ELSEIF T < 2000 AND T > 0 THEN
				FOR L = 2 TO 5
				  Top(L) = ((2000 - T) / 50) * (L - 1)
				  Bottom(L - 1) = Top(L) - 1
				NEXT L
			END IF
		ELSEIF Lap = 4 THEN
			IF T < 20000 AND T > 18000 THEN
				Bottom(5) = 249
				FOR L = 2 TO 5
				  Top(L) = (40 + (20000 - T) / 200) * (L - 1)
				  Bottom(L - 1) = Top(L) - 1
				NEXT L
			END IF
		ELSEIF Lap = 5 THEN
			IF T < 14000 AND T > 12000 THEN
				yoffset = 100 + (14000 - T) \ 10
			ELSEIF T < 12000 AND mode = 1 THEN
				S = 12
				points = S * S: faces = S * S * 2: lines = S * S * 2
				camdist = 310: facediv = faces / 1.1: gshade = 8
				mode = 2

				'REDIM X(points) AS SINGLE, Y(points) AS SINGLE, z(points) AS SINGLE, rad(points)
				'REDIM F1(faces), F2(faces), F3(faces), fcolor(faces)
				'REDIM L1(lines), L2(lines)
				'REDIM zavg(faces)
				'REDIM fsort(faces)
				'REDIM DX(points), DY(points)
				'REDIM JZ(points) AS SINGLE
				'REDIM SHARED tx1(faces), ty1(faces), tx2(faces), ty2(faces), tx3(faces), ty3(faces)

				'FOR L = 1 TO faces STEP 2
				'   tx1(L) = 0: ty1(L) = 0: tx2(L) = 63: ty2(L) = 63: tx3(L) = 0: ty3(L) = 63
				'   tx1(L + 1) = 63: ty1(L + 1) = 0: tx2(L + 1) = 0: ty2(L + 1) = 0: tx3(L + 1) = 63: ty3(L + 1) = 63
				'NEXT L
				FOR L = 1 TO faces STEP 4
					tx1(L) = 0: ty1(L) = 0: tx2(L) = 32: ty2(L) = 63: tx3(L) = 0: ty3(L) = 63
					tx1(L + 1) = 32: ty1(L + 1) = 0: tx2(L + 1) = 0: ty2(L + 1) = 0: tx3(L + 1) = 32: ty3(L + 1) = 63
					tx1(L + 2) = 32: ty1(L + 2) = 0: tx2(L + 2) = 63: ty2(L + 2) = 63: tx3(L + 2) = 32: ty3(L + 2) = 63
					tx1(L + 3) = 63: ty1(L + 3) = 0: tx2(L + 3) = 32: ty2(L + 3) = 0: tx3(L + 3) = 63: ty3(L + 3) = 63
				NEXT L
				FOR L = 1 TO faces: facetex(L) = 3: NEXT

				tr = 90: rr = 40    ' torus radius, ring radius

				FOR p = 1 TO points
					rang! = ((p - 1) \ S) / (S / (pi * 2))  ' ring angle
					rx! = COS(rang!) * tr
					ry! = SIN(rang!) * tr
					dang! = (p MOD S) / (S / (pi * 2))      ' dot angle
					X(p) = rx! + (rr * COS(dang!) * COS(rang!))
					Y(p) = ry! + (rr * COS(dang!) * SIN(rang!))
					z(p) = rr * SIN(dang!)

					IF p < points - (S - 1) THEN
						F1(p * 2) = p
						F2(p * 2) = p + (SGN(p MOD S) * S) - (S - 1)'p+1 or p-15
						F3(p * 2) = p + S
						F1(p * 2 - 1) = p + (SGN(p MOD S) * S) - (S - 1)
						F2(p * 2 - 1) = p + S
						F3(p * 2 - 1) = p + (SGN(p MOD S) * S) + 1 'p+17 or p+1
					END IF
				NEXT p
				FOR p = points - (S - 1) TO points
					F1(p * 2) = p
					F2(p * 2) = p + (SGN(p MOD S) * S) - (S - 1)'p+1 or p-15
					F3(p * 2) = ((p - 1) MOD S) + 1
					F1(p * 2 - 1) = p + (SGN(p MOD S) * S) - (S - 1)'p+1 or p-15
					F2(p * 2 - 1) = ((p - 1) MOD S) + 1
					F3(p * 2 - 1) = ((p - 1) MOD S) + (SGN(p MOD S) * S) - (S - 2)'p-14 or p+2
				NEXT p

				FOR L = 1 TO faces: fcolor(L) = (L MOD 2) * 1 + 7: NEXT L
				FOR p = 1 TO points
					L1(p * 2 - 1) = p: L2(p * 2 - 1) = p + (SGN(p MOD S) * S) - (S - 1)'p+1 or p-15
					L1(p * 2) = p
					IF p + S <= points THEN
						L2(p * 2) = p + S
					ELSE L2(p * 2) = ((p - 1) MOD S) + 1
					END IF
				NEXT p
			ELSEIF T < 12000 AND T > 10000 THEN
				yoffset = 100 + (T - 10000) \ 10
			END IF
		END IF
		CALL BlockMove(BS, BO, VS, VO, 64000, 0)
	END IF

	YS = SIN(T / 363.78) * 35 + SIN(T / 1018.59) * 45 + 85

	Hue = INT(T / 88.9) MOD 360
	IF OldHue - Hue > 3 AND Ending = 0 THEN
		HSL2RGB Hue, 1, .3
		OUT &H3C8, 6: OUT &H3C9, RGB.red: OUT &H3C9, RGB.green: OUT &H3C9, RGB.blue
		HSL2RGB Hue, 1, .45
		OUT &H3C8, 7: OUT &H3C9, RGB.red: OUT &H3C9, RGB.green: OUT &H3C9, RGB.blue
		HSL2RGB Hue, 1, .85
		OUT &H3C8, 8: OUT &H3C9, RGB.red: OUT &H3C9, RGB.green: OUT &H3C9, RGB.blue
		'OUT &H3C8, 9: OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
		FOR L = 0 TO 31
			HSL2RGB 360 - Hue, .5, L / 32
			OUT &H3C8, L + 16
			OUT &H3C9, RGB.red: OUT &H3C9, RGB.green: OUT &H3C9, RGB.blue
		NEXT L
		OldHue = Hue
		IF OldHue <= 3 THEN OldHue = 360
	END IF

	' 2546.48 1697.65 1273.24 1018.59
	xrot = T / 1273.24
	yrot = T / 1018.59
	zrot = T / 2546.48
	IF T = 0 THEN QTSetTimer 1, 32000: Lap = Lap + 1   ' only lasts 32.7 seconds :/
	cosx = COS(xrot): sinx = SIN(xrot)
	cosy = COS(yrot): siny = SIN(yrot)
	cosz = COS(zrot): sinz = SIN(zrot)
	FOR p = 1 TO points
		' x-axis rotate
		JY1 = cosx * Y(p) - sinx * z(p)
		JZ1 = sinx * Y(p) + cosx * z(p)
		' y-axis rotate
		JX1 = siny * JZ1 + cosy * X(p)
		JZ(p) = cosy * JZ1 - siny * X(p)
		' z-axis rotate
		JX = cosz * JX1 - sinz * JY1
		JY = sinz * JX1 + cosz * JY1
		' map 3d to 2d
		DX(p) = (-JX * 240) / (JZ(p) + camdist) + xoffset
		DY(p) = (-JY * 200) / (JZ(p) + camdist) + yoffset
	NEXT p
	IF mode = 1 THEN
		FOR p = 1 TO dots
			' x-axis rotate
			JY1 = cosx * Yd(p) - sinx * Zd(p)
			JZ1 = sinx * Yd(p) + cosx * Zd(p)
			' y-axis rotate
			JX1 = siny * JZ1 + cosy * Xd(p)
			JZd(p) = cosy * JZ1 - siny * Xd(p)
			' z-axis rotate
			JX = cosz * JX1 - sinz * JY1
			JY = sinz * JX1 + cosz * JY1
			' map 3d to 2d
			DXd(p) = (-JX * 240) / (JZd(p) + camdist) + xoffset
			DYd(p) = (-JY * 200) / (JZd(p) + camdist) + yoffset
		NEXT p
		FOR L = 1 TO 12 STEP 2
			fsort(L) = L
			fsort(L + 1) = L + 1
			zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L)) + JZ(F1(L + 1)) + JZ(F2(L + 1)) + JZ(F3(L + 1))) / 6
			zavg(L + 1) = zavg(L)
		NEXT
		FOR L = 1 TO 24
			fsortglz(L) = L + 12
			zavgglz(L) = JZ(F3(L + 12))
		NEXT
		Shellsort zavgglz(), fsortglz()
	ELSEIF mode = 2 THEN
		FOR L = 1 TO faces
			fsort(L) = L
			zavg(L) = (JZ(F1(L)) + JZ(F2(L)) + JZ(F3(L))) / 3
		NEXT
	END IF
	Shellsort zavg(), fsort()
	
	FTime = T \ 24
	FMove = OldFTime - FTime
	FOR Fill = 1 TO 5
		IF FMove > 0 AND ((Lap = 4 AND T < 16000) OR Lap > 4) THEN
			IF Bottom(Fill) <= 0 THEN Bottom(Fill) = Bottom(Fill) + 250: Top(Fill) = Top(Fill) + 250
			Top(Fill) = Top(Fill) - FMove
			Bottom(Fill) = Bottom(Fill) - FMove
		END IF
		Top = Top(Fill): Bottom = Bottom(Fill)
		IF Top < 0 THEN Top = 0
		IF Bottom > 199 THEN Bottom = 199
		SELECT CASE Fill
			CASE 1
				FOR L = 1 TO lines
					LineBres2 DX(L1(L)), DY(L1(L)), DX(L2(L)), DY(L2(L)), 60
					'AALine DX(L1(L)), DY(L1(L)), DX(L2(L)), DY(L2(L))
				NEXT L
			CASE 2
				IF mode = 1 THEN
					FOR L = 12 TO 1 STEP -2
						IF zavg(L) < -16 THEN
							M = fsort(L)
							N = (((M - 1) \ 2) * 49) + 1
							FOR O = 1 TO 49
								'X = DXd(N) - BobData.Width \ 2: Y = DYd(N) - BobData.Height \ 2
								X = DXd(N) - BDW2: Y = DYd(N) - BDH2
								FOR YL = 0 TO BobData.Height - 1
									IF Y >= Top AND Y <= Bottom THEN
										'CALL BlockMove(BobData.Segment, BobData.Offset + (YL * BobData.Width), VS, VO + X + (Y * 320), BobData.Width, 0)
										CALL BlockMove(BobData.Segment, BobData.Offset + BobLeft(YL) + (YL * BobData.Width), VS, VO + X + BobLeft(YL) + (Y * 320), BobWidth(YL), 0)
									END IF
									Y = Y + 1
								NEXT YL
								N = N + 1
							NEXT O
						END IF
					NEXT L
				ELSEIF mode = 2 THEN
					FOR L = points TO 1 STEP -1
						M = L 'fsortp(L)
						'X = DX(F1(M)) - BDW2: Y = DY(F1(M)) - BDH2
						X = DX(M) - BDW2: Y = DY(M) - BDH2
						FOR YL = 0 TO BobData.Height - 1
							IF Y >= Top AND Y <= Bottom THEN
								'CALL BlockMove(BobData.Segment, BobData.Offset + (YL * BobData.Width), VS, VO + X + (Y * 320), BobData.Width, 0)

								CALL BlockMove(BobData.Segment, BobData.Offset + BobLeft(YL) + (YL * BobData.Width), VS, VO + X + BobLeft(YL) + (Y * 320), BobWidth(YL), 0)
							END IF
							Y = Y + 1
						NEXT YL
					NEXT L
				END IF
			CASE 3
				FOR L = facediv TO 1 STEP -1
					M = fsort(L)
					a = 25 - JZ(F1(M)) / gshade: IF a < 16 THEN a = 16
					B = 25 - JZ(F2(M)) / gshade: IF B < 16 THEN B = 16
					C = 25 - JZ(F3(M)) / gshade: IF C < 16 THEN C = 16
					TriGFill DX(F1(M)), DY(F1(M)), a, DX(F2(M)), DY(F2(M)), B, DX(F3(M)), DY(F3(M)), C
				NEXT L
			CASE 4
				FOR L = facediv TO 1 STEP -1
					M = fsort(L)
					TriTFill DX(F1(M)), DY(F1(M)), DX(F2(M)), DY(F2(M)), DX(F3(M)), DY(F3(M)), M, facetex(M)
				NEXT L
			CASE 5
				IF mode = 1 THEN
					FOR L = 36 TO 13 STEP -1
						M = fsortglz(L - 12)
						N = fcolor(M)
						IF zavgglz(L - 12) < -16 THEN
							N = N * 2
							TriFill2 DX(F1(M)), DY(F1(M)), DX(F2(M)), DY(F2(M)), DX(F3(M)), DY(F3(M)), N
						ELSE
							TriFill DX(F1(M)), DY(F1(M)), DX(F2(M)), DY(F2(M)), DX(F3(M)), DY(F3(M)), N
						END IF
					NEXT L
				ELSEIF mode = 2 THEN
					FOR L = facediv TO 1 STEP -1
						M = fsort(L)
						TriFill DX(F1(M)), DY(F1(M)), DX(F2(M)), DY(F2(M)), DX(F3(M)), DY(F3(M)), fcolor(M)
					NEXT L
				END IF
			END SELECT
	NEXT Fill

	' scroller
	STime = T \ 8
	FOR L = STime + 1 TO OldSTime
		Offset = SO
		FOR YL = 1 TO FontData.Height
			CALL BlockMove(SS, Offset + 1, SS, Offset, 319, 0)
			Offset = Offset + 320
		NEXT
		PrintOneColumn 319, 0, CharAsc, CC
		CC = CC + 1
		IF CC >= CharWidth(CharAsc) THEN
			Char = Char + 1
			IF Char > LEN(Text$) THEN Char = 1
			CharAsc = ASC(MID$(Text$, Char))
			CC = 0
		END IF
	NEXT L
	IF INKEY$ = CHR$(27) AND Ending = 0 THEN
		Ending = 1
		FOR L = 0 TO 255
			OUT &H3C7, L
			FOR M = 1 TO 3: PD.Palett(L, M) = INP(&H3C9): NEXT M
		NEXT L
		QTSetTimer 2, 2000
	END IF
	IF Ending = 1 THEN
		T2 = QTGetTimer(2)
		IF T2 = 0 THEN EXIT DO
		' fade out
		T3! = T2 / 2000
		FOR M = 0 TO 255
			OUT &H3C8, M
			FOR N = 1 TO 3
				OUT &H3C9, PD.Palett(M, N) * T3!
			NEXT N
		NEXT M
		L = MusicVolume(MainVol * T3!)
	END IF
	CALL BlockMove(SS, SO, VS, VO + YS * 320, 320 * FontData.Height, 0)
	'WAIT &H3DA, 8
	CALL BlockMove(VS, VO, &HA000, 0, 64000, 0)
	'Frames = Frames + 1
	OldSTime = STime: OldFTime = FTime

LOOP
SCREEN 0: WIDTH 80
'regs.Ax = &H3
'CALL Interrupt(&H10, regs, regs)
'PRINT "fps:"; Frames / ((32000 - T) / 1000)

TheEnd:
QTDone
StopMusic                               'Disable music processing
StopOutput                              'Stop all sound output
UnloadModule                            'Free module memory
FreeMSE                                 'Remove MSE from memory

END

LogoData:
DATA 93,43
DATA 85,38
DATA 93,35
DATA 112,25
DATA 144,24
DATA 165,25
DATA 190,34
DATA 210,55
DATA 204,43
DATA 204,43
DATA 204,43
DATA 204,63


FontData:
DATA 6,8,11,15,14,18,16,7,9,9,11,13,9,10,6,10,16,8,13,13,14,13,14,11,14,14,7,9,12,14,14
DATA 12,23,17,15,15,16,13,14,15,17,6,8,17,11,19,17,17,14,17,15,14,14,15,17,21,16,15,14
DATA 9,8,8,12,16,8,13,13,12,13,13,9,13,13,6,8,13,9,18,13,14,13,13,9,11,10,14,13,17,14,14,12

TextData:
DATA "                     "
DATA "Welcome, DC5+ subscribers! Your monthly plan unlocks"
DATA "exclusive content you can't find anywhere else. We"
DATA "are honored to present to you the world premiere of..."

DATA "this cube! Behold its smoothness, its simplicity, its"
DATA "aliased lines! What, you're not"
DATA "impressed? We have other ways to fill this"
DATA "object. How about... "

DATA "some balls? So shiny, so decadent!"
DATA "Each ball tells a different story. Around the edges"
DATA "they come and go, and... no? Okay, what else we got.  "
DATA "How about some..."

DATA "gouraud shading! Oh, this is nice! That cube is"
DATA "fully covered up now. Featuring our z-buffer lighting"
DATA "technology. Huh? Need more detail? Check out... "

DATA "some texture mapping! A DC5 first, only"
DATA "decades after everyone else did it. Who needs"
DATA "correct perspective, anyway? It's overrated."
DATA "Let us know when you get bored. Now?"
DATA "Fine, one more. Let's get ready for some..."

DATA "glenz! Notable glenz! You can see right through that"
DATA "cube, can't you? It takes you to another time"
DATA "and place (1991, and an Amiga 500)."
DATA "Alright, so if you've ever seen Surrealism by"
DATA "Andromeda, then you know what's coming up next."

DATA "Here we go: all five effects together. It's the royal"
DATA "sampler. Vote for your favorite now! If you only like"
DATA "one, you can ignore the rest of the screen. But oh,"
DATA "you think we're done?  Let's make it a little more"
DATA "interesting... Boom. Welcome to the latest release"
DATA "from the Dennis Courtney Five. Phoenix here with"
DATA "yet another QuickBasic/QBX thing for @party 2020."
DATA "Of course I'm not actually at @party, nobody is!"
DATA "Hope you're enjoying the video stream."
DATA "So it's been a crazy-ass year, but I did the whole"
DATA "socio-political commentary thing last year with"
DATA "Permanent Damage. Gonna keep it light this time."

DATA "Are you getting hungry? Here, have a donut."
DATA "Five flavors, but no sprinkles or frosting, sorry."
DATA "Greetings? Let's keep it simple. All contributing"
DATA "to @party; all keeping DOS coding alive, be it"
DATA "tiny intros or 90's nostalgia; all keeping Amiga"
DATA "OCS/ECS coding alive, and inspiring me to keep"
DATA "it simple (, stupid). If you wanna read a group"
DATA "list, watch our last demo."

DATA "OK, that's it for the new effects, so @party compo"
DATA "runners, feel free to move on to the next entry"
DATA "now."

DATA "Ugh, that framerate drop! Hey, I tried. At least"
DATA "I took the glenz out. I also tried a version where"
DATA "the effects are set line-by-line, rather than a"
DATA "top-to-bottom range. It looked really trippy with"
DATA "multiple sinewaves going between the five effects,"
DATA "but was a bit slower due to having to check every"
DATA "line for each effect, so I stuck with the original."
DATA "            Hmm, let's see, it's not an"
DATA "@party compo without some Aeronaut beer brewed right"
DATA "next door. Let's check their website to see what's"
DATA "on tap.. I think I'll go with the Hinterspace bock this time!"
DATA "Regards to Artisan's Asylum, where we"
DATA "shall hopefully return next year. In the meantime,"
DATA "I hope everyone has been staying safe and healthy."
DATA "I'm doing fine, but I'll be honest, I'm in dire"
DATA "need of a haircut.          "

DATA "This scroller is going to loop now, so you get to"
DATA "read all the effect reveal text again even though"
DATA "it'll be stuck on the donut. Press Escape when you've"
DATA "had your fill. G'bye!                                "
DATA ""

DEFINT J
FUNCTION GetLibOffset& (File$)
	DIM LibHeader AS LibHeaderType
	GetLibOffset& = 0
	H = FREEFILE
	OPEN Lib$ FOR BINARY AS H
	SEEK H, 7: GET H, , F
	FOR L = 1 TO F
		GET H, , LibHeader
		IF UCASE$(File$) = RTRIM$(UCASE$(LibHeader.FileName)) THEN
			GetLibOffset& = LibHeader.Offset
			EXIT FOR
		END IF
	NEXT L
	CLOSE H
END FUNCTION

SUB GetSoundCardInfo
SHARED Dev, Port, IRQ, DMA
		  IF INSTR(COMMAND$, "SETUP") THEN Setup = 1
		  IF LEN(ENVIRON$("ULTRASND")) AND Setup = 0 THEN
					 PRINT "Gravis Ultrasound detected."
					 Dev = 1: Port = &HFFFF: IRQ = &HFF: DMA = &HFF
		  ELSEIF LEN(ENVIRON$("BLASTER")) AND Setup = 0 THEN
					 T$ = MID$(ENVIRON$("BLASTER"), INSTR(ENVIRON$("BLASTER"), "T") + 1, 1)
					 SELECT CASE T$
					 CASE "1"
								PRINT "Sound Blaster 1.x detected."
								Dev = 2
					 CASE "2"
								PRINT "Sound Blaster 2.x detected."
								Dev = 3
					 CASE "4"
								PRINT "Sound Blaster Pro detected."
								Dev = 4
					 CASE "6"
								PRINT "Sound Blaster 16 detected."
								Dev = 5
					 END SELECT
					 Port = &HFFFF: IRQ = &HFF: DMA = &HFF
		  ELSE
					 PRINT "Select soundcard:"
					 PRINT "1) Gravis Ultrasound"
					 PRINT "2) Sound Blaster 1.x"
					 PRINT "3) Sound Blaster 2.x"
					 PRINT "4) Sound Blaster Pro"
					 PRINT "5) Sound Blaster 16"
					 PRINT "6) Pro Audio Spectrum"
					 PRINT "0) Abort"
					 DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "6"
					 IF In$ = "0" THEN END ELSE Dev = ASC(In$) - 48
					 PRINT "Port address (2x0h, 0 to autodetect):"
					 DO: In$ = INKEY$: LOOP UNTIL In$ >= "0" AND In$ <= "9"
					 IF In$ = "0" THEN Port = &HFFFF ELSE Port = (16 * (ASC(In$) - 48)) + 512
					 PRINT "IRQ (in hex, 0 to autodetect):"
					 DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9") OR (In$ >= "a" AND In$ <= "f")
					 IF In$ = "0" THEN
								IRQ = &HFF
					 ELSEIF In$ <= "9" THEN IRQ = ASC(In$) - 48
					 ELSE IRQ = ASC(In$) - 87
					 END IF
					 PRINT "DMA (0 to autodetect):"
					 DO: In$ = INKEY$: LOOP UNTIL (In$ >= "0" AND In$ <= "9")
					 IF In$ = "0" THEN DMA = &HFF ELSE DMA = ASC(In$) - 48
		  END IF
END SUB

DEFSNG J
SUB HSL2RGB (BYVAL Hue, BYVAL S!, BYVAL L!)
	SHARED RGB AS RGBType
	RGB.red = HSL2RGBf(0, Hue, S!, L!) * 63
	RGB.green = HSL2RGBf(8, Hue, S!, L!) * 63
	RGB.blue = HSL2RGBf(4, Hue, S!, L!) * 63
END SUB

FUNCTION HSL2RGBf! (BYVAL N, BYVAL Hue, BYVAL S!, BYVAL L!)
	a! = S! * min(L!, 1 - L!)
	k! = N + Hue / 30!
	IF k! >= 12 THEN k! = k! - 12
	km! = min(k! - 3, 9 - k!)
	IF km! > 1 THEN km! = 1
	IF km! < -1 THEN km! = -1
	HSL2RGBf! = L! - a! * km!
END FUNCTION

DEFINT J
SUB LineBres2 (BYVAL a, BYVAL B, BYVAL C, BYVAL D, BYVAL Col)
	U = C - a: V = D - B
	d1x = SGN(U): d1y = SGN(V): d2x = SGN(U): d2y = 0
	M = ABS(U): N = ABS(V)
	IF M <= N THEN
		d2x = 0: d2y = SGN(V)
		SWAP M, N
	END IF
	S = M \ 2
	FOR I = 0 TO M
		IF B >= Top AND B <= Bottom THEN POKE a + B * 320, Col
			S = S + N
			IF S > M THEN
				S = S - M: a = a + d1x: B = B + d1y
			ELSE
				a = a + d2x: B = B + d2y
			END IF
	NEXT I
END SUB

SUB LoadBMP (BMPFile$, Array() AS STRING * 1, PData AS ImageType)
	Offs& = GetLibOffset(BMPFile$) - 1&
	OPEN Lib$ FOR BINARY AS 1
	TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
	Buffer$ = STRING$(5000, 0)
	GET 1, Offs& + 11, Offset
	GET 1, Offs& + 19, Wid
	GET 1, Offs& + 23, Hei&
	GET 1, Offs& + 47, PalCount
	REDIM Array(0 TO Wid - 1, 0 TO ABS(Hei&) - 1) AS STRING * 1
	SEEK 1, Offs& + 55
	FOR L = 0 TO PalCount - 1
		GET 1, , TmpLong$
		PData.Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
		PData.Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
		PData.Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
	NEXT L
	SEEK 1, Offs& + Offset + 1
	GET 1, , Buffer$
	BSeg = SSEG(Buffer$): BOff = SADD(Buffer$)
	DEF SEG = BSeg
	PData.points = 0
	Byte = 0
	FOR Y = 0 TO ABS(Hei&) - 1
		IF Hei& < 0 THEN
			FOR X = 0 TO Wid - 1
				IF Byte >= 5000 THEN GET 1, , Buffer$: Byte = 0
				T = PEEK(BOff + Byte)
				Array(X, Y) = CHR$(T)
				IF Wid <= 320 AND T <> 0 THEN PData.points = PData.points + 1
				Byte = Byte + 1
			NEXT X
		ELSE
			FOR X = 0 TO Wid - 1
				IF Byte >= 5000 THEN GET 1, , Buffer$: Byte = 0
				T = PEEK(BOff + Byte)
				Array(X, ABS(Hei&) - Y - 1) = CHR$(T)
				IF Wid <= 320 AND T <> 0 THEN PData.points = PData.points + 1
				Byte = Byte + 1
			NEXT X
		END IF
		SELECT CASE Wid MOD 4
			CASE 1: Byte = Byte + 3
			CASE 2: Byte = Byte + 2
			CASE 3: Byte = Byte + 1
		END SELECT
	NEXT Y
	Buffer$ = ""
	CLOSE 1
	PData.Height = Hei&: PData.Width = Wid: PData.Colors = PalCount

END SUB

DEFSNG J
FUNCTION min! (BYVAL a!, BYVAL B!)
	IF a! < B! THEN
		min! = a!
	ELSE
		min! = B!
	END IF
END FUNCTION

DEFINT J
SUB PrintOneColumn (BYVAL X, BYVAL Y, BYVAL Char, BYVAL Column)
SHARED FontData AS ImageType, CharOffs(), SS, SO
	SOff = SO + X
	FOff = FontData.Offset + CharOffs(Char) + Column
	FOR YL = 0 TO FontData.Height - 1
		CALL BlockMove(FontData.Segment, FOff, SS, SOff, 1, 0)
		SOff = SOff + 320
		FOff = FOff + FontData.Width
	NEXT YL
END SUB

' SubRoutine by Andy Voss '94
' Sorts an array, quickly.
SUB Shellsort (Array(), Index())
Span = UBOUND(Array) \ 2
DO WHILE Span > 0
	 FOR I = Span TO UBOUND(Array) - 1
		  FOR J = (I - Span + 1) TO 1 STEP -Span
				IF Array(J) <= Array(J + Span) THEN EXIT FOR
				SWAP Array(J), Array(J + Span)
				SWAP Index(J), Index(J + Span)
		  NEXT J
	 NEXT I
	 Span = Span \ 2
LOOP

END SUB

REM $STATIC
SUB ShowBMP (BMPFile$, PData AS ImageType, BYVAL X0, BYVAL Y0, BYVAL SetPal)
	Offs& = GetLibOffset(BMPFile$) - 1&
	F = FREEFILE
	OPEN Lib$ FOR BINARY AS F
	'OPEN BMPFile$ FOR BINARY AS F
	TmpInt$ = "  ": TmpLong$ = "    ": TmpByte$ = " "
	Buffer$ = STRING$(5000, 0)
	GET F, Offs& + 11, Offset
	GET F, Offs& + 19, Wid
	GET F, Offs& + 23, Hei&
	GET F, Offs& + 47, PalCount
	IF PalCount = 0 THEN PalCount = 256
	
	IF SetPal <> 0 THEN
		SEEK F, Offs& + 55
		FOR L = 0 TO PalCount - 1
			'OUT &H3C8, L
			GET F, , TmpLong$
			PData.Palett(L, 1) = ASC(MID$(TmpLong$, 3, 1)) \ 4
			PData.Palett(L, 2) = ASC(MID$(TmpLong$, 2, 1)) \ 4
			PData.Palett(L, 3) = ASC(MID$(TmpLong$, 1, 1)) \ 4
			'OUT &H3C9, ASC(MID$(TmpLong$, 3, 1)) \ 4
			'OUT &H3C9, ASC(MID$(TmpLong$, 2, 1)) \ 4
			'OUT &H3C9, ASC(MID$(TmpLong$, 1, 1)) \ 4
		NEXT L
	END IF
	SEEK F, Offs& + Offset + 1
	GET F, , Buffer$
	BSeg = SSEG(Buffer$): BOff = SADD(Buffer$)
	Byte = 0
	FOR Y = 0 TO ABS(Hei&) - 1
		IF Hei& < 0 THEN
			Y1 = Y0 + Y
		ELSE Y1 = (Y0 + Hei&) - Y
		END IF
		BytesLeft = 5000 - Byte
		IF BytesLeft < Wid THEN
			CALL BlockMove(BSeg, BOff + Byte, &HA000, X0 + Y1 * 320, BytesLeft, 0)
			GET F, , Buffer$: Byte = 0
			X = BytesLeft: BytesShow = Wid - BytesLeft
		ELSE
			X = 0: BytesShow = Wid
		END IF
		CALL BlockMove(BSeg, BOff + Byte, &HA000, X0 + X + Y1 * 320, BytesShow, 0)
		Byte = Byte + BytesShow
		SELECT CASE Wid AND 3
			CASE 1: Byte = Byte + 3
			CASE 2: Byte = Byte + 2
			CASE 3: Byte = Byte + 1
		END SELECT
	NEXT Y
	Buffer$ = ""
	CLOSE F
END SUB

REM $DYNAMIC
SUB TriFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, BYVAL Col)
SHARED YS
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
IF Y3 < Top OR Y1 > Bottom THEN EXIT SUB
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB

IF Y1 <> Y2 THEN
	xmint! = X21 / Y21: xbint! = X31 / Y31
	MidX! = X1: BottomX! = X1
	FOR Y = Y1 TO Y2
		IF Y >= Top AND NOT (Y >= YS AND Y < YS + 30) THEN
			IF Y > Bottom THEN EXIT SUB
			YRow = Y * 320
			MidX = MidX!: BottomX = BottomX!
			IF S < 0 THEN SWAP MidX, BottomX
			FOR X = MidX TO BottomX - 1
				POKE X + YRow, Col
			NEXT X
		END IF
		MidX! = MidX! + xmint!: BottomX! = BottomX! + xbint!
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	xmint! = X23 / Y23: xbint! = X13 / Y13
	MidX! = X3: TopX! = X3
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y <= Bottom AND NOT (Y >= YS AND Y < YS + 30) THEN
			IF Y < Top THEN EXIT SUB
			YRow = Y * 320
			MidX = MidX!: TopX = TopX!
			IF S < 0 THEN SWAP MidX, TopX
			FOR X = MidX TO TopX - 1
				POKE X + YRow, Col
			NEXT X
		END IF
		MidX! = MidX! - xmint!: TopX! = TopX! - xbint!
	NEXT Y
END IF
END SUB

SUB TriFill2 (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, BYVAL Col)
SHARED YS
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2
IF Y3 < Top OR Y1 > Bottom THEN EXIT SUB
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB

IF Y1 <> Y2 THEN
	xmint! = X21 / Y21: xbint! = X31 / Y31
	MidX! = X1: BottomX! = X1
	FOR Y = Y1 TO Y2
		IF Y >= Top AND NOT (Y >= YS AND Y < YS + 30) THEN
			IF Y > Bottom THEN EXIT SUB
			YRow = Y * 320
			MidX = MidX!: BottomX = BottomX!
			IF S < 0 THEN SWAP MidX, BottomX
			FOR X = MidX TO BottomX - 1
				a = Col + PEEK(X + YRow)
				POKE X + YRow, a
			NEXT X
		END IF
		MidX! = MidX! + xmint!: BottomX! = BottomX! + xbint!
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	xmint! = X23 / Y23: xbint! = X13 / Y13
	MidX! = X3: TopX! = X3
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y <= Bottom AND NOT (Y >= YS AND Y < YS + 30) THEN
			IF Y < Top THEN EXIT SUB
			YRow = Y * 320
			MidX = MidX!: TopX = TopX!
			IF S < 0 THEN SWAP MidX, TopX
			FOR X = MidX TO TopX - 1
				a = Col + PEEK(X + YRow)
				POKE X + YRow, a
			NEXT X
		END IF
		MidX! = MidX! - xmint!: TopX! = TopX! - xbint!
	NEXT Y
END IF
END SUB

SUB TriGFill (BYVAL X1, BYVAL Y1, Col1, BYVAL X2, BYVAL Y2, Col2, BYVAL X3, BYVAL Y3, Col3)
SHARED YS
' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1: SWAP Col2, Col1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1: SWAP Col3, Col1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2: SWAP Col3, Col2
IF Y3 < Top OR Y1 > Bottom THEN EXIT SUB
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
Col12 = Col1 - Col2: Col13 = Col1 - Col3: Col23 = Col2 - Col3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB

IF Y1 <> Y2 THEN
	xmint! = X21 / Y21: xbint! = X31 / Y31
	MidX! = X1: BottomX! = X1
	Aint! = Col12 / Y21: Bint! = Col13 / Y31
	a! = Col1: B! = Col1
	YRow = Y1 * 320
	FOR Y = Y1 TO Y2
		IF Y >= Top AND NOT (Y >= YS AND Y < YS + 30) THEN
			IF Y > Bottom THEN EXIT SUB
			MidX = MidX!: BottomX = BottomX!
			IF MidX <> BottomX THEN
				C! = (B! - a!) / ABS(MidX - BottomX)
				Col! = a!
				FOR X = MidX TO BottomX STEP S
					Col = Col!
					POKE X + YRow, Col   'PSET (X, Y), Col
					Col! = Col! + C!
				NEXT X
			END IF
		END IF
		MidX! = MidX! + xmint!: BottomX! = BottomX! + xbint!
		a! = a! - Aint!: B! = B! - Bint!
		YRow = YRow + 320
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	xmint! = X23 / Y23: xbint! = X13 / Y13
	MidX! = X3: TopX! = X3
	Aint! = Col23 / Y23: Bint! = Col13 / Y13
	a! = Col3: B! = Col3
	YRow = Y3 * 320
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y <= Bottom AND NOT (Y >= YS AND Y < YS + 30) THEN
			IF Y < Top THEN EXIT SUB
			MidX = MidX!: TopX = TopX!
			IF MidX <> TopX THEN
				C! = (B! - a!) / ABS(MidX - TopX)
				Col! = a!
				FOR X = MidX TO TopX STEP S
					Col = Col!
					POKE X + YRow, Col   'PSET (X, Y), Col
					Col! = Col! + C!
				NEXT X
			END IF
		END IF
		MidX! = MidX! - xmint!: TopX! = TopX! - xbint!
		a! = a! - Aint!: B! = B! - Bint!
		YRow = YRow - 320
	NEXT Y
END IF
END SUB

SUB TriTFill (BYVAL X1, BYVAL Y1, BYVAL X2, BYVAL Y2, BYVAL X3, BYVAL Y3, BYVAL face, BYVAL ftex)
SHARED YS
tx1 = tx1(face): ty1 = ty1(face)
tx2 = tx2(face): ty2 = ty2(face)
tx3 = tx3(face): ty3 = ty3(face)

' sort point pairs top-to-bottom
IF Y2 < Y1 THEN SWAP Y2, Y1: SWAP X2, X1: SWAP tx2, tx1: SWAP ty2, ty1
IF Y3 < Y1 THEN SWAP Y3, Y1: SWAP X3, X1: SWAP tx3, tx1: SWAP ty3, ty1
IF Y3 < Y2 THEN SWAP Y3, Y2: SWAP X3, X2: SWAP tx3, tx2: SWAP ty3, ty2
IF Y3 < Top OR Y1 > Bottom THEN EXIT SUB
Y21 = Y2 - Y1: Y31 = Y3 - Y1: X21 = X2 - X1: X31 = X3 - X1
Y23 = Y2 - Y3: Y13 = Y1 - Y3: X23 = X2 - X3: X13 = X1 - X3
tx12 = tx1 - tx2: tx13 = tx1 - tx3: tx23 = tx2 - tx3
ty12 = ty1 - ty2: ty13 = ty1 - ty3: ty23 = ty2 - ty3
IF Y31 = 0 THEN EXIT SUB
S = SGN((X1 + (Y21 / Y31) * X31) - X2)
IF S = 0 THEN EXIT SUB

IF Y1 <> Y2 THEN
	xmint! = X21 / Y21: xbint! = X31 / Y31
	MidX! = X1: BottomX! = X1
	Axint! = tx12 / Y21: Bxint! = tx13 / Y31
	Ayint! = ty12 / Y21: Byint! = ty13 / Y31
	Ax! = tx1: Bx! = tx1
	Ay! = ty1: By! = ty1
	FOR Y = Y1 TO Y2
		IF Y > Bottom THEN EXIT SUB
		IF Y >= Top AND NOT (Y >= YS AND Y < YS + 30) THEN
			MidX = MidX!: BottomX = BottomX!
			IF MidX <> BottomX THEN
				YRow = Y * 320
				Cx! = (Bx! - Ax!) / ABS(MidX - BottomX)
				Cy! = (By! - Ay!) / ABS(MidX - BottomX)
				Tx! = Ax!: Ty! = Ay!
				FOR X = MidX TO BottomX STEP S
					Tx = Tx!: Ty = Ty!
					Col = tex(ftex, Tx, Ty)
					POKE X + YRow, Col
					Tx! = Tx! + Cx!: Ty! = Ty! + Cy!
				NEXT X
			END IF
		END IF
		MidX! = MidX! + xmint!: BottomX! = BottomX! + xbint!
		Ax! = Ax! - Axint!: Bx! = Bx! - Bxint!
		Ay! = Ay! - Ayint!: By! = By! - Byint!
	NEXT Y
END IF
IF Y2 <> Y3 THEN
	xmint! = X23 / Y23: xbint! = X13 / Y13
	MidX! = X3: TopX! = X3
	Axint! = tx23 / Y23: Bxint! = tx13 / Y13
	Ayint! = ty23 / Y23: Byint! = ty13 / Y13
	Ax! = tx3: Bx! = tx3
	Ay! = ty3: By! = ty3
	FOR Y = Y3 TO Y2 + 1 STEP -1
		IF Y < Top THEN EXIT SUB
		IF Y <= Bottom AND NOT (Y >= YS AND Y < YS + 30) THEN
			MidX = MidX!: TopX = TopX!
			IF MidX <> TopX THEN
				YRow = Y * 320
				Cx! = (Bx! - Ax!) / ABS(MidX - TopX)
				Cy! = (By! - Ay!) / ABS(MidX - TopX)
				Tx! = Ax!: Ty! = Ay!
				FOR X = MidX TO TopX STEP S
					Tx = Tx!: Ty = Ty!
					Col = tex(ftex, Tx, Ty)
					POKE X + YRow, Col
					Tx! = Tx! + Cx!: Ty! = Ty! + Cy!
				NEXT X
			END IF
		END IF
		MidX! = MidX! - xmint!: TopX! = TopX! - xbint!
		Ax! = Ax! - Axint!: Bx! = Bx! - Bxint!
		Ay! = Ay! - Ayint!: By! = By! - Byint!
	NEXT Y
END IF
END SUB

