// trackerDoc.h : interface of the CTrackerDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRACKERDOC_H__6647B059_FDFF_4D77_96A7_BA437A318857__INCLUDED_)
#define AFX_TRACKERDOC_H__6647B059_FDFF_4D77_96A7_BA437A318857__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "optionsdlg.h"
#include "gtkformat.h"
#include <windows.h>


// steffo
#include <mmsystem.h>



#include <mmreg.h>
#include <dsound.h>

#include "isPlayer.h"
#include "isSynth.h"

#define GTK_EDITSTATE_DEFAULT 0x0
#define GTK_EDITSTATE_PATTERNSELECT 0x01
#define GTK_EDITSTATE_TRACKSELECT 0x02

typedef struct EDITDATA EDITDATA;
typedef struct EDT_CURSOR EDT_CURSOR;
typedef struct EDTCOPYBUFFER EDTCOPYBUFFER;
#ifndef VK_OEM_102
#define VK_OEM_102        0xE2  //  "<>" or "\|" on RT 102-key kbd.
#endif

struct EDTCOPYBUFFER
{
  int hasdata;
  int colnum,posnum;
  GTK_PATTERNPOS **poslist;
    
};
struct EDT_CURSOR
{
  int num,pos,col,rowcol;
};
struct EDITDATA
{
	int trkpos,trkcol,trknum,trkposadd;
	int patpos,patcol,patnum,patposadd;
	int octave;
  int state;
  int patternmark;
  EDT_CURSOR beginmark,endmark;
  EDTCOPYBUFFER copybuffer;
};


class CTrackerDoc : public CDocument
{
protected: // create from serialization only
	CTrackerDoc();
	DECLARE_DYNCREATE(CTrackerDoc)

// Attributes
public:
	int playing;
	int play_seqpos,play_pattern, play_patternrow;
	isPlayer *pl;
  isSynth *synth;

	CString curFname;
	EDITDATA editData;
	//GTK_SONG song;
	GTK *gtk;


	COLORREF ctrl_bg,ctrl_light,ctrl_dark,ctrl_text,ctrl_curtext,ctrl_cursor,ctrl_marktext;
	_TCHAR fontface[128];
    int ctrl_latency;


// Operations
public:
	void ValidateEditData ();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTrackerDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	void LoadConfig (void);
	void SaveConfig (void);
	virtual ~CTrackerDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
public:
	//{{AFX_MSG(CTrackerDoc)
	afx_msg void OnMenuOptions();
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnFileOpen();
	afx_msg void OnMenuSongoptions();
	afx_msg void OnDeltaposSpinTcntrlPjump(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMenuSampleview();
	afx_msg void OnMenuMixerview();
	afx_msg void OnMenuSendfxeditor();
	afx_msg void OnMenuSamplepool();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKERDOC_H__6647B059_FDFF_4D77_96A7_BA437A318857__INCLUDED_)
