/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isOscillator_h
#define __isOscillator_h

#include "isBase.h"
#include "isModulator.h"
#include "isSamplePool.h"

enum isWaveForm {SINE1 = 0,PULSE1,PULSE2,TRI1,NOISE1,NOISE2,SAMPLE};
enum isMixMode	{ADD = 0,MUL};


class isOscillator : public isBase
{
public:
	isOscillator(isSamplePool &samplePool, isModulator **modList, isOscillator *mod=NULL);
	virtual ~isOscillator();

	void Load(isFile *f);
	void Save(isFile *f);
	void Play(int length,float *buff, int polyNr);
	void Event(isEVENT event, int polyNr);

	void SetBufferSize(int length); // for the temporary shared buffers in Params

	// variables
	float detune;
	float dc;
	unsigned char multiplier;
	signed char transpose;	// -128..127
	float portamento;				// 0.0f..1.0f weird results on polyphonic instruments
	isWaveForm wave;	// CAN be set by SetWave
	bool sync;
	isMixMode mode;
	float mix;
	float fm;

	// modulators (max is 256, so 8bits is enough for indexing)
	// 0 1 = DC  -  2 3 = Pitch  -  4 5 = FM Amount
	unsigned char modNr[6];
	// amount for each
	float modAmount[6];


private:
	isSamplePool &samplePool;
	float pong[MAXPOLY]; // +1.0 when going forward in sample, -1.0 when going backward
	isModulator  **modulatorList;
	// for rendering
	float baseFreq[MAXPOLY],newFreq[MAXPOLY];
	
	float c[MAXPOLY];
	float lc[MAXPOLY];
	float lastOut[MAXPOLY];
	// Parameters for the oscillator
	struct Params
	{
		bool sync;
		float sDC,eDC,sFreq,eFreq,sFM,eFM,cnt[MAXPOLY],lcnt[MAXPOLY];
		isOscillator *modulator;
	} params;
	static float *syncBuffer; // this is the sync info from the last rendered oscillator
	static float *buffer;			// this is the last rendered wave data
		
	void Sine1(int length, Params &p, int polyNr);	
	void Pulse1(int length, Params &p, int polyNr);
	void Pulse2(int length, Params &p, int polyNr);
	void Tri1(int length, Params &p, int polyNr);
	void Noise1(int length, Params &p, int polyNr);
	void Noise2(int length, Params &p, int polyNr);
	void Sample(int length, Params &p, int polyNr);

	void ModCounter(float &cnt, float &syncBuffer, bool &sync)
	{
		if(cnt>1.0f)
		{
			do
			{
				cnt-=1.0f;
			} while(cnt>1.0f);
			syncBuffer=cnt;
		}
		else if(cnt<0.0f)
		{
			do
			{
				cnt+=1.0f;
			} while(cnt<0.0f);
			syncBuffer=cnt;
		}
		else if(syncBuffer>=0.0f && sync) 
		{
			cnt=syncBuffer;
		}
		else
			syncBuffer=-1.0f;
	}
	
	long jng_seed[MAXPOLY];
	float jng_rand(int polyNr);
	
	// for integrals in sine1 and pulse2
	float sineX[MAXPOLY],pulseX[MAXPOLY];
};

#endif
