/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isLFO_h
#define __isLFO_h

#include "isModulator.h"
enum isLFOWave
{
	SINE = 0,
	SAW,
	SQUARE,
	TRIANGLE,
	RANDOM1,
	RANDOM2
};

class isLFO : public isModulator
{
public:
	isLFO();
	virtual ~isLFO();

	void Load(isFile *f);
	void Save(isFile *f);
	
	void Render(int polyNr);
	void Event(isEVENT event,int polyNr);

	isLFOWave wave;
	bool invert;
	float offset; // DC offset of the lfo
	unsigned char attack;		// attack in ticks
	bool retrig;	// retrig LFO on note on?
	float veloSens;
	unsigned int length; // only 16bits used.
private:
	
	float velo[MAXPOLY];
	unsigned int tickCounter[MAXPOLY],wCounter[MAXPOLY]; // tickCounter resets on each cycle, wCounter does not
	float sRand[MAXPOLY],eRand[MAXPOLY]; // for interpolation when using RANDOM2

};

#endif