/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <math.h>
#include <stdlib.h>
#include "isLFO.h"

isLFO::isLFO()
{
	// variables
	wave=RANDOM2;
	invert=true;
	offset=0.0f;
	attack=32;
	retrig=true;
	length=16;
	veloSens=0.0f;
	
	// private stuff
	for(int polyNr=0;polyNr<MAXPOLY;polyNr++)
	{
		velo[polyNr]=0.0f;
		tickCounter[polyNr]=wCounter[polyNr]=0;
		sRand[polyNr]=eRand[polyNr]=0.0f;
	}

	// for isBase
	type=is_LFO;
}

isLFO::~isLFO()
{

}

void isLFO::Load(isFile *f)
{
	wave=(isLFOWave)f->ReadInt(1);
	invert=f->ReadInt(1)==0?false:true;
	offset=f->ReadFloat();
	attack=f->ReadInt(1);
	retrig=f->ReadInt(1)==0?false:true;
	veloSens=f->ReadFloat();
	length=f->ReadInt(2);
}

void isLFO::Save(isFile *f)
{
	SaveType(f);
	f->WriteInt((unsigned char)wave,1);
	f->WriteInt(invert?1:0,1);
	f->WriteFloat(offset);
	f->WriteInt(attack,1);
	f->WriteInt(retrig?1:0,1);
	f->WriteFloat(veloSens);
	f->WriteInt(length,2);
}

void isLFO::Render(int polyNr)
{

	switch(wave)
	{
		case SINE:
			startValue[polyNr]=(float)sin(tickCounter[polyNr]*2.0f*3.14592f/length);
			endValue[polyNr]=(float)sin((tickCounter[polyNr]+1)*2.0f*3.14592f/length);
			break;
		case SAW:
			startValue[polyNr]=(float)tickCounter[polyNr]*2/length - 1.0f;
			endValue[polyNr]=(float)(tickCounter[polyNr]+1)*2/length - 1.0f;
			break;
		case SQUARE:
			startValue[polyNr]=(tickCounter[polyNr]<(length/2))?1.0f:-1.0f;
			endValue[polyNr]=startValue[polyNr];
			break;
		case TRIANGLE:
			if (tickCounter[polyNr]<(length/2)) 
			{
				startValue[polyNr]=(float)tickCounter[polyNr]*4.0f/(float)length-1.0f;
			}
			else 
			{
				startValue[polyNr]=1.0f-(float)(tickCounter[polyNr]-length/2)*4.0f/(float)length;
			}
			if ((tickCounter[polyNr]+1)<(length/2)) 
			{
				endValue[polyNr]=(float)(tickCounter[polyNr]+1)*4.0f/(float)length-1.0f;
			}
			else 
			{
				endValue[polyNr]=1.0f-(float)(tickCounter[polyNr]+1-length/2)*4.0f/(float)length;
			}
			break;
		case RANDOM1:
			if(tickCounter[polyNr]==0)
			{
				startValue[polyNr]=endValue[polyNr]=rand()*2.0f/RAND_MAX - 1.0f;
			}
			break;
		case RANDOM2:
			if (tickCounter[polyNr]==0) 
			{
				sRand[polyNr]=eRand[polyNr];
				eRand[polyNr]=rand()*2.0f/RAND_MAX - 1.0f;
			}
			startValue[polyNr]=eRand[polyNr]*((float)tickCounter[polyNr]/(float)length) + sRand[polyNr]*(1.0f-(float)tickCounter[polyNr]/(float)length);
			endValue[polyNr]=eRand[polyNr]*((float)(tickCounter[polyNr]+1)/(float)length) + sRand[polyNr]*(1.0f-(float)(tickCounter[polyNr]+1)/(float)length);
	}
	if(invert)
	{
		startValue[polyNr]=-startValue[polyNr];
		endValue[polyNr]=-endValue[polyNr];
	}
	// DC offset
	startValue[polyNr]+=offset;
	endValue[polyNr]+=offset;

	// attack envelope
	if (wCounter[polyNr]<attack) 
	{
		startValue[polyNr]*=(float)wCounter[polyNr]/(float)attack;
		endValue[polyNr]*=(float)wCounter[polyNr]/(float)attack;
	}
	
	// counter control :)
	tickCounter[polyNr]++;
	wCounter[polyNr]++;
	if (tickCounter[polyNr]==length) 
	{
		tickCounter[polyNr]=0;
	}
		
}

void isLFO::Event(isEVENT event, int polyNr)
{
	if(event.type==NOTE_ON)
	{
		wCounter[polyNr]=0;
		if(retrig)
			tickCounter[polyNr]=0;
		velo[polyNr]=event.param2/65535.0f;
	}
}
