/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <math.h>
#include "isFilter.h"

isFilter::isFilter(isModulator **modList)
{
	OutputDebugString("isFilter\n");
	// variables
	mode=LP;
	cutoff=1.0f;
	resonance=0.0f;
	gain=0.125f;
	for(int polyNr=0;polyNr<MAXPOLY;polyNr++)
	{
		lo[polyNr]=bp[polyNr]=0.0f;
		lo2[polyNr]=bp2[polyNr]=0.0f;
		for(int i=0;i<10;i++)
		{
			memory[i][polyNr]=0.0f;
		}
	}
	cascade=true;
	// set modulator stuff
	modNr[0]=0;
	modNr[1]=0;
	modNr[2]=0;

	modAmount[0]=0.0f;
	modAmount[1]=0.0f;
	modAmount[2]=0.0f;

	// private stuff
	modulatorList=modList;

	// for isBase
	type=is_FILTER;
}

isFilter::~isFilter()
{

}

void isFilter::Load(isFile *f)
{
	mode=(isFilterMode)f->ReadInt(1);
	cascade=f->ReadInt(1)==1;
	cutoff=f->ReadFloat();
	resonance=f->ReadFloat();
	gain=f->ReadFloat();

	for(int i=0;i<3;i++)
	{
		modNr[i]=f->ReadInt(1);
		modAmount[i]=f->ReadFloat();
	}
}

void isFilter::Save(isFile *f)
{
	SaveType(f);
	f->WriteInt((unsigned char)mode,1);
	f->WriteInt((unsigned char)cascade?1:0,1);
	f->WriteFloat(cutoff);
	f->WriteFloat(resonance);
	f->WriteFloat(gain);

	for(int i=0;i<3;i++)
	{
		f->WriteInt(modNr[i],1);
		f->WriteFloat(modAmount[i]);
	}

}


void isFilter::Play(float *buffer,int polyNr)
{
	float sCutoff,eCutoff,deltaCutoff;
	if(modulatorList[modNr[0]]!=NULL && modAmount[0]!=0.0f)
	{
		sCutoff=modulatorList[modNr[0]]->StartValue(polyNr)*modAmount[0];
		eCutoff=modulatorList[modNr[0]]->EndValue(polyNr)*modAmount[0];
		// check if we should do a mod1*mod3
		if(modulatorList[modNr[2]]!=NULL && modAmount[2]!=0.0f)
		{
			sCutoff*=1.0f*(1.0f-modAmount[2])+modulatorList[modNr[2]]->StartValue(polyNr)*modAmount[2];
			eCutoff*=1.0f*(1.0f-modAmount[2])+modulatorList[modNr[2]]->EndValue(polyNr)*modAmount[2];
		}
	}
	if(modulatorList[modNr[1]]!=NULL && modAmount[1]!=0.0f)
	{
		sCutoff+=modulatorList[modNr[1]]->StartValue(polyNr)*modAmount[1];
		eCutoff+=modulatorList[modNr[1]]->EndValue(polyNr)*modAmount[1];
	}
	float cf = 0;
	sCutoff+=cutoff;
	eCutoff+=cutoff;
	
	// some cutoff clamping :)
	if (sCutoff>CUTOFF_MAX) 
	{
		sCutoff=CUTOFF_MAX;
	}
	else if (sCutoff<CUTOFF_MIN)
	{
		sCutoff=CUTOFF_MIN;
	}
	if (eCutoff>CUTOFF_MAX) 
	{
		eCutoff=CUTOFF_MAX;
	}
	else if (eCutoff<CUTOFF_MIN) 
	{
		eCutoff=CUTOFF_MIN;
	}

	deltaCutoff=(eCutoff-sCutoff)/bufferLength;


	// the filtering goes here
	float rez;
	rez=1.0f-resonance;
	float *o[4];
	if(mode==FORMANT)
	{
		float vowelnum;
		for(unsigned int register i=0;i<bufferLength;i++)
		{
			vowelnum=sCutoff*4.0f;
			int v1=(int)vowelnum;
			int v2=v1+1;
			float xfade1=vowelnum-(int)vowelnum;
			float xfade2=1.0f-xfade1;

			buffer[i]= (float) ( 
			(coeff[v1][0]*xfade2+coeff[v2][0]*xfade1)  *buffer[i]*gain + 
			(coeff[v1][1]*xfade2+coeff[v2][1]*xfade1)  *memory[0][polyNr] +   
			(coeff[v1][2]*xfade2+coeff[v2][2]*xfade1)  *memory[1][polyNr] + 
			(coeff[v1][3]*xfade2+coeff[v2][3]*xfade1)  *memory[2][polyNr] + 
			(coeff[v1][4]*xfade2+coeff[v2][4]*xfade1)  *memory[3][polyNr] + 
			(coeff[v1][5]*xfade2+coeff[v2][5]*xfade1)  *memory[4][polyNr] + 
			(coeff[v1][6]*xfade2+coeff[v2][6]*xfade1)  *memory[5][polyNr] + 
			(coeff[v1][7]*xfade2+coeff[v2][7]*xfade1)  *memory[6][polyNr] + 
			(coeff[v1][8]*xfade2+coeff[v2][8]*xfade1)  *memory[7][polyNr] + 
			(coeff[v1][9]*xfade2+coeff[v2][9]*xfade1)  *memory[8][polyNr] + 
			(coeff[v1][10]*xfade2+coeff[v2][10]*xfade1) *memory[9][polyNr] );

			memory[9][polyNr]= memory[8][polyNr]; 
			memory[8][polyNr]= memory[7][polyNr]; 
			memory[7][polyNr]= memory[6][polyNr]; 
			memory[6][polyNr]= memory[5][polyNr]; 
			memory[5][polyNr]= memory[4][polyNr]; 
			memory[4][polyNr]= memory[3][polyNr]; 
			memory[3][polyNr]= memory[2][polyNr]; 
			memory[2][polyNr]= memory[1][polyNr]; 
			memory[1][polyNr]= memory[0][polyNr]; 
			memory[0][polyNr]=buffer[i]; 
			sCutoff+=deltaCutoff;
		}
	}
	else
	{
		if(cascade)
		{
			float *o2[4];
			o[0]=&lo[polyNr];
			o[1]=&hi[polyNr];
			o[2]=&bp[polyNr];
			o[3]=&bs[polyNr];
			o2[0]=&lo2[polyNr];
			o2[1]=&hi2[polyNr];
			o2[2]=&bp2[polyNr];
			o2[3]=&bs2[polyNr];
			cf=sCutoff;
			for(unsigned int register i=0;i<bufferLength;i++)
			{
				lo2[polyNr] = lo2[polyNr] + cf * bp2[polyNr];
				hi2[polyNr] = buffer[i]*gain - lo2[polyNr] - bp2[polyNr];
				bp2[polyNr] = cf * hi2[polyNr] + bp2[polyNr];
				bs2[polyNr] = hi2[polyNr] + lo2[polyNr];

				lo[polyNr] = lo[polyNr] + cf * bp[polyNr];
				hi[polyNr] = *(o2[mode]) - lo[polyNr] - rez*bp[polyNr];
				bp[polyNr] = cf * hi[polyNr] + bp[polyNr];
				bs[polyNr] = hi[polyNr] + lo[polyNr];
				buffer[i]=*(o[mode]);
				cf+=deltaCutoff;
			}
		}
		else
		{
			o[0]=&lo[polyNr];
			o[1]=&hi[polyNr];
			o[2]=&bp[polyNr];
			o[3]=&bs[polyNr];
			cf=sCutoff;
			for(unsigned int register i=0;i<bufferLength;i++)
			{
				lo[polyNr] = lo[polyNr] + cf * bp[polyNr];
				hi[polyNr] = buffer[i]*gain - lo[polyNr] - rez*bp[polyNr];
				bp[polyNr] = cf * hi[polyNr] + bp[polyNr];
				bs[polyNr] = hi[polyNr] + lo[polyNr];
				buffer[i]=*(o[mode]);
				cf+=deltaCutoff;
			}
		}
	}
}

const double isFilter::coeff[5][11]= { 
		{ 8.11044e-06, 
		8.943665402, -36.83889529, 92.01697887, -154.337906, 181.6233289, 
		-151.8651235,   89.09614114, -35.10298511, 8.388101016, -0.923313471  ///A 
		}, 
		{4.36215e-06, 
		8.90438318, -36.55179099, 91.05750846, -152.422234, 179.1170248,  ///E 
		-149.6496211,87.78352223, -34.60687431, 8.282228154, -0.914150747 
		}, 
		{ 3.33819e-06, 
		8.893102966, -36.49532826, 90.96543286, -152.4545478, 179.4835618, 
		-150.315433, 88.43409371, -34.98612086, 8.407803364, -0.932568035  ///I 
		}, 
		{1.13572e-06, 
		8.994734087, -37.2084849, 93.22900521, -156.6929844, 184.596544,   ///O 
		-154.3755513, 90.49663749, -35.58964535, 8.478996281, -0.929252233 
		}, 
		{4.09431e-07, 
		8.997322763, -37.20218544, 93.11385476, -156.2530937, 183.7080141,  ///U 
		-153.2631681, 89.59539726, -35.12454591, 8.338655623, -0.910251753 
		} 
		}; 