/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include <math.h>

#include "isDistortion.h"

isDistortion::isDistortion() 
{
	OutputDebugString("isFilter\n");

	// variables
	mode=HARD;
 	dist=1.0f;
	outputVolume=1.0f;

	// for isBase
	type=is_DISTORTION;
}

isDistortion::~isDistortion()
{

}

void isDistortion::Load(isFile *f)
{
	dist=f->ReadFloat();
	outputVolume=f->ReadFloat();
	mode=(isDISTMODE)f->ReadInt(1);
}

void isDistortion::Save(isFile *f)
{
	
	SaveType(f);
	f->WriteFloat(dist);
	f->WriteFloat(outputVolume);
	f->WriteInt((unsigned char)mode,1);
}

void isDistortion::Play(float *buffer, int polyNr)
{
	unsigned int i;
	float *b=buffer;
	switch(mode) 
	{
	case HARD:
		for(i=0;i<bufferLength;i++)
		{
			(*b)*=dist*outputVolume;
			if(*b>outputVolume) *b=outputVolume;
			else if(*b<-outputVolume) *b=-outputVolume;
			b++;
		}
		break;
	case SOFT:
		for(i=0;i<bufferLength;i++)
		{
			*b*=dist;
			*b=*b*(12**b**b + 144.0f)*outputVolume / (*b**b*(*b**b+60.0f) + 144.0f);
			b++;
		}
		break;
	case SIN:
		for(i=0;i<bufferLength;i++)
		{
			*b=sinf((*b)*dist)*outputVolume;
			b++;
		}
		break;
	}

}