/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#include "isInsert.h"
#include "isDelay.h"

isDelay::isDelay()
{
	left.delay=32;
	left.echoLength=32;
	left.volume=0.5f;
	left.feedback=0.5f;

	right.delay=16;
	right.echoLength=32;
	right.volume=0.5f;
	right.feedback=0.5f;
	
	dryMix=0.5f;
	
	for(int b=0;b<MAXDELAY;b++)
	{
		buffersLeft[b]=NULL;
		buffersRight[b]=NULL;
	}
	Update(); // activate settings
	
	// for isBase
	type=is_DELAY;
}

isDelay::~isDelay()
{
	for(int b=0;b<MAXDELAY;b++)
	{
		delete []buffersLeft[b];
		delete []buffersRight[b];
	}
}

void isDelay::Save(isFile *f)
{
	SaveType(f);

	f->WriteInt(left.delay,1);
	f->WriteInt(left.echoLength,1);
	f->WriteFloat(left.volume);
	f->WriteFloat(left.feedback);

	f->WriteInt(right.delay,1);
	f->WriteInt(right.echoLength,1);
	f->WriteFloat(right.volume);
	f->WriteFloat(right.feedback);

	f->WriteFloat(dryMix);
}

void isDelay::Load(isFile *f)
{

	left.delay=f->ReadInt(1);
	left.echoLength=f->ReadInt(1);
	left.volume=f->ReadFloat();
	left.feedback=f->ReadFloat();

	right.delay=f->ReadInt(1);
	right.echoLength=f->ReadInt(1);
	right.volume=f->ReadFloat();
	right.feedback=f->ReadFloat();

	dryMix=f->ReadFloat();

	Update();
	
}

void isDelay::Play(float *leftIn, float *rightIn, float *leftOut, float *rightOut)
{

	// DAAAAN KOD
	if (totalLengthLeft >= (MAXDELAY-1)) totalLengthLeft = (MAXDELAY-1);
	if (totalLengthRight >= (MAXDELAY-1)) totalLengthRight = (MAXDELAY-1);

	if(tickCountLeft>totalLengthLeft)				tickCountLeft=0;
	if(delayTickCountLeft>totalLengthLeft)	delayTickCountLeft=0;
	if(echoTickCountLeft>totalLengthLeft)		echoTickCountLeft=0;
	if(tickCountRight>totalLengthRight)				tickCountRight=0;
	if(delayTickCountRight>totalLengthRight)	delayTickCountRight=0;
	if(echoTickCountRight>totalLengthRight)		echoTickCountRight=0;
	


	for(unsigned int b=0;b<bufferLength;b++)
	{
		// first left channel
		// trying to get some feedback
		// write buffer to delay 
		buffersLeft[delayTickCountLeft][b]+=buffersLeft[echoTickCountLeft][b]*left.feedback;
		// write buffer to delay 
		buffersLeft[tickCountLeft][b]=leftIn[b];
		// write delay to output
		leftOut[b]+=buffersLeft[delayTickCountLeft][b]*left.volume + leftIn[b]*dryMix;
		
		// then right channel
		// trying to get some feedback
		// write buffer to delay 
		buffersRight[delayTickCountRight][b]+=buffersRight[echoTickCountRight][b]*right.feedback;
		// write buffer to delay 
		buffersRight[tickCountRight][b]=rightIn[b];
		// write delay to output
		rightOut[b]+=buffersRight[delayTickCountRight][b]*right.volume + rightIn[b]*dryMix;
		
	}

	// left counters
	tickCountLeft++;
	delayTickCountLeft++;
	echoTickCountLeft++;
	if(tickCountLeft>totalLengthLeft)				tickCountLeft=0;
	if(delayTickCountLeft>totalLengthLeft)	delayTickCountLeft=0;
	if(echoTickCountLeft>totalLengthLeft)		echoTickCountLeft=0;
	
	// right counters
	tickCountRight++;
	delayTickCountRight++;
	echoTickCountRight++;
	if(tickCountRight>totalLengthRight)				tickCountRight=0;
	if(delayTickCountRight>totalLengthRight)	delayTickCountRight=0;
	if(echoTickCountRight>totalLengthRight)		echoTickCountRight=0;
	
}

void isDelay::SetBufferSize(unsigned int length)
{
	bufferLength=length;
	isStereoFX::SetBufferSize(length);
	unsigned int b,i;
	
	for(b=0;b<MAXDELAY;b++)
	{
		if(buffersLeft[b]!=NULL) // is something allocated? delete it
		{	
			delete []buffersLeft[b];
			delete []buffersRight[b];
		}
		
		buffersLeft[b]=new float[length];		
		buffersRight[b]=new float[length];		
					// clear the buffers
		for(i=0;i<length;i++)
			buffersLeft[b][i]=buffersRight[b][i]=0.0f;
	}	
}

void isDelay::Update()
{
	totalLengthLeft=left.delay+left.echoLength;
	tickCountLeft=totalLengthLeft;
	delayTickCountLeft=left.echoLength;
	echoTickCountLeft=0;
	
	totalLengthRight=right.delay+right.echoLength;
	tickCountRight=totalLengthRight;
	delayTickCountRight=right.echoLength;
	echoTickCountRight=0;	
}