/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isBase_h
#define __isBase_h

#include "isFile.h"
#include "isEVENT.h"

const int MAXPOLY=256;

enum isTYPE
{
	is_UNDEFINED = 0, // this should really not happen, blame steffo if it happens
	// modulators
	is_ENVELOPE,
	is_LFO,
	is_CONTROLLER,
	
	// generators (I will probably not implement any more, I'll add stuff to isOscillator instead)
	is_OSCILLATOR,
	
	// inserts
	is_FILTER,
	is_DISTORTION,

	// stereo fx
	is_DELAY,
	is_CHORUS

};


class isBase  
{
public:
	isBase();
	virtual ~isBase();
	virtual void Save(isFile *f);
	virtual void Load(isFile *f);
	
	void SaveType(isFile *f);
	isTYPE LoadType(isFile *f);
	
	virtual void Event(isEVENT, int) {}; // all classes handling events has to implement this (generators/modulators/filters mainly)
	
	isTYPE GetType() { return type; };

	// temporary "global" buffers used by lots of generators/filters/send effects
	// 0 used for rendering instrument (they are rendered in mono, stereo comes later on)
	// 1,2 used for rendering oscillators
	// 3 
	static float **tempBuffer;
	
	// misc. methods ("global functions")
	inline float SoftClipping(float in) { return in*(12*in*in + 144.0f) / (in*in*(in*in+60.0f) + 144.0f); };
protected:
	isTYPE type;
};

#endif
