// CInstrEditor.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "instrEditor.h"
#include "oscillatoredit.h"
#include "modulatormain.h"
#include "insertmain.h"
#include "isSynth.h"
#include "isDistortion.h"
#include "trackerdoc.h"
#include "channelmixer.h"
#include "Globals.h"
#include "MIDIInput.h"

#include <string.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static void dbgf (char *str, ...)
{
    va_list values;
    char newstr[1024];
    
    va_start( values, str );
    vsprintf( newstr, str, values);
    va_end( values);
    OutputDebugString (newstr);
}


/////////////////////////////////////////////////////////////////////////////
// instrEditor

IMPLEMENT_DYNCREATE(CInstrEditor, CFormView)

CInstrEditor::CInstrEditor()
	: CFormView(CInstrEditor::IDD)
{	
	cursel_voice = 0;
	//{{AFX_DATA_INIT(CInstrEditor)
	m_useDist = FALSE;
	m_vol0ModAmount = 0.0f;
	m_vol1ModAmount = 0.0f;
	m_enable_arp = FALSE;
	//}}AFX_DATA_INIT
}

CInstrEditor::~CInstrEditor()
{
}


void CInstrEditor::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInstrEditor)
	DDX_Control(pDX, IDC_COMBO_VOL1MODNR, m_vol1ModNr);
	DDX_Control(pDX, IDC_COMBO_VOL0MODNR, m_vol0ModNR);
	DDX_Control(pDX, IDC_TEXT_DIST_AMOUNT, m_instrDistAmText);
	DDX_Control(pDX, IDC_TEXT_POLYFONI, m_textPolyCount);
	DDX_Control(pDX, IDC_TEXT_NRANGE_START, m_textNRangeStart);
	DDX_Control(pDX, IDC_TEXT_NRANGE_END, m_textNRangeEnd);
	DDX_Control(pDX, IDC_SLIDER_INSTR_DIST_AMOUNT, m_instrDistAmount);
	DDX_Control(pDX, IDC_COMBO_INSTR_DIST_TYPE, m_instrDistType);
	DDX_Control(pDX, IDC_SLIDER_NOTEREND, m_noterangeend);
	DDX_Control(pDX, IDC_SLIDER_NOTERSTART, m_noterangestart);
	DDX_Control(pDX, IDC_LIST_VOICE, m_voicelist);
	DDX_Control(pDX, IDC_COMBO_INSTRUMENT, m_instrlist);
	DDX_Control(pDX, IDC_TAB_SUBOBJECTS, m_subObects);
	DDX_Check(pDX, IDC_CHECK_USEDIST, m_useDist);
	DDX_Text(pDX, IDC_EDIT_VOL0MODAMOUNT, m_vol0ModAmount);
	DDX_Text(pDX, IDC_EDIT_VOL1MODAMOUNT, m_vol1ModAmount);
	DDX_Check(pDX, IDC_ENABLEARP, m_enable_arp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInstrEditor, CFormView)
	//{{AFX_MSG_MAP(CInstrEditor)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_SUBOBJECTS, OnSelchangeTabSubobjects)
	ON_BN_CLICKED(IDC_BUTTON_DELVOICE, OnButtonDelvoice)
	ON_LBN_SELCHANGE(IDC_LIST_VOICE, OnSelchangeListVoice)
	ON_WM_HSCROLL()
	ON_CBN_SELCHANGE(IDC_COMBO_INSTRUMENT, OnSelchangeComboInstrument)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_NRPOLYFONI, OnDeltaposSpinNrpolyfoni)
	ON_BN_CLICKED(IDC_CHECK_USEDIST, OnCheckUsedist)
	ON_CBN_SELCHANGE(IDC_COMBO_INSTR_DIST_TYPE, OnSelchangeComboInstrDistType)
	ON_BN_CLICKED(IDC_BUTTON_INSTRSAVE, OnButtonInstrsave)
	ON_BN_CLICKED(IDC_BUTTON_INSTRLOAD, OnButtonInstrload)
    ON_CBN_SELCHANGE(IDC_COMBO_VOL0MODNR, OnSelchangeCombo)
    ON_EN_MAXTEXT(IDC_EDIT_VOL0MODAMOUNT, OnMaxtextEditVolMod)
	ON_EN_CHANGE(IDC_EDIT_VOL0MODAMOUNT, OnChangeEditVol0modamount)
	ON_EN_CHANGE(IDC_EDIT_VOL1MODAMOUNT, OnChangeEditVol1modamount)
	ON_EN_KILLFOCUS(IDC_EDIT_VOL0MODAMOUNT, OnKillfocusEditVol0modamount)
	ON_EN_KILLFOCUS(IDC_EDIT_VOL1MODAMOUNT, OnKillfocusEditVol1modamount)
	ON_BN_CLICKED(IDC_BUTTON2, OnEditArpeggio)
	ON_BN_CLICKED(IDC_BUTTON_ADDVOICE, OnButtonAddvoice)
    ON_CBN_SELCHANGE(IDC_COMBO_VOL1MODNR, OnSelchangeCombo)
    ON_EN_MAXTEXT(IDC_EDIT_VOL1MODAMOUNT, OnMaxtextEditVolMod)
	ON_BN_CLICKED(IDC_ENABLEARP, OnEnablearp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInstrEditor diagnostics

#ifdef _DEBUG
void CInstrEditor::AssertValid() const
{
	CFormView::AssertValid();
}

void CInstrEditor::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

#endif //_DEBUG

CTrackerDoc* CInstrEditor::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrackerDoc)));
    return (CTrackerDoc*)m_pDocument;
}


/////////////////////////////////////////////////////////////////////////////
// CInstrEditor message handlers

static CChannelMixer *dummy;
void CInstrEditor::OnInitialUpdate() 
{
    CTrackerDoc *pDoc = GetDocument();
    isSynth *synth;

	CFormView::OnInitialUpdate();
	
    // TODO: Add your specialized code here and/or call the base class
    m_subObects.InsertItem(0,"Oscillaotrs");
    m_subObects.InsertItem(1,"Modulators");
    m_subObects.InsertItem(2,"Inserts");

    CRect wrect;
    current = (CVoiceBaseDlg*)new COscillatorEdit();
    current->Create(MAKEINTRESOURCE(IDD_DIALOG_OSCIALLTOR),&m_subObects);
    current->UpdateWindow();
    current->ShowWindow(SW_SHOW);
    current->GetClientRect(&wrect);
    current->MoveWindow(4,40,wrect.Width(),wrect.Height());


    // this must reflect the current number of octaves
    m_noterangestart.SetRange(1,102);
    m_noterangeend.SetRange(1,102);
    

    synth = GetSynth();
    int i;
    char iname[64];

    for (i=0;i<16;i++)
    {
        synth->instrument[i];
        sprintf (iname,"Instrument%d",i);
        m_instrlist.InsertString(i,iname);
        m_instrlist.SetItemData(i,(DWORD)i);
    }
    m_instrlist.SetCurSel(0);

    


    SetUpVoices(0);



    m_instrDistType.InsertString(0,"Hard");
    m_instrDistType.SetItemData(0,HARD);
    m_instrDistType.InsertString(1,"Soft");
    m_instrDistType.SetItemData(1,SOFT);
    m_instrDistType.InsertString(2,"Sin");
    m_instrDistType.SetItemData(2,SIN);

    m_instrDistAmount.SetRange(0,64 * 512);

    UpdateData (FALSE);   
    
  
}

void CInstrEditor::OnSelchangeTabSubobjects(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

  CRect wrect;
  int wt=m_subObects.GetCurSel();

  delete current;
  switch (wt)
  {
    case 0 :
      current = (CVoiceBaseDlg *)new COscillatorEdit();
      current->Create(MAKEINTRESOURCE(IDD_DIALOG_OSCIALLTOR),&m_subObects);
      break;
    case 1 :
      current = (CVoiceBaseDlg*)new CModulatorMain();
      current->Create(MAKEINTRESOURCE(IDD_DIALOG_MODULATEMAIN),&m_subObects);
      ((CModulatorMain *)current)->ownerDlg = this;
      break;
    case 2 :
      current = (CVoiceBaseDlg*)new CInsertMain();
      current->Create(MAKEINTRESOURCE(IDD_DIALOG_INSERTSMAIN),&m_subObects);
      break;
/*
    case 3 :
        current = (CVoiceBaseDlg*)new COscillatorEdit();
        current->Create(MAKEINTRESOURCE(IDD_DIALOG_OSCIALLTOR),&m_subObects);
        break;
*/
  }
  current->UpdateWindow();
  current->ShowWindow(SW_SHOW);
  current->GetClientRect(&wrect);
  current->MoveWindow(4,40,wrect.Width(),wrect.Height());
  UpdateCurrent();


  *pResult = 0;
}

void CInstrEditor::SetUpVoices(int instrnr)
{
    int i,num;
    char vname[64];
    isSynth *synth = GetSynth();

    num = synth->instrument[instrnr]->GetNrOfVoices();

    m_voicelist.ResetContent();

    for (i=0;i<num;i++)
    {
        sprintf (vname,"Voice%d",i);
        m_voicelist.InsertString(i,vname);
        m_voicelist.SetItemData(i,i);
    }

    m_useDist = synth->instrument[instrnr]->enableDistortion;
	m_enable_arp = synth->instrument[instrnr]->enableArpeggiator;
    UpdateData(false);
    cursel_voice=0;
    UpdateCurrent ();

    GetVoiceData ();
}

isSynth * CInstrEditor::GetSynth()
{
  CTrackerDoc *pDoc = GetDocument();
  return (pDoc->synth);
  
}
isInstrument *CInstrEditor::GetInstr()
{
    int instr;
    isSynth *synth = GetSynth();
    isInstrument *instrpek;
    instr = m_instrlist.GetCurSel(); 
    instr = m_instrlist.GetItemData (instr);
    instrpek = synth->instrument[instr];

    return instrpek;
}


void CInstrEditor::UpdateCurrent()
{
    isInstrument *instrpek;
    instrpek=GetInstr();

    current->SetVoice (instrpek->GetVoice(cursel_voice),instrpek,GetSynth());
    current->UpdateVoiceData();


}

void CInstrEditor::OnButtonAddvoice() 
{
	// TODO: Add your control notification handler code here
/*
    isVoice *voice;
    isSynth *synth = GetSynth();
    */
    int curinst;

    isInstrument *instrpek;
    instrpek=GetInstr();


    curinst = m_instrlist.GetCurSel();
    curinst = m_instrlist.GetItemData (curinst);
    instrpek->IncVoice ();
    
    SetUpVoices(curinst);
	
}

void CInstrEditor::OnButtonDelvoice() 
{
	// TODO: Add your control notification handler code here
    isVoice *voice;
    isSynth *synth = GetSynth();
    int curinst;
    
    curinst = m_instrlist.GetCurSel();
    curinst = m_instrlist.GetItemData (curinst);
    if (synth->instrument[curinst]->GetNrOfVoices() > 1)
    {
        synth->instrument[curinst]->DecVoice();
        SetUpVoices(curinst);
    }
    
	
}

void CInstrEditor::OnSelchangeListVoice() 
{
	// TODO: Add your control notification handler code here

    int idx;

    idx = m_voicelist.GetCurSel();
    cursel_voice = m_voicelist.GetItemData(idx);
    UpdateCurrent();
    GetVoiceData();
	
}

void CInstrEditor::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default


    SetVoiceData();

    
    
	CFormView::OnHScroll(nSBCode, nPos, pScrollBar);
}
isVoice *CInstrEditor::GetVoice(void)
{

    isInstrument *instrpek;
    instrpek=GetInstr();
    isVoice *voice;
    
    voice = instrpek->GetVoice(cursel_voice);
    return voice;
}
// set data in voice from controllers
void CInstrEditor::SetVoiceData()
{
    isVoice *voice;
    
    //voice = instrpek->GetVoice(cursel_voice);
    voice = GetVoice ();    

    // Make sure controller data are saved in controller var's
    // prepare controllers for retrievial
    UpdateData (TRUE);
    
    voice->noteRangeEnd = m_noterangeend.GetPos();
    voice->noteRangeStart = m_noterangestart.GetPos();    

    isInstrument *instrpek;
    instrpek = GetInstr();

    float distam = m_instrDistAmount.GetPos() / 512.0f;
    instrpek->distortion.dist = distam;    


    int idx = m_instrDistType.GetCurSel();
    idx = m_instrDistType.GetItemData(idx);
    
    dbgf ("\n[set] DistType (old, topindex) %d to %d\n",instrpek->distortion.mode,idx);
    instrpek->distortion.mode = (isDISTMODE)idx;

    voice->modAmount[0] = m_vol0ModAmount;
    voice->modAmount[1] = m_vol1ModAmount;

    voice->modNr[0] = m_vol0ModNR.GetItemData(m_vol0ModNR.GetCurSel());
    voice->modNr[1] = m_vol1ModNr.GetItemData(m_vol1ModNr.GetCurSel());

 
//    instrpek->Update();

    UpdateCntrlText ();    
}
// reset and fill the combo boxes for volume modulators
void CInstrEditor::FillVolModCombo()
{
    int i;
    char buffer[128];

    isVoice *voice = GetVoice ();
    
    m_vol0ModNR.ResetContent();
    m_vol1ModNr.ResetContent();
    
    for(i=0;i<voice->GetNrOfModulators();i++)
    {
        sprintf (buffer,"modnr:%d",i);
        m_vol0ModNR.InsertString(i,buffer);
        m_vol0ModNR.SetItemData(i,i);
        m_vol1ModNr.InsertString(i,buffer);
        m_vol1ModNr.SetItemData(i,i);
    }
    m_vol0ModNR.SetCurSel(voice->modNr[0]);
    m_vol1ModNr.SetCurSel(voice->modNr[1]);

    if (voice->GetNrOfModulators() != m_vol0ModNR.GetCount())
        FillVolModCombo();
    
}
// reflect controller support texts
void CInstrEditor::UpdateCntrlText (void)
{
    char buf[128];
    isVoice *voice = GetVoice ();
    
    
    sprintf (buf,"%d",voice->noteRangeEnd);
    m_textNRangeEnd.SetWindowText (buf);
    sprintf (buf,"%d",voice->noteRangeStart);
    m_textNRangeStart.SetWindowText (buf);


    isInstrument *instrpek;
    instrpek=GetInstr();
    
	int pcount = instrpek->GetVoice(cursel_voice)->GetPoly();
//    int pcount = instrpek->GetPoly (cursel_voice);


    if (instrpek->enableDistortion)
    {
        int t = instrpek->distortion.mode;

        m_instrDistType.SetCurSel(t);
        sprintf (buf,"%2.4f",instrpek->distortion.dist);
        m_instrDistAmText.SetWindowText (buf);
        m_instrDistAmount.SetPos (instrpek->distortion.dist * 512);

        dbgf ("[get] DistType: %d\n",m_instrDistType.GetTopIndex());
        
    } else
    {
        m_instrDistType.SetTopIndex(-1);
        m_instrDistAmText.SetWindowText("<unused>");
        m_instrDistAmount.SetPos (0);
    }
    sprintf (buf,"%d",pcount);
    m_textPolyCount.SetWindowText (buf);


    if (voice->GetNrOfModulators() != m_vol0ModNR.GetCount())
        FillVolModCombo();

}
// collect voice data and set in controllers
void CInstrEditor::GetVoiceData()
{
    int instr;
    isVoice *voice = GetVoice ();
    
    m_noterangeend.SetPos(voice->noteRangeEnd);    
    m_noterangestart.SetPos(voice->noteRangeStart);

    if (GetInstr()->enableDistortion)
        m_instrDistAmount.SetPos(GetInstr()->distortion.dist * 512.0f);

    m_vol0ModAmount = voice->modAmount[0];
    m_vol1ModAmount = voice->modAmount[1];
    
    FillVolModCombo();        

    // Tell the dialog controller they have new data to show!
    UpdateData(FALSE);  
    UpdateCntrlText ();    
    
}

void CInstrEditor::OnSelchangeComboInstrument() 
{
	// TODO: Add your control notification handler code here
    int idx;
    idx = m_instrlist.GetCurSel();
    idx = m_instrlist.GetItemData(idx);
    SetUpVoices(idx);
	
}

void CInstrEditor::OnDeltaposSpinNrpolyfoni(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here

    isInstrument *instrpek;
    instrpek=GetInstr();


    if (pNMUpDown->iDelta < 0)
//        instrpek->IncPoly (cursel_voice);
		instrpek->GetVoice(cursel_voice)->IncPoly();

    else
    {
//        if (instrpek->GetPoly (cursel_voice) > 1)
//            instrpek->DecPoly (cursel_voice);
		if(instrpek->GetVoice(cursel_voice)->GetPoly() > 1)
			instrpek->GetVoice(cursel_voice)->DecPoly();
    }

    UpdateCntrlText();
    
	*pResult = 0;
}

void CInstrEditor::OnCheckUsedist() 
{
	// TODO: Add your control notification handler code here
    UpdateData();
    GetInstr()->enableDistortion = m_useDist;
//    GetInstr()->Update();

}

void CInstrEditor::OnSelchangeComboInstrDistType() 
{
	// TODO: Add your control notification handler code here
    SetVoiceData();
	
}

void CInstrEditor::OnButtonInstrsave() 
{
	// TODO: Add your control notification handler code here
    CFileDialog dlg(FALSE);
//    GetInstr()->Update();
    if (dlg.DoModal()==IDOK)
    {
        CString fn;
        fn = dlg.GetPathName();

        HANDLE fh = CreateFile ((LPCSTR)fn,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
        if (fh != INVALID_HANDLE_VALUE)
        {
            isFile isf(fh,FALSE);
            GetInstr()->Save(&isf);
            CloseHandle(fh);
        } else
            AfxMessageBox("Unable to save file\nCould not open file");
    }

	
}

void CInstrEditor::OnButtonInstrload() 
{
	// TODO: Add your control notification handler code here
    CTrackerDoc *pDoc = GetDocument();
    CFileDialog dlg(TRUE);

    pDoc->pl->Stop();

//    GetInstr()->Update();
    if (dlg.DoModal()==IDOK)
    {
        CString fn;
        fn = dlg.GetPathName();
        
        HANDLE fh = CreateFile ((LPCSTR)fn,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
        if (fh != INVALID_HANDLE_VALUE)
        {
            isFile isf(fh,FALSE);
            GetInstr()->Load(&isf);
            CloseHandle(fh);
        } else
            AfxMessageBox("Unable to open file");

        UpdateCntrlText();

        int instr;
        instr = m_instrlist.GetCurSel(); 
        instr = m_instrlist.GetItemData (instr);
        SetUpVoices(instr);
//	    GetInstr()->Update();
    }
    
}


void CInstrEditor::OnSelchangeCombo() 
{
	// TODO: Add your control notification handler code here
	SetVoiceData();
}

void CInstrEditor::OnMaxtextEditVolMod() 
{
	// TODO: Add your control notification handler code here
    SetVoiceData();	
}


void CInstrEditor::OnMIDIKeyDown( UINT key, UINT velocity )
{
	int note = key + 1;

    isVoice *voice;
    isSynth *synth = GetSynth();
    int curinst;  
    curinst = m_instrlist.GetCurSel();
    curinst = m_instrlist.GetItemData (curinst);

	isEVENT event;
	event.type = NOTE_ON;
	event.param1 = note;
	event.param2 = velocity;
    synth->instrument[curinst]->Event( event );

	MIDIReceptor::OnMIDIKeyDown( key, velocity );
	
}

void CInstrEditor::OnMIDIKeyUp( UINT key, UINT velocity )
{
	int note = key + 1;

    isVoice *voice;
    isSynth *synth = GetSynth();
    int curinst;  
    curinst = m_instrlist.GetCurSel();
    curinst = m_instrlist.GetItemData (curinst);

	isEVENT event;
	event.type = NOTE_OFF;
	event.param1 = note;
	event.param2 = velocity;
    synth->instrument[curinst]->Event( event );


	MIDIReceptor::OnMIDIKeyUp( key, velocity );
}

void CInstrEditor::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (TRUE == bActivate) {
		g_midi_input->setmsgdest( m_hWnd );
	} else {
		g_midi_input->endmsgdest( m_hWnd );
	}
	
	CFormView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

LRESULT CInstrEditor::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	MIDIReceptor::FilterMidiMsg( message, wParam, lParam );	
	return CFormView::WindowProc(message, wParam, lParam);
}

BOOL CInstrEditor::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	// TODO: Add your specialized code here and/or call the base class	
	
	return CFormView::OnNotify(wParam, lParam, pResult);
}

void CInstrEditor::OnChangeEditVol0modamount() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.	
	// TODO: Add your control notification handler code here
	
}

void CInstrEditor::OnChangeEditVol1modamount() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}

void CInstrEditor::OnKillfocusEditVol0modamount() 
{
	// TODO: Add your control notification handler code here
	SetVoiceData();		
}

void CInstrEditor::OnKillfocusEditVol1modamount() 
{
	// TODO: Add your control notification handler code here
	SetVoiceData();			
}

void CInstrEditor::OnEditArpeggio() 
{
	// TODO: Add your control notification handler code here
	m_arpeditor.m_instrument = GetInstr();
	if (m_arpeditor.m_instrument)
		m_arpeditor.DoModal();
}

void CInstrEditor::OnEnablearp() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	GetInstr()->enableArpeggiator = m_enable_arp;
}
