// OscillatorEdit.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "OscillatorEdit.h"
#include "isSynth.h"
#include "tkerror.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)

/////////////////////////////////////////////////////////////////////////////
// COscillatorEdit dialog


COscillatorEdit::COscillatorEdit(CWnd* pParent /*=NULL*/)
	: CVoiceBaseDlg(COscillatorEdit::IDD, pParent)
{
	//{{AFX_DATA_INIT(COscillatorEdit)
	//}}AFX_DATA_INIT
}


void COscillatorEdit::DoDataExchange(CDataExchange* pDX)
{
	CVoiceBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COscillatorEdit)
	DDX_Control(pDX, IDC_CHECK_SYNC, m_sync);
	DDX_Control(pDX, IDC_STATIC_TRANSVAL, m_transval);
	DDX_Control(pDX, IDC_STATIC_PORTAVAL, m_portaval);
	DDX_Control(pDX, IDC_STATIC_MULVAL, m_mulval);
	DDX_Control(pDX, IDC_STATIC_MIXVAL, m_mixval);
	DDX_Control(pDX, IDC_STATIC_FMVAL, m_fmval);
	DDX_Control(pDX, IDC_STATIC_DCVAL, m_dcval);
	DDX_Control(pDX, IDC_SLIDER_OSC_TRANS, m_transSlider);
	DDX_Control(pDX, IDC_SLIDER_OSC_PORTA, m_portaSlider);
	DDX_Control(pDX, IDC_LIST_OSCILLATORS, m_osclist);
	DDX_Control(pDX, IDC_EDIT_DC0, m_dc0Edit);
	DDX_Control(pDX, IDC_EDIT_P1, m_p1Edit);
	DDX_Control(pDX, IDC_EDIT_P0, m_p0Edit);
	DDX_Control(pDX, IDC_EDIT_FM1, m_fm1Edit);
	DDX_Control(pDX, IDC_EDIT_FM0, m_fm0Edit);
	DDX_Control(pDX, IDC_EDIT_DC1, m_dc1Edit);
	DDX_Control(pDX, IDC_COMBO_P1, m_p1List);
	DDX_Control(pDX, IDC_COMBO_P0, m_p0List);
	DDX_Control(pDX, IDC_COMBO_FM1, m_fm1List);
	DDX_Control(pDX, IDC_COMBO_FM0, m_fm0List);
	DDX_Control(pDX, IDC_COMBO_DC1, m_dc1List);
	DDX_Control(pDX, IDC_COMBO_DC0, m_dc0List);
	DDX_Control(pDX, IDC_EDIT_OSCDETUNE, m_detuneEdit);
	DDX_Control(pDX, IDC_SLIDER_OSC_FM, m_fmSlider);
	DDX_Control(pDX, IDC_SLIDER_OSCMULT, m_multSlider);
	DDX_Control(pDX, IDC_SLIDER_OSCMIXAM, m_mixSlider);
	DDX_Control(pDX, IDC_SLIDER_OSCDC, m_dcSlider);
	DDX_Control(pDX, IDC_COMBO_OSC_WAVE, m_oscwaves);
	//}}AFX_DATA_MAP
}
static int oscenumtab[]=
{
  SINE1,
    PULSE1,
    PULSE2,
    TRI1,
    NOISE1,
    NOISE2,
    SAMPLE,
};
static char *oscenumnames[]=
{
  "SINE1",
    "PULSE1",
    "PULSE2",
    "TRI1",
    "NOISE1",
    "NOISE2",
    "SAMPLE",
    NULL
};

void COscillatorEdit::UpdateVoiceData()
{
  int num,i;
  char oname[128];
  isOscillator *osc;    
  m_osclist.ResetContent();
  num = voice->GetNrOfOscillators();
  for (i=0;i<num;i++)
  {
    osc = voice->GetOscillator(i);
    m_oscwaves.SetCurSel(osc->wave);
    m_osclist.InsertString(i,oscenumnames[osc->wave]);
    m_osclist.SetItemData(i,osc->wave);
  }  
  curosc=0;
  if (voice->GetNrOfOscillators())
    UpdateOscData(0);
  
}
BEGIN_MESSAGE_MAP(COscillatorEdit, CVoiceBaseDlg)
	//{{AFX_MSG_MAP(COscillatorEdit)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_RADIO_OSCMULT, OnRadioOscmult)
	ON_BN_CLICKED(IDC_RADIO_OSCADD, OnRadioOscadd)
	ON_CBN_SELCHANGE(IDC_COMBO_OSC_WAVE, OnSelchangeComboOscwave)
	ON_BN_CLICKED(IDC_BUTTON_NEWOSC, OnButtonNewosc)
	ON_BN_CLICKED(IDC_BUTTON_DELOSC, OnButtonDelosc)
	ON_LBN_SELCHANGE(IDC_LIST_OSCILLATORS, OnSelchangeListOscillators)
	ON_CBN_SELCHANGE(IDC_COMBO_DC0, OnSelchangeCombo)
	ON_EN_MAXTEXT(IDC_EDIT_DC0, OnMaxtextEdit)
	ON_EN_UPDATE(IDC_EDIT_FM1, OnUpdateEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_DC1, OnSelchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_P0, OnSelchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_P1, OnSelchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_FM0, OnSelchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_FM1, OnSelchangeCombo)
	ON_EN_MAXTEXT(IDC_EDIT_DC1, OnMaxtextEdit)
	ON_EN_MAXTEXT(IDC_EDIT_FM0, OnMaxtextEdit)
	ON_EN_MAXTEXT(IDC_EDIT_OSCDETUNE, OnMaxtextEdit)
	ON_EN_MAXTEXT(IDC_EDIT_P0, OnMaxtextEdit)
	ON_EN_MAXTEXT(IDC_EDIT_P1, OnMaxtextEdit)
	ON_BN_CLICKED(IDC_CHECK_SYNC, OnCheckSync)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//ON_CONTROL_RANGE(EN_MAXTEXT,IDC_EDIT_DC0,IDC_EDIT_OSCDETUNE,OnMaxtextEditCntrl)
//ON_CONTROL_RANGE(CBN_SELCHANGE,IDC_COMBO_DC0,IDC_COMBO_FM1,OnIDCCombo)

//ON_EN_MAXTEXT(IDC_EDIT_OSCDETUNE, OnMaxtextEditOscdetune)
/////////////////////////////////////////////////////////////////////////////
// COscillatorEdit message handlers
void COscillatorEdit::UpdateOscData(int oscnr)
{

//    m_dc0List.ResetContent();
//    m_dc0List.InsertString(0,"hej");
    


    isOscillator *osc;
    osc = voice->GetOscillator(oscnr);
    char buffer[128];

    tdbg_printf("[> OscillatorEdit::UpdataOscData]\n");
    
    m_dcSlider.SetPos (uFloatToInt(osc->dc));
    m_mixSlider.SetPos (uFloatToInt (osc->mix));
    m_multSlider.SetPos (osc->multiplier);
    m_fmSlider.SetPos (uFloatToInt(osc->fm));

    m_portaSlider.SetPos (uFloatToInt (osc->portamento));
    m_transSlider.SetPos (osc->transpose+128);

    sprintf (buffer,"%f",osc->detune);
    m_detuneEdit.SetWindowText(buffer);
    m_oscwaves.SetCurSel (osc->wave);

    if (osc->sync)
        CheckDlgButton(IDC_CHECK_SYNC,1);
    else
        CheckDlgButton(IDC_CHECK_SYNC,0);
    
    
    CheckDlgButton(IDC_RADIO_OSCMULT,0);
    CheckDlgButton(IDC_RADIO_OSCADD,0);
    
    switch (osc->mode)
    {
    case MUL :
        CheckDlgButton(IDC_RADIO_OSCMULT,1);
        
        break;
    case ADD: 
        CheckDlgButton(IDC_RADIO_OSCADD,1);
        break;
    }
    

    tdbg_printf("[> OscillatorEdit::UpdataOscData] filling modulator combobox: %d\n",voice->GetNrOfModulators());

    int i,j;
    CComboBox *listtab[]={&m_dc0List,&m_dc1List,&m_p0List,&m_p1List,&m_fm0List,&m_fm1List};

    for (i=0;i<6;i++)
        listtab[i]->ResetContent();
    for (i=0;i<voice->GetNrOfModulators();i++)
    {
        sprintf (buffer,"modnr:%d",i);
        tdbg_printf("  modnr: %d\n",i);
        for (j=0;j<6;j++)
        {
            listtab[j]->InsertString(i,buffer);
            listtab[j]->SetItemData(i,i);
        }
        //listtab[j]->SetCurSel(voice->GetModulator)
    }
    
    tdbg_printf("[> OscillatorEdit::UpdataOscData] filling modulator editobox\n");

    for (i=0;i<6;i++)
        listtab[i]->SetCurSel(osc->modNr[i]);
    CEdit *dumtab[]={&m_dc0Edit,&m_dc1Edit,&m_p0Edit,&m_p1Edit,&m_fm0Edit,&m_fm1Edit};

    for (i=0;i<6;i++)
    {
        sprintf (buffer,"%f",osc->modAmount[i]);
        dumtab[i]->SetWindowText (buffer);
        tdbg_printf("  fetching: %d with %f\n",i,osc->modAmount[i]);
    }

    int num;
    m_osclist.ResetContent();
    num = voice->GetNrOfOscillators();
    for (i=0;i<num;i++)
    {
        osc = voice->GetOscillator(i);
        m_osclist.InsertString(i,oscenumnames[osc->wave]);
        m_osclist.SetItemData(i,osc->wave);
    }  
    m_osclist.SetCurSel (curosc);

    osc = voice->GetOscillator(curosc);
    m_oscwaves.SetCurSel (osc->wave);

    tdbg_printf("  Updateing sliders\n");
    UpdateSliderVaues();

    tdbg_printf("[< OscillatorEdit::UpdataOscData]\n");        
    tdbg_printf ("---------------------------\n");

//    instrument->Update();
    
  // hooka slider mecket... fr att kunna uppdatera datan i "realtid"...
}
void COscillatorEdit::SetOscData()
{
    char buffer[128];
    isOscillator *osc;

    tdbg_printf("[> OscillatorEdit::SetOscData]\n");
    osc = voice->GetOscillator(curosc);

    osc->dc = uIntToFloat(m_dcSlider.GetPos());
    osc->mix = uIntToFloat(m_mixSlider.GetPos());
    osc->multiplier = m_multSlider.GetPos();
    osc->fm = uIntToFloat(m_fmSlider.GetPos ());
    osc->portamento = uIntToFloat (m_portaSlider.GetPos ());
    osc->transpose = m_transSlider.GetPos () - 128;
    
    m_detuneEdit.GetWindowText(buffer,128);
    osc->detune = atof (buffer);

    if (IsDlgButtonChecked(IDC_CHECK_SYNC))
        osc->sync = true;
    else
        osc->sync = false;
/*
    CheckDlgButton(IDC_RADIO_OSCMULT,0);
    CheckDlgButton(IDC_RADIO_OSCADD,0);
    
    switch (osc->mode)
    {
        case MUL :
            CheckDlgButton(IDC_RADIO_OSCMULT,1);
            
            break;
        case ADD: 
            CheckDlgButton(IDC_RADIO_OSCADD,1);
            break;
    }
*/
    if (IsDlgButtonChecked(IDC_RADIO_OSCMULT))
        osc->mode = MUL;
    if (IsDlgButtonChecked(IDC_RADIO_OSCADD))
        osc->mode = ADD;
    
    
    
    CEdit *edtab[]={&m_dc0Edit,&m_dc1Edit,&m_p0Edit,&m_p1Edit,&m_fm0Edit,&m_fm1Edit};
    CComboBox *listtab[]={&m_dc0List,&m_dc1List,&m_p0List,&m_p1List,&m_fm0List,&m_fm1List};
    int i,csel;
    processing = 1;
    for (i=0;i<6;i++)
    {    
        
        edtab[i]->GetWindowText (buffer,128);
        
        
        osc->modAmount[i]=atof (buffer);
        tdbg_printf("  assiging: %d with %f\n",i,osc->modAmount[i]);
        csel = listtab[i]->GetCurSel ();
        osc->modNr[i]=listtab[i]->GetItemData(csel);
    }
    processing = 0;
    
    
    tdbg_printf("  Updateing sliders\n");
    UpdateSliderVaues();
    
    tdbg_printf("  Updateing instrument\n");
//    instrument->Update();

    tdbg_printf("[< OscillatorEdit::SetOscData]\n");
    tdbg_printf("-----------------------------------\n");
    
}

BOOL COscillatorEdit::OnInitDialog() 
{
	CVoiceBaseDlg::OnInitDialog();  
	
	// TODO: Add extra initialization here
  m_dcSlider.SetRange (0,FloatIntMAX);
  m_mixSlider.SetRange (0,FloatIntMAX);
  m_multSlider.SetRange(0,8);
  m_fmSlider.SetRange(0,FloatIntMAX*16);
  m_portaSlider.SetRange(0,FloatIntMAX);
  m_transSlider.SetRange(0,255);

  int i;
  for (i=0;oscenumnames[i]!=NULL;i++)
  {
    m_oscwaves.InsertString(i,oscenumnames[i]);
    m_oscwaves.SetItemData(i,oscenumtab[i]);
  }
  
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COscillatorEdit::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
  CSliderCtrl *ctrl=(CSliderCtrl *)pScrollBar;

  switch (nSBCode)
  {
    // keyboard
    case TB_BOTTOM :
      break;
    case TB_LINEDOWN :
      break;
    case TB_LINEUP :
      break;
    case TB_TOP :
      break;

    // mouse
    case TB_THUMBPOSITION :
      break;
    case TB_THUMBTRACK :
      break;

    // both    
    case TB_ENDTRACK :
      break;
    case TB_PAGEDOWN:
      break;
    case TB_PAGEUP :
      break;
      
  }
  SetOscData();
  CVoiceBaseDlg::OnHScroll(nSBCode, nPos, pScrollBar);

}


void COscillatorEdit::OnRadioOscmult() 
{
	// TODO: Add your control notification handler code here
//  isOscillator *osc;
//  osc = voice->GetOscillator(curosc);
//  osc->mode=MUL;

  SetOscData();
  UpdateOscData(curosc);
}

void COscillatorEdit::OnRadioOscadd() 
{
	// TODO: Add your control notification handler code here
//  isOscillator *osc;
//  osc = voice->GetOscillator(curosc);  
//  osc->mode=ADD;
  SetOscData();
  UpdateOscData(curosc);
  
}

void COscillatorEdit::OnSelchangeComboOscwave() 
{
	// TODO: Add your control notification handler code here
  isOscillator *osc;
  int type;
  osc = voice->GetOscillator(curosc);
 
  int oscidx = m_oscwaves.GetCurSel();

  osc->wave=((isWaveForm)m_oscwaves.GetItemData(oscidx));
  
  SetOscData();	
  UpdateOscData(curosc);
}

void COscillatorEdit::OnSelchangeListOscillators() 
{
    // TODO: Add your control notification handler code here
    curosc = m_osclist.GetCurSel();
    UpdateOscData(curosc);
}   


void COscillatorEdit::OnButtonNewosc() 
{
	// TODO: Add your control notification handler code here
  int next = m_osclist.GetCount();
  int oscidx = m_oscwaves.GetCurSel();

  voice->AddOscillator();
  curosc = next;
  UpdateOscData(curosc);
 
}

void COscillatorEdit::OnIDCCombo() 
{
    // TODO: Add your control notification handler code here
    SetOscData();
    tdbg_printf("[< OscillatorEdit::OnIDCCombo], leaving control to windows\n");        
    
}


void COscillatorEdit::OnMaxtextEditCntrl() 
{
	// TODO: Add your control notification handler code here
    SetOscData();
	
}

void COscillatorEdit::OnButtonDelosc() 
{
	// TODO: Add your control notification handler code here
    int idx;
        
    
    if(curosc>=1)
    {
        curosc--;
        voice->DelOscillator();
        UpdateOscData(curosc);
    }
    
}



void COscillatorEdit::UpdateSliderVaues()
{
    isOscillator *osc;
    osc = voice->GetOscillator(curosc);

    CString bla;

    bla.Format("%5.4f",osc->dc);
    m_dcval.SetWindowText(bla);

    bla.Format("%d",osc->multiplier);
    m_mulval.SetWindowText (bla);

    bla.Format("%5.4f",osc->mix);
    m_mixval.SetWindowText(bla);

    bla.Format("%5.4f",osc->fm);
    m_fmval.SetWindowText (bla);

    bla.Format("%d",osc->transpose);
    m_transval.SetWindowText (bla);

    bla.Format("%5.4f",osc->portamento);
    m_portaval.SetWindowText(bla);
}

void COscillatorEdit::OnSelchangeCombo() 
{
	// TODO: Add your control notification handler code here
    SetOscData();
    tdbg_printf("[< OscillatorEdit::OnIDCCombo], leaving control to windows\n");        
    
}

void COscillatorEdit::OnMaxtextEdit() 
{
	// TODO: Add your control notification handler code here
    SetOscData();
	
}

void COscillatorEdit::OnUpdateEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CVoiceBaseDlg::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
	
}

void COscillatorEdit::OnCheckSync() 
{
	// TODO: Add your control notification handler code here
    SetOscData();
	
}

LRESULT COscillatorEdit::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (message == WM_COMMAND) {
		if (EN_CHANGE == HIWORD(wParam))
			SetOscData();
	}


	return CVoiceBaseDlg::WindowProc(message, wParam, lParam);
}
