#ifndef __MIDI_INPUT_H__
#define __MIDI_INPUT_H__

#include <mmsystem.h>

class MIDIInput {
	public:
		MIDIInput(void);
		virtual ~MIDIInput();

		void start( UINT device );
		void stop( void );

		void setmsgdest( HWND hwnd );
		void endmsgdest( HWND hwnd ); // end a relationship.. guarantee that there will be no msgs to this hwnd

	protected:

		void thread(void);

	private:

		UINT m_curdevice;
		BOOL m_isopen;
		HMIDIIN m_handle;
		HANDLE m_thread;
		HWND m_msgdest;
		DWORD m_threadid;

		friend static DWORD WINAPI MIDIThreadProc( LPVOID lpParameter );
};


#endif
