// InsertDist.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "InsertDist.h"
#include "isSynth.h"
#include "isFilter.h"
#include "isDistortion.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInsertDist dialog

#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)

CInsertDist::CInsertDist(CWnd* pParent /*=NULL*/)
	: CInsertBaseDlg(CInsertDist::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInsertDist)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CInsertDist::DoDataExchange(CDataExchange* pDX)
{
	CInsertBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInsertDist)
	DDX_Control(pDX, IDC_SLIDER_DISTAMOUNT, m_amountslider);
	DDX_Control(pDX, IDC_STATIC_AMOUNTVAL, m_distamount);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInsertDist, CInsertBaseDlg)
	//{{AFX_MSG_MAP(CInsertDist)
	ON_BN_CLICKED(IDC_RADIO_DISTHARD, OnRadio)
	ON_BN_CLICKED(IDC_RADIO_DISTSOFT, OnRadio)
	ON_BN_CLICKED(IDC_RADIO_DISTSIN, OnRadio)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInsertDist message handlers
void CInsertDist::UpdateInsertData()
{
    SetCntrlData();    
    m_amountslider.SetRange(0,FloatIntMAX*64);
    m_amountslider.SetPos(0);
    SetCntrlData();
}
void CInsertDist::SetCntrlData(void)
{
    isDistortion *dist;

    dist = (isDistortion *)insert;
    CheckDlgButton(IDC_RADIO_DISTHARD,0);
    CheckDlgButton(IDC_RADIO_DISTSOFT,0);
    CheckDlgButton(IDC_RADIO_DISTSIN,0);
    switch (dist->mode)
    {
        case HARD:
            CheckDlgButton(IDC_RADIO_DISTHARD,1);
            break;
        case SOFT: 
            CheckDlgButton(IDC_RADIO_DISTSOFT,1);
            break;
        case SIN:
            CheckDlgButton(IDC_RADIO_DISTSIN,1);
            break;
    }
    m_amountslider.SetPos (uFloatToInt (dist->dist));
    char buffer[128];
    sprintf (buffer,"%5.4f",dist->dist);
    m_distamount.SetWindowText(buffer);

//    instrument->Update();
    
}
void CInsertDist::ReadCntrlData(void)
{
    int am;
    isDistortion *dist;
    dist = (isDistortion *)insert;
    am = m_amountslider.GetPos ();
    dist->dist = uIntToFloat (am);    
    
    if (IsDlgButtonChecked(IDC_RADIO_DISTHARD))
        dist->mode = HARD;
    else
        if (IsDlgButtonChecked(IDC_RADIO_DISTSOFT))
            dist->mode = SOFT;
        else
            if (IsDlgButtonChecked(IDC_RADIO_DISTSIN))
                dist->mode = SIN;
            else
                dist->mode = HARD;
    SetCntrlData();                
}

void CInsertDist::OnRadio() 
{
	// TODO: Add your control notification handler code here
    ReadCntrlData ();	
}

void CInsertDist::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	ReadCntrlData();
	CInsertBaseDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}
