// EffectSlider1.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "EffectSlider1.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEffectSlider dialog


CEffectSlider::CEffectSlider(CWnd* pParent /*=NULL*/)
	: CDialog(CEffectSlider::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEffectSlider)
	m_edit = _T("");
	//}}AFX_DATA_INIT
	m_float = 0;
	m_rangestart = 0;
	m_rangestop = 1000;
	m_value = 0;
	m_int = 0;
	m_ccb_recurse_count = 0;
	m_ccb = 0;
	m_ccb_passed = 0;
}


void CEffectSlider::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEffectSlider)
	DDX_Control(pDX, IDC_SLIDER1, m_scroller);
	DDX_Text(pDX, IDC_EDIT1, m_edit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEffectSlider, CDialog)
	//{{AFX_MSG_MAP(CEffectSlider)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER1, OnCustomdrawSlider1)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER1, OnReleasedcaptureSlider1)
	ON_EN_KILLFOCUS(IDC_EDIT1, OnKillfocusEdit1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEffectSlider message handlers

BOOL CEffectSlider::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (wParam == IDCANCEL || wParam == IDOK)
		return FALSE;
	
	return CDialog::OnCommand(wParam, lParam);
}

void CEffectSlider::setRange( float start, float stop )
{
	m_rangestart = start;
	m_rangestop = stop;
	m_value = start + stop / 2;
	setValue( m_value );
}

void CEffectSlider::setFloat( float *_float )
{	
	m_float = _float;
	setValue( *m_float );
}

void CEffectSlider::setInt( int *_int )
{	
	m_int = _int;
	setValue( *m_int );
}

void CEffectSlider::setValue( float value, bool change_edit)
{
	if (value < m_rangestart)
		value = m_rangestart;
	if (value > m_rangestop)
		value = m_rangestop;
	if (m_float)
		*m_float = value;
	if (m_int)
		*m_int = value;

	// Anropa callback
	if (m_ccb && m_ccb_recurse_count<1) {
		m_ccb_recurse_count++;
		if (m_value != value)
			m_ccb( m_ccb_passed, m_value );
		m_ccb_recurse_count--;
	}

	m_value = value;
	m_scroller.SetPos( 10000 * (float)(m_value-m_rangestart)/(float)(m_rangestop-m_rangestart) );
	if (true == change_edit) {
		if (!m_float)
			m_edit.Format(_T("%d"),(int)value);
		else
			m_edit.Format(_T("%f"),value);
		UpdateData(FALSE);
	}
}

void CEffectSlider::setTitle( CString title )
{
	GetDlgItem( IDC_STATIC_EFF_DESC )->SetWindowText( title );
}

BOOL CEffectSlider::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_scroller.SetRange( 0, 10000, FALSE );
	setRange(-100,100);
	if (m_float)
		setValue( *m_float );
	if (m_int)
		setValue( *m_int );

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEffectSlider::OnCustomdrawSlider1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	setValue( (float)m_scroller.GetPos() / 10000.0f * (m_rangestop - m_rangestart) + m_rangestart );		
	*pResult = 0;
}

void CEffectSlider::OnChangeEdit1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	

	if (GetFocus() != GetDlgItem( IDC_EDIT1 )) 
	{

	}
	
	// TODO: Add your control notification handler code here
	
}

void CEffectSlider::OnReleasedcaptureSlider1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CEffectSlider::OnKillfocusEdit1() 
{
	UpdateData(TRUE);

	for (int i=0;i<m_edit.GetLength();i++) {
		char t = m_edit[i];
		if ( t != '.' && (!(t >= '0' && t <= '9')))
			return;
	}

	// TODO: Add your control notification handler code here
	float newfloat = atof( m_edit );
	setValue( newfloat );
}

void CEffectSlider::setChangeCallback( EFFECTSLIDER_CALLBACK cb, LPVOID passed )
{
	m_ccb = cb;
	m_ccb_passed = passed;
}
