// AEWindow.cpp : implementation file
//

#include "stdafx.h"
//#include "tracker.h"
#include "AEWindow.h"
#include "isInstrument.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAEWindow

CAEWindow::CAEWindow()
{
	m_posx = 1;
	m_posy = 1;
	m_digitno = 0;
	m_cols = 7;
	m_rows = 33;
	m_isedit = FALSE;	
}

CAEWindow::~CAEWindow()
{
	enterLeave();

}


BEGIN_MESSAGE_MAP(CAEWindow, CWnd)
	//{{AFX_MSG_MAP(CAEWindow)
	ON_WM_PAINT()
	ON_WM_SETFOCUS()
	ON_WM_KEYDOWN()
	ON_WM_SYSKEYDOWN()
	ON_WM_GETDLGCODE()
	ON_WM_CHAR()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAEWindow message handlers

void CAEWindow::OnPaint() 
{

	CPaintDC dc(this); // device context for painting
	RECT dcr;
	CWnd::GetClientRect( &dcr );
	CWnd::GetClientRect( &m_field );
	
	// TODO: Add your message handler code here	
	CDC dcc;
	dcc.CreateCompatibleDC(0);
	CBitmap bmp;
	bmp.CreateCompatibleBitmap( &dc, dcr.right, dcr.bottom );
	dcc.SelectObject( &bmp );
	CDC* pDC = &dcc;

	pDC->PatBlt( 0, 0, dcr.right, dcr.bottom, BLACKNESS );

	CGdiObject *old_pen, *old_brush, *old_font;

	DWORD col1 = RGB(255,255,255);
	DWORD col2 = RGB(64,78,92);
	DWORD col3 = RGB(255,255,0);
	DWORD col4 = RGB(50,255,50);
	DWORD bkcolor = RGB(0,0,0);

	CPen pen1( PS_SOLID, 1, col1 );
	CPen pen2( PS_SOLID, 1, col2 );
	CBrush brush( bkcolor );

	old_pen = pDC->SelectObject( &pen2 );
	old_brush = pDC->SelectObject( &brush );			

	pDC->SetTextColor( col1 );
	pDC->SetBkColor( bkcolor );

	CFont font;
	font.CreateFont(11,0,0,0,0,0,0,0,0,0,0,0,0,"Lucida Console");


	old_font = pDC->SelectObject( &font );

	for (int y=0;y<m_rows;y++) {
		for (int x=0;x<8;x++) {
			RECT r;
			getItemRect( x, y, &r );
			// Rkna ut rect fr denna
			pDC->Rectangle( &r );
		}
	}
	
	RECT r;
	getItemRect( m_posx, m_posy, &r );
	pDC->SelectObject( &pen1 );
	pDC->Rectangle( &r );
	
	for (y=0;y<m_rows;y++) {

		for (int x=0;x<8;x++) {	

			if (!y)
				pDC->SetTextColor( col1 );
			else {

				if (x == 0)
					pDC->SetTextColor( col2 );
				if (x >= 1 && x <= 3)
					pDC->SetTextColor( col3 );
				if (x > 3)
					pDC->SetTextColor( col4 );

			}

			_TCHAR tmp[32];
			_tcscpy( tmp, _T("") );
			getItemRect( x, y, &r );
			getItemText( x, y, tmp );

			pDC->DrawText( tmp, -1, &r, DT_CENTER | DT_VCENTER | DT_SINGLELINE );

		}		
	}

	pDC->SelectObject( old_pen );
	pDC->SelectObject( old_brush );
	pDC->SelectObject( old_font );


	dc.BitBlt( 0, 0, dcr.right, dcr.bottom, pDC, 0, 0, SRCCOPY );

	bmp.DeleteObject();
	dcc.DeleteDC();
		
	// Do not call CWnd::OnPaint() for painting messages
}

BOOL CAEWindow::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL m = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);		

	enterEdit();


	return m;
}


void CAEWindow::getItemRect( int x, int y, RECT *rect )
{
	int s_x = (m_field.right - m_field.left) / m_cols;
	int s_y = (m_field.bottom - m_field.top) / m_rows;
	int ofs_y = 0; //(m_field.bottom - m_field.top - s_y) / 2;
	int real_y = y;
	rect->left = m_field.left + x * s_x;
	rect->right = rect->left + s_x + 1;
	rect->top = m_field.top + real_y * s_y + ofs_y;
	rect->bottom = rect->top + s_y + 1;			
}

void CAEWindow::getItemText( int x, int y, _TCHAR *str )
{
	if (x == m_posx && y == m_posy && TRUE == m_isedit) {
		_tcscpy( str, m_editstr );
		return;
	}

	if (!y) {

		switch (x) {					
			case 0:
				_tcscpy( str, _T("pos") );
				break;
			case 1:
				_tcscpy( str, _T("note1") );
				break;
			case 2:
				_tcscpy( str, _T("note2") );
				break;
			case 3:
				_tcscpy( str, _T("note3") );
				break;
			case 4:
				_tcscpy( str, _T("velocity") );
				break;
			case 5:
				_tcscpy( str, _T("length") );
				break;
			case 6:
				_tcscpy( str, _T("octave") );
				break;
		}
	} else {

		if (!x) {
			_stprintf(str,_T("%02d"),y-1);			
		} else {		
			if (x >= 1 && x <= 3 ) {
				// not
				unsigned char _naat = m_instrument->arpeggiator.step[y-1].index[x-1];
				if (_naat == 255) {
					_tcscpy( str, _T("") );
				} else
					_stprintf(str,_T("%02d"),_naat + 1);				
			}
			if (x == 4) 
				_stprintf(str,_T("%02d"),m_instrument->arpeggiator.step[y-1].velocity );		
			if (x == 5)
				_stprintf(str,_T("%02d"),m_instrument->arpeggiator.step[y-1].length );
			if (x == 6)
				_stprintf(str,_T("%02d"),m_instrument->arpeggiator.step[y-1].octave );
			
		}
	}
}

void CAEWindow::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (_tcslen( m_editstr ) > 0 && nChar == VK_BACK)
		m_editstr[ _tcslen( m_editstr ) - 1 ] = 0;
		


	switch (nChar) {	
			break;

		case VK_DELETE:		
			_tcscpy( m_editstr, _T("") );
			break;

		case VK_DOWN:
			enterLeave();
			m_posy++;
			if (m_posy >= m_rows)
				m_posy = m_rows - 1;
			enterEdit();
			break;
		case VK_UP:
			enterLeave();
			m_posy--;
			if (m_posy < 1)
				m_posy = 1;
			enterEdit();
			break;
		case VK_LEFT:
			enterLeave();
			m_posx--;
			if (m_posx < 1)
				m_posx = 1;
			enterEdit();
			break;
		case VK_RIGHT:
			enterLeave();
			m_posx++;			
			if (m_posx >= m_cols)
				m_posx = m_cols - 1;
			enterEdit();
			break;

		default:
			CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
			return;

	}
	InvalidateRect(0);
	UpdateWindow();
	
}

void CAEWindow::OnSetFocus(CWnd* pOldWnd) 
{
	CWnd::OnSetFocus(pOldWnd);
	
	// TODO: Add your message handler code here		
}

void CAEWindow::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	
	CWnd::OnSysKeyDown(nChar, nRepCnt, nFlags);
}

UINT CAEWindow::OnGetDlgCode() 
{
	// TODO: Add your message handler code here and/or call default	
	return CWnd::OnGetDlgCode() | DLGC_WANTARROWS | DLGC_WANTCHARS | DLGC_WANTALLKEYS;
}



void CAEWindow::enterEdit(void)
{
	m_isedit = FALSE;
	getItemText( m_posx, m_posy, m_editstr );
	m_isedit = TRUE;
	InvalidateRect(0);
	UpdateWindow();
}

void CAEWindow::enterLeave(void)
{
	
	if (m_posy < 1 || m_posy > m_rows) {
		m_isedit = FALSE;
		return;
	}

	if (TRUE == m_isedit) {
		int _val = atoi( m_editstr );

		if (m_posx >= 1 && m_posx <= 3) {
			if (_tcslen( m_editstr ) == 0) 
				_val = 256;
			else {
				if (_val < 1) _val = 1;
				if (_val > 16) _val = 16;
			}
			m_instrument->arpeggiator.step[m_posy-1].index[m_posx-1] = _val - 1;
		}
		if (m_posx == 4) {
			if (_val < 0) _val = 0;
			if (_val > 255) _val = 255;
			m_instrument->arpeggiator.step[m_posy-1].velocity = _val;
		}
		if (m_posx == 5) {
			if (_val < 0) _val = 0;
			if (_val > 255) _val = 255;
			m_instrument->arpeggiator.step[m_posy-1].length = _val;
		}
		if (m_posx == 6) {
			if (_val < -128) _val = -128;
			if (_val > 127) _val = 127;
			m_instrument->arpeggiator.step[m_posy-1].octave = _val;
		}
	}
	m_isedit = FALSE;
}

void CAEWindow::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (FALSE == m_isedit)
		return;

	// TODO: Add your message handler code here and/or call default
	if ((nChar >= '0' && nChar <= '9') || nChar == '+' || nChar == '-') {
		_TCHAR add[2] = { (_TCHAR)nChar, 0 };
		if (_tcslen( m_editstr ) < 4)
			_tcscat( m_editstr, add );
	}
	
	InvalidateRect(0);
	UpdateWindow();
	CWnd::OnChar(nChar, nRepCnt, nFlags);
}

void CAEWindow::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	SetForegroundWindow();
	CDialog *prnt = (CDialog *) GetParent();
	prnt->GotoDlgCtrl( this );


	RECT r;
	for (int y=0;y<m_rows;y++)
		for (int x=0;x<m_cols;x++) {
			getItemRect( x, y, &r );
			if (point.x > r.left && point.x < r.right && point.y > r.top && point.y < r.bottom) {
				enterLeave();
				m_posx = x;
				m_posy = y;
				enterEdit();
				break;
			}
		}	
	
	CWnd::OnLButtonDown(nFlags, point);
}
