/****************************************************************************
 **                                                                        **
 **  8bit texture extractor and flipper routines - Aron, 1998.06.05.       **
 **                                                                        **
 ****************************************************************************/

// - sajat fejlecfile-ok ----------------------------------------------------
#include "defs.h"
#include "texture.h"
#include "tracer.h"

// - implementacio ----------------------------------------------------------
void ExtractTexture_ASM(byte *,byte *);
#pragma aux ExtractTexture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void ExtractTexture(byte *destptr,byte *srcptr)
{ ExtractTexture_ASM(destptr,srcptr);
}

void FlipTexture_ASM(byte *,byte *);
#pragma aux FlipTexture_ASM "_*" modify [eax ebx ecx edx esi edi] parm [edi] [esi]

void FlipTexture(byte *destptr,byte *srcptr)
{ FlipTexture_ASM(destptr,srcptr);
}

void InitTextures(byte *tbuffer)
{ dword i;
  extern byte texture0data[COMPRESSED_TEXTURE_SIZE],
              texture1data[COMPRESSED_TEXTURE_SIZE],
              texture2data[COMPRESSED_TEXTURE_SIZE],
              texture3data[COMPRESSED_TEXTURE_SIZE];

  for(i=0; i<TEXTURES_COMPRESSED; i++)
  { if(i == 0) ExtractTexture(tbuffer + 2*i*TEXTURE_SIZE,texture0data);
    else if(i == 1) ExtractTexture(tbuffer + 2*i*TEXTURE_SIZE,texture1data);
    else if(i == 2) ExtractTexture(tbuffer + 2*i*TEXTURE_SIZE,texture2data);
    else if(i == 3) ExtractTexture(tbuffer + 2*i*TEXTURE_SIZE,texture3data);
    FlipTexture(tbuffer + (2*i + 1)*TEXTURE_SIZE,tbuffer + 2*i*TEXTURE_SIZE);
  }
}