/* Fireworks demo written by Dave Ashley */
/* dash@xdr.com */
/* http://www.xdr.com/dash */
/* Sat Jun 13 02:46:09 PDT 1998 */
/* This is my first attempt at an SDL program */
/* See the SDL home page http://www.devolution.com/~slouken/projects/SDL/ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string>
#include <time.h>
#include <windows.h>
#include <iostream>
#include <math.h>

#include "SDL.h"


#define XSIZE 30
#define YSIZE 160

SDL_Surface *thescreen;
unsigned int *pixels;

std::string g_filename;

int scrlock()
{
	if(SDL_MUSTLOCK(thescreen))
	{
		if ( SDL_LockSurface(thescreen) < 0 )
		{
			fprintf(stderr, "Couldn't lock display surface: %s\n",
				SDL_GetError());
			return -1;
		}
	}

	pixels = (unsigned int *) thescreen->pixels;

	return 0;
}
void scrunlock(void)
{
	if(SDL_MUSTLOCK(thescreen))
		SDL_UnlockSurface(thescreen);
	SDL_UpdateRect(thescreen, 0, 0, 0, 0);
}

void putPixel( int x, int y, unsigned int color )
{
	if ( x < 0 )
		return;

	if ( y < 0 )
		return;

	if ( x >= XSIZE )
		return;

	if ( y >= YSIZE )
		return;

	pixels[ y * XSIZE + x ] = color; // ARGB 0x00FF0000 = red
}

void drawRect( int x1, int y1, int x2, int y2, unsigned int color )
{
	int x, y;

	for ( y = y1; y < y2; y++ )
	{
		for ( x = x1; x < x2; x++ )
		{
			putPixel( x, y, color );
		}
	}
}


// ----------------------------------------------------------------------------
#define screenxsize XSIZE
#define screenysize YSIZE
#define nbsquares 15

int campos;
FILE *fileHandle = 0;

// ----------------------------------------------------------------------------
void writeRect( unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2 )
{
	if ( x1 > screenxsize )
	{
		x1 = screenxsize - 1;
	}
	if ( x2 > screenxsize )
	{
		x2 = screenxsize - 1;
	}

	if ( y1 > screenysize )
	{
		y1 = screenysize - 1;
	}
	if ( y2 > screenysize )
	{
		y2 = screenysize - 1;
	}

	if ( g_filename.size()>0)
	{
		fwrite( &x1, 1, 1, fileHandle );
		fwrite( &y1, 1, 1, fileHandle );
		fwrite( &x2, 1, 1, fileHandle );
		fwrite( &y2, 1, 1, fileHandle );
	}
}

void initTunnel()
{
	campos = 31*256;
}

void playTunnel()
{
	int z;
	int i;
	int size;
	int x1, y1, x2, y2;
	int prevx1, prevy1, prevx2, prevy2;
	int clipx1, clipy1, clipx2, clipy2;
	int sinx, siny;

	
	sinx = SDL_GetTicks( ) * 20;
	siny = sinx * 3;

	campos += SDL_GetTicks( );
	z = 0;

	if (campos > (31+32)*256)
	{
		campos = 31*256;
	}

	clipx1 = 0;
	clipy1 = 0;
	clipx2 = screenxsize - 1;
	clipy2 = screenysize - 1;

	prevx1 = prevy1 = prevx2 = prevy2 = -1;

	for(i=0; i<nbsquares; i++)
	{
		if (z&31)
		{
			size = (8*screenxsize)/(3*(z&31));
		}
		else size=0;

		if (size>1)
		{
			x1 = (screenxsize/2) - (size/2);
			y1 = (screenysize/2) - (int)(((float)size)*0.8f);
			x2 = (screenxsize/2) + (size/2);
			y2 = (screenysize/2) + (int)(((float)size)*0.8f);

			x1 += (int)(cos( ((float)sinx )/256.0f ) * 10.0f);
			y1 += (int)(sin( ((float)siny )/256.0f ) * 20.0f);
			x2 += (int)(cos( ((float)sinx )/256.0f ) * 10.0f);
			y2 += (int)(sin( ((float)siny )/256.0f ) * 20.0f);

			sinx += 10;
			siny += 80;

			if (x1<clipx1) x1 = clipx1;
			if (x1>clipx2) x1 = clipx2;				
			if (x2<clipx1) x2 = clipx1;
			if (x2>clipx2) x2 = clipx2;

			if (y1<clipy1) y1 = clipy1;
			if (y1>clipy2) y1 = clipy2;				
			if (y2<clipy1) y2 = clipy1;
			if (y2>clipy2) y2 = clipy2;

			if ( y1 > y2 )
			{
				int t;

				t = y2;
				y1 = y2;
				y2 = t;
			}

			if ( x1 > x2 )
			{
				int t;

				t = x2;
				x1 = x2;
				x2 = t;
			}

			int pen = 63 + ( i * 12 );

			//drawRect( x1, y1, x2, y2, 63 + ( i * 12 ) );

			if ( ( prevx1 != -1 ) )
			{
				unsigned char v;

				/*
				En mode 0, on a 2 pixels par octet [PixelA,PixelB] et 4bits par pixel
				(indexe de 0  15 sur la palette).

				PixelA est cod sur les bits 1,3,5,7 (poid fort -> poid faible)
				PixelB est cod sur les bits 0,2,4,6 (idem)

				Pour retrouver l'index de palette des pixels, c'est donc :
				Pen(PixelA) = 8*bit1 + 4*bit3 + 2*bit5 + bit7
				Pen(PixelB) = 8*bit0 + 4*bit2 + 2*bit4 + bit6
				*/

				v =		( ( i ) & 1 ) + ( ( ( i ) & 1 ) << 1 ) 
					+   ( ( ( i >> 1 ) & 1 ) << 2 ) + ( ( ( i >> 1 ) & 1 ) << 3 ) 
					+   ( ( ( i >> 2 ) & 1 ) << 4 ) + ( ( ( i >> 2 ) & 1 ) << 5 ) 
					+   ( ( ( i >> 3 ) & 1 ) << 6 ) + ( ( ( i >> 3 ) & 1 ) << 7 );
				if ( g_filename.size()>0)
					fwrite( &v, 1, 1, fileHandle ); // color
				
				if ( ( prevx2 > prevx1 ) && ( y1 > prevy1 ) )
				{
					writeRect( prevx1, prevy1, prevx2, y1 );
					drawRect( prevx1, prevy1, prevx2, y1, pen );
				}

				if ( ( x1 > prevx1 ) && ( y2 > y1 ) )
				{
					writeRect( prevx1, y1, x1, y2 );
					drawRect( prevx1, y1, x1, y2, pen );
				}

				if ( ( prevx2 > x2 ) && ( y2 > y1 ) )
				{
					writeRect( x2, y1, prevx2, y2 );
					drawRect( x2, y1, prevx2, y2, pen );
				}

				if ( ( prevx2 > prevx1 ) && ( prevy2 > y2 ) )
				{
					writeRect( prevx1, y2, prevx2, prevy2 );
					drawRect( prevx1, y2, prevx2, prevy2, pen );
				}

				v = 0xFF;		
				if ( g_filename.size()>0)
					fwrite( &v, 1, 1, fileHandle );
			}

			prevx1 = x1;
			prevy1 = y1;
			prevx2 = x2;
			prevy2 = y2;

			clipx1 = x1;
			clipy1 = y1;
			clipx2 = x2;
			clipy2 = y2;
		}

		z += (16 / (nbsquares));
	}

}

int main(int argc, char *argv[])
{
	std::cout << "PrecaTunnel version 1.0 -- Create Tunnel Position (crocolib)" << std::endl;

	if ( argc == 2 )
	{
		g_filename = argv[ 1 ];

		if ( g_filename.size()>0)
			fileHandle = fopen( g_filename.c_str(), "wb" );
	}

	int done = 0;
	SDL_Event event;

	initTunnel( );
	
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
	{
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		exit(1);
	}
	
	thescreen = SDL_SetVideoMode(XSIZE, YSIZE, 32, SDL_SWSURFACE|SDL_HWPALETTE);
	if ( thescreen == NULL )
	{
		fprintf(stderr, "Couldn't set display mode: %s\n",
			SDL_GetError());
		SDL_Quit();
		exit(5);
	}

	int nbFrames = 120;
	while(!done)
	{
		scrlock( );

		playTunnel( );

		scrunlock( );
		
		while(SDL_PollEvent(&event))
		{
			switch (event.type)
			{
						case SDL_QUIT:
				done = 1;
				break;
			default:
				break;
			}
		}

		if ( g_filename.size()>0)
		{
			if ( nbFrames-- == 0 )
			{
				done = true;
			}
		}
	}

	if ( fileHandle )
		fclose( fileHandle );

	SDL_Quit();
	exit(0);

	return 0;
}
