/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

// ----------------------------------------------------------------------------
#include "crLIB.h"
#include <lib3d.h>

#include <string.h> // memset

#include "Demo.h"

#include "Nuages.h"

// ----------------------------------------------------------------------------
unsigned char *s_dataPtr = (unsigned char *) 0x3600;
#define GETDATAPTR( offset ) ( (unsigned char *) ( s_dataPtr + offset ) )

// ----------------------------------------------------------------------------
static void init( );
static void frameUpdate( );
static int isFinished( );

// ----------------------------------------------------------------------------
void main( )
{
#asm
	ei;
	ld sp, $1500 - 2;
#endasm

	crASICIsBegin( );
	crBANKGetBank( );

	init( );
	
	playMusic( );

	while ( isFinished( ) == 0 )
	{
		frameUpdate( );

		playMusic( );
	}

#asm
	ld hl, ( $1500 - 2);
	jp ( hl );
#endasm
}

// ----------------------------------------------------------------------------
static unsigned int s_palette[ 17 ];

// ----------------------------------------------------------------------------
#define NUAGES1_PTR		0x7000
#define NUAGES2_PTR		0x7A00

// ----------------------------------------------------------------------------
static unsigned char *s_screen;

static int s_compareValue;
static unsigned char s_doClear;

static int s_isFinished;

static int s_secondTime;

// ----------------------------------------------------------------------------
static void init( )
{
	unsigned char *pSecondTime = 0x812;	

	playMusic( );

	memset( s_palette, 0, 16 * 2 );
	crSYNCWaitVBL( );
	crASICSetPalette( s_palette );

	crSYNCWaitVBL( );
	crCRTCSetupScreen( CRTC_OVERSCAN_VERTICAL, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGE_C000, CRTC_VIDEOPAGESIZE_16KB );

	playMusic( );

	if ( *pSecondTime == 255 )
	{
		s_secondTime = 0;
	}
	else
	{
		s_secondTime = 1;
	}	

	s_isFinished = 0;
	s_compareValue = 0;
	s_doClear = 0;

	if ( s_secondTime == 1 )
	{
		crPACKERUnpack( 0x8000, GETDATAPTR( DATA_SKULL ) );
		playMusic( );
		memcpy( s_palette, GETDATAPTR( DATA_SKULL_PAL ) + 8, 16 * 2 );
		playMusic( );
		crPACKERUnpack( NUAGES1_PTR, GETDATAPTR( DATA_NUAGES2 ) );	
		playMusic( );
		crPACKERUnpack( NUAGES2_PTR, GETDATAPTR( DATA_NUAGES ) );
		
	}
	else
	{
		// crPACKERUnpack( 0x8000, GETDATAPTR( DATA_ALONE ) );
		crPACKERUnpack( NUAGES1_PTR, GETDATAPTR( DATA_NUAGES ) );	
		playMusic( );
		crPACKERUnpack( NUAGES2_PTR, GETDATAPTR( DATA_NUAGES2 ) );
		playMusic( );
		memcpy( s_palette, GETDATAPTR( DATA_ALONE_PAL ) + 8, 16 * 2 );
	}	
	
	playMusic( );

	s_screen = 0xC000;
	memset( s_screen, 0, 0x4000 );

	playMusic( );

	crSYNCWaitVBL( );
	crGASetMode( 0 );
	crGASetColor( BORDER, COLOR_BLACK );
	crGASetColor( BKGRD, COLOR_BLACK );

	s_palette[ 16 ] = 0;

	if ( s_secondTime == 0 )
	{
		initMusic( );
	}
	playMusic( );

	crASICSetPalette( s_palette );
	crSYNCWaitVBL( );
}

// ----------------------------------------------------------------------------
static void frameUpdate( )
{
	if ( s_compareValue <= 63 )
	{
		if ( s_doClear == 0 )
		{
			if ( s_compareValue > 0 )
			{
				crGFXDrawClouds( s_compareValue, NUAGES1_PTR, s_screen );
			}
			if ( s_compareValue < 63 )
			{
				crGFXDrawIntermediateClouds( s_compareValue + 1, NUAGES1_PTR, s_screen );
			}
		}
		else
		{
			if ( s_compareValue < 255 )
			{
				crGFXClearClouds( s_compareValue, NUAGES2_PTR, s_screen );
			}

			if ( s_compareValue > 0 )
			{
				crGFXClearIntermediateClouds( s_compareValue - 1, NUAGES2_PTR, s_screen );
			}
		}
	}

	if ( s_doClear == 1 )
	{
		s_compareValue--;	
		if ( s_compareValue < 0 )
		{
			s_compareValue = 0;
			s_doClear = 0;

			memset( s_palette, 0, 16 * 2 );
			crASICSetPalette( s_palette );

			playMusic( );
			s_isFinished = 1;
		}
	}
	else
	{
		s_compareValue++;	
		if ( s_compareValue > 163 )
		{
			s_compareValue = 63;
			s_doClear = 1;
		}
	}
}

// ----------------------------------------------------------------------------
static int isFinished( )
{
	return s_isFinished;
}
