/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crTEXT.h"
#include "crCRTC.h"
#include "crBANK.h"

#include <string.h> // memcpy

// ----------------------------------------------------------------------------
unsigned int fontScanlineWidth;
unsigned int posX;
unsigned int posY;
unsigned char *scanline;
unsigned char *fontCharAdress;
unsigned char fontCharHeight;
unsigned char iScanLine;
unsigned char pixel;

// ----------------------------------------------------------------------------
void __LIB__ crTEXTDrawScrollerX( struct SFont *font, unsigned int text, struct SScroll *scroll )
{
	switch( font->fontBank )
	{
		case 0xC4: crBANKSetC4( ); break;
		case 0xC5: crBANKSetC5( ); break;
		case 0xC6: crBANKSetC6( ); break;
		case 0xC7: crBANKSetC7( ); break;

		default:
		case 0xC0: crBANKSetC0( ); break;
	}

	posX = scroll->posX + scroll->charOffset;
	posY = scroll->posY;
	
	fontScanlineWidth = font->fontPitch;

	fontCharHeight = font->fontCharHeight;

	fontCharAdress = scroll->charOffset + font->fontCharAdress[ *( (unsigned char *) ( text + scroll->textOffset ) ) ];

	for ( iScanLine = 0; iScanLine < fontCharHeight; iScanLine++ )
	{
		*( posX + crCRTCGetScanline( posY ) )= *fontCharAdress;

		posY++;
		fontCharAdress += fontScanlineWidth;
	}

	scroll->charOffset++;
	if ( scroll->charOffset == font->fontCharWidth )
	{
		scroll->charOffset = 0;

		scroll->posX += font->fontCharWidth;

		scroll->textOffset++;
		if ( *(unsigned char *)( text + scroll->textOffset ) == 0 )
		{
			scroll->textOffset = 0;
		}
	}

	if ( scroll->posX > 1024 - 50 )
	{
		scroll->posX = 0;
	}

	crBANKSetC0( );
}
