/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
extern unsigned int *g_scanlineBuffer;

// ----------------------------------------------------------------------------
void __LIB__ crGFXDrawRect( int x1, int y1, int x2, int y2, unsigned char pen )
{
	int x;
	int y;

	int t;

	if ( x1 > x2 )
	{
		t = x1;
		x1 = x2;
		x2 = t;
	}
	if ( y1 > y2 )
	{
		t = y1;
		y1 = y2;
		y2 = t;
	}

	for ( y = y1; y < y2; y++ )
	{
		for ( x = x1; x < x2; x++ )
		{
			crGFXDrawPixel( x, y, pen );
		}
	}
}
