/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
extern unsigned int *g_scanlineBuffer;

// ----------------------------------------------------------------------------
void _DrawLineToRight( int pen, unsigned int scanlineBuffer, unsigned int x1, unsigned int y1, unsigned int height, unsigned int deltaX )
{
#asm
	ld ix, 0;
	add	ix, sp;

	// ( ix + 2 ) = deltaX
	// ( ix + 4 ) = height
	// ( ix + 6 ) = y1
	// ( ix + 8 ) = x1
	// ( ix + 10 ) = scanlineBuffer

	ld a, ( ix + 3 ); // deltaX
	ld ( setDeltaX_r + 2 ), a; // automodify code for deltaX
	ld a, ( ix + 2 );
	ld ( setDeltaX_r + 1 ), a;

	ld h, ( ix + 7 ); // hl = height
	ld l, ( ix + 6 );

	ld b, ( ix + 9 ); // bc = x1 << 8
	ld c, ( ix + 8 );

	ld a, ( ix + 12 ); // automodify code for color
	ld ( setColor1_r + 1 ), a;
	ld ( setColor2_r + 1 ), a;

	ld a, ( ix + 11 ); // automodify code for scanlinebuffer
	ld ( setScanlineBuffer_r + 2 ), a
	ld a, ( ix + 10 );
	ld ( setScanlineBuffer_r + 1 ), a

	ld a, ( ix + 4 ); // a = height

.loop_r
	push af;
	push hl;

.setScanlineBuffer_r
	ld de, $0000;
	add hl, de;

	ld e, ( hl );
	inc hl;
	ld d, ( hl );

	ld l, b;
	ld h, 0;
	ld a, l;
	add hl, de;

	ld d, h; // de = xLeft
	ld e, l;

.setDeltaX_r
	ld hl, $0000; // automodified
	add hl, bc;
	ld b, h; // bc = currX
	ld c, l;

	ld l, a;
	ld a, h;
	sub l; // a = scanline length

	cp a, 0;
	jr nz, moreThanOnePixel_r;

.setColor1_r
	ld a, 55; // automodified code
	ld ( de ), a;

	jr endOfScanline_r;

.moreThanOnePixel_r
	ld l, a;
.setColor2_r
	ld a, 55; // automodified code
.writeX_r
	ld ( de ), a;
	inc de;
	dec l;
	jr nz, writeX_r;

.endOfScanline_r

	pop hl;
	inc hl;
	inc hl;

	pop af;

	dec a;
	jr nz, loop_r;
#endasm
}

// ----------------------------------------------------------------------------
void _DrawLineToLeft( int pen, unsigned int scanlineBuffer, unsigned int x1, unsigned int y1, unsigned int height, unsigned int deltaX )
{
#asm
	ld ix, 0;
	add	ix, sp;

	// ( ix + 2 ) = deltaX
	// ( ix + 4 ) = height
	// ( ix + 6 ) = y1
	// ( ix + 8 ) = x1
	// ( ix + 10 ) = scanlineBuffer

	ld a, ( ix + 3 ); // hl = deltaX
	ld ( setDeltaX_l + 2 ), a; // automodify code for deltaX
	ld a, ( ix + 2 );
	ld ( setDeltaX_l + 1 ), a;

	ld h, ( ix + 7 ); // hl = height
	ld l, ( ix + 6 );

	ld b, ( ix + 9 ); // bc = x1 << 8
	ld c, ( ix + 8 );

	ld a, ( ix + 12 ); // automodify code for color
	ld ( setColor1_l + 1 ), a;
	ld ( setColor2_l + 1 ), a;

	ld a, ( ix + 11 ); // automodify code for scanlinebuffer
	ld ( setScanlineBuffer_l + 2 ), a
	ld a, ( ix + 10 );
	ld ( setScanlineBuffer_l + 1 ), a

	ld a, ( ix + 4 ); // a = height

.loop_l
	push af;
	push hl;

.setScanlineBuffer_l
	ld de, $0000;
	add hl, de;

	ld e, ( hl );
	inc hl;
	ld d, ( hl );

	ld l, b;
	ld h, 0;
	ld a, l;
	add hl, de;

	ld d, h; // de = xLeft
	ld e, l;

.setDeltaX_l
	ld hl, $0000; // automodified
	add hl, bc;
	ld b, h; // bc = currX
	ld c, l;

	ld l, a;
	sub h; // a = scanline length

	cp a, 0;
	jr nz, moreThanOnePixel_l;

.setColor1_l
	ld a, 55; // automodified code
	ld ( de ), a;

	jr endOfScanline_l;

.moreThanOnePixel_l
	ld l, a;
.setColor2_l
	ld a, 55; // automodified code
.writeX_l
	ld ( de ), a;
	dec de;
	dec l;
	jr nz, writeX_l;

.endOfScanline_l

	pop hl;
	inc hl;
	inc hl;

	pop af;

	dec a;
	jr nz, loop_l;
#endasm
}

// ----------------------------------------------------------------------------
static int xTemp = 0;
static int yTemp = 0;
static int currX = 0;
static int currY = 0;
static int deltaX = 0;
static int height = 0;
static int xLeft = 0;
static int xRight = 0;
static unsigned int scanline = 0;

// ----------------------------------------------------------------------------
void __LIB__ crGFXDrawLine( int x1, int y1, int x2, int y2, unsigned char pen )
{
	if ( y1 == y2 )
	{
		scanline = crCRTCGetScanline( y1 );
		xLeft = x1;
		xRight = x2;

		if ( xLeft > xRight )
		{
			xTemp = xLeft;
			xLeft = xRight;
			xRight = xTemp;
		}

		scanline += xLeft;
		memset( scanline, 255, xRight - xLeft );

		return;
	}

	if ( y1 > y2 )
	{
		yTemp = y2;
		y2 = y1;
		y1 = yTemp;

		xTemp = x2;
		x2 = x1;
		x1 = xTemp;
	}

	x1 <<= 8;
	x2 <<= 8;

	height = y2 - y1;

	deltaX = ( x2 - x1 ) / height;

	if ( x1 <= x2 )
	{
		_DrawLineToRight( pen, (unsigned int) g_scanlineBuffer, x1, y1, height, deltaX );
	}	
	else
	{
		_DrawLineToLeft( pen, (unsigned int) g_scanlineBuffer, x1, y1, height, deltaX );
	}
}
