/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

// ----------------------------------------------------------------------------
void __LIB__ crGFXDrawIntermediateClouds( unsigned char compareValue, unsigned int clouds, unsigned char *screen )
{
#asm
	pop bc;
	pop de; // screen

	pop hl; // clouds
	ld ( setClouds + 1 ), hl;

	pop hl; // compareValue
	ld a, l;
	ld ( compareValue + 1 ), a;
	push hl;

	ld hl, ( setClouds + 1 );

	push hl;
	push de;
	push bc;

	ld hl, $8000; // image
.setClouds
	ld bc, 0; // clouds
	// de = screen

.loop
	ld a, ( bc );
	inc bc;

.compareValue
	cp 0;
	jp z, draw;

	inc de;
	inc de;
	inc hl;
	inc hl;

	ld a, h;
	cp $88;
	jp nz, loop;

	jp finish;

.draw
	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl ); // 4
	and $aa; // 10101010
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $aa; // 10101010
	ld ( de ), a;
	dec hl;
	dec de;
	ld a, h;
	add 8;
	ld h, a;	
	ld a, d;
	add 8;
	ld d, a;

	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, ( hl );
	and $55; // 01010101
	ld ( de ), a;
	inc hl;
	inc de;
	ld a, h;
	sub 8 * 7;
	ld h, a;	
	ld a, d;
	sub 8 * 7;
	ld d, a;

	ld a, h;
	cp $88;
	jp nz, loop;

.finish	
#endasm
}
