/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
void __LIB__ crGFXCreateRotoZoomFrame(	unsigned char *screenPtr, // 12
										unsigned char *imagePtr, // 10
										int u, // 8
										int v, // 6
										int xx, // 4
										int yy ) // 2
{
#asm
	di;
	ld ( rotoSaveStack + 1 ), sp;
	
	ld ix, 0;
	add	ix, sp;

	ld h, ( ix + 13 ); // hl = screenPtr
	ld l, ( ix + 12 );

	dec hl; // remove JP at end
	dec hl;
	dec hl;

	ld sp, hl;

	ei;

	ld a, $c5;
	ld d, a;
	ld a, $01;
	ld e, a;

	ld h, ( ix + 11 );
	ld l, ( ix + 10 ); // imagePtr
	ld ( baseImage + 1 ), hl;

	ld h, ( ix + 9 );
	ld l, ( ix + 8 ); // u
	ld ( baseU + 1 ), hl;

	ld h, ( ix + 7 );
	ld l, ( ix + 6 ); // v
	ld ( baseV + 1 ), hl;

	ld h, ( ix + 5 );
	ld l, ( ix + 4 ); // xx
	ld ( incXX + 1 ), hl;
	ld ( baseVInc + 1 ), hl;

	ld h, ( ix + 3 );
	ld l, ( ix + 2 ); // yy
	ld ( incYY + 1 ), hl;
	ld ( baseUInc + 1 ), hl;

	ld a, ( table + 2 );
	or a;
	jp nz, noPreca;
	ld ix, table;
.baseImage
	ld hl,0;
	ld bc, 64;
	ld a, 64;
.preca
	ld ( ix + 0 ), l;
	ld ( ix + 1 ), h;
	inc ix;
	inc ix;
	add hl, bc;
	dec a;
	jp nz, preca;
.noPreca

	ld a, 33;
	ld ( decLoopY + 1 ), a;

.rotoLoop
.baseU
	ld hl, 0;
	ld ( incU + 1 ), hl;
.baseUInc
	ld bc, 0;
	sbc hl, bc;
	ld ( baseU + 1 ), hl;

.baseV
	ld hl, 0;
	ld ( incV + 1 ), hl;
.baseVInc
	ld bc, 0;
	add hl, bc;
	ld ( baseV + 1 ), hl;

	ld a, ( decLoopY + 1 );
	dec a;
	ld ( decLoopY + 1 ), a;
	or a;
	jp nz, skipDI;
	di;
.skipDI

	ld a, 30;
	ld ( decLoopX + 1 ), a;

.rotoLoopScanline
.incU
	ld hl, 0;
.incXX
	ld bc, 0;
	add hl, bc;
	ld ( incU + 1 ), hl;

.incV
	ld hl, 0;
.incYY
	ld bc, 0;
	add hl, bc;
	ld ( incV + 1 ), hl;

	ld a, h;
	and 63;
	rla;
	ld l, a;

	ld a, ( incU + 2 ); // u
	and 63;
	ld ( addBC + 1 ), a;

	xor a;
	ld h, a;

	ld bc, table;
	add hl, bc;
	ld a, ( hl );
	inc hl;
	ld h, ( hl );
	ld l, a;
	
.addBC
	ld bc, 0;	
	add hl, bc; // hl = ( ( ( v >> 8 ) & 63 ) << 6 ) + ( ( u >> 8 ) & 63 );

	// ld d, $c5;
	// ld e, $01;

	//defb $ed, $ff;

	ld a, ( hl );	
	ld b, d;
	ld c, a;
	push bc;

	ld b, a;
	ld c, e;
	push bc;

.decLoopX
	ld a, 10;
	dec a;
	ld ( decLoopX + 1 ), a;
	jp nz, rotoLoopScanline;

.decLoopY
	ld a, 10;
	or a;
	jp nz, rotoLoop;

	jp end;

.table
	defs 64 * 2, 0;

.end
.rotoSaveStack	
	ld sp, 0;
	ei;
#endasm
}
