/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
unsigned int g_framePtr;

// ----------------------------------------------------------------------------
void __LIB__ crGFXCreateMonoRotoZoomFrame(	unsigned char *screenPtr, // 12
											unsigned char *imagePtr, // 10
											int u, // 8
											int v, // 6
											int xx, // 4
											int yy ) // 2
{
#asm
	ld ix, 0;
	add	ix, sp;

	ld d, ( ix + 13 ); // de = screenPtr
	ld e, ( ix + 12 );

	ld h, ( ix + 11 );
	ld l, ( ix + 10 ); // imagePtr
	ld ( baseImage + 1 ), hl;

	ld h, ( ix + 9 );
	ld l, ( ix + 8 ); // u
	ld ( baseU + 1 ), hl;

	ld h, ( ix + 7 );
	ld l, ( ix + 6 ); // v
	ld ( baseV + 1 ), hl;

	ld h, ( ix + 5 );
	ld l, ( ix + 4 ); // xx
	ld ( incXX + 1 ), hl;
	ld ( baseVInc + 1 ), hl;

	ld h, ( ix + 3 );
	ld l, ( ix + 2 ); // yy
	ld ( incYY + 1 ), hl;
	ld ( baseUInc + 1 ), hl;

	ld a, ( table + 2 );
	or a;
	jp nz, noPreca;
	ld ix, table;
.baseImage
	ld hl,0;
	ld bc, 64;
	ld a, 64;
.preca
	ld ( ix + 0 ), l;
	ld ( ix + 1 ), h;
	inc ix;
	inc ix;
	add hl, bc;
	dec a;
	jp nz, preca;
.noPreca

	exx;
	ld h, 30;
	ld l, 33;
.incXX
	ld de, 0;
.incYY
	ld bc, 0;
	exx;

.rotoLoop

.baseU
	ld hl, 0;
	push hl;
	pop ix;
.baseUInc
	ld bc, 0;
	sbc hl, bc;
	ld ( baseU + 1 ), hl;

.baseV
	ld hl, 0;
	push hl;
	pop iy;
.baseVInc
	ld bc, 0;
	add hl, bc;
	ld ( baseV + 1 ), hl;

	/*ld hl, ( baseUInc + 1 );
	ld bc, 12;
	add hl, bc;
	ld ( baseUInc + 1 ), hl;

	ld hl, ( baseVInc + 1 );
	ld bc, 8;
	sbc hl, bc;
	ld ( baseVInc + 1 ), hl;*/
	
.rotoLoopScanline
	ld a, iyh;
	and 63;
	rla;
	ld l, a;
	ld h, 0;

	ld bc, table;
	add hl, bc;
	ld a, ( hl );
	inc hl;
	ld h, ( hl );
	ld l, a;

	ld a, ixh; // u
	and 63;
	ld b, 0;
	ld c, a;
	add hl, bc; // hl = ( ( ( v >> 8 ) & 63 ) << 6 ) + ( ( u >> 8 ) & 63 );

	ldi;	

	// xloop
	exx;
	add ix, de;
	add iy, bc;	
	dec h;
	exx;
	jp nz, rotoLoopScanline;

	// yloop
	exx;
	ld h, 30;
	dec l;
	exx;
	jp nz, rotoLoop;

	jp end;

.table
	defs 64 * 2, 0;

.end
	ld ( _g_framePtr ), de;
#endasm
}
