/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crCRTC.h"

// ----------------------------------------------------------------------------
unsigned char g_overscanMode = CRTC_OVERSCAN_DISABLE;
unsigned char g_screenWidth = 40;
unsigned char g_screenHeight = 25;
unsigned char g_screenPosX = 46;
unsigned char g_screenPosY = 30;

// ----------------------------------------------------------------------------
unsigned char g_crtcIsScreenFlipped = 0;
unsigned int *g_scanlineBuffer = 0;
unsigned char g_videoPage1 = CRTC_VIDEOPAGE_C000;
unsigned int g_scanlineBuffer1[ 35 * 8 ];
unsigned char g_videoPage2 = CRTC_VIDEOPAGE_C000;
unsigned int g_scanlineBuffer2[ 35 * 8 ];
unsigned char g_videoPageSize = CRTC_VIDEOPAGESIZE_32KB;

// ----------------------------------------------------------------------------
static void _CreateScanlineBuffer( unsigned int *scanlineBuffer, unsigned char videoPage )
{
	int y = 0;
	unsigned char iChar = 0;
	unsigned char iScanline = 0;

	unsigned int screen = 0;
	unsigned int baseScreen = 0;

	unsigned char secondScreen = 0;

	switch ( videoPage )
	{
	case CRTC_VIDEOPAGE_0000:	screen = 0x0000;	break;
	case CRTC_VIDEOPAGE_4000:	screen = 0x4000;	break;
	case CRTC_VIDEOPAGE_8000:	screen = 0x8000;	break;
	default:
	case CRTC_VIDEOPAGE_C000:	screen = 0xC000;	break;
	}

	baseScreen = screen;

	for ( iChar = 0; iChar < g_screenHeight; ++iChar )
	{
		if ( g_overscanMode == CRTC_OVERSCAN_FULLSCREEN )
		{
			if ( ( iChar == 19 ) && ( secondScreen == 0 ) )
			{
				secondScreen = 1;

				screen = baseScreen + 0x4000;
				screen += 4;
			}
		}

		for ( iScanline = 0; iScanline < 8; ++iScanline )
		{	
			scanlineBuffer[ y++ ] = screen + ( iScanline * 0x0800 );
		}

		screen += ( g_screenWidth * 2 );
	}
}

// ----------------------------------------------------------------------------
void __LIB__ crCRTCSetupScreen( unsigned char overscanMode, unsigned char videoPage1, unsigned char videoPage2, unsigned char videoPageSize )
{
	g_overscanMode = overscanMode;

	switch( g_overscanMode )
	{
	case CRTC_OVERSCAN_HORIZONTAL:
		g_screenWidth = 48;
		g_screenHeight = 21;
		g_screenPosX = 49; // 50 makes ASIC Raster Interrupt buggy!
		g_screenPosY = 28;
		break;

	case CRTC_OVERSCAN_VERTICAL:
		g_screenWidth = 30;
		g_screenHeight = 33;
		g_screenPosX = 41;
		g_screenPosY = 34;
		break;

	case CRTC_OVERSCAN_FULLSCREEN_CONVIMGCPC:
		g_screenWidth = 48;
		g_screenHeight = 34;
		g_screenPosX = 49; // 50 makes ASIC Raster Interrupt buggy!
		g_screenPosY = 34;
		break;

	case CRTC_OVERSCAN_FULLSCREEN:
		g_screenWidth = 54;
		g_screenHeight = 34;
		g_screenPosX = 49; // 50 makes ASIC Raster Interrupt buggy!
		g_screenPosY = 34;
		break;

	default:
	case CRTC_OVERSCAN_DISABLE:
		g_screenWidth = 40;
		g_screenHeight = 25;
		g_screenPosX = 46;
		g_screenPosY = 30;
		break;
	}

	crCRTCSetWidth( g_screenWidth );
	crCRTCSetHeight( g_screenHeight );
	crCRTCSetPosX( g_screenPosX );
	crCRTCSetPosY( g_screenPosY );

	g_videoPage1 = videoPage1;
	_CreateScanlineBuffer( g_scanlineBuffer1, videoPage1 );

	g_videoPage2 = videoPage2;
	_CreateScanlineBuffer( g_scanlineBuffer2, videoPage2 );

	g_videoPageSize = videoPageSize;

	g_crtcIsScreenFlipped = 1;
	crCRTCFlipScreen( );
}
