/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crCRTC.h"

// ----------------------------------------------------------------------------
extern unsigned char g_crtcIsScreenFlipped;

extern unsigned int *g_scanlineBuffer;
extern unsigned char g_videoPage1;
extern unsigned int g_scanlineBuffer1[ 34 * 8 ];
extern unsigned char g_videoPage2;
extern unsigned int g_scanlineBuffer2[ 34 * 8 ];
extern unsigned char g_videoPageSize;

// ----------------------------------------------------------------------------
void __LIB__ crCRTCFlipScreen( )
{
	if ( g_crtcIsScreenFlipped == 1 )
	{
		g_crtcIsScreenFlipped = 0;

		g_scanlineBuffer = (unsigned int *) g_scanlineBuffer2;
		crCRTCSetScreenOffset( g_videoPage1, g_videoPageSize, 0 );
	}
	else
	{
		g_crtcIsScreenFlipped = 1;

		g_scanlineBuffer = (unsigned int *) g_scanlineBuffer1;
		crCRTCSetScreenOffset( g_videoPage2, g_videoPageSize, 0 );
	}
}

