;Vortex Tracker II v1.0 PT3 player for ZX Spectrum
;(c)2004 S.V.Bulba <vorobey@mail.khstu.ru> http://bulba.at.kz

; modified by utopian / CEZ GS for acceptable Pasmo compilation, 
; and addition of effect player (original by WYZ / CEZ GS)
;
; Pasmo is quite good, but it fails in translating IX mnemonics
; It translates LD (IX-9+10), A into LD (IX-19), A, just like
; no other assembler!!!
; For this reason, I have to change a lot of calls.
; 



;Release number
Release EQU "6"

;Features
;--------
;-Can be compiled at any address (i.e. no need rounding ORG
; address).
;-Variables (VARS) can be located at any address (not only after
;code block).
;-INIT subroutine detects module version and rightly generates
; both note and volume tables outside of code block (in VARS).
;-Two portamento (spc. command 3xxx) algorithms (depending of
; module version).
;-Any Tempo value are accepted (including Tempo=1 and Tempo=2).
;-Fully compatible with Ay_Emul PT3 player codes.
;-See also notes at the end of this source code.

;Limitations
;-----------
;-Can run in RAM only (self-modified code is used).

;Warning!!! PLAY subroutine can crash if no module are loaded
;into RAM or INIT subroutine was not called before.

;Call MUTE or INIT one more time to mute sound after stopping
;playing 

	org 50176


;Test codes (commented)
;	CALL START
;	EI
;_LP	HALT
;	CALL START+5
;	XOR A
;	IN A,(#FE)
;	CPL
;	AND 15
;	JR Z,_LP

;Entry and other points
;START initialization
;START+3 initialization with module address in HL
;START+5 play one quark
;START+8 mute
;START+10 setup and status flags
;START+11 pointer to current position value in PT3 module;
;After INIT (START+11) points to Postion0-1 (optimization)

START
	LD HL, MUSIC_TABLE
	CALL EXT_WORD		; A is the input: number of the song to load
	LD DE, MDLADDR
	call 24576		; call apack depacker	
	LD HL,MDLADDR
	JR INIT
	CALL PLAY
	CALL REPRODUCE_EFECTOS
	CALL ROUT	
	RET
	JR MUTE
	JP INICIA_EFECTO
SETUP	DB 0 ;set bit0 to 1, if you want to play without looping
	     ;bit7 is set each time, when loop point is passed
CrPsPtr	DW 0 

;Identifier
;	DB "=VTII PT3 Player r.",Release,"="		; Sorry, no space for identifiers ;)

CHECKLP	LD HL,SETUP
	SET 7,(HL)
	BIT 0,(HL)
	RET Z
	POP HL
	LD HL,DelyCnt
	INC (HL)
	LD HL,ChanA+CHNPRM_NtSkCn
	INC (HL)
MUTE	LD      HL,ENABLE_MUSIC_EFFECTS	; Disable music, but not effects
        RES     1,[HL]
	XOR A
	LD H,A
	LD L,A
	LD (AYREGS+AR_AmplA),A
	LD (AYREGS+AR_AmplB),HL
	JP ROUT_A0

INIT
;HL - AddressOfModule

	LD (MODADDR),HL
	LD (MDADDR2),HL
	PUSH HL
; added code to allow music and / or effects to be individually enabled
        LD      HL,ENABLE_MUSIC_EFFECTS
        SET     1,[HL]        
        POP HL
        PUSH HL
; end addition        
	LD DE,100
	ADD HL,DE
	LD A,(HL)
	LD (Delay),A
	PUSH HL
	POP IX
	ADD HL,DE
	LD (CrPsPtr),HL
	LD E,(IX+2)
	ADD HL,DE
	INC HL
	LD (LPosPtr),HL
	POP DE
	LD L,(IX+3)
	LD H,(IX+4)
	ADD HL,DE
	LD (PatsPtr),HL
	LD HL,169
	ADD HL,DE
	LD (OrnPtrs),HL
	LD HL,105
	ADD HL,DE
	LD (SamPtrs),HL
	LD HL,SETUP
	RES 7,(HL)

;note table data depacker
	LD DE,T_PACK
	LD BC,T1_+(2*49)-1
TP_0	LD A,(DE)
	INC DE
	CP 15*2
	JR NC,TP_1
	LD H,A
	LD A,(DE)
	LD L,A
	INC DE
	JR TP_2
TP_1	PUSH DE
	LD D,0
	LD E,A
	ADD HL,DE
	ADD HL,DE
	POP DE
TP_2	LD A,H
	LD (BC),A
	DEC BC
	LD A,L
	LD (BC),A
	DEC BC
	SUB #F8*2
	JR NZ,TP_0

	LD HL,VARS
	LD (HL),A
	LD DE,VARS+1
	LD BC,VAR0END-VARS-1
	LDIR
	INC A
	LD (DelyCnt),A
	LD HL,#F001 ;H - CHNPRM_Volume, L - CHNPRM_NtSkCn
	LD (ChanA+CHNPRM_NtSkCn),HL
	LD (ChanB+CHNPRM_NtSkCn),HL
	LD (ChanC+CHNPRM_NtSkCn),HL

	LD HL,EMPTYSAMORN
	LD (AdInPtA),HL ;ptr to zero
	LD (ChanA+CHNPRM_OrnPtr),HL ;ornament 0 is "0,1,0"
	LD (ChanB+CHNPRM_OrnPtr),HL ;in all versions from
	LD (ChanC+CHNPRM_OrnPtr),HL ;3.xx to 3.6x and VTII

	LD (ChanA+CHNPRM_SamPtr),HL ;S1 There is no default
	LD (ChanB+CHNPRM_SamPtr),HL ;S2 sample in PT3, so, you
	LD (ChanC+CHNPRM_SamPtr),HL ;S3 can comment S1,2,3; see
				    ;also EMPTYSAMORN comment

        LD A,(IX-87) ;EXTRACT VERSION NUMBER
	SUB #30
	JR C,L20
	CP 10
	JR C,L21
L20	LD A,6
L21	LD (Version),A
	PUSH AF
	CP 4
        LD A,(IX-1) ;TONE TABLE NUMBER
	RLA
	AND 7

;NoteTableCreator (c) Ivan Roshin
;A - NoteTableNumber*2+VersionForNoteTable
;(xx1b - 3.xx..3.4r, xx0b - 3.4x..3.6x..VTII1.0)

	LD HL,NT_DATA
	PUSH DE
	LD D,B
	ADD A,A
	LD E,A
	ADD HL,DE
	LD E,(HL)
	INC HL
	SRL E
	SBC A,A
	AND #A7 ;#00 (NOP) or #A7 (AND A)
	LD (L3),A
	EX DE,HL
	POP BC ;BC=T1_
	ADD HL,BC

	LD A,(DE)

	ADD A,T_
	LD C,A
	ADC A,T_/256 ;Z80ASM by AIG cannot to assemble it

;other variant (temporary, 1 byte longer...)
;	LD BC,T_
;	ADD A,C
;	LD C,A
;	ADC A,B

	SUB C
	LD B,A
	PUSH BC
	LD DE,NT_
	PUSH DE

	LD B,12
L1	PUSH BC
	LD C,(HL)
	INC HL
	PUSH HL
	LD B,(HL)

	PUSH DE
	EX DE,HL
	LD DE,23
      LD IXH,8

L2	SRL B
	RR C
L3	DB #19	;AND A or NOP
	LD A,C
	ADC A,D	;=ADC 0
	LD (HL),A
	INC HL
	LD A,B
	ADC A,D
	LD (HL),A
	ADD HL,DE
        DEC IXH
	JR NZ,L2

	POP DE
	INC DE
	INC DE
	POP HL
	INC HL
	POP BC
	DJNZ L1

	POP HL
	POP DE

	LD A,E
	CP TCOLD_1
	JR NZ,CORR_1
	LD A,#FD
	LD (NT_+#2E),A

CORR_1	LD A,(DE)
	AND A
	JR Z,TC_EXIT
	RRA
	PUSH AF
	ADD A,A
	LD C,A
	ADD HL,BC
	POP AF
	JR NC,CORR_2
	DEC (HL)
	DEC (HL)
CORR_2	INC (HL)
	AND A
	SBC HL,BC
	INC DE
	JR CORR_1

TC_EXIT

	POP AF

;VolTableCreator (c) Ivan Roshin
;A - VersionForVolumeTable (0..4 - 3.xx..3.4x;
			   ;5.. - 3.5x..3.6x..VTII1.0)

	CP 5
	LD HL,#11
	LD D,H
	LD E,H
	LD A,#17
	JR NC,M1
	DEC L
	LD E,L
	XOR A
M1      LD (M2),A

	LD IX,VT_+16
	LD C,#10

INITV2  PUSH HL

	ADD HL,DE
	EX DE,HL
	SBC HL,HL

INITV1  LD A,L
M2      DB #7D
	LD A,H
	ADC A,0
	LD (IX),A
	INC IX
	ADD HL,DE
	INC C
	LD A,C
	AND 15
	JR NZ,INITV1

	POP HL
	LD A,E
	CP #77
	JR NZ,M3
	INC E
M3      LD A,C
	AND A
	JR NZ,INITV2

	JP ROUT_A0

;pattern decoder
PD_OrSm	LD (IX+8),0
	CALL SETORN
	LD A,(BC)
	INC BC
	RRCA

PD_SAM	ADD A,A
PD_SAM_	LD E,A
	LD D,0
SamPtrs EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD E,(HL)
	INC HL
	LD D,(HL)
MODADDR EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD (IX+3),L
	LD (IX+4),H
	JR PD_LOOP

PD_VOL	RLCA
	RLCA
	RLCA
	RLCA
	LD (IX+16),A
	JR PD_LP2
	
PD_EOff	LD (IX+8),A
	LD (IX-12),A
	JR PD_LP2

PD_SorE	DEC A
	JR NZ,PD_ENV
	LD A,(BC)
	INC BC
	LD (IX+5),A
	JR PD_LP2

PD_ENV	CALL SETENV
	JR PD_LP2

PD_ORN	CALL SETORN
	JR PD_LOOP

PD_ESAM	LD (IX+8),A
	LD (IX-12),A
	CALL NZ,SETENV
	LD A,(BC)
	INC BC
	JR PD_SAM_

PTDECOD LD A,(IX+6)
	LD (PrNote+1),A
	LD L,(IX-6)
	LD H,(IX-5)
	LD (PrSlide+1),HL

PD_LOOP	LD DE,#2010
PD_LP2	LD A,(BC)
	INC BC
	ADD A,E
	JR C,PD_OrSm
	ADD A,D
	JR Z,PD_FIN
	JR C,PD_SAM
	ADD A,E
	JR Z,PD_REL
	JR C,PD_VOL
	ADD A,E
	JR Z,PD_EOff
	JR C,PD_SorE
	ADD A,96
	JR C,PD_NOTE
	ADD A,E
	JR C,PD_ORN
	ADD A,D
	JR C,PD_NOIS
	ADD A,E
	JR C,PD_ESAM
	ADD A,A
	LD E,A
	LD HL,SPCCOMS+#FF20-#2000
	ADD HL,DE
	LD E,(HL)
	INC HL
	LD D,(HL)
	PUSH DE
	JR PD_LOOP

PD_NOIS	LD (Ns_Base),A
	JR PD_LP2

PD_REL	RES 0,(IX+9)
	JR PD_RES
	
PD_NOTE	LD (IX+6),A
	SET 0,(IX+9)
	XOR A

PD_RES	LD (PDSP_+1),SP
	LD SP,IX
	LD H,A
	LD L,A
	PUSH HL
	PUSH HL
	PUSH HL
	PUSH HL
	PUSH HL
	PUSH HL
PDSP_	LD SP,#3131

PD_FIN	LD A,(IX+5)
	LD (IX+15),A
	RET

C_PORTM RES 2,(IX+9)
	LD A,(BC)
	INC BC
;SKIP PRECALCULATED TONE DELTA (BECAUSE
;CANNOT BE RIGHT AFTER PT3 COMPILATION)
	INC BC
	INC BC
	LD (IX+10),A
	LD (IX-7),A
	LD DE,NT_
	LD A,(IX+6)
	LD (IX+7),A
	ADD A,A
	LD L,A
	LD H,0
	ADD HL,DE
	LD A,(HL)
	INC HL
	LD H,(HL)
	LD L,A
	PUSH HL
PrNote	LD A,#3E
	LD (IX+6),A
	ADD A,A
	LD L,A
	LD H,0
	ADD HL,DE
	LD E,(HL)
	INC HL
	LD D,(HL)
	POP HL
	SBC HL,DE
	LD (IX+13),L
	LD (IX+14),H
	LD E,(IX-6)
	LD D,(IX-5)
Version EQU $+1
	LD A,#3E
	CP 6
	JR C,OLDPRTM ;Old 3xxx for PT v3.5-
PrSlide	LD DE,#1111
	LD (IX-6),E
	LD (IX-5),D
OLDPRTM	LD A,(BC) ;SIGNED TONE STEP
	INC BC
	EX AF,AF'
	LD A,(BC)
	INC BC
	AND A
	JR Z,NOSIG
	EX DE,HL
NOSIG	SBC HL,DE
	JP P,SET_STP
	CPL
	EX AF,AF'
	NEG
	EX AF,AF'
SET_STP	LD (IX+12),A
	EX AF,AF'
	LD (IX+11),A
	LD (IX-2),0
	RET

C_GLISS	SET 2,(IX+9)
	LD A,(BC)
	INC BC
	LD (IX+10),A
	LD (IX-7),A
	LD A,(BC)
	INC BC
	EX AF,AF'
	LD A,(BC)
	INC BC
	JR SET_STP

C_SMPOS	LD A,(BC)
	INC BC
	LD (IX-11),A
	RET

C_ORPOS	LD A,(BC)
	INC BC
	LD (IX-12),A
	RET

C_VIBRT	LD A,(BC)
	INC BC
	LD (IX+0),A
	LD (IX-2),A
	LD A,(BC)
	INC BC
	LD (IX+0),A
	XOR A
	LD (IX+10),A
	LD (IX-6),A
	LD (IX-5),A
	RET

C_ENGLS	LD A,(BC)
	INC BC
	LD (Env_Del),A
	LD (CurEDel),A
	LD A,(BC)
	INC BC
	LD L,A
	LD A,(BC)
	INC BC
	LD H,A
	LD (ESldAdd),HL
	RET

C_DELAY	LD A,(BC)
	INC BC
	LD (Delay),A
	RET
	
SETENV	LD (IX+8),E
	LD (AYREGS+AR_EnvTp),A
	LD A,(BC)
	INC BC
	LD H,A
	LD A,(BC)
	INC BC
	LD L,A
	LD (EnvBase),HL
	XOR A
	LD (IX-12),A
	LD (CurEDel),A
	LD H,A
	LD L,A
	LD (CurESld),HL
C_NOP	RET

SETORN	ADD A,A
	LD E,A
	LD D,0
	LD (IX-12),D
OrnPtrs	EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD E,(HL)
	INC HL
	LD D,(HL)
MDADDR2	EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD (IX+1),L
	LD (IX+2),H
	RET

;ALL 16 ADDRESSES TO PROTECT FROM BROKEN PT3 MODULES
SPCCOMS DW C_NOP
	DW C_GLISS
	DW C_PORTM
	DW C_SMPOS
	DW C_ORPOS
	DW C_VIBRT
	DW C_NOP
	DW C_NOP
	DW C_ENGLS
	DW C_DELAY
	DW C_NOP
	DW C_NOP
	DW C_NOP
	DW C_NOP
	DW C_NOP
	DW C_NOP

CHREGS	XOR A
	LD (Ampl),A
	BIT 0,(IX+21)
	PUSH HL
	JP Z,CH_EXIT
	LD (CSP_+1),SP
	LD L,(IX+13)
	LD H,(IX+14)
	LD SP,HL
	POP DE
	LD H,A
	LD A,(IX+0)
	LD L,A
	ADD HL,SP
	INC A
	CP D
	JR C,CH_ORPS
	LD A,E
CH_ORPS	LD (IX+0),A
	LD A,(IX+18)
	ADD A,(HL)
	JP P,CH_NTP
	XOR A
CH_NTP	CP 96
	JR C,CH_NOK
	LD A,95
CH_NOK	ADD A,A
	EX AF,AF'
	LD L,(IX+15)
	LD H,(IX+16)
	LD SP,HL
	POP DE
	LD H,0
	LD A,(IX+1)
	LD B,A
	ADD A,A
	ADD A,A
	LD L,A
	ADD HL,SP
	LD SP,HL
	LD A,B
	INC A
	CP D
	JR C,CH_SMPS
	LD A,E
CH_SMPS	LD (IX+1),A
	POP BC
	POP HL
	LD E,(IX+8)
	LD D,(IX+9)
	ADD HL,DE
	BIT 6,B
	JR Z,CH_NOAC
	LD (IX+8),L
	LD (IX+9),H
CH_NOAC EX DE,HL
	EX AF,AF'
	LD L,A
	LD H,0
	LD SP,NT_
	ADD HL,SP
	LD SP,HL
	POP HL
	ADD HL,DE
	LD E,(IX+6)
	LD D,(IX+7)
	ADD HL,DE
CSP_	LD SP,#3131
	EX (SP),HL
	XOR A
	OR (IX+5)
	JR Z,CH_AMP
	DEC (IX+5)
	JR NZ,CH_AMP
	LD A,(IX+22)
	LD (IX+5),A
	LD L,(IX+CHNPRM_TSlStp)
	LD H,(IX+CHNPRM_TSlStp+1)
	LD A,H
	ADD HL,DE
	LD (IX+CHNPRM_CrTnSl),L
	LD (IX+CHNPRM_CrTnSl+1),H
	BIT 2,(IX+CHNPRM_Flags)
	JR NZ,CH_AMP
	LD E,(IX+CHNPRM_TnDelt)
	LD D,(IX+CHNPRM_TnDelt+1)
	AND A
	JR Z,CH_STPP
	EX DE,HL
CH_STPP SBC HL,DE
	JP M,CH_AMP
	LD A,(IX+CHNPRM_SlToNt)
	LD (IX+CHNPRM_Note),A
	XOR A
	LD (IX+CHNPRM_TSlCnt),A
	LD (IX+CHNPRM_CrTnSl),A
	LD (IX+CHNPRM_CrTnSl+1),A
CH_AMP	LD A,(IX+CHNPRM_CrAmSl)
	BIT 7,C
	JR Z,CH_NOAM
	BIT 6,C
	JR Z,CH_AMIN
	CP 15
	JR Z,CH_NOAM
	INC A
	JR CH_SVAM
CH_AMIN	CP -15
	JR Z,CH_NOAM
	DEC A
CH_SVAM	LD (IX+CHNPRM_CrAmSl),A
CH_NOAM	LD L,A
	LD A,B
	AND 15
	ADD A,L
	JP P,CH_APOS
	XOR A
CH_APOS	CP 16
	JR C,CH_VOL
	LD A,15
CH_VOL	OR (IX+CHNPRM_Volume)
	LD L,A
	LD H,0
	LD DE,VT_
	ADD HL,DE
	LD A,(HL)
CH_ENV	BIT 0,C
	JR NZ,CH_NOEN
	OR (IX+CHNPRM_Env_En)
CH_NOEN	LD (Ampl),A
	BIT 7,B
	LD A,C
	JR Z,NO_ENSL
	RLA
	RLA
	SRA A
	SRA A
	SRA A
	ADD A,(IX+CHNPRM_CrEnSl) ;SEE COMMENT BELOW
	BIT 5,B
	JR Z,NO_ENAC
	LD (IX+CHNPRM_CrEnSl),A
NO_ENAC	LD HL,AddToEn
	ADD A,(HL) ;BUG IN PT3 - NEED WORD HERE.
		   ;FIX IT IN NEXT VERSION?
	LD (HL),A
	JR CH_MIX
NO_ENSL RRA
	ADD A,(IX+CHNPRM_CrNsSl)
	LD (AddToNs),A
	BIT 5,B
	JR Z,CH_MIX
	LD (IX+CHNPRM_CrNsSl),A
CH_MIX	LD A,B
	RRA
	AND #48
CH_EXIT	LD HL,AYREGS+AR_Mixer
	OR (HL)
	RRCA
	LD (HL),A
	POP HL
	XOR A
	OR (IX+CHNPRM_COnOff)
	RET Z
	DEC (IX+CHNPRM_COnOff)
	RET NZ
	XOR (IX+CHNPRM_Flags)
	LD (IX+CHNPRM_Flags),A
	RRA
	LD A,(IX+CHNPRM_OnOffD)
	JR C,CH_ONDL
	LD A,(IX+CHNPRM_OffOnD)
CH_ONDL	LD (IX+CHNPRM_COnOff),A
	RET

PLAY    LD      HL,ENABLE_MUSIC_EFFECTS
        BIT     1,[HL]          ;ESTA ACTIVADA LA MUSICA?
        RET     Z
        ; end code addition
	XOR A
	LD (AddToEn),A
	LD (AYREGS+AR_Mixer),A
	DEC A
	LD (AYREGS+AR_EnvTp),A
	LD HL,DelyCnt
	DEC (HL)
	JR NZ,PL2
	LD HL,ChanA+CHNPRM_NtSkCn
	DEC (HL)
	JR NZ,PL1B
AdInPtA	EQU $+1
	LD BC,#0101
	LD A,(BC)
	AND A
	JR NZ,PL1A
	LD D,A
	LD (Ns_Base),A
	LD HL,(CrPsPtr)
	INC HL
	LD A,(HL)
	INC A
	JR NZ,PLNLP
	CALL CHECKLP
LPosPtr	EQU $+1
	LD HL,#2121
	LD A,(HL)
	INC A
PLNLP	LD (CrPsPtr),HL
	DEC A
	ADD A,A
	LD E,A
	RL D
PatsPtr	EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD DE,(MODADDR)
	LD (PSP_+1),SP
	LD SP,HL
	POP HL
	ADD HL,DE
	LD B,H
	LD C,L
	POP HL
	ADD HL,DE
	LD (AdInPtB),HL
	POP HL
	ADD HL,DE
	LD (AdInPtC),HL
PSP_	LD SP,#3131
PL1A	LD IX,ChanA+12
	CALL PTDECOD
	LD (AdInPtA),BC

PL1B	LD HL,ChanB+CHNPRM_NtSkCn
	DEC (HL)
	JR NZ,PL1C
	LD IX,ChanB+12
AdInPtB	EQU $+1
	LD BC,#0101
	CALL PTDECOD
	LD (AdInPtB),BC

PL1C	LD HL,ChanC+CHNPRM_NtSkCn
	DEC (HL)
	JR NZ,PL1D
	LD IX,ChanC+12
AdInPtC	EQU $+1
	LD BC,#0101
	CALL PTDECOD
	LD (AdInPtC),BC

Delay	EQU $+1
PL1D	LD A,#3E
	LD (DelyCnt),A

PL2	LD IX,ChanA
	LD HL,(AYREGS+AR_TonA)
	CALL CHREGS
	LD (AYREGS+AR_TonA),HL
	LD A,(Ampl)
	LD (AYREGS+AR_AmplA),A
	LD IX,ChanB
	LD HL,(AYREGS+AR_TonB)
	CALL CHREGS
	LD (AYREGS+AR_TonB),HL
	LD A,(Ampl)
	LD (AYREGS+AR_AmplB),A
	LD IX,ChanC
	LD HL,(AYREGS+AR_TonC)
	CALL CHREGS
;	LD A,(Ampl) ;Ampl = AYREGS+AR_AmplC
;	LD (AYREGS+AR_AmplC),A
	LD (AYREGS+AR_TonC),HL

	LD HL,(Ns_Base_AddToNs)
	LD A,H
	ADD A,L
	LD (AYREGS+AR_Noise),A

AddToEn EQU $+1
	LD A,#3E
	LD E,A
	ADD A,A
	SBC A,A
	LD D,A
	LD HL,(EnvBase)
	ADD HL,DE
	LD DE,(CurESld)
	ADD HL,DE
	LD (AYREGS+AR_Env),HL

	XOR A
	LD HL,CurEDel
	OR (HL)		
	
	ld (reg0), a
	
	;JR Z,ROUT_A0
	RET Z
	xor a
	ld (reg0), a
	DEC (HL)
	;JR NZ,ROUT	
	RET NZ
Env_Del	EQU $+1
	LD A,#3E
	LD (HL),A
ESldAdd	EQU $+1
	LD HL,#2121
	ADD HL,DE
	LD (CurESld),HL
	RET

reg0 db 0

ROUT	ld a, (reg0)	;XOR A
ROUT_A0	LD DE,#FFBF
	LD BC,#FFFD
	LD HL,AYREGS
LOUT	OUT (C),A
	LD B,E
	OUTI 
	LD B,D
	INC A
	CP 13
	JR NZ,LOUT
	OUT (C),A
	LD A,(HL)
	AND A
	RET M
	LD B,E
	OUT (C),A
	RET

NT_DATA	DB (T_NEW_0-T1_)*2
	DB TCNEW_0-T_
	DB (T_OLD_0-T1_)*2+1
	DB TCOLD_0-T_
	DB (T_NEW_1-T1_)*2+1
	DB TCNEW_1-T_
	DB (T_OLD_1-T1_)*2+1
	DB TCOLD_1-T_
	DB (T_NEW_2-T1_)*2
	DB TCNEW_2-T_
	DB (T_OLD_2-T1_)*2
	DB TCOLD_2-T_
	DB (T_NEW_3-T1_)*2
	DB TCNEW_3-T_
	DB (T_OLD_3-T1_)*2
	DB TCOLD_3-T_

T_

TCOLD_0	DB #00+1,#04+1,#08+1,#0A+1,#0C+1,#0E+1,#12+1,#14+1
	DB #18+1,#24+1,#3C+1,0
TCOLD_1	DB #5C+1,0
TCOLD_2	DB #30+1,#36+1,#4C+1,#52+1,#5E+1,#70+1,#82,#8C,#9C
	DB #9E,#A0,#A6,#A8,#AA,#AC,#AE,#AE,0
TCNEW_3	DB #56+1
TCOLD_3	DB #1E+1,#22+1,#24+1,#28+1,#2C+1,#2E+1,#32+1,#BE+1,0
TCNEW_0	DB #1C+1,#20+1,#22+1,#26+1,#2A+1,#2C+1,#30+1,#54+1
	DB #BC+1,#BE+1,0
TCNEW_1 EQU TCOLD_1
TCNEW_2	DB #1A+1,#20+1,#24+1,#28+1,#2A+1,#3A+1,#4C+1,#5E+1
	DB #BA+1,#BC+1,#BE+1,0

EMPTYSAMORN EQU $-1
	DB 1,0,#90 ;delete #90 if you don't need default sample

;first 12 values of tone tables (packed)

T_PACK	DB #06EC*2/256,#06EC*2
	DB #0755-#06EC
	DB #07C5-#0755
	DB #083B-#07C5
	DB #08B8-#083B
	DB #093D-#08B8
	DB #09CA-#093D
	DB #0A5F-#09CA
	DB #0AFC-#0A5F
	DB #0BA4-#0AFC
	DB #0C55-#0BA4
	DB #0D10-#0C55
	DB #066D*2/256,#066D*2
	DB #06CF-#066D
	DB #0737-#06CF
	DB #07A4-#0737
	DB #0819-#07A4
	DB #0894-#0819
	DB #0917-#0894
	DB #09A1-#0917
	DB #0A33-#09A1
	DB #0ACF-#0A33
	DB #0B73-#0ACF
	DB #0C22-#0B73
	DB #0CDA-#0C22
	DB #0704*2/256,#0704*2
	DB #076E-#0704
	DB #07E0-#076E
	DB #0858-#07E0
	DB #08D6-#0858
	DB #095C-#08D6
	DB #09EC-#095C
	DB #0A82-#09EC
	DB #0B22-#0A82
	DB #0BCC-#0B22
	DB #0C80-#0BCC
	DB #0D3E-#0C80
	DB #07E0*2/256,#07E0*2
	DB #0858-#07E0
	DB #08E0-#0858
	DB #0960-#08E0
	DB #09F0-#0960
	DB #0A88-#09F0
	DB #0B28-#0A88
	DB #0BD8-#0B28
	DB #0C80-#0BD8
	DB #0D60-#0C80
	DB #0E10-#0D60
	DB #0EF8-#0E10

; Effect player!

;INICIA EL EFECTO N [A]

INICIA_EFECTO:  LD      HL,TABLA_EFECTOS
                CALL    EXT_WORD
                LD      [PUNTERO_EFECTO],HL
                LD      HL,ENABLE_MUSIC_EFFECTS
                SET     3,[HL]
                RET   
                
;EXTRAE UN WORD DE UNA TABLA
;IN:[HL]=DIRECCION TABLA
;   [A]= POSICION
;OUT[HL]=WORD

EXT_WORD:       LD      D,0
                SLA     A               ;*2
                LD      E,A
                ADD     HL,DE
                LD      E,[HL]
                INC     HL
                LD      D,[HL]
                EX      DE,HL
                RET
                

REPRODUCE_EFECTOS:
                LD      HL,ENABLE_MUSIC_EFFECTS
                BIT     3,[HL]          ;ESTA ACTIVADO EL EFECTO?
                RET     Z
                
                xor a
		ld (reg0), a
	
                LD      HL,[PUNTERO_EFECTO]
                LD      A,[HL]
                CP      $FF
                JR      Z,FIN_EFECTO
                LD      [AYREGS+4],A
                INC     HL
                LD      A,[HL]
                RRCA
                RRCA
                RRCA
                RRCA
                AND     00001111B
                LD      [AYREGS+5],A
                LD      A,[HL]
                AND     00001111B
                LD      [AYREGS+10],A
       
       
                LD   A,10111000B
                LD   [AYREGS+7],A 
       
                INC     HL
                LD      [PUNTERO_EFECTO],HL
                RET
FIN_EFECTO:     LD      HL,ENABLE_MUSIC_EFFECTS
                RES     3,[HL]
                XOR     A        
                LD      [AYREGS+4],A
                LD      [AYREGS+5],A                
                LD      [AYREGS+10],A
                RET      

; Effect variables

ENABLE_MUSIC_EFFECTS DB 0
PUNTERO_EFECTO: DW      0               ;DW : PUNTERO DEL SONIDO QUE SE REPRODUCE

;EFECTOS DE SONIDO

TABLA_EFECTOS:  DW      EFECTO0,EFECTO1,EFECTO2,EFECTO3,EFECTO4

EFECTO0:	DB $F0,$0A	; lanzar bola
		DB $A0,$0E
		DB $98,$0F
		DB $90,$0F
		DB $88,$0C
		DB $00,$00
		DB $00,$0D
		DB $F0,$08
		DB $A0,$09
		DB $98,$09
		DB $90,$08
		DB $88,$07
		DB $00,$06
		DB $00,$05
		DB $FF

EFECTO1:	DB $F0,$0E	; store ball
		DB $30,$1E
		DB $55,$1B
		DB $60,$19
		DB $55,$18
		DB $00,$18
		DB $00,$18
		DB $F0,$19
		DB $30,$1A
		DB $55,$19
		DB $60,$18
		DB $55,$17
		DB $FF

EFECTO2:      ;PULSA TECLA

		DB $30,$0E
		DB $70,$0E
		DB $10,$0D
		DB $30,$0A
		DB $00,$00
		DB $00,$00
		DB $30,$0B
		DB $30,$09
		DB $10,$08
		DB $30,$07
		DB $00,$00
		DB $00,$00
		DB $30,$09
		DB $20,$0A
		DB $10,$09
		DB $10,$07
		DB $FF 

EFECTO3:      ;EXPLSION BURBUJAS

		DB $F0,$2C
		DB $80,$1D
		DB $E0,$0E
		DB $C8,$0F
		DB $C0,$0E
		DB $B0,$0B
		DB $F0,$29
		DB $60,$18
		DB $E0,$09
		DB $C8,$0A
		DB $C0,$09
		DB $B0,$09
		DB $F0,$29
		DB $80,$18
		DB $E0,$09
		DB $C8,$08
		DB $C0,$08
		DB $C0,$07
		DB $FF

EFECTO4:      ;TOCA PARED

		DB $80,$3B
		DB $80,$4E
		DB $30,$1C
		DB $80,$57
		DB $80,$3A
		DB $30,$28
		DB $80,$46
		DB $80,$39
		DB $30,$16
		DB $80,$45
		DB $80,$28
		DB $30,$17
		DB $FF	


;vars from here can be stripped
;you can move VARS to any other address

VARS

;ChannelsVars
;struc	CHNPRM
;reset group
CHNPRM_PsInOr	EQU 0	;RESB 1
CHNPRM_PsInSm	EQU 1	;RESB 1
CHNPRM_CrAmSl	EQU 2	;RESB 1
CHNPRM_CrNsSl	EQU 3	;RESB 1
CHNPRM_CrEnSl	EQU 4	;RESB 1
CHNPRM_TSlCnt	EQU 5	;RESB 1
CHNPRM_CrTnSl	EQU 6	;RESW 1
CHNPRM_TnAcc	EQU 8	;RESW 1
CHNPRM_COnOff	EQU 10	;RESB 1
;reset group

CHNPRM_OnOffD	EQU 11	;RESB 1

;IX for PTDECOD here (+12)
CHNPRM_OffOnD	EQU 12	;RESB 1
CHNPRM_OrnPtr	EQU 13	;RESW 1
CHNPRM_SamPtr	EQU 15	;RESW 1
CHNPRM_NNtSkp	EQU 17	;RESB 1
CHNPRM_Note	EQU 18	;RESB 1
CHNPRM_SlToNt	EQU 19	;RESB 1
CHNPRM_Env_En	EQU 20	;RESB 1
CHNPRM_Flags	EQU 21	;RESB 1
 ;Enabled - 0,SimpleGliss - 2
CHNPRM_TnSlDl	EQU 22	;RESB 1
CHNPRM_TSlStp	EQU 23	;RESW 1
CHNPRM_TnDelt	EQU 25	;RESW 1
CHNPRM_NtSkCn	EQU 27	;RESB 1
CHNPRM_Volume	EQU 28	;RESB 1
CHNPRM_Size	EQU 29	;RESB 1
;endstruc

ChanA	DS CHNPRM_Size
ChanB	DS CHNPRM_Size
ChanC	DS CHNPRM_Size

;struc	AR
AR_TonA	EQU 0	;RESW 1
AR_TonB	EQU 2	;RESW 1
AR_TonC	EQU 4	;RESW 1
AR_Noise	EQU 6	;RESB 1
AR_Mixer	EQU 7	;RESB 1
AR_AmplA	EQU 8	;RESB 1
AR_AmplB	EQU 9	;RESB 1
AR_AmplC	EQU 10	;RESB 1
AR_Env	EQU 11	;RESW 1
AR_EnvTp	EQU 13	;RESB 1
;endstruc

;GlobalVars
DelyCnt	DB 0
CurESld	DW 0
CurEDel	DB 0
Ns_Base_AddToNs
Ns_Base	DB 0
AddToNs	DB 0

AYREGS

VT_	DS 256 ;CreatedVolumeTableAddress

EnvBase	EQU VT_+14

T1_	EQU VT_+16 ;Tone tables data depacked here

T_OLD_1	EQU T1_
T_OLD_2	EQU T_OLD_1+24
T_OLD_3	EQU T_OLD_2+24
T_OLD_0	EQU T_OLD_3+2
T_NEW_0	EQU T_OLD_0
T_NEW_1	EQU T_OLD_1
T_NEW_2	EQU T_NEW_0+24
T_NEW_3	EQU T_OLD_3

NT_	DS 192 ;CreatedNoteTableAddress

;local var
Ampl	EQU AYREGS+AR_AmplC

VAR0END	EQU VT_+16 ;INIT zeroes from VARS to VAR0END-1

VARSEND EQU $

MUSIC_TABLE	DW MUSIC1, MUSIC2, MUSIC3, LEVELOK, LEVELSTART, GAMEOVER	; levelstart, levelend, gameover

MUSIC1 INCBIN "pulsar.bin"
MUSIC2 INCBIN "pirates.bin"
MUSIC3 INCBIN "nebulus.bin"
LEVELOK INCBIN "levelok.bin"
LEVELSTART INCBIN "getready.bin"
GAMEOVER INCBIN "gameover.bin"

MDLADDR EQU $		; The module will be decompressed here
			; we need at least 3402 bytes