       org 49152
; Include the one player levels       
INCLUDE "1plevels.asm"

PlayEffect EQU 25259

; INPUT:
; A: number of continues for one player games

; Main menu 
       LD (continues), a
       LD A, (initialized)
       and A
       JR NZ, start_mainmenu	; if already initialized the default keys, go to the real main menu

       ld HL, default_keys;      ; default keys are O-P-U-SPACE for player 1
			 	 ;T-Y-Q-Z for player 2, M for music on/off
       ld DE, 65527
       ld BC, 9
       ldir
       LD A, 1
       LD (initialized), A
; Beginning of the menu itself       
start_mainmenu:
       LD BC, $0703
       LD HL, menustr1
       LD DE, $0900		; ink red, paper black
       CALL PRINTF
       ;LD BC, $0704
       ld c, 4
       LD HL, menustr2
       CALL PRINTF
       ;LD BC, $0705
       ld c, 5
       LD HL, menustr3
       CALL PRINTF
       ;LD BC, $0707
       ld c, 7
       LD HL, menustr4
       CALL PRINTF
       ;LD BC, $0709
       ld c, 9
       LD HL, menustr5
       CALL PRINTF
       ;LD BC, $070B
       ld c, $0b
       LD DE, $0500
       LD HL, copyright
       CALL PRINTF
       ; Ver cual es la seleccion actual para player 1
print_selection:
       LD BC, $0906       
       LD A, (player1)              
       LD D, A
       AND A	; compare a with 0       
       JR Z, pl1_kempston
       LD A, 1
       CP D
       JR Z, pl1_sinclair1
       LD A, 2
       CP D
       JR Z, pl1_sinclair2       
; Si todo falla, va con teclas
pl1_keyboard:
       LD HL, strkeyboard1
       JR imprimepl1
pl1_kempston:
       LD HL, strkempston
       JR imprimepl1
pl1_sinclair1:
       LD HL, strsinclair1
       JR imprimepl1
pl1_sinclair2:
       LD HL, strsinclair2
       JR imprimepl1
imprimepl1:
       LD DE, $0300		; ink red, paper black
 	ld a, (menutimer)
 	cp 50
 	jr c, pl1_ok
	LD D, 0
pl1_ok:       
       CALL PRINTF      
       ; Ver cual es la seleccion actual para player 2
       LD BC, $0908
       LD A, (player2)
       LD D, A
       AND A	; compare a with 0
       JR Z, pl2_kempston
       LD A, 1
       CP D
       JR Z, pl2_sinclair1
       LD A, 2
       CP D
       JR Z, pl2_sinclair2       
; Si todo falla, va con teclas
pl2_keyboard:
       LD HL, strkeyboard2
       JR imprimepl2
pl2_kempston:
       LD HL, strkempston
       JR imprimepl2
pl2_sinclair1:
       LD HL, strsinclair1
       JR imprimepl2
pl2_sinclair2:
       LD HL, strsinclair2
       JR imprimepl2
imprimepl2:
       LD DE, $0400		; ink red, paper black
 	ld a, (menutimer)
 	cp 50
 	jr c, pl2_ok
	LD D, 0
pl2_ok:             
       CALL PRINTF      
write_credits:
       LD BC, $1717
       LD HL, string_credits
       LD DE, $0700		; ink red, paper black
       ld a, (menutimer)
       cp 32
       jr c, credits_ok
       LD D, 0
credits_ok:       
       CALL PRINTF      
       ld BC, $1F17
       ; How many credits do we have?
       ld a, (continues)
       and a
       jr z, zero_continues
one_continue:       
       LD HL, string_one
       jr write_continues
zero_continues:
	LD HL, string_zero
write_continues:
	CALL PRINTF

       ; Leemos el teclado
       CALL READ_KEYS
       LD B, A			; guardamos en B el valor de la tecla
check_p1_start:
       AND 1
       JP NZ, p1_start
check_p2_start:
       LD A,B
       AND 2
       JP NZ, p2_start
check_change_pl1:
       LD A,B
       AND 4
       JR Z, check_change_pl2
       CALL CHANGE_PL1
check_change_pl2:
       LD A, B
       AND 8
       JR Z, check_redefine_keys
       CALL CHANGE_PL2
check_redefine_keys:
       LD A,B
       AND 16
       JP Z, continue_menu
; Redefine keyboard 1        
       LD DE, $0500		; ink red, paper black
       LD BC, $060B
       LD HL, strplayer1
       CALL PRINTF      
       ;LD BC, $100B
       LD B, $10
       LD HL, redefineleft     
       CALL PRINTF                         
       CALL SCAN_KEYBOARD	
       LD (65527),A		; P1 Left is at 65527
              
       LD BC, $100B
       LD HL, redefineright
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                     
redef_p1r:           
       CALL SCAN_KEYBOARD	       
       LD BC, 65528
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p1r
       LD (65528),A		; P1 Right is at 65528
       
       LD BC, $100B
       LD HL, redefineup
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                         
redef_p1u:
       CALL SCAN_KEYBOARD	    
       LD BC, 65529
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p1u          
       LD (65529),A		; P1 Up is at 65529
       
       LD BC, $100B
       LD HL, redefinefire
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                         
redef_p1f:       
       CALL SCAN_KEYBOARD	       
       LD BC, 65530
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p1f
       LD (65530),A		; P1 Fire is at 65530

; Redefine keyboard 2
       LD DE, $0500		; ink red, paper black
       LD BC, $060B
       LD HL, strplayer2
       CALL PRINTF      
       LD BC, $100B
       LD HL, redefineleft     
       CALL PRINTF                         
redef_p2l:
       CALL SCAN_KEYBOARD	
       LD BC, 65531
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p2l          
       LD (65531),A		; P2 Left is at 65531
              
       LD BC, $100B
       LD HL, redefineright
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                         
redef_p2r:
       CALL SCAN_KEYBOARD	       
       LD BC, 65532
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p2r          
       LD (65532),A		; P2 Right is at 65532
       
       LD BC, $100B
       LD HL, redefineup
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                         
redef_p2u:
       CALL SCAN_KEYBOARD	       
       LD BC, 65533
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p2u          
       LD (65533),A		; P2 Up is at 65533
       
       LD BC, $100B
       LD HL, redefinefire
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                         
redef_p2f:
       CALL SCAN_KEYBOARD	       
       LD BC, 65534
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_p2f
       LD (65534),A		; P2 Fire is at 65534

; Redefine Music on/off key
       LD BC, $060B
       LD HL, redefinemusic
       LD DE, $0500		; ink red, paper black
       CALL PRINTF                         
redef_mus:       
       CALL SCAN_KEYBOARD	       
       LD BC, 65535
       call check_nodup		; Check that the key was not duplicated
       jr c, redef_mus
       LD (65535),A		; Music on/off is at 65535
       
       call check_cheat		; check if the user enabled cheat mode

; Write copyright message again
       LD BC, $070B
       LD HL, copyright
       LD DE, $0500		; ink red, paper black
       CALL PRINTF        

continue_menu:
       HALT
       ld a, (menutimer)
       inc a
       and $3f
       ld (menutimer), a	; the timer goes from 0 to 63.
       JP print_selection
       ;RET
p1_start:
       XOR a			; ld a,0
       JR end_menu
p2_start:
       LD A,1
end_menu:
       LD B,A
       LD A,(player2)		; 000000XX
       ADD A,A			; 00000XX0
       ADD A,A			; es equivalente a SLA A (2 veces) -> 0000XX00
       LD C,A
       LD A,(player1)
       OR C			; 0000XXYY
       ADD A,A			; 000XXYY0
       OR B			; 000XXYYZ
       LD B, A			; 
       LD A, (cheat_enabled)
       and a
       jr z, normal_mode
       ld A, $80		; high bit enabled: cheat mode enabled
       or B
       jr write_and_exit		       
normal_mode:       
       LD A,B			; no differences, restore A
write_and_exit:       
       LD (65526),A		; z: n players, yy: controles player 1, xx: controles player 2
       RET			

; Check if the user redefined the keys with the "magic combination"

check_cheat:
	ld a, (65527)	; Left is at 65527
	cp 'u'
	jr nz, nocheat
	ld a, (65528)	; Right is at 65528
	cp 't'
	jr nz, nocheat		
	ld a, (65529)	; Up is at 65529
	cp 'o'
	jr nz, nocheat
	ld a, (65530)	; Fire is at 65530
	cp 'p'
	jr nz, nocheat	
	ld a, (65531)	; P2 Left is at 65531
	cp 'i'
	jr nz, nocheat
	ld a, (65532)	; P2 Right is at 65532
	cp 'a'
	jr nz, nocheat		
	ld a, (65533)	; P2 Up is at 65533
	cp 'n'
	jr nz, nocheat
	ld a, 1
	ld (cheat_enabled), a ; User has enabled cheats!
nocheat:
	ret		

; check that the user did not try to use the same key twice
; INPUT
;	BC: address of the key being defined
;	A:  key defined
; OUTPUT:
;	carry flag = 1: error, tried to define twice
;	carry flag = 0: ok

check_nodup:
        push af                 ; save the defined key, just in case
        ld h, b
        ld l, c                 ; hl = last key
        ld bc, 65527    ; first key
        xor a           ; carry flag=0
        sbc hl, bc      
        ld b, h
        ld c, l                 ; bc=number of keys to check
        ld hl, 65527    
        pop af
        cpir            ; compare A with (HL), if not equal inc HL and dec BC                  
        jr z, is_duplicated          ; when exiting from cpir, Z is enabled if a match was found
        scf
        ccf             ; carry flag = 0
        ret
is_duplicated
        ld hl, 1
        push hl
        call PlayEffect	; PlayEffect, C function in the main code part (whoaaa)
        pop hl

        scf
        ret
	
		
org 52215

; Rutinas de apoyo

; Imprimir cadena de caracteres en X,Y
; Entrada:     B: coord X
;              C: coord Y
;	       D: ink
;	       E: paper
;              HL: direccion de la cadena, terminada en FF
; Registros utilizados: A, BC, DE, HL

PRINTF:
	LD IY, 5C3Ah	; re-establish the IY pointer (must be done!)
        ld a, $16
        sub c
        jr nc, higher_screen
lower_screen:
	ld a, c
	sub $16
	ld c, a
        PUSH BC         ; la rutina en 1601H toca todo lo que puede...
        PUSH DE
        PUSH HL 
   ;     SET     0,(IY+$02)      ; update TV_FLAG  - signal lower screen in use
    ;    RES     5,(IY+$01)      ; update FLAGS    - signal no new key
     ;   SET     4,(IY+$30)      ; update FLAGS2   - signal K channel in use
      ;  RES 	1, (IY+01)                                                 
        LD A, 1			; select lower screen (1)
        CALL 1601H
        POP HL
        POP DE
        POP BC
	jr printf_start
higher_screen:	
        PUSH BC         ; la rutina en 1601H toca todo lo que puede...
        PUSH DE
        PUSH HL        
       ; RES 0, (IY+02)
        ;RES 1, (IY+01)                                 
        LD A, 2			; select upper screen (2)
        CALL 1601H
        POP HL
        POP DE
        POP BC
printf_start:          
	push bc                     
       LD BC, (23606)		; 23606 == CHARS
       LD (oldchars), BC	; save the old CHARS value
       LD BC, FONT-256		;CHARS must be loaded with 32 characters before the first char
       LD (23606), BC		; now we've got the new charset        
       pop bc
       LD A, 16
       RST 10h       	
       LD A, D
       RST 10h		; ink
       LD A, 17
       RST 10h		; bright
       LD A, E
       RST 10h		; paper
       LD A, 22      ; seleccionar fila y columna
       RST 10h
       LD A, C        ; Y
       RST 10h
       LD A, B        ; X
PRINTC:
       RST 10h
       LD A, (HL)      ; caracter
       INC HL
       CP $FF
       JR NZ, PRINTC
       LD HL, (oldchars)	; restore the previous font
       LD (23606), HL
       RET

; Leer teclado
; Entrada: n/a
; Salida: En A, una mascara de bits con los valores
;

READ_KEYS:
       LD BC, $F7FE
       IN A, (C)  ; Leemos solo la fila 1-5
       CPL          ; Invertimos
       AND $1F      ; Y nos quedamos solo con los bits necesarios
       PUSH AF
WAIT_RELEASE:
       XOR A
       IN A, (C)  
       CPL 
       AND $1F
       JR NZ, WAIT_RELEASE ; Alguna tecla esta aun pulsada
       pop af 
       push af
       and $1f
       jr z, end_read_keys
              
       push hl
       ld hl, 2
       push hl
       call PlayEffect	; PlayEffect, C function in the main code part (whoaaa)
       pop hl
       pop hl              
end_read_keys:
       POP AF       
       RET

; Incrementar el valor de seleccion para jugador 1
; Entrada: n/a
; Salida: n/a
CHANGE_PL1:
       PUSH BC
       LD A, (player1)       
repeat_change_pl1:
       INC A
       CP 3
       JR Z, ok_selection_pl1	; we do not want to check for repeated controls if using keyboard
       CP 4
       JR C, fin_change_pl1
       xor a			; ld a, 0
fin_change_pl1:
       ld b, a
       LD a, (player2)
       cp b
       jr z, repeat_change_pl1
       ld a, b
ok_selection_pl1:
       LD (player1),A
       POP BC
       RET

; Incrementar el valor de seleccion para jugador 2
; Entrada: n/a
; Salida: n/a
CHANGE_PL2:
	push bc
       LD A, (player2)
repeat_change_pl2:       
       INC A   
       CP 3
       JR Z, ok_selection_pl2	; we do not want to check for repeated controls if using keyboard
       CP 4
       JR C, fin_change_pl2
       xor a			; ld a, 0
fin_change_pl2:
       ld b, a
       ld a, (player1)
       cp b
       jr z, repeat_change_pl2
       ld a, b
ok_selection_pl2
       LD (player2),A
       pop bc
       RET


; Scan the keyboard to find a single keypress
; Input: n/a
; Output: key scan code, in A

KeyCodes  defb 255,'z','x','c','v'      ; CAPS SHIFT, Z, X, C, V
   defb 'a','s','d','f','g'      ; A, S, D, F, G
   defb 'q','w','e','r','t'      ; Q, W, E, R, T
   defb '1','2','3','4','5'      ; 1, 2, 3, 4, 5
   defb '0','9','8','7','6'      ; 0, 9, 8, 7, 6
   defb 'p','o','i','u','y'      ; P, O, I, U, Y
   defb 13,'l','k','j','h'       ; ENTER, L, K, J, H
   defb ' ',255,'m','n','b'      ; SPACE, SYM SHIFT, M, N, B


SCAN_KEYBOARD:
	LD BC, $FEFE	; This is the first row, we will later scan all of them
	LD HL,KeyCodes  ; Let's go to the KeyCode table
	LD A,8		; loop counter
	
scan_loop:
	IN E, (C)	; Read the row status
	LD D, 5		; We just need to do it 5 times per scan line
find_keypress:
	RR E
	JR NC, keyfound	; we found a pressed key!	
	INC HL		; if not, go to the next scan code
	DEC D
	JR NZ, find_keypress ; try next key
	RLC B
	DEC A
	JR NZ, scan_loop	; back to the scan loop. This will repeat forever until a key press is found					
	JR SCAN_KEYBOARD	; if not, restart again		
keyfound:
	LD A,(HL)	; This is the scan code. We are not going back to the main loop, so we can reuse A
	PUSH AF
waitforrelease:
       	XOR A
        IN A, (C)  
       	CPL 
       	AND $1F
       	JR NZ, waitforrelease ; some key in this row is still pressed
       
        push hl
        ld hl, 2
        push hl
        call PlayEffect	; PlayEffect, C function in the main code part (whoaaa)
        pop hl
        pop hl                    
            
       	POP AF
	RET
	
; Datos

default_keys DB "opu tyqzm"
menustr1 DB  "1 - 1P start",$FF
menustr2 DB  "2 - 2P start",$FF
menustr3 DB  "3 - 1P control",$FF
menustr4 DB  "4 - 2P control",$FF
menustr5 DB  "5 - Define keys",$FF
strplayer1 DB " Player 1 ",$FF
strplayer2 DB " Player 2 ",$FF
redefineleft 	DB  "Left  ",$FF
redefineright 	DB  "Right ",$FF
redefineup 	DB  "Up    ",$FF
redefinefire 	DB  "Fire  ",$FF
redefinemusic   DB  " Music on/off  ",$ff
copyright	DB  "(c) CEZ GS 2007",$FF

strkempston  DB "Kempston  ", $FF
strsinclair1 DB "Sinclair 1", $FF
strsinclair2 DB "Sinclair 2", $FF
strkeyboard1  DB "Keyboard 1",$FF
strkeyboard2  DB "Keyboard 2",$FF

player1 DB 3
player2 DB 1
initialized DB 0
menutimer DB 0
string_credits  DB "Credits: ",$ff
string_one	DB "1",$ff
string_zero	DB "0",$ff
continues	DB 0
cheat_enabled	DB 0
oldchars DW 0

FONT 	DEFB	  0,  0,  0,  0,  0,  0,  0,  0
	DEFB	  0, 48, 48, 48, 48, 48,  0, 48
	DEFB	 54, 36,  0,  0,  0,  0,  0,  0
	DEFB	  0, 20, 62, 20, 62, 20,  0,  0
	DEFB	  0,  8, 62, 64, 60,  2,124,  8
	DEFB	  0,200,208, 16, 32, 44, 76,  0
	DEFB	  0, 56,100,100, 56,102,100, 58
	DEFB	 48, 32,  0,  0,  0,  0,  0,  0
	DEFB	  0,  8, 16, 16, 16, 16,  8,  0
	DEFB	  0, 16,  8,  8,  8,  8, 16,  0
	DEFB	  0,  0,  0, 48,120, 48,  0,  0
	DEFB	  0,  0,  0, 48,120, 48,  0,  0
	DEFB	  0,  0,  0,  0,  0,  0, 24, 48	; ","
	DEFB	  0,  0,  0,  0, 60,  0,  0,  0
	DEFB	  0,  0,  0,  0,  0,  0,  0, 48	; "."
	DEFB	  0,  0, 24, 48, 48, 96, 96,192
	DEFB	  0, 56, 76, 76, 76, 76, 76, 56
	DEFB	  0, 48,120,120, 88, 24, 24, 60
	DEFB	  0,112,184,120,240,224,196,184
	DEFB	  0, 56, 76, 12, 56, 12, 76, 56
	DEFB	  0,204,200,200,120,  8,  8, 28
	DEFB	  0,124, 96,120, 12, 12, 76, 56
	DEFB	  0, 56, 96,120,108,108,108, 56
	DEFB	  0,124, 12, 12,120, 60, 48, 48
	DEFB	  0, 56,100,100, 56,100,100, 56
	DEFB	  0, 56,108,108, 60, 12, 12, 56
	DEFB	  0,  0,  0,  0, 48,  0, 48,  0
	DEFB	  0,  0,  0,  0, 24,  0, 24, 48
	DEFB	  0, 24, 48, 48, 96, 48, 48, 24
	DEFB	  0,  0,  0,  0,120,  0,120,  0
	DEFB	  0, 96, 48, 48, 24, 48, 48, 96
	DEFB	  0, 56, 76, 28, 60, 56,  0, 48
	DEFB	 30, 33, 39, 73, 74, 78, 64, 60
	DEFB	  0, 30, 26, 50, 62,114, 98,227
	DEFB	  0,124, 50, 50, 60, 50, 50,124	; "B"
	DEFB	  0, 28, 50, 48, 48, 48, 50, 28
	DEFB	  0,124, 50, 50, 50, 50, 50,124	; "D"
	DEFB	  0,124, 50, 48, 60, 48, 50,124
	DEFB	  0,124, 54, 48, 62, 48, 48,120
	DEFB	  0, 56,100, 96,110,100,100, 60
	DEFB	  0,230,108,108,124,108,108,206
	DEFB	  0, 60, 24, 24, 24, 24, 24, 60
	DEFB	  0,112, 24, 24, 24, 24, 92, 56
	DEFB	  0,230,108,108,120,108,109,230
	DEFB	  0, 28, 50, 48, 48, 48, 50,124
	DEFB	  0,194,102,126,126, 86, 70,135
	DEFB	  0,198,100,116,124,124,236,198
	DEFB	  0, 60,110,100,100,100,100, 56
	DEFB	  0,124, 54, 54, 54, 60, 48,112
	DEFB	 56,100,100,100,108,108, 56,  6
	DEFB	  0,248,108,108,120,108,108,238
	DEFB	  0, 56,116,120, 60, 28, 76, 56	; "S"
	DEFB	  0,126,219, 24, 24, 24, 24, 60
	DEFB	  0,236,108,108,108,108,109, 54
	DEFB	  0,237,110,100,100,100,100, 56
	DEFB	  0,219,219,217,217,217,217,102
	DEFB	  0,236,184, 56, 48, 48,114,220
	DEFB	  0,236,108,108,108, 62, 76, 56
	DEFB	  0,252, 28, 28, 56, 56,114,220
	DEFB	  0, 12, 24, 24, 48, 24, 24, 12
	DEFB	  0,  0,192, 96, 96, 48, 48, 24
	DEFB	  0, 48, 24, 24, 12, 24, 24, 48
	DEFB	108, 72,  0,  0,  0,  0,  0,  0
	DEFB	  0,  0,  0,  0,  0,  0,  0,126 ; "_"
	DEFB	  0,100,104,  8, 16, 22, 38,  0
	DEFB	  0, 30, 26, 50, 62,114, 98,227
	DEFB	  0,124, 50, 50, 60, 50, 50,124	; "b"
	DEFB	  0, 28, 50, 48, 48, 48, 50, 28
	DEFB	  0,124, 50, 50, 50, 50, 50,124	; "d"
	DEFB	  0,124, 50, 48, 60, 48, 50,124
	DEFB	  0,124, 54, 48, 62, 48, 48,120
	DEFB	  0, 56,100, 96,110,100,100, 60
	DEFB	  0,230,108,108,124,108,108,206
	DEFB	  0, 60, 24, 24, 24, 24, 24, 60
	DEFB	  0,112, 24, 24, 24, 24, 92, 56
	DEFB	  0,230,108,108,120,108,109,230
	DEFB	  0, 28, 50, 48, 48, 48, 50,124
	DEFB	  0,194,102,126,126, 86, 70,135
	DEFB	  0,198,100,116,124,124,236,198
	DEFB	  0, 60,110,100,100,100,100, 56
	DEFB	  0,124, 54, 54, 54, 60, 48,112
	DEFB	 56,100,100,100,108,108, 56,  6
	DEFB	  0,248,108,108,120,108,108,238
	DEFB	  0, 56,116,120, 60, 28, 76, 56 ; "s"
	DEFB	  0,126,219, 24, 24, 24, 24, 60
	DEFB	  0,236,108,108,108,108,109, 54
	DEFB	  0,237,110,100,100,100,100, 56
	DEFB	  0,219,219,217,217,217,217,102
	DEFB	  0,236,184, 56, 48, 48,114,220
	DEFB	  0,236,108,108,108, 62, 76, 56
	DEFB	  0,252, 28, 28, 56, 56,114,220
	DEFB	  0, 12, 24, 24, 48, 24, 24, 12
	DEFB	  0, 16, 16, 16, 16, 16, 16,  0
	DEFB	  0, 48, 24, 24, 12, 24, 24, 48
	DEFB	108, 72,  0,  0,  0,  0,  0,  0
	DEFB	  0, 62, 75,145,153,130,124,  0
	
		
;; Intro!!!
org 53485

; fade in routine
; reminder
; spectrum attribute: xyZZZWWW
; WWW = ink, ZZZ = paper
	call clrscr

; uncompress the intro screen
	ld hl, INTROCOMP	
	ld de, INTROSCREEN
	call 24576

; copy intro screen to the actual screen
       ld hl, INTROSCREEN
       ld de, 16384
       ld bc, 6144
       ldir

; first third of the screen
fade_loop_begin:
       ld de, INTROSCREEN+6144
       ld hl, 16384+6144
       ld a, 0
       
       call fade_loop_main

       ld a, 50
       call sleep_halt                ; slow the fade a bit


; second third of the screen
fade_loop2_begin:
       ld de, INTROSCREEN+6144+256
       ld hl, 16384+6144+256
       ld a, 0

       call fade_loop_main

       ld a, 50
       call sleep_halt                ; slow the fade a bit

; last third of the screen
 ;      ld b,7
fade_loop3_begin:
       ld de, INTROSCREEN+6144+512
       ld hl, 16384+6144+512
       ld a, 0

	call fade_loop_main

       ld a, 150
       call sleep_halt                ; slow the fade a bit

; clear screen and print credits
	call clrscr
; fade code credits
	ld de, 0			; color is black, will fade to white
	ld b, 8
code_loop:
        ld a, (must_exit_intro) ; These 3 lines exit the intro 
        and a			; as soon as a key is pressed
        ret nz			; must be placed on every loop
	
	push bc
	push de
	ld bc, $0100			; x=1, y=0
	ld hl, string_code
	call PRINTF
	ld bc, $0102			; x=1, y=2
	ld hl, string_gfx
	call PRINTF
	ld bc, $0104			; x=1, y=4
	ld hl, string_addgfx
	call PRINTF
	ld bc, $0106			; x=1, y=6
	ld hl, string_mzx
	call PRINTF
	ld a, 6
	call sleep_halt		; slow the fade a bit	
	pop de
	ld a, d
	inc a
	ld d, a
	pop bc
	djnz code_loop              
        ld a, 35
        call sleep_halt                ; slow the fade a bit

; fade add gfx credits
	ld de, 0			; color is black, will fade to white
	ld b, 8
gfx_loop:
	ld a, (must_exit_intro) ; These 3 lines exit the intro 
        and a			; as soon as a key is pressed
        ret nz			; must be placed on every loop
	push bc
	push de
	ld bc, $0108			; x=1, y=8
	ld hl, string_ply
	call PRINTF
	ld bc, $010A			; x=1, y=10
	ld hl, string_lvl
	call PRINTF
	ld bc, $010C			; x=1, y=12
	ld hl, string_load
	call PRINTF
	ld bc, $010E			; x=1, y=14
	ld hl, string_kar
	call PRINTF
	ld a, 6
	call sleep_halt		; slow the fade a bit	
	pop de
	ld a, d
	inc a
	ld d, a
	pop bc
	djnz gfx_loop              
        ld a, 35
        call sleep_halt                ; slow the fade a bit

; fade add mzk credits
	ld de, 0			; color is black, will fade to white
	ld b, 8
mzk_loop:
	ld a, (must_exit_intro) ; These 3 lines exit the intro 
        and a			; as soon as a key is pressed
        ret nz			; must be placed on every loop
	push bc
	push de
	ld bc, $0111			; x=1, y=17
	ld hl, string_beta
	call PRINTF
	ld bc, $0112			; x=1, y=18
	ld hl, string_beta2
	call PRINTF
	ld bc, $0113			; x=1, y=19
	ld hl, string_beta3
	call PRINTF
	ld a, 6
	call sleep_halt		; slow the fade a bit	
	pop de
	ld a, d
	inc a
	ld d, a
	pop bc
	djnz mzk_loop              
        ld a, 35
        call sleep_halt                ; slow the fade a bit

; fade add other credits
	ld de, 0			; color is black, will fade to white
	ld b, 8
other_loop:
 	ld a, (must_exit_intro) ; These 3 lines exit the intro 
        and a			; as soon as a key is pressed
        ret nz			; must be placed on every loop
	push bc
	push de
	ld bc, $0115			; x=1, y=21
	ld hl, string_cez
	call PRINTF
	ld a, 6
	call sleep_halt		; slow the fade a bit	
	pop de
	ld a, d
	inc a
	ld d, a
	pop bc
	djnz other_loop              
        ld a, 50
        call sleep_halt                ; slow the fade a bit
; return
       ret




fade_loop_main:
       ld b, 7
       push de
       push hl
       
fade_loop_main0:
	pop hl
	pop de
	push de
	push hl
fade_loop1_start:
       push af
       ld a, (must_exit_intro) ; These 3 lines exit the intro 
       and a			; as soon as a key is pressed
       jp nz, pop_and_exit	; must be placed on every loop       
       ld a, (de)  
       and 7           ;get the expected ink
       ld c, a
       ld a, (hl)
       and 7           ; get the current ink
       cp c
       jr nc, fade_loop1_continue1 ; if the current is lower than expected
       inc (hl)                    ; increase it
fade_loop1_continue1:
       ld a, (de)
       and 56          ; get the expected paper
       ld c, a
       ld a, (hl)
       and 56          ; get the current ink                     
       cp c
       jr nc, fade_loop1_continue2 ; if the current is lower than expected
       ld a, (hl)
       and 56              
       add a, 8		; increase it       
       ld c, a
       ld a, (hl)      ; get the current value
       and $c7         ; leave out the paper
       or c            ; add the paper
       ld (hl),a       ; and store it
fade_loop1_continue2:
       inc hl
       inc de
       pop af
       dec a
       jr nz, fade_loop1_start ; back to the start
       ld a, 6
       call sleep_halt                	; slow the fade a bit
       djnz fade_loop_main0 		; do it 7 times
       pop hl
       pop de       
       ret
pop_and_exit:				;  only for the first loops :)
	pop af
       pop hl
       pop de       
	ret       

; Function: clean screen
; INPUT : none
; OUTPUT: none

clrscr:
; cleanup attribute part only
       ld hl, 22528
       ld (hl),0
       ld de, 22529
       ld bc, 767
       ldir
       ret
       
; Function: sleep a specific number of retraces
; INPUT: A: number of retraces to wait 
; OUTPUT: none
     
sleep_halt:
	push af
	push bc
	push de
	call KEYPRESSED
	and A
	jr nz, exit_keypressed
	pop de
	pop bc
	pop af
	halt
	dec a
	jr nz,sleep_halt
	ret
exit_keypressed:
	ld a, 1
	ld (must_exit_intro), a
	pop de
	pop bc
	pop af ; cleanup
	ret
       
; Function: test if any key is pressed
; INPUT: none
; OUTPUT: A = 0 if no key pressed, A != 0 if any key pressed
; MODIFIES: AF, BC, DE

KEYPRESSED:
	LD BC, $FEFE	; This is the first row, we will later scan all of them
	LD D,8		; loop counter
	
keyp_scanloop:
	IN A, (C)	; Read the row status
	CPL		; invert, so that any bit in 1 is a key pressed
	AND $1f		; get the 5 significant bits
	RET NZ		; A != 0, a key was pressed
	RLC B		; go to the next row
	DEC D
	JR NZ, keyp_scanloop
	XOR A		; No key pressed, A=0 and return
	RET		
       
string_code   DB "Code: Utopian",$ff
string_gfx    DB "Graphics: Kendroock",$ff
string_addgfx DB "Additional GFX: Anjuel, Beyker",$ff
string_mzx    DB "Music Themes: Beyker",$ff
string_ply    DB "Sound FX: WYZ",$ff
string_lvl    DB "Level Design: TBrazil, IvanZX",$ff
string_load   DB "Loader & Packing: Black Hole",$ff
string_beta   DB  "Test: TBrazil, IvanZX, Zemman",$ff
string_beta2  DB "      Edge, Pagantipaco, Alx",$ff
string_beta3  DB "      Konamito, Na_th_an",$ff
string_kar    DB "Direction: Karnevi",$ff
string_cez    DB "Thanks: A.Albrecht, S.Bulba",$ff

must_exit_intro DB 0
     
INTROCOMP INCBIN "ram1_1.bin"
TWOPLAYER_WIN INCBIN "ram1_2.bin"
INTROSCREEN:	; we will uncompress the screen right after this

