; Ending sequence	
	org 49152
	
the_end:
	call gen_scrtab	; generate screen address table
	call clrscr
	ld hl,endscreen1
	ld de,16384
	call 24576
	ld a, 100
	call sleep_halt
	call firstscreen
	ld a, 100
	call sleep_halt
	call fadeout
		
	call clrscr
	ld hl,endscreen2
	ld de,16384
	call 24576	
	call secondscreen
	;ld a, 50
	;call sleep_halt
	call fadeout_nowhite
	call reprint_credits
	call scrollup
		
	ld a, 50
	call sleep_halt
				
	call clrscr
	ld hl,fin_screen
	ld de,16384
	call 24576
	ld a, 100
	call sleep_halt

	ld hl, string_scr3_1
	ld bc, $0814
	call print_fadeloop	

	ld a, 250
	call sleep_halt
;	call fadeout
	ret		
	
; Function: First screen
firstscreen:
	ld a, 16
	ld hl, string_scr1
	ld bc, 0
	ld de, $0700
first_loop:
	push af
	push de
	push bc
	push hl	
	call PRINTF_SLOW
	pop hl
	ld bc, 33
	add hl, bc	; next line
	pop bc
	pop de
	pop af
	inc c		; one line down
	dec a
	jr nz, first_loop
	ret
	
secondscreen:
	ld hl, string_scr2_1
	ld bc, $0900
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_2
	ld bc, $0002
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_3
	ld bc, $0004
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_4
	ld bc, $0005
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_5
	ld bc, $0007
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_6
	ld bc, $0008
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_7
	ld bc, $000A
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_8
	ld bc, $000C
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_9
	ld bc, $000E
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_10
	ld bc, $000F
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_11
	ld bc, $0010
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_12
	ld bc, $0012
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_13
	ld bc, $0614
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ld hl, string_scr2_14
	ld bc, $0E17
	call print_fadeloop	
	ld a, 20
	call sleep_halt
	ret

print_fadeloop:
	ld a, 7
	ld de, $0100
print_loop1:
	push af
	push de
	push bc
	push hl	
	call PRINTF_NORMAL
	pop hl
	pop bc
	pop de
	inc d
	ld a, 8
	call sleep_halt
	pop af
	dec a
	jr nz, print_loop1
	ret

reprint_credits:
; cleanup whole screen
       ld hl, 16384
       ld (hl),0
       ld de, 16385
       ld bc, 6911
       ldir
	ld hl, string_scr2_1
	ld bc, $0900
	ld de, $0700
	call PRINTF_NORMAL
	ld hl, string_scr2_2
	ld bc, $0002
	call PRINTF_NORMAL
	ld hl, string_scr2_3
	ld bc, $0004
	call PRINTF_NORMAL
	ld hl, string_scr2_4
	ld bc, $0005
	call PRINTF_NORMAL
	ld hl, string_scr2_5
	ld bc, $0007
	call PRINTF_NORMAL
	ld hl, string_scr2_6
	ld bc, $0008
	call PRINTF_NORMAL
	ld hl, string_scr2_7
	ld bc, $000A
	call PRINTF_NORMAL
	ld hl, string_scr2_8
	ld bc, $000C
	call PRINTF_NORMAL
	ld hl, string_scr2_9
	ld bc, $000E
	call PRINTF_NORMAL
	ld hl, string_scr2_10
	ld bc, $000F
	call PRINTF_NORMAL
	ld hl, string_scr2_11
	ld bc, $0010
	call PRINTF_NORMAL
	ld hl, string_scr2_12
	ld bc, $0012
	call PRINTF_NORMAL
	ld hl, string_scr2_13
	ld bc, $0614
	call PRINTF_NORMAL
	ld hl, string_scr2_14
	ld bc, $0E17
	call PRINTF_NORMAL
	ret

	
fadeout:
	ld e, 7
fade_loop:
       ld hl, 16384+6144
       ld b,0
       ld d, 3
fade_loop1_start:
       ld a, (hl)
       and 7           ; get the current ink
       jr z, continue_paper1
       dec a		; decrement ink
continue_paper1:
       ld c, a
       ld a, (hl)
       and 56		; get the current paper
       jr z, continue_1
       sub 8		; decrement paper
continue_1:
       or c
       ld (hl), a
       inc hl
       djnz fade_loop1_start
       dec d
       jr nz, fade_loop1_start
       ld a, 7
       call sleep_halt
       dec e
       jr nz, fade_loop
       ret
       
fadeout_nowhite:
	ld e, 7
fadewhite_loop:
       ld hl, 16384+6144
       ld b,0
       ld d, 3
fadewhite_loop1_start:
       ld a, (hl)
       and 7           ; get the current ink
       jr z, continuewhite_paper1
       cp 7
       jp z, continuewhite_paper1
       dec a		; decrement ink
continuewhite_paper1:
       ld c, a
       ld a, (hl)
       and 56		; get the current paper
       jr z, continuewhite_1
       sub 8		; decrement paper
continuewhite_1:
       or c
       ld (hl), a
       inc hl
       djnz fadewhite_loop1_start
       dec d
       jr nz, fadewhite_loop1_start
       ld a, 7
       call sleep_halt
       dec e
       jr nz, fadewhite_loop
       ret       
       
       
       
       
string_scr1 DEFM "Finally, after a long and hard  ",$ff
	    DEFM "battle, you have defeated the   ",$ff
	    DEFM "terrible pirate Blackbeard under",$ff
	    DEFM "the heavy fire from your ship.  ",$ff
	    DEFM "                                ",$ff
	    DEFM "News on this heroic achievement ",$ff
	    DEFM "were spread by word of mouth,   ",$ff
	    DEFM "until it became an old tale, and",$ff
	    DEFM "then a legend.                  ",$ff
	    DEFM "                                ",$ff
	    DEFM "Even today, there are people who",$ff
	    DEFM "think Blackbeard never died in  ",$ff
	    DEFM "that battle, and his soul is    ",$ff
	    DEFM "still sailing through the Seven ",$ff
	    DEFM "Seas, seeking vengueance...     ",$ff
	    DEFM "                                ",$ff

string_scr2_1  DEFM "*CANNON BUBBLE*",$ff
string_scr2_2  DB "Code: Utopian",$ff
string_scr2_3  DB "Graphics: Kendroock",$ff
string_scr2_4  DB "Additional GFX: Anjuel, Beyker",$ff
string_scr2_5  DB "Music Themes: Beyker",$ff
string_scr2_6  DB "Sound FX: WYZ",$ff
string_scr2_7  DB "Level Design: TBrazil, IvanZX",$ff
string_scr2_8  DB "Loader & Packing: Black Hole",$ff
string_scr2_9  DB "Test: TBrazil, IvanZX, Zemman",$ff
string_scr2_10 DB "      Edge, Pagantipaco, Alx",$ff
string_scr2_11 DB "      Konamito, Na_th_an",$ff
string_scr2_12 DB "Direction: Karnevi",$ff
string_scr2_13 DB "A CEZ TEAM PRODUCTION",$ff
string_scr2_14 DB "Dedicated to Marta",$ff
string_scr3_1  DEFM "** THE END **",$ff


; Function: clean screen
; INPUT : none
; OUTPUT: none

clrscr:
; cleanup attribute part only
       ld hl, 22528
       ld (hl),0
       ld de, 22529
       ld bc, 767
       ldir
       ret

; Function: sleep a specific number of retraces
; INPUT: A: number of retraces to wait 
; OUTPUT: none

sleep_halt:
	halt
	dec a
	jp nz,sleep_halt
	ret


; Rutinas de apoyo

; Imprimir cadena de caracteres en X,Y, con retardo entre caracteres
; Entrada:     B: coord X
;              C: coord Y
;	       D: ink
;	       E: paper
;              HL: direccion de la cadena, terminada en FF
; Registros utilizados: A, BC, DE, HL

PRINTF_SLOW:
       PUSH BC         ; la rutina en 1601H toca todo lo que puede...
       PUSH DE
       PUSH HL
       LD IY, 5C3Ah	; re-establish the IY pointer (must be done!)
       RES 0, (IY+02)
       RES 1, (IY+01)              
       LD BC, (23606)		; 23606 == CHARS
       LD (oldchars), BC	; save the old CHARS value
       LD BC, endfont-256		;CHARS must be loaded with 32 characters before the first char
       LD (23606), BC		; now we've got the new charset        
       LD A, 2        ; seleccionar pantalla
       CALL 1601H
       POP HL
       POP DE
       POP BC
       LD A, 16
       RST 10h       	
       LD A, D
       RST 10h		; ink
       LD A, 17
       RST 10h
       LD A, E
       RST 10h		; paper
       LD A, 22      ; seleccionar fila y columna
       RST 10h
       LD A, C        ; Y
       RST 10h
       LD A, B        ; X
PRINTC:
       RST 10h
       ld a, 6
       call sleep_halt
       LD A, (HL)      ; caracter
       INC HL
       CP $FF
       JR NZ, PRINTC
       LD HL, (oldchars)	; restore the previous font
       LD (23606), HL
       RET


; Imprimir cadena de caracteres en X,Y
; Entrada:     B: coord X
;              C: coord Y
;	       D: ink
;	       E: paper
;              HL: direccion de la cadena, terminada en FF
; Registros utilizados: A, BC, DE, HL

PRINTF_NORMAL:
	LD IY, 5C3Ah	; re-establish the IY pointer (must be done!)
        ld a, $16
        sub c
        jr nc, higher_screen
lower_screen:
	ld a, c
	sub $16
	ld c, a
        PUSH BC         ; la rutina en 1601H toca todo lo que puede...
        PUSH DE
        PUSH HL 
;        SET     0,(IY+$02)      ; update TV_FLAG  - signal lower screen in use
 ;       RES     5,(IY+$01)      ; update FLAGS    - signal no new key
  ;      SET     4,(IY+$30)      ; update FLAGS2   - signal K channel in use
   ;     RES 	1, (IY+01)                                                 
        LD A, 1			; select lower screen (1)
        CALL 1601H
        POP HL
        POP DE
        POP BC
	jr printf_start
higher_screen:	
        PUSH BC         ; la rutina en 1601H toca todo lo que puede...
        PUSH DE
        PUSH HL        
    ;    RES 0, (IY+02)
    ;    RES 1, (IY+01)                                 
        LD A, 2			; select upper screen (2)
        CALL 1601H
        POP HL
        POP DE
        POP BC
printf_start:          
	push bc                     
       LD BC, (23606)		; 23606 == CHARS
       LD (oldchars), BC	; save the old CHARS value
       LD BC, endfont-256		;CHARS must be loaded with 32 characters before the first char
       LD (23606), BC		; now we've got the new charset        
       pop bc
       LD A, 16
       RST 10h       	
       LD A, D
       RST 10h		; ink
       LD A, 17
       RST 10h		; bright
       LD A, E
       RST 10h		; paper
       LD A, 22      ; seleccionar fila y columna
       RST 10h
       LD A, C        ; Y
       RST 10h
       LD A, B        ; X
PRINTC2:
       RST 10h
       LD A, (HL)      ; caracter
       INC HL
       CP $FF
       JR NZ, PRINTC2
       LD HL, (oldchars)	; restore the previous font
       LD (23606), HL
       RET


; the following routine is copy&paste from Derek Smith's sprite tutorial

gen_scrtab: ld de,16384
            ld hl,screen_table
            ld b,192
lineloop:    ld (hl),e
            inc hl
            ld (hl),d
            inc hl
            inc d
            ld a,d
            and 7
            jr nz,nextline
            ld a,e
            add a,32
            ld e,a
            jr c,nextline
            ld a,d
            sub 8
            ld d,a
nextline:    djnz lineloop
            ret
            
; scroll up a whole screen
scrollup:	       ld hl, 16384+6144       ; set all screen attributes to paper black, ink white
       ld de, 16384+6145
       ld (hl), 7
       ld bc, 767
       ldir
              
start_loop:
       ld b, 192
outer_loop:
       ld a, 191
       ld hl, screen_table
       push bc
inner_loop:
       push hl
       ld e, (hl)
       inc hl
       ld d, (hl)              ; de has the destination address
       inc hl   
       ld c, (hl)
       inc hl
       ld b, (hl)              ;bc has the source address
       inc hl
       ld h, b
       ld l, c                 ; hl now has the source address             
       ld bc, 32               ; move 32 bytes
       ldir                    ; or repeat ldi 32 times (ldi: 512 t-states, ldir: 667)      
;REPT 32
;	ldi
;ENDM       
       
       pop hl
       inc hl
       inc hl                  ; move to the next line
       dec a
       jr nz, inner_loop       ; repeat 191 times, one for each screen line

       ld hl, 22496            ; last line will be filled with blanks
       ld de, 22497
       ld (hl), 0
       ld bc, 31
       ldir

       pop bc
       halt
       djnz outer_loop

       ret   


endfont	   INCBIN "endfont.fnt"            
endscreen1 INCBIN "ram6_1.bin"
endscreen2 INCBIN "ram6_2.bin"
fin_screen INCBIN "ram6_3.bin"
oldchars DW 0
screen_table DW 0
