#extension GL_ARB_texture_rectangle : enable

varying vec2 vTexCoord;
uniform sampler2DRect cleanSource;
uniform sampler2DRect blurredSource;
uniform sampler2D noise;
uniform float cleanStrength;
uniform float blurStrength;
uniform float flashStrength;
uniform float globalFade;
uniform float backgroundBrightness;
uniform float backgroundNoiseBrightness;

void main()
{
	// Apply a bit of a warp to the screen, to simulate tube distorsion
	float fadeSize = 0.02;				// Fade to black at edge of screen
	float distorsionStrength = 6.0;		// Strength of distorsion (higher means less)
	vec2 vResolution = vec2(960, 720);
	vec2 vNormalisedTexCoord = vTexCoord / vResolution;
	float width = pow(abs(vNormalisedTexCoord.y - 0.5), distorsionStrength);
	float realX = ((vNormalisedTexCoord.x - 0.5) * 0.99) + 0.5;
	vec2 vBentTexCoord = vec2(((vNormalisedTexCoord.x - 0.5) * (1.0 + width)) + 0.5, vNormalisedTexCoord.y);
	vec2 vAdjustedTexCoord = vBentTexCoord * vResolution;
	
	// Fade out edges of screen
	float colourMod;
	if (realX - fadeSize < width / 2.0)
	{
		colourMod = 1.0 - (((width / 2.0) - (realX - fadeSize)) / fadeSize);
	}
	else if (realX + fadeSize > 1.0 - width / 2.0)
	{
		colourMod = 1.0 + (((1.0 - width / 2.0) - (realX + fadeSize)) / fadeSize);
	}
	else
	{
		colourMod = 1.0;
	}

	// Get final colour
	vec4 vSum = vec4(0.0);
	vec4 clean = texture2DRect(cleanSource, vAdjustedTexCoord);
	float cleanGreyscale = dot(clean.rgb, vec3(0.299, 0.587, 0.114));
	vSum += mix(clean * cleanStrength, vec4(1.0), cleanGreyscale);
	vSum += texture2DRect(blurredSource, vAdjustedTexCoord) * blurStrength;
	vSum += flashStrength;
	vSum *= globalFade;
	vec4 noiseValue = ((texture2D(noise, vTexCoord / vec2(960.0, 720.0) * 2.17) * 2.0) - 1.0) * 0.2 + 
					  ((texture2D(noise, vTexCoord / vec2(960.0, 720.0) * 0.024) * 2.0) - 1.0) * 0.8;
	float noiseGreyscale = dot(noiseValue.rgb, vec3(0.299, 0.587, 0.114));
	vSum += backgroundBrightness + backgroundNoiseBrightness * mix(vec4(noiseGreyscale), noiseValue, 0.3);
	vSum = clamp(vSum * (sin(vAdjustedTexCoord.y * 2.0) * 0.1 + 1.0), 0.0, 1.0);
	gl_FragColor = vSum * colourMod;

}
