import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;
import moonlander.library.*;
Moonlander moonlander;



PImage img1;
PImage img2;
PImage img3;
PImage img4;
PImage img4b;
PImage img5;
PImage img6;
PImage img7;

void setup() {
  // Use one of these lines only
//  size(800, 800, P2D);    // Windowed mode
  fullScreen(P2D);        // Fullscreen mode //<>//

  noCursor();
  frameRate(60);
  smooth();
  
  img1 = loadImage("overlay_esc_001.png");
  img1.filter(THRESHOLD, 0.2);
  img1.filter(INVERT);
  img2 = loadImage("overlay_seat_001.png");
  img2.filter(THRESHOLD, 0.2);
  img2.filter(INVERT);
  img3 = loadImage("overlay_seat_002.png");
  img3.filter(THRESHOLD, 0.6);
  img3.filter(INVERT);
  img4 = loadImage("overlay_doors_001.png");
  img4.filter(THRESHOLD, 0.3);
//  img4.filter(INVERT);
  img4b = loadImage("overlay_doors_001.png");
  img4b.filter(THRESHOLD, 0.9);
//  img4b.filter(INVERT);
  img5 = loadImage("overlay_seat_003.png");
  img5.filter(THRESHOLD, 0.2);
  img5.filter(INVERT);
  img6 = loadImage("overlay_smile_001.png");
  img6.filter(THRESHOLD, 0.6);
  img6.filter(INVERT);
  img7 = loadImage("overlay_roof_001.png");
  img7.filter(THRESHOLD, 0.1);
  img7.filter(INVERT);

 moonlander = Moonlander.initWithSoundtrack(this, "029_-_02_-_Texturas.mp3", 125, 8);
 moonlander.start();
}

void bg_effect1_dots(float time, float sizeMod, float posMod) {
//  float mx = 0;//sin(time*0.1) * 10;
//  float my = 0;//cos(time*0.1) * 10;
  for (float x = -10.0; x <= 10.0; x++) {
    for (float y = -10.0; y <= 10.0; y++) {
      float size = noise(x*0.5 + 500, y*0.5 + 500, time * 0.3) * 2.0 + sizeMod;
      float l = sqrt(pow(x+0.0001,2) + pow(y+0.0001,2));
//      float dx = x / l;
//      float dy = y / l;
      circle(x + x * posMod, y + y * posMod, size);
    }
  }
}
void bg_effect1(float time) {
  translate(0.5, 0.5);
  scale(0.15);

  fill(10);
  bg_effect1_dots(time, 0.15, 0.05);
  fill(60);
  bg_effect1_dots(time, 0.15, 0.0);
  fill(55);
  bg_effect1_dots(time, 0.0, 0.0);
}



void bg_effect2(float time) {
  translate(0.5, 0.5);
  scale(0.1);

  for (float z = 0.0; z <= 1.0; z += 0.025) {
    fill(z * 100);
    for (float x = -5; x <= 5; x++) {
      for (float y = -5; y <= 5; y++) {
        float h = noise(x*0.5+400, y*0.5+400, time * 0.2);
        if (h > z) {
          rect(x, y-z, 1.0 - z*0.5, 1.0-z);
        }
      }
    }
  }
}


void fg_effect1(float time) {
  translate(0.5, 0.5);
  noFill();
  stroke(223,129,68,145);
  blendMode(LIGHTEST);
  int arcCount = moonlander.getIntValue("arc_count");

  for (int i = 0; i < arcCount; i++) {
    float d = noise(i) * 1.5;
    float as = noise(i, time * 0.3) * 10;
    float al = noise(i*0.1 - 100, arcCount* 3.71 + time*0.1) * 3;
    strokeWeight(noise(i * 4.34) * 0.05);
    arc(0, 0, d, d, as, as + al);  
  }
}

void fg_effect2(float time) {
  translate(0, -time % 0.5);
  stroke(100);
  strokeWeight(0.01);
  int lines = 15;
  for (int x = 0; x < lines; x++) {
    float px = float(x)/(lines-1);
    line(px, 0.0, px, 0.0 + 0.4);
    line(px, 0.5, px, 0.5 + 0.4);
//    line(px, 1.0, px, 1.0 + 0.4);
  }
}


void fg_effect3(float time) {
  blendMode(ADD);
  noStroke();
  for (int i = 0; i < 70; i++ ) {
    float py = noise(i * 3.18) * 2 - 0.5;
    float bx = noise(i * 2.73) * 2 - 0.5;
    float tx = noise(i * 1.92) * (123 + time) * 4 + (float)moonlander.getValue("train-speed");
    float px = 1 - ((bx + tx) % 4 - 0.5);
    float alp = map(noise(i * 0.24, time * 0.01), 0, 1, 50, 100);

    fill(223,129,68, alp/1);
    ellipse(px, py, 0.50, 0.02);

    fill(223,129,68, alp/1);
    ellipse(px, py, 0.35, 0.01);

    fill(223,129,68, alp/1);
    ellipse(px, py, 0.20, 0.005);
  }
}

void fg_effect4(float time) {
  blendMode(ADD);
  tint(255, moonlander.getIntValue("seat-alpha"));
  int seatRepeats = moonlander.getIntValue("seat-repeats");
  float seatOffsets = (float)moonlander.getValue("seat_offsets");
  for (int i = 0; i < seatRepeats; i++) {
    pushMatrix();
    translate(0.5, 0.5);
    rotate(sin(float(i)*seatOffsets + time*0.54));
    translate(-0.5, -0.5);
    scale(2.0+sin(float(i)*seatOffsets + time*0.22));
    image(img5, 0,0, 1,1);
    popMatrix();
  }
}


void mytri(float x1, float y1, float x2, float y2, float x3, float y3, float t, float size, float alpha) {
  float c1 = noise(600+x1*2,600+y1*2,t*0.5);
  float c2 = noise(600+x2*2,600+y2*2,t*0.5);
  float c3 = noise(600+x3*2,600+y3*2,t*0.2);
  float c = (c1 + c2 + c3) * 55;
  fill(c * alpha);

  float mx = (x1+x2+x3)/3;
  float px1 = x1-(x1-mx)*size;
  float px2 = x2-(x2-mx)*size;
  float px3 = x3-(x3-mx)*size;

  float my = (y1+y2+y3)/3;
  float py1 = y1-(y1-my)*size;
  float py2 = y2-(y2-my)*size;
  float py3 = y3-(y3-my)*size;

  triangle(px1,py1,px2,py2,px3,py3);
}
void bg_efect5(float time) {
  background(10);
  translate(0.5, 0.5);
  float sc = (float)moonlander.getValue("tri_scale"); 
  float ro = (float)moonlander.getValue("tri_rotate");
  scale(sc);
  rotate(ro);
  for (int y=-8;y<=8;y++) {
    for (int x=-8;x<=8;x++) {
      float px1 = (float)x / 8;
      float px2 = (float)(x + 1) / 8;
      float py1 = (float)y / 8;
      float py2 = (float)(y + 1) / 8;
      mytri(px1,py1, px2,py1, px1+(px2-px1)/2,py2, time, 0.1, 0.7);
      mytri(px1,py1, px2,py1, px1+(px2-px1)/2,py2, time, 0.3, 1.0);
      mytri(px1,py1, px2,py1, px1+(px2-px1)/2,py2, time, 0.5, 1.5);
      mytri(px1+(px2-px1)/2,py2, px2,py1, px2+(px2-px1)/2,py2, time, 0.1, 0.7);
      mytri(px1+(px2-px1)/2,py2, px2,py1, px2+(px2-px1)/2,py2, time, 0.3, 1.0);
      mytri(px1+(px2-px1)/2,py2, px2,py1, px2+(px2-px1)/2,py2, time, 0.5, 1.5);
    }
  }
}

void fg_effect5(float time) {
  translate(0.5, 0.5);
  noFill();
  scale(0.25);
  rotate(time*0.1);
  strokeWeight(0.05);
  blendMode(LIGHTEST);
  float hsl1 = (float)moonlander.getValue("hsl1");
  float hsl2 = (float)moonlander.getValue("hsl2");
  for (int r = -5; r <= 5; r++) {
    float aa = float(r) * 0.03;
    float ac = 1 - abs((float)r) * 0.15;
    stroke(223*ac,129*ac,68*ac);
    beginShape();
    for (int i = 0; i <= 8; i++) {
      float a = aa + (float(i) / 8) * TWO_PI;
      curveVertex(sin(a+hsl1),cos(a+hsl1));
      curveVertex(sin(a)*hsl2,cos(a)*hsl2);
      curveVertex(sin(a-hsl1),cos(a-hsl1));
    }
    endShape();
  }
}


void resetGfx() {
  resetMatrix();
  translate((width-height)/2, 0);
  scale(height, height);
  noStroke();
  fill(0);
  rectMode(CENTER);
  blendMode(BLEND);
  noTint();
  blendMode(BLEND);
  strokeCap(SQUARE);
}
void draw() {
  moonlander.update();
  float time = (float)moonlander.getCurrentTime();
  background(50);

  int scene = moonlander.getIntValue("scene");
  float overlayStrength = (float)moonlander.getValue("overlay-strength");

  if (scene == 0) {
    resetGfx();
    bg_effect1(time);
    resetGfx();
    fg_effect1(time);
    resetGfx();
    blendMode(ADD);
    tint(255, map(noise(time * 6), 0, 1, 100, 150) * overlayStrength);
    image(img2, 0,0, 1,1);
  }
  if (scene == 1) {
    resetGfx();
    bg_effect2(time);
    resetGfx();
    fg_effect2(time);
    resetGfx();
    blendMode(ADD);
    tint(255, map(noise(time * 6), 0, 1, 100, 150) * overlayStrength);
    image(img1, 0,0, 1,1);
  }
  if (scene == 2) {
    background(30);
    resetGfx();
    fg_effect3(time);
    resetGfx();
    tint(255, map(noise(time * 6), 0, 1, 100, 150) * overlayStrength);
    tint(map(noise(time * 6), 0, 1, 100, 150) * overlayStrength);
    translate(0,-noise(time*3)*0.01);
    scale(1.01);
    image(img4, 0,0, 1,1);
    tint(map(noise(time * 6), 0, 1, 100, 150) * overlayStrength,120);
    image(img4b, 0,0, 1,1);
  }
  if (scene == 3||scene == 4) {
    resetGfx();
    fg_effect4(time);
    resetGfx();
    blendMode(ADD);
    tint(255, map(noise(time * 6), 0, 1, 100, 150) * overlayStrength);
    if(scene==3)
      image(img3, 0,0, 1,1);
    else
      image(img6, 0,0, 1,1);
  }
  if (scene == 5) {
    resetGfx();
    bg_efect5(time);
    resetGfx();
    fg_effect5(time);
    resetGfx();
    tint(255, map(noise(time * 6), 0, 1, 100, 150) * overlayStrength);
    blendMode(ADD);
    image(img7, 0,0, 1,1);
  }
  
  if (scene == 6) {
    exit();
  }
 
  // border
  resetGfx();
  fill(0);
  rect(-0.5,0,-1,2);
  rect(1.5,0,1,2);

  // fade-to-black overlay
  fill(0, (float)moonlander.getValue("fade-to-black")*255);
  rect(0, 0, 2, 2);

  println(frameRate);
}
