{
  Texture v.0.4

  (C)2K1 by CARSTEN WAECHTER aka THE TOXIC AVENGER/AINC.

  This Unit/Prog is Public Domain..
   Feel free to use, enhance or even learn about this code..
  If you like it, please drop a message to:
   toxie@ainc.de
  To get the newest version of Texture surf to:
   http://ainc.de

  All future changes will be listed below..
}

//Includes a .INC-file (from Texture!), converts it (24->32Bit) and shows it in a window

{$IFDEF FPC}
//Compile it using the FPC-Compiler
{$MODE DELPHI}
{$APPTYPE GUI}
USES Windows,Tex;
{$ELSE}
//Compile it using the DCC32-Compiler delivered with Delphi
{$D-,L-}
{$APPTYPE GUI}
USES Windows,Messages,Tex;
{$ENDIF}

Var
  hWindow     : HWnd;     //Window handle
  hHDC        : HDC;      //Draw Context
  pbitmapinfo : pointer;
  {$IFDEF FPC}
  AMessage    : Msg;
  {$ELSE}
  AMessage    : TMsg;
  {$ENDIF}

  vidvscr     : pointer;  //Virtual screen
  tempp       : pointer;
  xres,yres   : longint;


PROCEDURE InitGraphic;
 Var bisize : longint;
BEGIN
  {$IFDEF FPC}
  bisize:=sizeof(BITMAPINFOHEADER);
  {$ELSE}
  bisize:=sizeof(TBITMAPINFOHEADER);
  {$ENDIF}
  getmem(pbitmapinfo, bisize);
  fillchar(pbitmapinfo^, bisize, 0);

  {$IFDEF FPC}
  with BITMAPINFO(pbitmapinfo^) do
  {$ELSE}
  with TBITMAPINFO(pbitmapinfo^) do
  {$ENDIF}
   begin //BitmapInfoHeader 32Bit
     bmiHeader.biSize        :=bisize;
     bmiHeader.biWidth       :=xres;
     bmiHeader.biHeight      :=-yres;
     bmiHeader.biPlanes      :=1;
     bmiHeader.biBitCount    :=32;
     bmiHeader.biCompression :=BI_RGB;
   end;
END;


PROCEDURE BlitGraphic(source : pointer);
{$IFDEF FPC}
 Var r: rect;
BEGIN
  if (hHDC=0) then exit;

  GetClientRect(hWindow, @r);
  StretchDIBits(hHDC, 0, 0, r.right, r.bottom, 0, 0,
                xres, yres, source, bitmapinfo(pbitmapinfo^),
                DIB_RGB_COLORS, SRCCOPY);
{$ELSE}
 Var r: trect;
BEGIN
  if (hHDC=0) then exit;

  GetClientRect(hWindow, r);
  StretchDIBits(hHDC, 0, 0, r.right, r.bottom, 0, 0,
                xres, yres, source, tbitmapinfo(pbitmapinfo^),
                DIB_RGB_COLORS, SRCCOPY);
{$ENDIF}
END;


FUNCTION WindowProc(Window: HWnd; AMessage, WParam, LParam: Longint): Longint; stdcall; export;
BEGIN
  WindowProc:=0;

  case AMessage of
    wm_paint: begin
                BlitGraphic(vidvscr);
                Exit;
    end;
    wm_Destroy: begin  //Closed ??!
                  ReleaseDC(hWindow,hHDC);
                  hHDC:=0;
                  PostQuitMessage(0);
                  Exit;
    end;
  end;

  WindowProc:=DefWindowProc(Window, AMessage, WParam, LParam);
END;


FUNCTION WinRegister: Boolean; //Register Window Class
Var WindowClass: TWndClass;
BEGIN
  WindowClass.Style:=cs_ByteAlignClient;
  {$IFDEF FPC}
  WindowClass.lpfnWndProc:=WndProc(@WindowProc);
  {$ELSE}
  WindowClass.lpfnWndProc:=@WindowProc;
  {$ENDIF}
  WindowClass.cbClsExtra:=0;
  WindowClass.cbWndExtra:=0;
  WindowClass.hInstance:=system.MainInstance;
  WindowClass.hIcon:=LoadIcon(0, idi_Application);
  WindowClass.hCursor:=LoadCursor(0, idc_Arrow);
  WindowClass.hbrBackground:=GetStockObject(BLACK_BRUSH);
  WindowClass.lpszMenuName:=nil;
  WindowClass.lpszClassName:='AINC'; //Class Name

  WinRegister:=RegisterClass(WindowClass)<>0;
END;


FUNCTION WinCreate: HWnd;  //Create Window Class
Var
  hWindow: HWnd;
  r: trect;
  style, styleex : longint;
BEGIN
  r.top   :=CW_USEDEFAULT;
  r.left  :=CW_USEDEFAULT;
  r.right :=xres+2*GetSystemMetrics(SM_CXSIZEFRAME);
  r.bottom:=yres+GetSystemMetrics(SM_CYCAPTION)-GetSystemMetrics(SM_CYBORDER)+2*GetSystemMetrics(SM_CYSIZEFRAME);

  style:=WS_OVERLAPPED or WS_MINIMIZEBOX or WS_SYSMENU or WS_SIZEBOX or WS_MAXIMIZEBOX;
  styleex:=0;

  hWindow:=CreateWindowEx(styleex, 'AINC', 'Texture', style, r.left, r.top, r.right, r.bottom, 0, 0, system.MainInstance, nil);
                                  //Class //Window Name
  if hWindow<>0 then
   begin
     ShowWindow(hWindow, CmdShow);
     UpdateWindow(hWindow);
     hHDC:=GetDC(hWindow);
   end;

  WinCreate:=hWindow;
END;

begin
  {$I testin1.inc}

  getmem(vidvscr,256*256*4);  //Pointer to show Stuff

  tempp:=layers[MAXLAYERS-1]; //Pointer to the Texture

  {$IFDEF FPC}
  {$ASMMODE INTEL}
  {$ENDIF}
  ASM                         //Convert/Copy 24Bit-BGR-Texture to 32Bit-RGBA
   mov ecx,256*256
   mov edi,vidvscr
   mov esi,tempp
  @@loop:
   mov ah,[esi+1]
   mov al,[esi+2]
   shl eax,16
   mov al,[esi]
   xor ah,ah
   ror eax,16

   mov [edi],eax

   add esi,3
   add edi,4

   dec ecx
   jnz @@loop
  END;

  deinitlayers; //Free Memory

  //That's it.. =)

  xres:=256;  //Used for Window-Setup
  yres:=256;

  //The Rest is just Windows-Stuff to display the 32Bit-RGB-Content of 'vidvscr'

  if not WinRegister then
   begin
     MessageBox(0, 'Register Window Class failed', nil, mb_Ok);
     Halt(6);
   end;

  hWindow:=WinCreate;
  if (longint(hWindow)=0) then
   begin
     MessageBox(0, 'Window Create failed', nil, mb_Ok);
     Halt(6);
   end;

  InitGraphic;

  {$IFDEF FPC}
  while GetMessage(@AMessage,0,0,0) do
  {$ELSE}
  while GetMessage(AMessage,0,0,0) do  //Shows the image until a key is pressed
  {$ENDIF}
   begin
     sleep(50);
     TranslateMessage(AMessage);
     DispatchMessage(AMessage);
   end;
end.