/*
 *  Fly over Cydonia and view the Martian landscape
 *  Interesting note: sky backdrop is a real picture of the Martian sky taken from a
 *  NASA web site. So you see, it really is Mars!
 *
 *  Code by -Pan-/Atx
 *
*/

#define DISPCNT     *(u32*)0x04000000   // Define video display control
#define BG0CNT      *(u16*)0x04000008   // Define BG0 control
#define BG1CNT      *(u16*)0x0400000a   // Define BG1 control
#define BG2CNT      *(u16*)0x0400000c   // Define BG2 control
#define BG0HOFS     *(u16*)0x04000010   // BG0 Horizontal offset
#define BG0VOFS     *(u16*)0x04000012   // BG0 Vertical offset
#define DMA3SAD     *(u32*)0x040000d4   // Define DMA 3 Source
#define DMA3DAD     *(u32*)0x040000d8   // Define DMA 3 Destination
#define DMA3CNT     *(u32*)0x040000dc   // Define DMA 3 data amount
#define OAM     ((Sprite*)0x07000000)   // Setup pointer to OAM ram
#define OBJCHARDATA ((u8*)0x06010000)   // Setup pointer to OBJ graphics data
#define OBJ_PLTT    ((u16*)0x05000200)  // Setup pointer to OBJ palette


//some type definitions
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;
typedef short s16;
//define a sprite as a structure
typedef struct _Sprite { u16 Attrib0, Attrib1, Attrib2, RotateScale; } Sprite;

const u32 screensize = 160;
// include the sinus data
#include "sinus.c"
// need this for RAND() function
#include <stdlib.h>

//Add graphics from data.asm
extern u32 skyscape_data;              // background skycape pic

//set up function calls
void SetupScreen(void);
void createhorizon(void);
void Init(void);
void VBlank(void);
void C_Entry(void);



//Set up pointer to background map VRAM
u16 *screen16=(u16*)0x6000000;   //this is for 16 bit writes
u32 *screen32=(u32*)0x6000000;   //this is for quick 32 bit writes
u32 *sky_data;                         // this is where the sky graphics are
u16 y_max[40];
u16 mars[4000];
u32 count;
u32 count2;
u32 frameflip;
u32 frameaddress1;
u32 frameaddress2;



void C_Entry()
{
    //Set up registers for screen and sprites
    frameflip = 0;
    frameaddress1=0;
    frameaddress2=0;

    //call init to set up our screen display
    Init();
    count = 0;
    count2 = 0;
    sky_data = (u32*)(&skyscape_data);

    //loop
    while (1)
    {
    // Wait for VBlank Interval
    VBlank();
    count--;
    count2++;
    SetupScreen();

    }

}


void SetupScreen()
{
        u32 j, x;
        u16 max;
        u16 y, k;
        u16 z, z2, z3;
        u16 color;
        u32 pixeladdress;


         // flip frame buffer to display the OTHER screen.. so we can work on the other
         // buffer
         DISPCNT = (u16)(0x0405 | frameflip);

         frameflip ^=  0x10;
         frameaddress1 ^=0x2800;
         frameaddress2 ^=0x5000;

         //set Z position to bottom of the screen
         z2=128;
         z3=128;

          //copy red sky to background
          for ( j=0; j<10240; j++) screen32[j+frameaddress1]= sky_data[j];


         //Draw mountains
         createhorizon();

         //reset baseline to 0
         for ( j=0;j<(screensize>>2);j++) y_max[j] = 0;

         //draw 100 lines
         for ( z=0;z<100;z+=1)
          {
              //Draw a line
              for ( x=0; x<(screensize-2); x+=4)
              {

                //get the max height for the X coord
                max = y_max[x>>2];

                //get height from map, offset it with z2 to give it a
                // fake depth and divide by 2 then add z/2 to give it perspective
                y = (u16)(  (((mars[(z*40)+(x>>2)])-z2 )>>1)+(z>>1))  ;


                // if current height is greater than the known max height AND
                // the current height is not below the screen
                // then draw the pixel from current height to former max height
                if ( y>max  && (128-y) > 0)
                    {
                        //Draw a column from current Y to former max height at the
                        //current X position
                        for (k=y; k != max; k--)
                        {
                           //get Y value from map add 80 to brighten it
                           //and subtract Z to
                           //give the illusion of light, convert to 32 shades
                           color = (u16) ((((mars[(z*40)+(x>>2)])+80-(z)) >>3 ));
                            //if the Z subtraction resulted in a negative number then
                            //make the color black
                            if ( color & 0x8000) color = 0;

                            //make the ground appear rough by adding a random 1 to the
                            //color
                            color = color + (rand() & 1);
                            // convert use the 32 shades and create a Salmon-pink color
                            color = color | ((color /3) << 10) | ((color /3) << 5);

                            //Draw the pixel on the screen
                            pixeladdress = (u32)(128-k)*screensize+x+frameaddress2;
                           screen16[pixeladdress] = color;

                           screen16[pixeladdress+1] = color;
                           screen16[pixeladdress+2] = color;
                           screen16[pixeladdress+3] = color;
                        }
                        //set max height for x coords to the current height
                        y_max[x>>2]=y;
                    }
              }
           z2--;
           z3++;
        }
}


void createhorizon()
{
          u16 xmap1 = 0;
          u16 xmap2 = 0;
          u16 j;

          //scroll the map data down so we can put in a new horizon
          for ( j=1;j<99; j++) {

                for ( xmap1=0; xmap1!=40;xmap1++)
                    {
                    mars[(j*40)+xmap1] = mars[((j+1)*40)+xmap1];
                    }
          }

          // create a new horizon at the end of the map
          j = 99;
          for ( xmap1=0; xmap1!=40; xmap1++)
            {

            //get some pre-calced sinus data and create a funky sinus wave with it
            xmap2 = (sinus_x1[sinus_data[count & 255]] + sinus_data[(xmap1+count2) & 255])/2;
            //put it into the map
            mars[(j*40)+xmap1] = xmap2 + (rand() & 1);

            }
}





void Init()
{
    BG2CNT = 0x0000;       //turn on BG2CNT.
    DISPCNT = 0x0405;      //sets the display mode to display BKG2 , mode 5
}

void VBlank()
{
    // Wait For Video Blank Interval to get in sync with screen
  __asm
   {
   /*   If you aren't using much CPU time you may find that it will
    * keep updating whenever its on line 160. enable this routine to correct timing
    * if you have that problem
    *
      mov     r0, #0x4000006
    scanline_wait1:
        ldrh   r1, [r0]
        cmp    r1, #160
      beq     scanline_wait1
    */

     mov     r0, #0x4000006
   scanline_wait2:
     ldrh	r1, [r0]
     cmp	r1, #160
    bne     scanline_wait2
   }
}



