	heap	O=128k			;max 128k object buffer                
	size	4			;4 32kblocks                          
                                                                                  
	SMC+				;yes, we want a smc header            
	lrom				;yes, please split in 32k hunks       

UnpackBuffr     EQU     $7e8000
Buff2	EQU	$000200	; 24-bit address of $1A0 byte buffer
in	EQU	$65
out	EQU	$68
wrkbuf	EQU	$6a
counts	EQU	$6d
blocks	EQU	$4f
bitbufl	EQU	$51
bitbufh	EQU	$43
bufbits	EQU	$55
bitlen	EQU	$57
hufcde	EQU	$59
hufbse	EQU	$5b
temp1	EQU	$5d
temp2	EQU	$5f
temp3	EQU	$61
temp4	EQU	$63
tmptab	EQU	0	; indexed from Buff2
rawtab	EQU	$20	; indexed from Buff2
postab	EQU	$a0	; indexed from Buff2
slntab	EQU	$120	; indexed from Buff2

;==========================================================================
;      Code (c) 1993-94 -Pan-/ANTHROX   All code can be used at will!
;==========================================================================                     


  
	LDA #$00   
	PHA        
	PLB        
	dc.b	$5c,$00,$80,$00
Start:
	jmp	Start1
	org	$8020


Fonttext:
		;********************-***********
	dc.b	"********************            "
	dc.b	"********************- ANTHROX - "
	DC.B	"******************** PRESENTS:  "
	DC.B	"********************            "
	DC.B	"********************   BUBSY 2  "
	DC.B	"********************            "
	DC.B	"********************SUPPLIED BY "
	DC.B	"********************            "
	DC.B	"********************    KIRK    "
	DC.B	"********************            "
	DC.B	"********************            "
	dc.b	"********************  CALL THE  "
	dc.b	"********************            "
	dc.b	"********************   THE ATX  "
	dc.b	"********************            "
	dc.b	"********************   BOARDS   "
	dc.b	"********************            "
	dc.b	"******************** AROUND THE "
	dc.b	"********************            "
	dc.b	"********************    WORLD   "
	dc.b	"***LAST*LINE********            "
	dc.b	"                                "
	dc.b    "                                "
	dc.b    "                                "
	dc.b    "                                "
	dc.b    "                                "
	dc.b    "                                "
	dc.b    "                                "
	dc.b    "                                "
	dc.b    "                                "


	dc.b	"END OF SCREEN TEXT              "
	dc.b	"SCROLL TEXT STARTS HERE-------->"

scrolltext:
	dc.b	" HI GUY! WHAT'S HAPPENING?!  THIS IS MIGHTY COOL! "
	DC.B	"IT'S TOO BAD THAT I RAN OUT OF SCREEN TIME TO DO "
	DC.B	"OTHER THINGS BUT AT LEAST THE HORIZONTAL SPLIT IS NEW!"
	DC.B	" OK TIME TO RUN!   SEE YA IN THE NEXT SCROLL TEXT!      "
	DC.B	0
	dc.b	"                                                   "
	dc.b	"                                                   "
	dc.b	"                                                   "
	dc.b	"                                                   "
	dc.b	"                                                   "
	dc.b	"                                                   "
	dc.b	"                                                   "
	dc.b	0,"<- END OF SCROLL TEXT"


Start1:


	phk			; Put current bank on stack
	plb			; make it current programming bank
				; if this program were used as an intro
				; and it was located at bank $20 then an
				; LDA $8000 would actually read from
				; $008000 if it were not changed!
				; JSRs and JMPs work fine, but LDAs do not! 
	clc			; Clear Carry flag
	xce			; Native 16 bit mode  (no 6502 Emulation!) 
;==========================================================================

	jsr	Snes_Init	; Cool Init routine! use it in your own code!!

	rep     #$10		; X,Y fixed -> 16 bit mode
	sep     #$20		; Accumulator ->  8 bit mode


	ldx	#Picture		; CRUNCHED FILE
	stx	$65
	phk
	pla
	;lda	#^Picture1		; CRUNCHED FILE BANK
	sta	$67
	ldx	#UnpackBuffr		; LOW WORD UNPACK BUFFER
	stx	$68
	lda	#^UnpackBuffr		; UNPACK BUFFER BANK
	pha
	plb
	jsr	UNPACK				;Requires A[8] XY[16]

	phk
	plb

	rep	#$30
	sep	#$20

	lda	#$13		; Mode 7 Plane Enabled
	sta	$212c

	lda	#$40
	sta	$2107		; @ $4000
	lda	#$45
	sta	$2108		; VRAM plane 2 address at: $4400 (2 screens)
	lda	#$4c
	sta	$2109

	lda	#$55
	sta	$210b


	lda	#$c0		; area outside of mode-7 screen
	sta	$211a		; is color 0  (you can change it to
				; repetition of screen or place a single
				; character throughout)
	jsr	Copy_Gfx	; Put graf-x in vram
	jsr	Copy_colors	; put colors into color ram
	jsr	Make_tiles	; set up the screen
	jsr	HDMA
	jsr	Sprite_Setup
	ldx	#$0000
	stx	$1000		; Matrix A offset
	stx	$1002		; Matrix B offset
	stx	$1004		; Matrix C offset
	stx	$1006		; Matrix D offset
	ldx	#$0060
	stx	$1008		; X center coordinate position
	ldx	#$0060
	stx	$100a		; Y center coordinate position

	ldx	#$0000		; dummy vram address for copying text to
	stx	$100c		; vram


	stx	$100e		; counter for text copy
	
	ldx	#$0000		; change this to move entire screen X
	stx	$1010		; horizontal screen position
	ldx	#$0000		; change this to move entire screen Y
	stx	$1012		; vertical screen position
	
	ldx	#sine1		; read address of SINE data and store it
	stx	$10
	stx	$12		; store it again

	ldx	#$0080
	stx	$1014		; offset for COS data (Matrix A)
	ldx	#$0040		;
	stx	$1016		; offset for SIN data (Matrix B)
	ldx	#$0200		; 
	stx	$1018		; offset for -SIN data (Matrix C)
	ldx	#$0100		; 
	stx	$101a		; offset for COS data (Matrix D)

	ldx	#$0000
	stx	$101c		; clear controller 1 data

	stz	$101e		; Spin on/off flag (0=spin)

	ldx	#$0000
	stx	$1100		; offset for split mover data; defunct

	stx	$1102		; storage for sine data; defunct

	stx	$1104		; offset for Plasma Vertical
	stx	$1106		; storage data for Plasma offset

	stx	$1108		; $210d scroll position
	stx	$110a		; scroll text offset


;===========================================================================
;                         Start of Core Program
;===========================================================================

Waitloop:
	jsr	WaitVb		; wait for vertical blank
	
Joypad:
	lda     $4212 
	and     #$01  
	bne     Joypad
	lda     $4219
	cmp	#$10
	bne	nostart
	jmp	Pancopyright


nostart:
	lda	#$13
	sta	$212c
	lda	#$07
	sta	$2105

	
	jsr	Mode7		; go to Mode 7 register set

	jsr	PlasmaV
	jsr	Scroll



	lda	#$21
	sta	$4200

	lda	#$01
	sta	$4209		; wait for top of screen
	stz	$420a

Waitvert:
	lda	$4211

Waitvert2:
	lda     $4211    
	and     #$80     
	beq     Waitvert2

	lda	#$11
	sta	$4200

	lda	#$68
	sta	$4207
	stz	$4208		; position to wait for (horizontal)

	rep	#$30
	lda	#$2100
	tcd
	sep	#$20

	lda	#$0f
	sta	$2100

	ldx	#$00b8		; number of rasters to split

Waitrast:
	lda	$4211
	
Waitrast2:
	lda	$4211			; test if it hits our co-ordinates
	and	#$80
	beq	Waitrast2
	

	

	lda	#$02			; mode 2
	sta	$05
	
	

Hblank:
	lda	$4212			; test to see if we're in H-Blank
					; by reading $4212, bit #$40
					; shift the bits so $40->$80
	asl a				; 
					; is $80 set?
	bpl	Hblank			;   this will remove a flicker

	lda	#$07			; mode 7
	sta	$05


	dex				; decrease line counter
	bne	Waitrast
	lda	#$01
	sta	$05

	lda	$1108
	sta	$0d
	stz	$0d

	rep	#$30
	lda	#$0000
	tcd
	sep	#$20


	jsr	PlasmaH
	stz	$210d
	stz	$210d

	jmp	Waitloop	; constant loop




;=========================================================================
;                              Start of Scroll
;=========================================================================

Scroll:
	lda	$1108
	inc a
	and	#$07
	sta	$1108
	beq	Movescroll
	rts
Movescroll:

	ldx	#$0000
copyscrollbuff:
	lda	$0a01,x
	sta	$0a00,x
	inx
	cpx	#$001f
	bne	copyscrollbuff
	ldy	$110a
	lda	scrolltext,y
	bne	noscrollreset
	ldy	#$0000
	sty	$110a
	lda	scrolltext,y
noscrollreset:
	and	#$3f
	sta	$0a00,x


	ldx	$110a
	inx
	stx	$110a

	ldx	#$4320
	stx	$2116
	ldx	#$0000
copyscrollvram:
	lda	$0a00,x
	sta	$2118
	lda	#$10
	sta	$2119
	inx
	cpx	#$0020
	bne	copyscrollvram
	rts



;==========================================================================
;                          Start of Split Mover Routine
;==========================================================================


PlasmaH:

                                            
                                                                 
        ldx     $1100           ; read actual offset and store it
        stx     $05                                              
        stz     $04             ; line counter                   
        ldy     #$0000                                           
xbackwave:                                                       
        ldx     $05                                              
        lda     splitsine,x                                       
        iny                                                      
        sta     $0300,y         ; store it in ram (H-DMA data)   
        iny                                                      
        lda     #$00                                             
        sta     $0300,y                                          
        iny                                                      
        lda     $05                                              
        clc                                                      
        adc     #$01            ; icrease offset                 
        sta     $05                                              
        inc     $04             ; increase # of lines written    
        lda     $04                                              
        cmp     #$b8            ; did we do #$6e line?           
        bne     xbackwave                                        
        lda     $1100                                            
        clc
	adc     #$01            ; increase actual offset by 2 
	sta     $1100                                         
	rts

;===========================================================================
;			Plasma vertical mover
;===========================================================================
PlasmaV:
	ldx	#$4c20		; $4c20
	stx	$2116

	ldx	$1104
	stx	$1106

	ldy	#$0000

CopyPlasmaVsine:
	ldx	$1106
	lda	splitsine,x
	sta	$2118
	lda	#$c0
	sta	$2119
	inc	$1106
	inc	$1106
	inc	$1106
	;inc	$1106
	iny
	cpy	#$0020
	bne	CopyPlasmaVsine
	
	inc	$1104
	inc	$1104
	;inc	$1104
	rts
	



;===========================================================================
;                     Start Of Mode 7 Routine
;===========================================================================


Mode7:
	ldy	$1000	; get sine offset spin
	rep	#$20	; A = 16 bit
	lda	$10	; get address of sine data
	clc
	adc	$1014	; add Matrix A offset
	sta	$12
	lda	($12),y	; read 16 bit word of COS data
	sep	#$20	; A = 8 bit
	sta	$211b	; store first 8 bit into Matrix A register
	xba		; exchange bytes (like swap) to get the other 8 bits
	sta	$211b	; store it

	rep	#$20	; A = 16 bit
	lda	$10	; get address of sine data
	clc
	adc	$1016	; add Matrix B offset
	sta	$12
	lda	($12),y	; read 16 bit word of SIN data
	sep	#$20	; A = 8 bit
	sta	$211c	; store into Matrix B register
	xba		; swap lo-hi bytes
	sta	$211c	; store it 

	rep	#$20	; A = 16 bit
	lda	$10	; get address of sine data
	clc
	adc	$1018	; add Matrix C offset
	sta	$12
	lda	($12),y	; read 16 bit word of -SIN data
	sep	#$20	; A = 8 bit 
	sta	$211d	; store into Matrix C register
	xba		; swap lo-hi bytes
	sta	$211d	; store it

	rep	#$20	; A = 16 bit
	lda	$10	; get address of sine data
	clc
	adc	$101a	; add Matrix D offset
	sta	$12
	lda	($12),y	; read 16 bit word of COS data
	sep	#$20	; A = 8 bit
	sta	$211e	; store into Matrix D register
	xba		; swap lo-hi bytes
	sta	$211e	; store it


			;     - a few notes about Mode 7 -
			; rotation is easy, it's about the same as making a 
			; sprite sine circle. you just need sine and cosine
			; and -sin
			; 
			; expansion and reduction are easy.
			; to expand/reduce in the X direction only write to
			; Matrix A register and zero out the the other Matrix
			; registers
			;
			; to expand/reduce in Y direction only write to
			; Matrix D register
			;
			; to expand/reduce both X/Y direction just
			; write to the Matrix A and Matrix D registers!

			; to expand/reduce and rotate... err.. good luck!
			; you'll need to calculate the correct data
			; and i haven't done it yet.. err...

			; the data is signed, meaning the highest bit is
			; the positive/negative sign.
			; bit 16 (#$8000) is the sign flag, if it is on
			; then the number is negative.
			; the entire sine data ranges from -$7f.ff to +$7f.ff
			; that's -127.256 to +127.256
			;
			; between the low and high bytes lies a decimal point
			; the decimal is written as the low byte and the
			; whole number as the high byte

			; clock wise rotation using sine data
			; create sine from -254 to 254
			; Matrix A = sine address + (# of sine data created/4)
			; Matrix B    "   "        
			; Matrix C = sine address + (# of sine data created/2)
			; Matrix D = sine address + (# of sine data created/4)
			;
			; to make it counter clockwise just read the
			; sine offset backwards for Matrix B and C
			; the sine wave found here ranges from
			; -254 to 254 and contains 512 numbers
			; 

	lda	$1008
	sta	$211F
	lda	$1009	; X center co-ordinate
	sta	$211F

	lda	$100a
	sta	$2120
	lda	$100b	; Y center co-ordinate
	sta	$2120

	lda	$1010
	sta	$210d
	lda	$1011   ; X screen position
	sta	$210d

	lda	$1012
	sta	$210e
	lda	$1013	; Y screen position
	sta	$210e

	lda	$101e
	beq	Spinsine
	rts
Spinsine:
	rep	#$20
	lda	$1000
	clc
	adc	#$0002
	cmp	#$0400
	bne	noclear
	lda	#$0000
noclear:
	sta	$1000
	sep	#$20
	rts




;==========================================================================
;                        Vertical Blank Wait Routine
;==========================================================================
WaitVb:	
	lda	$4210
	bpl     WaitVb	; is the number higher than #$7f? (#$80-$ff)
			; bpl tests bit #7 ($80) if this bit is set it means
			; the byte is negative (BMI, Branch on Minus)
			; BPL (Branch on Plus) if bit #7 is set in $4210
			; it means that it is at the start of V-Blank
			; if not it will keep testing $4210 until bit #7
			; is on (which would make it a negative (BMI)
	rts

;==========================================================================
;       	     SETUP ROUTINES FOR PROGRAM
;==========================================================================

;==========================================================================
;                         Copy graf-x data
;==========================================================================

Copy_Gfx:
	ldx	#$0000		; Vram address $0000 (Mode 7 is always
	stx	$2116		; located at VRAM address 0
	ldx	#$0000
Clearvr:
	stz	$2118		; clear entire Vram
	stz	$2119
	inx
	cpx	#$0000		;
	bne	Clearvr

	ldx	#$0000
	stx	$2116
copychars:
	;inx			;  IFF2SNES converts to mode 7 but also
	lda	>$7e82c0,x	;  contains $2118 data (which is zeroed out)
	sta	$2119		;  since $2118 was stored first we must skip
	inx			;  that byte to read the next one
	cpx	#$2680		;  that's why there are 2 INX
	bne	copychars


	ldx	#$5000
	stx	$2116
	ldx	#$0000
copyfontgfx:
	lda	>$7ec940,x	; copies Font GFX
	sta	$2118
	inx
	lda	>$7ec940,x
	sta	$2119
	inx
	cpx	#$0c00
	bne	copyfontgfx

	rts

;==========================================================================
;                      Copy Colors
;==========================================================================
Copy_colors:
	stz	$2121		; Select Color Register 1
	ldx	#$0000
CopCol:	
	lda	>$7e8200,X
	sta	$2122
	inx
	cpx	#$00a0 		; copy all colors
	bne	CopCol

	lda	#$80
	sta	$2121
	ldx	#$0000
Copsprtcol:
	lda	>$7e82a0,x
	sta	$2122
	inx
	cpx	#$0020
	bne	Copsprtcol
	rts
;==========================================================================
;                      Make Tiles
;==========================================================================

Make_tiles:
	rep	#$10
	stz	$2115		; putting #$00 into $2115 will
	ldx	#$0000		; increase the VRAM address when writing
	stx	$2116		; to $2118
	ldx	#$0000
clearscreen:
	lda	#$00
	sta	$2118		;
				;   clear the text screen (with spaces)
	inx			;
	cpx	#$4000		;   Mode 7 uses a 128*128 tile screen
	bne	clearscreen	;   128*128 = 16384 = $4000

	ldx	#$0400
	stx	$2116
	stx	$100c		; reset vram text address
	ldx	#$0000
	stx	$100e		; reset column offset
	ldy	#$0000
	ldx	#$0001		; all tiles are placed in $2118
writetext:
	lda	>$7e8000,x		; read text
	sta	$2118		; store it
	inx			; increase text offset
	inx
	lda	$100e		; read column offset
	inc a			; increase it
	and	#$1f		; make sure its only from 0-$1f
	sta	$100e		; store it
	bne	writetext	; did it hit 0? no go finish up!
	rep	#$30		; yes! (it drew all 32 chars on the line)
	lda	$100c		; get vram text address
	clc			;
	adc	#$0080		; add 128 to it to get to the next line
	sta	$100c		; store it
	sta	$2116		; store it as the next VRAM address
	sep	#$20		; A = 8 bit
	iny			; increase # of lines drawn
	cpy	#$0008		; did it draw 25 lines?
	bne	writetext	; no, go finish up!
	lda	#$80
	sta	$2115		; increase vram after writing to $2119


	ldx	#$6000
	stx	$2116
	ldx	#$0000
copysprtgfx:
	lda	>$7ea940,x
	sta	$2118
	inx
	lda	>$7ea940,x
	sta	$2119
	inx
	cpx	#$2000
	bne	copysprtgfx
	





	ldx	#$4000
	stx	$2116
	ldx	#$0000
copyfonttext:
	lda	Fonttext,x
	and	#$3f
	sta	$2118
	lda	#$08
	sta	$2119
	inx
	cpx	#$0400
	bne	copyfonttext


	ldx	#$42a0
	stx	$2116
	ldx	#$0000
copyright:
	lda	CRIGHT,x
	and	#$3f
	sta	$2118
	lda	#$10
	sta	$2119
	inx
	cpx	#$040
	bne	copyright

	ldx	#$4300
	stx	$2116
	ldx	#$0000
clearscrollvram:
	lda	#$20
	sta	$2118
	lda	#$08
	sta	$2119
	inx
	cpx	#$0060
	bne	clearscrollvram

	ldx	#$0000
clearscrollbuff:
	lda	#$20
	sta	$0a00,x
	inx
	cpx	#$0020
	bne	clearscrollbuff

	ldx	#$4400
	stx	$2116
	ldy	#$0000
	stz	$30		; dummy counter
	stz	$31
copyplasma1:
	ldx	$30
	lda	plasmadata,x
	ora	#$40
	sta	$2118
	lda	#$0c
	sta	$2119
	inc	$30
	lda	$30
	and	#$1f
	sta	$30
	beq	incitby11
returnplasma1
	iny
	cpy	#$0400
	bne	copyplasma1

	ldx	#$4800
	stx	$2116
	ldy	#$0000
	lda	#$01
	sta	$30		; dummy counter
	stz	$31
copyplasma2:
	ldx	$30
	lda	plasmadata,x
	ora	#$40
	sta	$2118
	lda	#$0c
	sta	$2119
	inc	$30
	lda	$30
	and	#$1f
	sta	$30
	beq	incitby12
returnplasma2:
	iny
	cpy	#$0400
	bne	copyplasma2



	rts

incitby11:
	inc	$30
	bra	returnplasma1
incitby12:
	inc	$30
	bra	returnplasma2


plasmadata:
	dc.b	$1,$1,$2,$3,$4,$5,$6,$7,$8,$9,$a,$b,$c,$d,$e,$f
	dc.b	$f,$e,$d,$c,$b,$a,$9,$8,$7,$6,$5,$4,$3,$2,$1,$1

CRIGHT:
		;********************************
	dc.b	"                    CODE:-PAN-  "
	DC.B	"                    LOGO:STATIC "
;==========================================================================
;                              Sprite Setup Routine
;==========================================================================

Sprite_Setup:
	lda	#$a3
	sta	$2101
	stz	$2102
	stz	$2103
	ldx	#$0000
sprtclear:
	lda	#$00
	sta	$2104		; Horizontal position
	lda	#$c0
	sta	$2104		; Vertical position
	lda	#$88
	sta	$2104		; sprite object = 0
	lda	#%00110000
	sta	$2104		; pallete = 0, priority = %11, h;v flip = 0
	inx
	cpx	#$0080		; (128 sprites)
	bne	sprtclear
	ldx	#$0000
sprtdataclear:
	lda	#%10101010
	sta	$2104		; clear H-position 
	sta	$2104		; and make size large
	inx
	cpx	#$0020		; 32 extra bytes for sprite data
				; info
	bne	sprtdataclear
	stz	$2102
	stz	$2103
	lda	#$60
	sta	$2104
	lda	#$00
	sta	$2104
	lda	#$00
	sta	$2104
	lda	#%00110000
	sta	$2104

	lda	#$60
	sta	$2104
	lda	#$40
	sta	$2104
	lda	#$80
	sta	$2104
	lda	#%00110000
	sta	$2104
	
	lda	#$60
	sta	$2104
	lda	#$80
	sta	$2104
	lda	#$08
	sta	$2104
	lda	#%00110000
	sta	$2104


	rts











;==========================================================================
;                     Start of HDMA routine
;==========================================================================

HDMA:


        ldx     #$0000                              
        txy                                         
HDMAgxpos:                                          
        lda     #$01                                
        sta     $0300,x         ; 1 scan line width 
        inx                                         
        lda     #$00            ; clear it          
        sta     $0300,x                             
        inx                                         
        lda     #$02            ; clear it          
        sta     $0300,x                             
        inx                                         
        iny                                         
        cpy     #$00c0          ; # of lines to make
        bne     HDMAgxpos                           
        stz     $0300,x         ; end hdma          
        inx                                         
        stz     $0300,x                             
        inx                                         
        stz     $0300,x                             
                                                    
      

	lda     #$02                                                     
	sta     $4300           ; 2= 2 bytes per register (not a word!)  
	lda     #$0f                                                     
	sta     $4301           ; 21xx   this is 210f                    
	lda     #$00                                                     
	sta     $4302                                                    
	lda     #$03            ; address = $0a00                        
	sta     $4303                                                    
	lda     #$7e                                                     
	sta     $4304           ; bank address of data in ram

	lda	#$01
	sta	$420c		; STA!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	rts

;==========================================================================
;                   SNES Register Initialization routine
;==========================================================================
Snes_Init:
	sep 	#$30    ; X,Y,A are 8 bit numbers
	lda 	#$8F    ; screen off, full brightness
	sta 	$2100   ; brightness + screen enable register 
	stz 	$2101   ; Sprite register (size + address in VRAM)
	stz 	$2102   ; Sprite registers (address of sprite memory [OAM])
	stz 	$2103   ;    ""                       ""
	stz 	$2105   ; Mode 0, = Graphic mode register
	stz 	$2106   ; noplanes, no mosaic, = Mosaic register
	stz 	$2107   ; Plane 0 map VRAM location
	stz 	$2108   ; Plane 1 map VRAM location
	stz 	$2109   ; Plane 2 map VRAM location
	stz 	$210A   ; Plane 3 map VRAM location
	stz 	$210B   ; Plane 0+1 Tile data location
	stz 	$210C   ; Plane 2+3 Tile data location
	stz 	$210D   ; Plane 0 scroll x (first 8 bits)
	stz 	$210D   ; Plane 0 scroll x (last 3 bits) #$0 - #$07ff
	stz 	$210E   ; Plane 0 scroll y (first 8 bits)
	stz 	$210E   ; Plane 0 scroll y (last 3 bits) #$0 - #$07ff
	stz 	$210F   ; Plane 1 scroll x (first 8 bits)
	stz 	$210F   ; Plane 1 scroll x (last 3 bits) #$0 - #$07ff
	stz 	$2110   ; Plane 1 scroll y (first 8 bits)
	stz 	$2110   ; Plane 1 scroll y (last 3 bits) #$0 - #$07ff
	stz 	$2111   ; Plane 2 scroll x (first 8 bits)
	stz 	$2111   ; Plane 2 scroll x (last 3 bits) #$0 - #$07ff
	stz 	$2112   ; Plane 2 scroll y (first 8 bits)
	stz 	$2112   ; Plane 2 scroll y (last 3 bits) #$0 - #$07ff
	stz 	$2113   ; Plane 3 scroll x (first 8 bits)
	stz 	$2113   ; Plane 3 scroll x (last 3 bits) #$0 - #$07ff
	stz 	$2114   ; Plane 3 scroll y (first 8 bits)
	stz 	$2114   ; Plane 3 scroll y (last 3 bits) #$0 - #$07ff
	lda 	#$80    ; increase VRAM address after writing to $2119
	sta 	$2115   ; VRAM address increment register
	stz 	$2116   ; VRAM address low
	stz 	$2117   ; VRAM address high
	stz 	$211A   ; Initial Mode 7 setting register
	stz 	$211B   ; Mode 7 matrix parameter A register (low)
	lda 	#$01
	sta 	$211B   ; Mode 7 matrix parameter A register (high)
	stz 	$211C   ; Mode 7 matrix parameter B register (low)
	stz 	$211C   ; Mode 7 matrix parameter B register (high)
	stz 	$211D   ; Mode 7 matrix parameter C register (low)
	stz 	$211D   ; Mode 7 matrix parameter C register (high)
	stz 	$211E   ; Mode 7 matrix parameter D register (low)
	sta 	$211E   ; Mode 7 matrix parameter D register (high)
	stz 	$211F   ; Mode 7 center position X register (low)
	stz 	$211F   ; Mode 7 center position X register (high)
	stz 	$2120   ; Mode 7 center position Y register (low)
	stz 	$2120   ; Mode 7 center position Y register (high)
	stz 	$2121   ; Color number register ($0-ff)
	stz 	$2123   ; BG1 & BG2 Window mask setting register
	stz 	$2124   ; BG3 & BG4 Window mask setting register
	stz 	$2125   ; OBJ & Color Window mask setting register
	stz 	$2126   ; Window 1 left position register
	stz 	$2127   ; Window 2 left position register
	stz 	$2128   ; Window 3 left position register
	stz 	$2129   ; Window 4 left position register
	stz 	$212A   ; BG1, BG2, BG3, BG4 Window Logic register
	stz 	$212B   ; OBJ, Color Window Logic Register (or,and,xor,xnor)
	sta 	$212C   ; Main Screen designation (planes, sprites enable)
	stz 	$212D   ; Sub Screen designation
	stz 	$212E   ; Window mask for Main Screen
	stz 	$212F   ; Window mask for Sub Screen
	lda 	#$30
	sta 	$2130   ; Color addition & screen addition init setting
	stz 	$2131   ; Add/Sub sub designation for screen, sprite, color
	lda 	#$E0
	sta 	$2132   ; color data for addition/subtraction
	stz 	$2133   ; Screen setting (interlace x,y/enable SFXdata)
	stz 	$4200   ; Enable V-blank, interrupt, Joypad register
	lda 	#$FF
	sta 	$4201   ; Programmable I/O port
	stz 	$4202   ; Multiplicand A
	stz 	$4203   ; Multiplier B
	stz 	$4204   ; Multiplier C
	stz 	$4205   ; Multiplicand C
	stz 	$4206   ; Divisor B
	stz 	$4207   ; Horizontal Count Timer
	stz 	$4208   ; Horizontal Count Timer MSB (most significant bit)
	stz 	$4209   ; Vertical Count Timer
	stz 	$420A   ; Vertical Count Timer MSB
	stz 	$420B   ; General DMA enable (bits 0-7)
	stz 	$420C   ; Horizontal DMA (HDMA) enable (bits 0-7)
	stz 	$420D	; Access cycle designation (slow/fast rom)
	rts

;===========================================================================
;                         Start Of Sine Data
;===========================================================================

sine1:

 dcr.w  -1,3,6,9,12,15,18,21,24,28,31,34,37,40,43,46,49,52,55,58,61
 dcr.w  64,67,70,73,76,79,82,85,88,91,94,97,100,103,105,108,111,114
 dcr.w  117,119,122,125,128,130,133,136,138,141,143,146,149,151,154
 dcr.w  156,159,161,163,166,168,170,173,175,177,179,182,184,186,188
 dcr.w  190,192,194,196,198,200,202,204,206,208,209,211,213,215,216
 dcr.w  218,219,221,222,224,225,227,228,230,231,232,233,235,236,237
 dcr.w  238,239,240,241,242,243,244,245,246,246,247,248,248,249,250
 dcr.w  250,251,251,252,252,252,253,253,253,254,254,254,254,254,254
 dcr.w  254,254,254,254,254,253,253,253,252,252,252,251,251,250,250
 dcr.w  249,248,248,247,246,246,245,244,243,242,241,240,239,238,237
 dcr.w  236,235,233,232,231,230,228,227,225,224,222,221,219,218,216
 dcr.w  215,213,211,209,208,206,204,202,200,198,196,194,192,190,188
 dcr.w  186,184,182,179,177,175,173,170,168,166,163,161,159,156,154
 dcr.w  151,149,146,143,141,138,136,133,130,128,125,122,119,117,114
 dcr.w  111,108,105,103,100,97,94,91,88,85,82,79,76,73,70,67,64,61
 dcr.w  58,55,52,49,46,43,40,37,34,31,28,24,21,18,15,12,9,6,3,-1,-4
 dcr.w  -7,-10,-13,-16,-19,-22,-25,-29,-32,-35,-38,-41,-44,-47,-50
 dcr.w  -53,-56,-59,-62,-65,-68,-71,-74,-77,-80,-83,-86,-89,-92,-95
 dcr.w  -98,-101,-104,-106,-109,-112,-115,-118,-120,-123,-126,-129
 dcr.w  -131,-134,-137,-139,-142,-144,-147,-150,-152,-155,-157,-160
 dcr.w  -162,-164,-167,-169,-171,-174,-176,-178,-180,-183,-185,-187
 dcr.w  -189,-191,-193,-195,-197,-199,-201,-203,-205,-207,-209,-210
 dcr.w  -212,-214,-216,-217,-219,-220,-222,-223,-225,-226,-228,-229
 dcr.w  -231,-232,-233,-234,-236,-237,-238,-239,-240,-241,-242,-243
 dcr.w  -244,-245,-246,-247,-247,-248,-249,-249,-250,-251,-251,-252
 dcr.w  -252,-253,-253,-253,-254,-254,-254,-255,-255,-255,-255,-255
 dcr.w  -255,-255,-255,-255,-255,-255,-254,-254,-254,-253,-253,-253
 dcr.w  -252,-252,-251,-251,-250,-249,-249,-248,-247,-247,-246,-245
 dcr.w  -244,-243,-242,-241,-240,-239,-238,-237,-236,-234,-233,-232
 dcr.w  -231,-229,-228,-226,-225,-223,-222,-220,-219,-217,-216,-214
 dcr.w  -212,-210,-209,-207,-205,-203,-201,-199,-197,-195,-193,-191
 dcr.w  -189,-187,-185,-183,-180,-178,-176,-174,-171,-169,-167,-164
 dcr.w  -162,-160,-157,-155,-152,-150,-147,-144,-142,-139,-137,-134
 dcr.w  -131,-129,-126,-123,-120,-118,-115,-112,-109,-106,-104,-101
 dcr.w  -98,-95,-92,-89,-86,-83,-80,-77,-74,-71,-68,-65,-62,-59,-56
 dcr.w  -53,-50,-47,-44,-41,-38,-35,-32,-29,-25,-22,-19,-16,-13,-10
 dcr.w  -7

	; copy on sine data again cawz the -SIN will leak over and
	; we need it to leak into here to continue the -SIN data

 dcr.w  -1,3,6,9,12,15,18,21,24,28,31,34,37,40,43,46,49,52,55,58,61
 dcr.w  64,67,70,73,76,79,82,85,88,91,94,97,100,103,105,108,111,114
 dcr.w  117,119,122,125,128,130,133,136,138,141,143,146,149,151,154
 dcr.w  156,159,161,163,166,168,170,173,175,177,179,182,184,186,188
 dcr.w  190,192,194,196,198,200,202,204,206,208,209,211,213,215,216
 dcr.w  218,219,221,222,224,225,227,228,230,231,232,233,235,236,237
 dcr.w  238,239,240,241,242,243,244,245,246,246,247,248,248,249,250
 dcr.w  250,251,251,252,252,252,253,253,253,254,254,254,254,254,254
 dcr.w  254,254,254,254,254,253,253,253,252,252,252,251,251,250,250
 dcr.w  249,248,248,247,246,246,245,244,243,242,241,240,239,238,237
 dcr.w  236,235,233,232,231,230,228,227,225,224,222,221,219,218,216
 dcr.w  215,213,211,209,208,206,204,202,200,198,196,194,192,190,188
 dcr.w  186,184,182,179,177,175,173,170,168,166,163,161,159,156,154
 dcr.w  151,149,146,143,141,138,136,133,130,128,125,122,119,117,114
 dcr.w  111,108,105,103,100,97,94,91,88,85,82,79,76,73,70,67,64,61
 dcr.w  58,55,52,49,46,43,40,37,34,31,28,24,21,18,15,12,9,6,3,-1,-4
 dcr.w  -7,-10,-13,-16,-19,-22,-25,-29,-32,-35,-38,-41,-44,-47,-50
 dcr.w  -53,-56,-59,-62,-65,-68,-71,-74,-77,-80,-83,-86,-89,-92,-95
 dcr.w  -98,-101,-104,-106,-109,-112,-115,-118,-120,-123,-126,-129
 dcr.w  -131,-134,-137,-139,-142,-144,-147,-150,-152,-155,-157,-160
 dcr.w  -162,-164,-167,-169,-171,-174,-176,-178,-180,-183,-185,-187
 dcr.w  -189,-191,-193,-195,-197,-199,-201,-203,-205,-207,-209,-210
 dcr.w  -212,-214,-216,-217,-219,-220,-222,-223,-225,-226,-228,-229
 dcr.w  -231,-232,-233,-234,-236,-237,-238,-239,-240,-241,-242,-243
 dcr.w  -244,-245,-246,-247,-247,-248,-249,-249,-250,-251,-251,-252
 dcr.w  -252,-253,-253,-253,-254,-254,-254,-255,-255,-255,-255,-255
 dcr.w  -255,-255,-255,-255,-255,-255,-254,-254,-254,-253,-253,-253
 dcr.w  -252,-252,-251,-251,-250,-249,-249,-248,-247,-247,-246,-245
 dcr.w  -244,-243,-242,-241,-240,-239,-238,-237,-236,-234,-233,-232
 dcr.w  -231,-229,-228,-226,-225,-223,-222,-220,-219,-217,-216,-214
 dcr.w  -212,-210,-209,-207,-205,-203,-201,-199,-197,-195,-193,-191
 dcr.w  -189,-187,-185,-183,-180,-178,-176,-174,-171,-169,-167,-164
 dcr.w  -162,-160,-157,-155,-152,-150,-147,-144,-142,-139,-137,-134
 dcr.w  -131,-129,-126,-123,-120,-118,-115,-112,-109,-106,-104,-101
 dcr.w  -98,-95,-92,-89,-86,-83,-80,-77,-74,-71,-68,-65,-62,-59,-56
 dcr.w  -53,-50,-47,-44,-41,-38,-35,-32,-29,-25,-22,-19,-16,-13,-10
 dcr.w  -7



splitsine:

 dc.b  128,131,134,137,140,143,146,149,152,155,158,162,165,167,170
 dc.b  173,176,179,182,185,188,190,193,196,198,201,203,206,208,211
 dc.b  213,215,218,220,222,224,226,228,230,232,234,235,237,238,240
 dc.b  241,243,244,245,246,248,249,250,250,251,252,253,253,254,254
 dc.b  254,255,255,255,255,255,255,255,254,254,254,253,253,252,251
 dc.b  250,250,249,248,246,245,244,243,241,240,238,237,235,234,232
 dc.b  230,228,226,224,222,220,218,215,213,211,208,206,203,201,198
 dc.b  196,193,190,188,185,182,179,176,173,170,167,165,162,158,155
 dc.b  152,149,146,143,140,137,134,131,128,124,121,118,115,112,109
 dc.b  106,103,100,97,93,90,88,85,82,79,76,73,70,67,65,62,59,57,54
 dc.b  52,49,47,44,42,40,37,35,33,31,29,27,25,23,21,20,18,17,15,14
 dc.b  12,11,10,9,7,6,5,5,4,3,2,2,1,1,1,0,0,0,0,0,0,0,1,1,1,2,2,3
 dc.b  4,5,5,6,7,9,10,11,12,14,15,17,18,20,21,23,25,27,29,31,33,35
 dc.b  37,40,42,44,47,49,52,54,57,59,62,65,67,70,73,76,79,82,85,88
 dc.b  90,93,97,100,103,106,109,112,115,118,121,124




	dc.b	"RIGHT HERE:"

;---------------------------------------------------------
; PRO-PACK Unpack Source Code - Super NES, Method 1
;
; Copyright (c) 1992 Rob Northen Computing
;
; File: RNC_1.S
;
; Date: 9.03.92
;---------------------------------------------------------
;---------------------------------------------------------
; Unpack Routine - Super NES, Method 1
;
; To unpack a packed file (in any data bank) to an output
; buffer (in any data bank) Note: the packed and unpacked
; files are limited to 65536 bytes in length.
;
; To call (assumes 16-bit accumulator)
;
;
; On exit,
;
; A, X, Y undefined, M=0, X=0
;---------------------------------------------------------
;---------------------------------------------------------
; Equates
;---------------------------------------------------------


;---------------------------------------------------------
UNPACK	rep	#$39	; 16-bit AXY, clear D and C
	lda	#Buff2
	sta	wrkbuf
	lda	#^Buff2
	sta	wrkbuf+2
	lda	#17
	adc	in
	sta	in
	lda	[in]
	and	#$00ff
	sta	blocks
	inc	in
	lda	[in]
	sta	bitbufl
	stz	bufbits
	lda	#2
	jsr	gtbits
unpack2	ldy	#rawtab
	jsr	makehuff
	ldy	#postab
	jsr	makehuff
	ldy	#slntab
	jsr	makehuff
	lda	#16
	jsr	gtbits
	sta	counts
	jmp	unpack8
unpack3	ldy	#postab
	jsr	gtval
	sta	temp2
	lda	out
	clc
	sbc	temp2
	sta	temp3
	ldy	#slntab
	jsr	gtval
	inc	a
	inc	a
	lsr	a
	tax
	ldy	#0
	lda	temp2
	bne	unpack5
	sep	#$20	; 8-bit accumulator
	lda	(temp3),y
	xba
	lda	(temp3),y
	rep	#$20	; 16-bit accumulator
unpack4	sta	(out),y
	iny
	iny
	dex
	bne	unpack4
	bra	unpack6
unpack5	lda	(temp3),y
	sta	(out),y
	iny
	iny
	dex
	bne	unpack5
unpack6	bcc	unpack7
	sep	#$20	; 8-bit accumulator
	lda	(temp3),y
	sta	(out),y
	iny
	rep	#$21	; 16-bit accumulator, clear carry
unpack7	tya
	adc	out
	sta	out
unpack8	ldy	#rawtab
	jsr	gtval
	tax
	beq	unpack14
	ldy	#0
	lsr	a
	beq	unpack10
	tax
unpack9	lda	[in],y
	sta	(out),y
	iny
	iny
	dex
	bne	unpack9
unpack10	bcc	unpack11
	sep	#$20	; 8-bit accumulator
	lda	[in],y
	sta	(out),y
	rep	#$21	; 16-bit accumulator, clear carry
	iny
unpack11	tya
	adc	in
	sta	in
	tya
	adc	out
	sta	out
	stz	bitbufh
	lda	bufbits
	tay
	asl	a
	tax
	lda	[in]
	cpy	#0
	beq	unpack13
unpack12	asl	a
	rol	bitbufh
	dey
	bne	unpack12
unpack13	sta	temp1
	phb
	phk
	plb
	lda	msktab,x		;>
	plb
	and	bitbufl
	ora	temp1
	sta	bitbufl
unpack14	dec	counts
	beq	.Mark1
	jmp	unpack3
.Mark1	dec	blocks
	beq	.Mark2
	jmp	unpack2
.Mark2	rts
;-----------------------------------------------------------
gtval	ldx	bitbufl
	bra	gtval3
gtval2	iny
	iny
gtval3	txa
	and	[wrkbuf],y
	iny
	iny
	cmp	[wrkbuf],y
	bne	gtval2
	tya
	adc	#(15*4+1)
	tay
	lda	[wrkbuf],y
	pha
	xba
	and	#$ff
	jsr	gtbits
	pla
	and	#$ff
	cmp	#2
	bcc	gtval4
	dec	a
	asl	a
	pha
	lsr	a
	jsr	gtbits
	plx
	phb
	phk
	plb
	ora	bittab,x		;>
	plb
gtval4	rts
bittab	dcr.w	1
	dcr.w	2
	dcr.w	4
	dcr.w	8
	dcr.w	$10
	dcr.w	$20
	dcr.w	$40
	dcr.w	$80
	dcr.w	$100
	dcr.w	$200
	dcr.w	$400
	dcr.w	$800
	dcr.w	$1000
	dcr.w	$2000
	dcr.w	$4000
	dcr.w	$8000
;-----------------------------------------------------------
gtbits	tay
	asl	a
	tax
	phb
	phk
	plb
	lda	msktab,x		;>
	plb
	and	bitbufl
	pha
	lda	bitbufh
	ldx	bufbits
	beq	gtbits3
gtbits2	lsr	a
	ror	bitbufl
	dey
	beq	gtbits4
	dex
	beq	gtbits3
	lsr	a
	ror	bitbufl
	dey
	beq	gtbits4
	dex
	bne	gtbits2
gtbits3	inc	in
	inc	in
	lda	[in]
	ldx	#16
	bra	gtbits2
gtbits4	dex
	stx	bufbits
	sta	bitbufh
	pla
gtbits5	rts
msktab	dcr.w	0
	dcr.w	1
	dcr.w	3
	dcr.w	7
	dcr.w	$f
	dcr.w	$1f
	dcr.w	$3f
	dcr.w	$7f
	dcr.w	$ff
	dcr.w	$1ff
	dcr.w	$3ff
	dcr.w	$7ff
	dcr.w	$fff
	dcr.w	$1fff
	dcr.w	$3fff
	dcr.w	$7fff
	dcr.w	$ffff
;-----------------------------------------------------------
makehuff	sty	temp4
	lda	#5
	jsr	gtbits
	beq	gtbits5
	sta	temp1
	sta	temp2
	ldy	#0
makehuff2	phy
	lda	#4
	jsr	gtbits
	ply
	sta	[wrkbuf],y
	iny
	iny
	dec	temp2
	bne	makehuff2
	stz	hufcde
	lda	#$8000
	sta	hufbse
	lda	#1
	sta	bitlen
makehuff3	lda	bitlen
	ldx	temp1
	ldy	#0
makehuff4	cmp	[wrkbuf],y
	bne	makehuff8
	phx
	sty	temp3
	asl	a
	tax
	phb
	phk
	plb
	lda	msktab,x		;>
	plb
	ldy	temp4
	sta	[wrkbuf],y
	iny
	iny
	lda	#16
	sec
	sbc	bitlen
	pha
	lda	hufcde
	sta	temp2
	ldx	bitlen
makehuff5	asl	temp2
	ror	a
	dex
	bne	makehuff5
	plx
	beq	makehuff7
makehuff6	lsr	a
	dex
	bne	makehuff6
makehuff7	sta	[wrkbuf],y
	iny
	iny
	sty	temp4
	tya
	clc
	adc	#(15*4)
	tay
	lda	bitlen
	xba
	sep	#$20	; 8-bit accumulator
	lda	temp3
	lsr	a
	rep	#$21	; 16-bit accumulator, clear carry
	sta	[wrkbuf],y
	lda	hufbse
	adc	hufcde
	sta	hufcde
	lda	bitlen
	ldy	temp3
	plx
makehuff8	iny
	iny
	dex
	bne	makehuff4
	lsr	hufbse
	inc	bitlen
	cmp	#16
	bne	makehuff3
	rts



Picture:
	.bin 95d4.rnc

;TEXT:
;		;********************************
;	.bin	atxstuff.chr
;
;	
;
;Colors:
;
;	.bin atxstuff.col
;	.bin	char.col
;	.bin	rain.col
;	.bin	purps.col
;sprtcolors:
;	.bin atxsprt.col
;
;Charset:
;	.bin atxstuff.gfx
;sprtgfx:
;	.bin atxsprt.dat

;Fontgfx:
;	.bin char.dat
Pancopyright:
	jsr	Snes_Init
	sep	#$30
	lda	#$8f
	sta	$2100
	jmp	$8000
	

	org	$fffc	;reset vector in 6502 mode
	dcr.w	Start
	.pad
